/*
 * Decompiled with CFR 0.152.
 */
package beaver;

import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.io.IOException;

public abstract class Parser {
    private final ParsingTables tables;
    private final short accept_action_id;
    private short[] states;
    private int top;
    protected Symbol[] _symbols;
    protected Events report;

    protected Parser(ParsingTables parsingTables) {
        this.tables = parsingTables;
        this.accept_action_id = (short)(~parsingTables.rule_infos.length);
        this.states = new short[256];
    }

    public Object parse(Scanner scanner) throws IOException, Exception {
        this.init();
        return this.parse(new TokenStream(scanner));
    }

    public Object parse(Scanner scanner, short s) throws IOException, Exception {
        this.init();
        TokenStream tokenStream = new TokenStream(scanner, new Symbol(s));
        return this.parse(tokenStream);
    }

    private Object parse(TokenStream tokenStream) throws IOException, Exception {
        block0: while (true) {
            Symbol symbol;
            block5: {
                Symbol symbol2;
                short s;
                symbol = tokenStream.nextToken();
                while (true) {
                    if ((s = this.tables.findParserAction(this.states[this.top], symbol.id)) > 0) {
                        this.shift(symbol, s);
                        continue block0;
                    }
                    if (s == this.accept_action_id) {
                        symbol2 = this._symbols[this.top];
                        this._symbols = null;
                        return symbol2.value;
                    }
                    if (s >= 0) break block5;
                    symbol2 = this.reduce(~s);
                    s = this.tables.findNextState(this.states[this.top], symbol2.id);
                    if (s <= 0) break;
                    this.shift(symbol2, s);
                }
                if (s == this.accept_action_id) {
                    this._symbols = null;
                    return symbol2.value;
                }
                throw new IllegalStateException("Cannot shift a nonterminal");
            }
            this.report.syntaxError(symbol);
            this.recoverFromError(symbol, tokenStream);
        }
    }

    protected abstract Symbol invokeReduceAction(int var1, int var2);

    private void init() {
        if (this.report == null) {
            this.report = new Events();
        }
        this._symbols = new Symbol[this.states.length];
        this.top = 0;
        this._symbols[this.top] = new Symbol("none");
        this.states[this.top] = 1;
    }

    private void increaseStackCapacity() {
        short[] sArray = new short[this.states.length * 2];
        System.arraycopy(this.states, 0, sArray, 0, this.states.length);
        this.states = sArray;
        Symbol[] symbolArray = new Symbol[this.states.length];
        System.arraycopy(this._symbols, 0, symbolArray, 0, this._symbols.length);
        this._symbols = symbolArray;
    }

    private void shift(Symbol symbol, short s) {
        if (++this.top == this.states.length) {
            this.increaseStackCapacity();
        }
        this._symbols[this.top] = symbol;
        this.states[this.top] = s;
    }

    private Symbol reduce(int n) {
        int n2 = this.tables.rule_infos[n];
        int n3 = n2 & 0xFFFF;
        this.top -= n3;
        Symbol symbol = this.invokeReduceAction(n, this.top);
        symbol.id = (short)(n2 >>> 16);
        if (n3 == 0) {
            symbol.start = symbol.end = this._symbols[this.top].end;
        } else {
            symbol.start = this._symbols[this.top + 1].start;
            symbol.end = this._symbols[this.top + n3].end;
        }
        return symbol;
    }

    protected void recoverFromError(Symbol symbol, TokenStream tokenStream) throws IOException, Exception {
        int n;
        Symbol symbol2;
        short s;
        if (symbol.id == 0) {
            throw new Exception("Cannot recover from the syntax error");
        }
        Simulator simulator = new Simulator();
        tokenStream.mark(3);
        if (simulator.parse(tokenStream)) {
            tokenStream.reset();
            this.report.unexpectedTokenRemoved(symbol);
            return;
        }
        short s2 = this.states[this.top];
        if (!this.tables.compressed && (s = this.tables.findFirstTerminal(s2)) >= 0) {
            int n2;
            short s3;
            symbol2 = new Symbol(s, this._symbols[this.top].end, symbol.start);
            tokenStream.insert(symbol2, symbol);
            tokenStream.reset();
            if (simulator.parse(tokenStream)) {
                tokenStream.reset();
                this.report.missingTokenInserted(symbol2);
                return;
            }
            n = this.tables.actn_offsets[s2];
            for (s3 = (short)(s + 1); s3 < this.tables.n_term && (n2 = n + s3) < this.tables.lookaheads.length; s3 = (short)(s3 + 1)) {
                if (this.tables.lookaheads[n2] != s3) continue;
                symbol2.id = s3;
                tokenStream.reset();
                if (!simulator.parse(tokenStream)) continue;
                tokenStream.reset();
                this.report.missingTokenInserted(symbol2);
                return;
            }
            tokenStream.remove(1);
            symbol2.start = symbol.start;
            symbol2.end = symbol.end;
            for (s3 = s; s3 < this.tables.n_term && (n2 = n + s3) < this.tables.lookaheads.length; s3 = (short)(s3 + 1)) {
                if (this.tables.lookaheads[n2] != s3) continue;
                symbol2.id = s3;
                tokenStream.reset();
                if (!simulator.parse(tokenStream)) continue;
                tokenStream.reset();
                this.report.misspelledTokenReplaced(symbol2);
                return;
            }
            tokenStream.remove(0);
        }
        Symbol symbol3 = symbol;
        symbol2 = symbol;
        while ((n = this.tables.findNextState(this.states[this.top], this.tables.error_symbol_id)) <= 0) {
            symbol3 = this._symbols[this.top];
            if (--this.top >= 0) continue;
            throw new Exception("Cannot recover from the syntax error");
        }
        Symbol symbol4 = new Symbol(this.tables.error_symbol_id, symbol3.start, symbol2.end);
        this.shift(symbol4, (short)n);
        tokenStream.reset();
        while (!simulator.parse(tokenStream)) {
            symbol2 = tokenStream.remove(0);
            if (symbol2.id == 0) {
                throw new Exception("Cannot recover from the syntax error");
            }
            tokenStream.reset();
        }
        symbol4.end = symbol2.end;
        tokenStream.reset();
        this.report.errorPhraseRemoved(symbol4);
    }

    private class Simulator {
        private short[] states;
        private int top;
        private int min_top;

        private Simulator() {
        }

        boolean parse(TokenStream tokenStream) throws IOException {
            this.initStack();
            do {
                short s;
                block3: {
                    block4: {
                        Symbol symbol = tokenStream.nextToken();
                        while (true) {
                            if ((s = Parser.this.tables.findParserAction(this.states[this.top], symbol.id)) > 0) break block3;
                            if (s == Parser.this.accept_action_id) {
                                return true;
                            }
                            if (s >= 0) break block4;
                            short s2 = this.reduce(~s);
                            s = Parser.this.tables.findNextState(this.states[this.top], s2);
                            if (s <= 0) break;
                            this.shift(s);
                        }
                        return s == Parser.this.accept_action_id;
                    }
                    return false;
                }
                this.shift(s);
            } while (!tokenStream.isFull());
            return true;
        }

        private void initStack() throws IOException {
            if (this.states == null || this.states.length < Parser.this.states.length) {
                this.states = new short[Parser.this.states.length];
                this.min_top = 0;
            }
            this.top = Parser.this.top;
            System.arraycopy(Parser.this.states, this.min_top, this.states, this.min_top, this.top + 1);
        }

        private void increaseStackCapacity() {
            short[] sArray = new short[this.states.length * 2];
            System.arraycopy(this.states, 0, sArray, 0, this.states.length);
            this.states = sArray;
        }

        private void shift(short s) {
            if (++this.top == this.states.length) {
                this.increaseStackCapacity();
            }
            this.states[this.top] = s;
        }

        private short reduce(int n) {
            int n2 = ((Parser)Parser.this).tables.rule_infos[n];
            int n3 = n2 & 0xFFFF;
            this.top -= n3;
            this.min_top = Math.min(this.min_top, this.top);
            return (short)(n2 >>> 16);
        }
    }

    private class TokenStream {
        private Scanner scanner;
        private Symbol[] buffer;
        private int n_marked;
        private int n_read;
        private int n_written;

        TokenStream(Scanner scanner) {
            this.scanner = scanner;
        }

        TokenStream(Scanner scanner, Symbol symbol) {
            this(scanner);
            this.mark(1);
            this.buffer[0] = symbol;
            ++this.n_written;
        }

        Symbol nextToken() throws IOException {
            if (this.buffer != null) {
                if (this.n_read < this.n_written) {
                    return this.buffer[this.n_read++];
                }
                if (this.n_written < this.n_marked) {
                    ++this.n_read;
                    Symbol symbol = this.readToken();
                    this.buffer[this.n_written++] = symbol;
                    return symbol;
                }
                this.buffer = null;
            }
            return this.readToken();
        }

        void mark(int n) {
            this.n_marked = n;
            this.buffer = new Symbol[this.n_marked + 1];
            this.n_written = 0;
            this.n_read = 0;
        }

        void reset() {
            this.n_read = 0;
        }

        boolean isFull() {
            return this.n_read == this.n_marked;
        }

        void insert(Symbol symbol, Symbol symbol2) {
            if (this.n_written + 2 > this.buffer.length) {
                Symbol[] symbolArray = new Symbol[this.n_written + 2];
                System.arraycopy(this.buffer, 0, symbolArray, 2, this.n_written);
                this.buffer = symbolArray;
                this.n_marked += 2;
            } else {
                System.arraycopy(this.buffer, 0, this.buffer, 2, this.n_written);
            }
            this.buffer[0] = symbol;
            this.buffer[1] = symbol2;
            this.n_written += 2;
        }

        Symbol remove(int n) {
            Symbol symbol = this.buffer[n];
            int n2 = this.n_written - 1;
            while (n < n2) {
                this.buffer[n++] = this.buffer[n];
            }
            this.n_written = n2;
            return symbol;
        }

        private Symbol readToken() throws IOException {
            while (true) {
                try {
                    return this.scanner.nextToken();
                }
                catch (Scanner.Exception exception) {
                    Parser.this.report.scannerError(exception);
                    continue;
                }
                break;
            }
        }
    }

    public static class Events {
        public void scannerError(Scanner.Exception exception) {
            System.err.print("Scanner Error:");
            if (exception.line > 0) {
                System.err.print(exception.line);
                System.err.print(',');
                System.err.print(exception.column);
                System.err.print(':');
            }
            System.err.print(' ');
            System.err.println(exception.getMessage());
        }

        public void syntaxError(Symbol symbol) {
            System.err.print(':');
            System.err.print(Symbol.getLine(symbol.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(symbol.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.end));
            System.err.print(": Syntax Error: unexpected token ");
            if (symbol.value != null) {
                System.err.print('\"');
                System.err.print(symbol.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(symbol.id);
            }
        }

        public void unexpectedTokenRemoved(Symbol symbol) {
            System.err.print(':');
            System.err.print(Symbol.getLine(symbol.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(symbol.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.end));
            System.err.print(": Recovered: removed unexpected token ");
            if (symbol.value != null) {
                System.err.print('\"');
                System.err.print(symbol.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(symbol.id);
            }
        }

        public void missingTokenInserted(Symbol symbol) {
            System.err.print(':');
            System.err.print(Symbol.getLine(symbol.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(symbol.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.end));
            System.err.print(": Recovered: inserted missing token ");
            if (symbol.value != null) {
                System.err.print('\"');
                System.err.print(symbol.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(symbol.id);
            }
        }

        public void misspelledTokenReplaced(Symbol symbol) {
            System.err.print(':');
            System.err.print(Symbol.getLine(symbol.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(symbol.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.end));
            System.err.print(": Recovered: replaced unexpected token with ");
            if (symbol.value != null) {
                System.err.print('\"');
                System.err.print(symbol.value);
                System.err.println('\"');
            } else {
                System.err.print('#');
                System.err.println(symbol.id);
            }
        }

        public void errorPhraseRemoved(Symbol symbol) {
            System.err.print(':');
            System.err.print(Symbol.getLine(symbol.start));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.start));
            System.err.print('-');
            System.err.print(Symbol.getLine(symbol.end));
            System.err.print(',');
            System.err.print(Symbol.getColumn(symbol.end));
            System.err.println(": Recovered: removed error phrase");
        }
    }

    public static class Exception
    extends java.lang.Exception {
        Exception(String string) {
            super(string);
        }
    }
}

