/*
 * Decompiled with CFR 0.152.
 */
/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Maybe<T> {
    private static final Maybe NOTHING = new Nothing();

    private Maybe() {
    }

    public final boolean isJust() {
        return !this.isNothing();
    }

    public abstract boolean isNothing();

    public abstract T fromJust();

    public static <S> Maybe<S> Just(S value) {
        return new Just(value);
    }

    public static <S> Maybe<S> Nothing() {
        return (Nothing)NOTHING;
    }

    /* synthetic */ Maybe(Maybe maybe) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Just<T>
    extends Maybe<T> {
        private T value;

        private Just(T value) {
            super(null);
            this.value = value;
        }

        @Override
        public boolean isNothing() {
            return false;
        }

        @Override
        public T fromJust() {
            return this.value;
        }

        public String toString() {
            return "Just " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Nothing<T>
    extends Maybe<T> {
        private Nothing() {
            super(null);
        }

        @Override
        public boolean isNothing() {
            return false;
        }

        @Override
        public T fromJust() {
            throw new UnsupportedOperationException("Cannot extract value from Nothing");
        }

        public String toString() {
            return "Nothing";
        }
    }
}

