/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class MissingJFlex {
    private static final String PROP_FILE = "common.properties";
    private static final String PROP_NAME = "jflex.jar.path.prop";
    private final Class<?> silentExitClass;
    private final Method genMethod;
    private final boolean jflexAvailable;

    public MissingJFlex() {
        boolean jflexAvail = false;
        try {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(PROP_FILE));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load properties file common.properties", e);
            }
            String jarFile = properties.getProperty(PROP_NAME);
            if (jarFile == null) {
                throw new RuntimeException("Failed to load property jflex.jar.path.prop");
            }
            URL jarURL = null;
            try {
                jarURL = new URL("file:lib/jflex-1.4.1/lib/JFlex.jar");
                URLClassLoader loader = new URLClassLoader(new URL[]{jarURL});
                this.silentExitClass = Class.forName("JFlex.SilentExit", true, loader);
                Class<?> mainClass = Class.forName("JFlex.Main", true, loader);
                this.genMethod = mainClass.getMethod("generate", String[].class);
                jflexAvail = true;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Jar path is incorrect: " + jarURL, e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.jflexAvailable = jflexAvail;
        }
    }

    public boolean isJFlexAvailable() {
        return this.jflexAvailable;
    }

    public void generate(String file, String destDir) {
        try {
            this.genMethod.invoke(null, new Object[]{new String[]{"-d", destDir, "--nobak", "-v", file}});
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (!this.silentExitClass.isInstance(targetException)) {
                throw new RuntimeException(targetException);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        MissingJFlex jflex = new MissingJFlex();
        jflex.generate("scratch/pipetest.flex", "scratch/missingjflex");
    }
}

