/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairFilter {
    private final Map<Character, Set<Character>> pairMap;
    private final Set<Character> allOpenChars;
    private final List<Character> unclosedOpenChars;

    private PairFilter(Map<Character, Set<Character>> pairMap, Set<Character> allOpenChars) {
        this.pairMap = pairMap;
        this.allOpenChars = allOpenChars;
        this.unclosedOpenChars = new ArrayList<Character>();
    }

    public boolean test(char ch) {
        Set<Character> correspondingOpens = this.pairMap.get(Character.valueOf(ch));
        if (correspondingOpens != null) {
            Iterator<Character> it = this.unclosedOpenChars.iterator();
            while (it.hasNext()) {
                char open = it.next().charValue();
                if (!correspondingOpens.contains(Character.valueOf(open))) continue;
                it.remove();
                return false;
            }
        }
        if (this.allOpenChars.contains(Character.valueOf(ch))) {
            this.unclosedOpenChars.add(0, Character.valueOf(ch));
        }
        return true;
    }

    public static void main(String[] args) {
        char ch;
        System.err.println("Test");
        PairFilter filter = new Builder().build();
        char[] cArray = "hello".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            System.out.println(String.valueOf(ch) + " - " + filter.test(ch));
            ++n2;
        }
        System.err.println("Test");
        filter = new Builder().add('(', ')').build();
        cArray = "(hello)".toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            System.out.println(String.valueOf(ch) + " - " + filter.test(ch));
            ++n2;
        }
        System.err.println("Test");
        filter = new Builder().add('(', ')').build();
        cArray = "(hello))".toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            System.out.println(String.valueOf(ch) + " - " + filter.test(ch));
            ++n2;
        }
        System.err.println("Test");
        filter = new Builder().add('l', 'l').build();
        cArray = "(hello))".toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            System.out.println(String.valueOf(ch) + " - " + filter.test(ch));
            ++n2;
        }
    }

    /* synthetic */ PairFilter(Map map, Set set, PairFilter pairFilter) {
        this(map, set);
    }

    public static class Builder {
        private final Map<Character, Set<Character>> pairMap = new HashMap<Character, Set<Character>>();
        private final Set<Character> allOpenChars = new HashSet<Character>();

        public Builder add(char open, char close) {
            this.allOpenChars.add(Character.valueOf(open));
            Set<Character> list = this.pairMap.get(Character.valueOf(close));
            if (list == null) {
                list = new HashSet<Character>();
                this.pairMap.put(Character.valueOf(close), list);
            }
            list.add(Character.valueOf(open));
            return this;
        }

        public PairFilter build() {
            return new PairFilter(this.pairMap, this.allOpenChars, null);
        }
    }
}

