/*
 * Decompiled with CFR 0.152.
 */
import com.sun.tools.javac.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import junit.framework.TestCase;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ast.Layout;
import metalexer.jflex.JFlexHelper;
import metalexer.jflex.PackageFind;
import metalexer.jflex.SymbolAssigner;

public class PartialCompilation
extends TestCase {
    public static final JFlexHelper JFLEX_HELPER = new JFlexHelper();
    private static final String BEAVER_PATH = "lib/beaver-0.9.6.2/lib/beaver.jar";
    private static final String PLACEHOLDER_PATH = "test/backend-jflex/placeholders";
    private static final String IN_BASE_DIR = "test/backend-jflex/in";
    private static final String OUT_BASE_DIR = "test/backend-jflex/out";
    private static final String OUT_BIN_DIR = "test/backend-jflex/out/bin";

    static {
        new File(IN_BASE_DIR).mkdirs();
        new File(OUT_BASE_DIR).mkdirs();
        new File(OUT_BIN_DIR).mkdirs();
    }

    public void test_metalexer_component() {
        PartialCompilation.compile("metalexer", "component");
    }

    public void test_metalexer_layout() {
        PartialCompilation.compile("metalexer", "layout");
    }

    public void test_natlab_natlab() {
        PartialCompilation.compile("natlab", "natlab");
    }

    public void test_natlab_annotations() {
        PartialCompilation.compile("natlab", "annotations");
    }

    public void test_natlab_annotated_natlab() {
        PartialCompilation.compile("natlab", "annotated_natlab");
    }

    public void test_natlab_attributed_natlab() {
        PartialCompilation.compile("natlab", "attributed_natlab");
    }

    public void test_natlabnaive_natlab() {
        PartialCompilation.compile("natlab-naive", "natlab");
    }

    private static void compile(String groupName, String layoutName) {
        String inDir = "test/backend-jflex/in/" + groupName;
        String outDir = "test/backend-jflex/out/" + groupName + "/" + layoutName;
        PartialCompilation.compileLayout(layoutName, inDir, outDir);
        ClassInfo lexerClassInfo = PartialCompilation.compileJFlex(outDir, String.valueOf(outDir) + "/" + layoutName + ".flex");
        ClassInfo metaLexerClassInfo = PartialCompilation.compileJFlex(outDir, String.valueOf(outDir) + "/" + layoutName + ".meta.flex");
        PartialCompilation.compileJava(outDir, "", metaLexerClassInfo);
        PartialCompilation.compileJava(outDir, String.valueOf(outDir) + ":" + BEAVER_PATH + ":" + PLACEHOLDER_PATH, lexerClassInfo);
    }

    public static void main(String[] args) {
        String groupName = "natlab";
        String layoutName = "natlab";
        String outDir = "test/backend-jflex/out/" + groupName + "/" + layoutName;
        ClassInfo metaLexerClassInfo = PartialCompilation.compileJFlex(outDir, String.valueOf(outDir) + "/" + layoutName + ".meta.flex");
        PartialCompilation.compileJava(outDir, "", metaLexerClassInfo);
        ClassInfo lexerClassInfo = PartialCompilation.compileJFlex(outDir, String.valueOf(outDir) + "/" + layoutName + ".flex");
        PartialCompilation.compileJava(outDir, String.valueOf(outDir) + ":" + BEAVER_PATH + ":" + PLACEHOLDER_PATH, lexerClassInfo);
    }

    private static void compileLayout(String layoutName, String inDir, String outDir) {
        SortedSet<CompilationError> errors;
        TreeSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
        Layout layout = null;
        try {
            FileLoader loader = new FileLoader(inDir);
            layout = loader.loadLayout(layoutName, problems);
            if (layout != null && (layout = layout.processInheritance(loader, problems)).getHelper()) {
                problems.add(layout.makeCompilationError(String.valueOf(layout.getName()) + " is a helper layout."));
            }
        }
        catch (IOException e) {
            problems.add(new CompilationError(null, e.getMessage()));
        }
        if ((errors = ProblemUtil.extractErrors(problems)).isEmpty()) {
            try {
                layout.tidyRuleGroups();
                layout.deleteUnusedDeclarations();
                layout.assignSymbolsToMetaTokens(new SymbolAssigner(1));
                layout.generateJFlex(outDir);
                layout.generateJFlexMacroPropFile(outDir);
                layout.generateJFlexEmbeddingPropFile(outDir);
            }
            catch (IOException e) {
                System.out.println(new CompilationError(null, e.getMessage()));
                PartialCompilation.fail();
            }
        } else {
            for (CompilationError error : errors) {
                System.out.println(error);
            }
            PartialCompilation.fail();
        }
        System.err.println("Compiled metalexer: " + layoutName);
    }

    private static ClassInfo compileJFlex(String destDir, String file) {
        ClassInfo classInfo = null;
        try {
            String packageName = PartialCompilation.getPackageName(file);
            String className = PartialCompilation.getClassName(file);
            classInfo = new ClassInfo(packageName, className);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load class info from " + file, e);
        }
        JFLEX_HELPER.generate(file, String.valueOf(destDir) + "/" + classInfo.getDirName());
        System.err.println("Compiled jflex: " + file);
        return classInfo;
    }

    private static String getPackageName(String jflexFileName) throws IOException {
        BufferedReader fileIn = new BufferedReader(new FileReader(jflexFileName));
        StringBuffer header = new StringBuffer();
        while (fileIn.ready()) {
            String line = fileIn.readLine();
            if (line.trim().startsWith("%%")) break;
            header.append(String.valueOf(line) + "\n");
        }
        String packageName = PackageFind.findPackage(header.toString());
        if (packageName == null) {
            throw new RuntimeException("Can't find package name for " + jflexFileName);
        }
        return packageName;
    }

    private static String getClassName(String jflexFileName) throws IOException {
        BufferedReader fileIn = new BufferedReader(new FileReader(jflexFileName));
        while (fileIn.ready()) {
            StringTokenizer tokenizer = new StringTokenizer(fileIn.readLine());
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equals("%class") || !tokenizer.hasMoreTokens()) continue;
            return tokenizer.nextToken();
        }
        throw new RuntimeException("Can't find class name for " + jflexFileName);
    }

    private static void compileJava(String outDir, String classpath, ClassInfo classInfo) {
        String dirName = String.valueOf(outDir) + "/" + classInfo.getDirName() + "/";
        String javaFileName = String.valueOf(classInfo.getClassName()) + ".java";
        PartialCompilation.assertEquals((String)"javac status", (int)0, (int)Main.compile(new String[]{"-d", OUT_BIN_DIR, "-classpath", classpath, String.valueOf(dirName) + javaFileName}));
        System.err.println("Compiled java: " + classInfo);
    }

    private static class ClassInfo {
        private final String packageName;
        private final String className;

        public ClassInfo(String packageName, String className) {
            this.packageName = packageName != null && packageName.length() == 0 ? null : packageName;
            this.className = className;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getDirName() {
            if (this.packageName == null) {
                return "";
            }
            return this.packageName.replaceAll("\\.", "/");
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            if (this.packageName == null) {
                return this.className;
            }
            return String.valueOf(this.packageName) + "." + this.className;
        }
    }
}

