/*
 * Decompiled with CFR 0.152.
 */
public class Unescape {
    private static char unescape(String escape) {
        char ch = escape.charAt(1);
        switch (ch) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'f': {
                return '\f';
            }
            case 'b': {
                return '\b';
            }
        }
        if (escape.length() == 2) {
            return ch;
        }
        switch (ch) {
            case 'u': 
            case 'x': {
                String hex = escape.substring(2);
                return (char)Integer.parseInt(hex, 16);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                String octal = escape.substring(1);
                return (char)Integer.parseInt(octal, 8);
            }
        }
        throw new RuntimeException("Invalid escape sequence: " + escape);
    }

    public static void main(String[] args) {
        System.out.println(Unescape.unescape("\\n"));
        System.out.println(Unescape.unescape("\\r"));
        System.out.println(Unescape.unescape("\\t"));
        System.out.println(Unescape.unescape("\\f"));
        System.out.println(Unescape.unescape("\\b"));
        System.out.println(Unescape.unescape("\\x31"));
        System.out.println(Unescape.unescape("\\ua"));
        System.out.println(Unescape.unescape("\\u31"));
        System.out.println(Unescape.unescape("\\u031"));
        System.out.println(Unescape.unescape("\\u0031"));
        System.out.println(Unescape.unescape("\\7"));
        System.out.println(Unescape.unescape("\\71"));
        System.out.println(Unescape.unescape("\\071"));
        System.out.println(Unescape.unescape("\\a"));
        System.out.println(Unescape.unescape("\\u"));
        System.out.println(Unescape.unescape("\\x"));
    }
}

