/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.BitSet;
import machine.NFA;

public class ENFA {
    private final int numStates;
    private final int numSymbols;
    private final BitSet[][] transitions;
    private final BitSet[] epsilons;
    private final Integer[] actions;

    public ENFA(BitSet[][] transitions, BitSet[] epsilons, Integer[] actions) {
        this.numStates = transitions.length;
        this.numSymbols = transitions[0].length;
        this.transitions = transitions;
        this.epsilons = epsilons;
        this.actions = actions;
    }

    public NFA convertToNFA() {
        BitSet[] epsilonClosures = new BitSet[this.numStates];
        int state = 0;
        while (state < this.numStates) {
            epsilonClosures[state] = this.buildEpsilonClosure(state);
            ++state;
        }
        BitSet[][] nfaTransitions = new BitSet[this.numStates][this.numSymbols];
        int state2 = 0;
        while (state2 < this.numStates) {
            int sym = 0;
            while (sym < this.numSymbols) {
                BitSet closure = epsilonClosures[state2];
                BitSet destination = new BitSet(this.numStates);
                int st = 0;
                while (st < this.numStates) {
                    if (closure.get(st)) {
                        destination.or(this.transitions[st][sym]);
                    }
                    ++st;
                }
                nfaTransitions[state2][sym] = destination = this.epsilonClosure(destination, epsilonClosures);
                ++sym;
            }
            ++state2;
        }
        return new NFA(nfaTransitions, this.actions);
    }

    private BitSet buildEpsilonClosure(int state) {
        BitSet closure = new BitSet();
        closure.set(state);
        BitSet nextStep;
        while (!(nextStep = this.buildEpsilonClosureStep(closure)).equals(closure)) {
            closure = nextStep;
        }
        return closure;
    }

    private BitSet buildEpsilonClosureStep(BitSet stateGroup) {
        BitSet nextStep = new BitSet();
        nextStep.or(stateGroup);
        int state = 0;
        while (state < this.numStates) {
            if (stateGroup.get(state)) {
                nextStep.or(this.epsilons[state]);
            }
            ++state;
        }
        return nextStep;
    }

    private BitSet epsilonClosure(BitSet stateGroup, BitSet[] epsilonClosures) {
        BitSet closure = new BitSet();
        int state = 0;
        while (state < this.numStates) {
            if (stateGroup.get(state)) {
                closure.or(epsilonClosures[state]);
            }
            ++state;
        }
        return closure;
    }

    public void dump() {
        System.out.println("ENFA");
        System.out.println("Transitions:");
        int state = 0;
        while (state < this.numStates) {
            int symbol = 0;
            while (symbol < this.numSymbols) {
                System.out.print(String.valueOf(ENFA.toString(this.transitions[state][symbol])) + "\t");
                ++symbol;
            }
            System.out.println();
            ++state;
        }
        System.out.println();
        System.out.println("Epsilons:");
        state = 0;
        while (state < this.numStates) {
            System.out.println(ENFA.toString(this.epsilons[state]));
            ++state;
        }
        System.out.println();
        System.out.println("Actions:");
        state = 0;
        while (state < this.numStates) {
            System.out.println(this.actions[state]);
            ++state;
        }
    }

    public static String toString(BitSet set) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        boolean first = true;
        int i = 0;
        while (i < set.size()) {
            if (set.get(i)) {
                if (!first) {
                    buf.append(',');
                }
                buf.append(i);
                first = false;
            }
            ++i;
        }
        buf.append('}');
        return buf.toString();
    }
}

