/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import machine.ENFA;
import metalexer.ast.AltMetaPattern;
import metalexer.ast.AnyMetaPattern;
import metalexer.ast.BOFMetaPattern;
import metalexer.ast.BaseMetaPattern;
import metalexer.ast.ClassMetaPattern;
import metalexer.ast.MetaPattern;
import metalexer.ast.OptMetaPattern;
import metalexer.ast.PlusMetaPattern;
import metalexer.ast.RegionMetaPattern;
import metalexer.ast.SeqMetaPattern;
import metalexer.ast.StarMetaPattern;
import metalexer.ast.SymMetaPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Machine {
    private static final int BOF_SYM_NUM = 0;

    public static ENFA buildENFA(List<MetaPattern> mpats, List<Integer> actions, int numSymbols) {
        ArrayList<SubMachine> machines = new ArrayList<SubMachine>(mpats.size());
        ArrayList<Integer[]> transitions = new ArrayList<Integer[]>();
        ArrayList<Set<Integer>> epsilons = new ArrayList<Set<Integer>>();
        int start = Machine.addState(transitions, epsilons, numSymbols);
        Integer[] startTransitions = (Integer[])transitions.get(start);
        Set startEpsilons = (Set)epsilons.get(start);
        int sym = 0;
        while (sym < numSymbols) {
            startTransitions[sym] = start;
            ++sym;
        }
        for (MetaPattern mpat : mpats) {
            SubMachine sub = Machine.buildSubMachine(mpat, transitions, epsilons, numSymbols);
            startEpsilons.add(sub.startState);
            machines.add(sub);
        }
        return Machine.buildENFA(transitions, epsilons, actions, numSymbols);
    }

    private static ENFA buildENFA(List<Integer[]> mTransitions, List<Set<Integer>> mEpsilons, List<Integer> mActions, int numSymbols) {
        int numStates = mTransitions.size();
        BitSet[][] transitions = new BitSet[numStates][numSymbols];
        BitSet[] epsilons = new BitSet[numStates];
        Integer[] actions = new Integer[numStates];
        int state = 0;
        while (state < numStates) {
            int sym = 0;
            while (sym < numSymbols) {
                transitions[state][sym] = new BitSet(numStates);
                Integer destination = mTransitions.get(state)[sym];
                if (destination != null) {
                    transitions[state][sym].set(destination);
                }
                ++sym;
            }
            epsilons[state] = new BitSet(numStates);
            for (Integer st : mEpsilons.get(state)) {
                epsilons[state].set(st);
            }
            actions[state] = mActions.get(state);
            ++state;
        }
        return new ENFA(transitions, epsilons, actions);
    }

    public static SubMachine buildSubMachine(MetaPattern mpat, List<Integer[]> transitions, List<Set<Integer>> epsilons, int numSymbols) {
        int start = Machine.addState(transitions, epsilons, numSymbols);
        int end = Machine.addState(transitions, epsilons, numSymbols);
        if (mpat instanceof AltMetaPattern) {
            SubMachine sub1 = Machine.buildSubMachine(((AltMetaPattern)mpat).getAlt1(), transitions, epsilons, numSymbols);
            SubMachine sub2 = Machine.buildSubMachine(((AltMetaPattern)mpat).getAlt2(), transitions, epsilons, numSymbols);
            epsilons.get(start).add(sub1.startState);
            epsilons.get(start).add(sub2.startState);
            epsilons.get(sub1.endState).add(end);
            epsilons.get(sub2.endState).add(end);
        } else if (mpat instanceof SeqMetaPattern) {
            SubMachine sub1 = Machine.buildSubMachine(((SeqMetaPattern)mpat).getSeq1(), transitions, epsilons, numSymbols);
            SubMachine sub2 = Machine.buildSubMachine(((SeqMetaPattern)mpat).getSeq2(), transitions, epsilons, numSymbols);
            epsilons.get(start).add(sub1.startState);
            epsilons.get(sub1.endState).add(sub2.startState);
            epsilons.get(sub1.endState).add(end);
        } else if (mpat instanceof PlusMetaPattern) {
            SubMachine sub = Machine.buildSubMachine(((PlusMetaPattern)mpat).getMetaPattern(), transitions, epsilons, numSymbols);
            epsilons.get(start).add(sub.startState);
            epsilons.get(sub.startState).add(end);
            epsilons.get(sub.endState).add(sub.startState);
        } else if (mpat instanceof StarMetaPattern) {
            SubMachine sub = Machine.buildSubMachine(((StarMetaPattern)mpat).getMetaPattern(), transitions, epsilons, numSymbols);
            epsilons.get(start).add(sub.startState);
            epsilons.get(sub.startState).add(end);
            epsilons.get(sub.endState).add(sub.startState);
            epsilons.get(start).add(end);
        } else if (mpat instanceof OptMetaPattern) {
            SubMachine sub = Machine.buildSubMachine(((OptMetaPattern)mpat).getMetaPattern(), transitions, epsilons, numSymbols);
            epsilons.get(start).add(sub.startState);
            epsilons.get(sub.startState).add(end);
            epsilons.get(start).add(end);
        } else if (mpat instanceof ClassMetaPattern) {
            Integer[] startStateRow = transitions.get(start);
            ClassMetaPattern cmp = (ClassMetaPattern)mpat;
            if (cmp.getNegated()) {
                HashSet<Integer> negated = new HashSet<Integer>();
                for (BaseMetaPattern bmp : cmp.getBaseMetaPatterns()) {
                    negated.add(Machine.getValue(bmp));
                }
                int sym = 0;
                while (sym < numSymbols) {
                    if (!negated.contains(sym)) {
                        startStateRow[sym] = end;
                    }
                    ++sym;
                }
            } else {
                for (BaseMetaPattern bmp : cmp.getBaseMetaPatterns()) {
                    startStateRow[Machine.getValue((BaseMetaPattern)bmp)] = end;
                }
            }
        } else if (mpat instanceof AnyMetaPattern) {
            Integer[] startStateRow = transitions.get(start);
            int sym = 0;
            while (sym < numSymbols) {
                if (sym != 0) {
                    startStateRow[sym] = end;
                }
                ++sym;
            }
        } else if (mpat instanceof BOFMetaPattern) {
            transitions.get((int)start)[0] = end;
        } else if (mpat instanceof BaseMetaPattern) {
            int sym = Machine.getValue((BaseMetaPattern)mpat);
            transitions.get((int)start)[sym] = end;
        }
        return new SubMachine(start, end);
    }

    public static int getValue(BaseMetaPattern bmp) {
        if (bmp instanceof SymMetaPattern) {
            SymMetaPattern smp = (SymMetaPattern)bmp;
            return smp.getSym().getSymbolValue();
        }
        if (bmp instanceof RegionMetaPattern) {
            RegionMetaPattern rmp = (RegionMetaPattern)bmp;
            return rmp.getRegion().getDecl().getComponent().getRegionSymbolValue();
        }
        throw new RuntimeException();
    }

    private static int addState(List<Integer[]> transitions, List<Set<Integer>> epsilons, int numSymbols) {
        int stateNum = transitions.size();
        transitions.add(new Integer[numSymbols]);
        epsilons.add(new HashSet());
        return stateNum;
    }

    private static class SubMachine {
        int startState;
        int endState;

        public SubMachine(int startState, int endState) {
            this.startState = startState;
            this.endState = endState;
        }
    }
}

