/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationProblem
implements Comparable<CompilationProblem> {
    private final String filename;
    private final int line;
    private final int col;
    private final String message;

    public CompilationProblem(String filename, String message) {
        this.filename = filename;
        this.line = Integer.MAX_VALUE;
        this.col = Integer.MAX_VALUE;
        this.message = message;
    }

    public CompilationProblem(String filename, int line, int col, String message) {
        this.filename = filename;
        this.line = line;
        this.col = col;
        this.message = message;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.line == Integer.MAX_VALUE && this.col == Integer.MAX_VALUE) {
            if (this.filename == null) {
                return this.message;
            }
            return String.valueOf(this.filename) + "  " + this.message;
        }
        if (this.filename == null) {
            throw new RuntimeException("Error has a position but not a filename: " + this.message + ".");
        }
        return String.valueOf(this.filename) + " [" + this.line + ", " + this.col + "]  " + this.message;
    }

    @Override
    public int compareTo(CompilationProblem o) {
        if (o == null) {
            return -1;
        }
        if (this.compare(this.filename, o.filename) != 0) {
            return this.compare(this.filename, o.filename);
        }
        if (this.line < o.line) {
            return -1;
        }
        if (this.line > o.line) {
            return 1;
        }
        if (this.col < o.col) {
            return -1;
        }
        if (this.col > o.col) {
            return 1;
        }
        return this.compare(this.message, o.message);
    }

    public int compare(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return 1;
        }
        if (s1 != null && s2 == null) {
            return -1;
        }
        if (s1 == null && s2 == null) {
            return 0;
        }
        return s1.compareTo(s2);
    }
}

