/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltRegex;
import metalexer.ast.AnyPattern;
import metalexer.ast.AppendRegion;
import metalexer.ast.CharClassRegex;
import metalexer.ast.CharRegex;
import metalexer.ast.Component;
import metalexer.ast.ComponentDirective;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.DeclRegion;
import metalexer.ast.Deletion;
import metalexer.ast.DotRegex;
import metalexer.ast.EOFPattern;
import metalexer.ast.EOLRegexPattern;
import metalexer.ast.EscapeRegex;
import metalexer.ast.ExternDecl;
import metalexer.ast.ExternDirective;
import metalexer.ast.HeaderBlob;
import metalexer.ast.HeaderSection;
import metalexer.ast.HelperDirective;
import metalexer.ast.ImportDirective;
import metalexer.ast.InheritSection;
import metalexer.ast.InitRegion;
import metalexer.ast.InitThrowDirective;
import metalexer.ast.LexThrowDirective;
import metalexer.ast.List;
import metalexer.ast.LookaheadRegexPattern;
import metalexer.ast.MacroDecl;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.MultiCharRange;
import metalexer.ast.NotRegex;
import metalexer.ast.Opt;
import metalexer.ast.OptRegex;
import metalexer.ast.Pattern;
import metalexer.ast.PlusRegex;
import metalexer.ast.RangeRepeatRegex;
import metalexer.ast.Regex;
import metalexer.ast.RepeatRegex;
import metalexer.ast.Rule;
import metalexer.ast.RuleGroup;
import metalexer.ast.RuleSection;
import metalexer.ast.SeqRegex;
import metalexer.ast.SingleCharRange;
import metalexer.ast.StarRegex;
import metalexer.ast.StartDirective;
import metalexer.ast.State;
import metalexer.ast.StateDirective;
import metalexer.ast.StateRef;
import metalexer.ast.StringRegex;
import metalexer.ast.UptoRegex;
import metalexer.ast.XStateDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMWUK5CKMlTCpi#mkYiWtY$lrgui11DQ02v9qTG5141SK5W414L4aI50G9IFcd0CgmQo0WWeY22fAagGWMRA0V52K$mtltwhfxktfgMwMPO$d7mzpp#jNLU#zMw#hNrVtp2vGzXNvCWYu77C3BDraB9gZmEtN4K4x6IjZTEySd84pSGdos9iJ1CoHtm8iYdaCld3xLwAsvXwZ#sDa3vv5XknX#uqm85$#WylG08tG4tLn5YhZKZHqhTtbO$aOTP23ggY6wl9I692FT0ENOor4U$J0BQx$w32GAzF0vLWBSItQeBNh$s8Oo7MCWSknAguMv7ByNmW3kKuqS3dMc#oy7F$dmq2kHmrSZhKGDvEhg#l$N1Z8TPw1ox4#PkVb#3yRXe2y7FkVSWTo4NFxpuI1TTutKUUu6AVXTCQgodMiZya0j4Kvr$#fC2HnrIFN0CtbsAV9DBH2URV$H1YIk6x3wOe9jLnh7NJXtVHVr$$XC2Hn3R2vCbnhVTmWlqiVr$#1C2HnFK#kfZhMiU$cNNsLx7RxzuV1mrM9xRFj$SQn$oG$uMeUdVwzOM1y5PlBtRbmlMl$KNx4hJmw$Vl2mCeUAbDbAWhbP$aPvr96u2BN#Y#SAlqnoFL$90pwxcs2rcXiL$WGnlPnxHyH7n9E$ybGZ7GvHg0YQk0ADCD9ZXNdOnWkO9wEz#EX628ZDOR9S1cXCPHdRLjPNyFuT1ZYUZyO1gxJa0JO6gun6ADSwuLeYMkOb#F$K2Y6yHmxShqwC1$xRF60OsLUdT2PbUzuFngAmJox1EwHeGdWNiUAcdW6zpCln$knK8mYMm9taqq33pjMzC9pU85SZlVJOS1JPDF0qsJJu7exrjuoHQQGo$6VYIpAUpBJ3ro7IJ919l0PES6m7zBY#dv0J9R9cAnx4nB0uwoOsz6V8##40Mdo1rV#HdbVtaSPJENwlqSuzhV3W0Vb3$atFi17F7wCgPoHSErlXG53wJiFHPy9wk3Qtmm3Z1$N$deO0c8T#sjX28XrxA#68I3MiRyIXe1On$vo609Y7Vj4cSWAcsYeC6KnnqwqyMuelgBdLobmhFqmc0BfvmU6svwVu17A7Faa1OxdKCxn9ShQB7CnGkRXKzoDUnnF3A9jheoJURe7pDGdy9dCuFWCZir8mNH4AK$8T3$qcO#3vNhsPkzJSe$JlN6qUZqv0sOvFNlT#YhXM5y$N8$Ry0c5EWK#JytawV6SRK#FXzsJBvImzuKVhkVdZgJ0vwcPadksfsVCxidjIjYxtG$NyquUyYcfrUVpr4p9lJlH3tTWe6SDxkAOzmtc5Bx1gCy9#2TEfZvAzuwcZCJXF5P0F3Y3KARZxEmFE0CPxylWi90r61YOcvfzl3S3tHlF8pFGxO66t0RANRHeIS5d7DNYXxlYjgVd6jWzlwSzyYcrbXGCugWMFznuszF3QFVydecHOb$r8xXY5GBMTBHdhLx2otW5Op0Mup0Uh#8rl8utJDTxFrTxlip7qPIHE59VxKJ6IsMfFiutOga9z9yFmqUpV2VViVMTRtoPBADUfgm6B3E1WH$AD$8Duxv9ObicAsG5zGfbDM252Of5bijowkL9INyeYsGHHnSfgm6BJ63S35aYInYt92ctHR9O5bClLbO35fkWMEHR#PRwsoIsnR905b0lK5O35fZ0mC$bQ$cQSLydiIsGXRAGUg6o6h3G19ibfR9eyTTqFlvXs3TcqNUM7xx2yLTo8b#Ffyp6yJBR3#NZUlyYlwXZ2al2ytsyYRVmDjx1kvY8APY6wPYDhrpseBjih#obVI#UT0bVPFzN#LKTpQpAQi1EsScOdRxiTiWEVTnfn0uZjijsncptCVqWF#ZZTYD#C6ARR6FCDX$JLjcgZzkCs6h45jd2c2q#fisoMH#t6B7PY4soYJ6RV4mRPQC#RZ9Yen4RP0DZDlYOlfVlzN634TyRiLxMCsQzZscThDF7zKQiCsAjh6NCMX$J6bcZZskDM6F4Abd5c5K#fjMoMXzN6R7QY9MoaZ4hVKpxP9y#hZHYdn6xP1TZTWMyGUmo8NbMUoS8Vexbuqx3qpBmlII5sVz9Z1vhdF4#FQF9yf2oo2IPnBETbCA9XCNqKHRQijcCm48KCSIHnc#wwSX09hyz78Okk017e3oVqHMudnx5VVKOvdSSZaSVnjL5FMJfl4v15QWticfageGpK0CN8XSrKOiP1xFdqMPcLypPA73PyyaVqRzrA$PpDMSMESFO3qSvMc2md80JKH4dqQfyggXVjjHleFlbQXRATIQlzTd5vcfQYbpdbI9NkLBaYfGYLzKGhlDBCI$rgShOud4LrVb5g8qwh4bLkKLvgNlYZ5BXKXubvr9CrLokAcIgIeQISsMvN1NrVbTIhifaolAiVOGZ9LdxelR1SXMrAYTnHOhDPN5VS$QU29y4KJJc$kzmAGsqA3PNeh8hkpgBkv#t9fGSA9U57lRktTlbkeonrPZdWNCvhJnFVQczkl51SBNqvANoF9YyAddoIjm79UTguCchERqE9g$3FLnniXMNwmQNuMQt5V5mAHy$Lyp0LHUtxcScv#dhr5bCFtsTcPhPirRV3qidsglmlKMrkzBdNDtotbl1iJdC0UX0QrGV8nh5YysZjQcu7pJMnsB5Yl5pAFR$AHOMFSEUuza17ZbsLOExZDghKpsSki$ZcrK1RYIBgljixcZP7El9jqx7emLjESmoHtcmVPNE$nQ#MmkvgnkuWOwqN9zgqP7PwELoz#DTarVqpakhRT6UrTLiYLdTTGkSjSW3tG9MnSDj#oPpdnFiOSzxJjYyokFlCA$$3KQFr#UtiKkeBzMz1fH6k9p79hWY98FzCvKW0qGE88D0Iw8MlHcW2YMW5ZsvbN2kuBCDMOU$SgvYNtNUOKq2ihhImtarha4hj4OXsk1Qj4KxjCTrnhd3hxRQ8HjmXxIljbFrkWgY0T#jZQE9wvtwuOwKu$0bZUUKT1OZM$OXjh#MZP9IMMJprJHtrqQ6IWwzj#pCV9MSEXhqf59FjkGwDhC4dB5zb#dde$akSrQiiyjtKydk6ND#XvWECVtzc0AUQG7xIzAiYRiry3d6VU3IqjzZq3ranc1Bm8x3iU9yMva$IFsgBlflkgUIQWIGretjsXH#9uZy1bWdKvyDnBlIzZRx$1uI6SdsBkgtW3BZEFO1#x#ppM$lPTHpzasWR7aWeopb68uLScmV4FsHF0Cehr4cSwm7EJvZ$7EKXUpVHBs8iSFPVfZ#Vm0npX#hm$uKwZRKgwdxKxUbVef2djXIyiobdCfpsKiEzcDxg9b$f1LvygbdSKxcf7vXYB$8V3TnB4eVzQlNC8wfN#RLVvIflzV#Gbj5oiMKBfG7ECOvhR5ilqVD$AqZsLP$fnyD$SEPTG95FTq#fsOkLZrAO$PtKFUYxAQGDteiXTmMSxUcawC2#rnlQoCrvxFQKMTo$4BgQfIMb3ie7IdC9JgAyZA5EKNVeJ0VD6SSroiMenx3iJay7yuTEPDZFCSeyumqPJjEOOunNi#CN8upyJZVoQ9yDutpkfVXsfRPoZRNBDwTRSuNPrvnhccq0QyByum#oBLJr#H4zZaMPKsaLQUq0UpVeX5ZtXdgtCaJuxnM7eNr4vt6FFgm$H25DPBHZpA4mkkVCPuoapAFifd2zSfa$MIoVZB9brcBqeBIdi9haSaQoUHrZAwZvdMBxgIUJM4TnNYTCxTHinRJsOureMQ#wJNORaRDTOuLKAiQ8cVwZHJofJEl6DSxdRd5M8lfhBdq9PGrvFkPkJFVikK6wTEC5oYTQAUfQpOtqKQUhHaVvrgdZIxoAzFQraycTFfinvRePx9UquObZrcZl7s$CAVE7j$JMFzxFFspRDt876jriVMqeh5ekgqBp36H#ppnJSDoOovZAQjJvq2cZ$C6pbVUqxy$$9nr7KsqsnTuufQ7nVau#jjwTF9uWZU8Z#VHoTPhWxcjdsnkrbtPyuh6u#eUgXySbt4qOthOiGqzUVnPr2xJeRZd63nFh98zHqfjgJtQCBRRpd#KhPids#CrbUQrtcUOAokXzUTUzEFtlrwKhbei$Ljh9pqMunqJeLZepB7ERD#inGAhWn91HpxLhsU$EVMLx1TNhgPSGsb5QKqf9CUjr6sehwMqfRIZjATSH#b0MmVEeNwFlOhIJKiK1TItQ55$8OcWXPQe$ZxRLFrsIsd9ysZ9ju16R7VNalX6mYST9S8tXoXwKzUtvM8j5YNgqJ4#sIDQQbFgQ8dosH#XM7mNY50iBRbivsgTa8RiDwI#3D1$8Sdb#qWktqLgCBu6#q5IYpdNf4zDpbrJjzCebXxhGzs7utsf#rBdK#TxT1V6ErBF8tLzqaIBfNzpk9pjAxH4AN7qPBidRTo9AH7zb#lR$WSkXiLT");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol token, String msg) {
        return new CompilationError(this.filename, Symbol.getLine(token.getStart()), Symbol.getColumn(token.getStart()), msg);
    }

    private CompilationError buildError(Scanner.Exception e, String msg) {
        return new CompilationError(this.filename, e.line, e.column, msg);
    }

    private CompilationWarning buildWarning(Symbol token, String msg) {
        return new CompilationWarning(this.filename, Symbol.getLine(token.getStart()), Symbol.getColumn(token.getStart()), msg);
    }

    private CompilationWarning buildWarning(Scanner.Exception e, String msg) {
        return new CompilationWarning(this.filename, e.line, e.column, msg);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> children) {
        if (children == null) {
            return null;
        }
        return new List<T>().addAll(children);
    }

    private static <T extends ASTNode<?>> List<T> nullToEmpty(List<T> original) {
        return original == null ? new List() : original;
    }

    private static SingleCharRange makeSingleCharRange(Symbol ch) {
        SingleCharRange scr = new SingleCharRange(ch);
        scr.acquirePositionFromChildren();
        return scr;
    }

    private static MultiCharRange makeMultiCharRange(Symbol lower, Symbol upper) {
        MultiCharRange mcr = new MultiCharRange(lower, upper);
        mcr.acquirePositionFromChildren();
        return mcr;
    }

    private Symbol buildComponent(HeaderSection headerSection, RuleSection localRuleSection, List<InheritSection> inheritSections) {
        StateRef startState = null;
        boolean isHelper = false;
        List<State> states = new List<State>();
        LinkedHashSet<StringSymbol> imports = new LinkedHashSet<StringSymbol>();
        List<ExternDecl> externs = new List<ExternDecl>();
        LinkedHashSet<StringSymbol> declRegions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> yylexExceptions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> initRegions = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> initExceptions = new LinkedHashSet<StringSymbol>();
        StringSymbol appendRegion = null;
        HashSet<String> stateNames = new HashSet<String>();
        HashSet<String> xstateNames = new HashSet<String>();
        HashSet<String> importNames = new HashSet<String>();
        HashSet<Iterator<String>> externNames = new HashSet<Iterator<String>>();
        HashSet<String> yylexExceptionNames = new HashSet<String>();
        HashSet<String> initExceptionNames = new HashSet<String>();
        HashSet<String> macroNames = new HashSet<String>();
        for (HeaderBlob blob : headerSection.getHeaderBlobs()) {
            if (blob instanceof StartDirective) {
                if (startState == null) {
                    startState = ((StartDirective)blob).getState();
                    continue;
                }
                this.problems.add(this.buildWarning(blob, "Start state has already been declared."));
                continue;
            }
            if (blob instanceof HelperDirective) {
                if (isHelper) {
                    this.problems.add(this.buildWarning(blob, "Component has already been flagged as a helper component."));
                }
                isHelper = true;
                continue;
            }
            if (blob instanceof StateDirective) {
                for (State state : ((StateDirective)blob).getStates()) {
                    String stateName = state.getName();
                    if (stateNames.contains(stateName)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of state " + stateName + "."));
                        continue;
                    }
                    states.add(state);
                    stateNames.add(stateName);
                }
                continue;
            }
            if (blob instanceof XStateDirective) {
                for (State xstate : ((XStateDirective)blob).getStates()) {
                    String xstateName = xstate.getName();
                    if (xstateNames.contains(xstateName)) {
                        this.problems.add(this.buildWarning(xstate, "Duplicate declaration of xstate " + xstateName + "."));
                        continue;
                    }
                    states.add(xstate);
                    xstateNames.add(xstateName);
                }
                continue;
            }
            if (blob instanceof ImportDirective) {
                String importName = ((ImportDirective)blob).getText();
                if (importNames.contains(importName)) {
                    this.problems.add(this.buildWarning(blob, "Duplicate import."));
                    continue;
                }
                imports.add(new StringSymbol(blob, importName));
                importNames.add(importName);
                continue;
            }
            if (blob instanceof ExternDirective) {
                ExternDecl decl = ((ExternDirective)blob).getExternDecl();
                String externName = decl.getText();
                if (externNames.contains(externName)) {
                    this.problems.add(this.buildWarning(blob, "Duplicate extern."));
                    continue;
                }
                externs.add(decl);
                externNames.add((Iterator<String>)((Object)externName));
                continue;
            }
            if (blob instanceof DeclRegion) {
                declRegions.add(new StringSymbol(blob, ((DeclRegion)blob).getText()));
                continue;
            }
            if (blob instanceof LexThrowDirective) {
                for (String exceptionName : ((LexThrowDirective)blob).getExceptions()) {
                    if (yylexExceptionNames.contains(exceptionName)) {
                        this.problems.add(this.buildWarning(blob, "Duplicate declaration of lex exception " + exceptionName + "."));
                        continue;
                    }
                    yylexExceptions.add(new StringSymbol(blob, exceptionName));
                    yylexExceptionNames.add(exceptionName);
                }
                continue;
            }
            if (blob instanceof InitRegion) {
                initRegions.add(new StringSymbol(blob, ((InitRegion)blob).getText()));
                continue;
            }
            if (blob instanceof InitThrowDirective) {
                for (String exceptionName : ((InitThrowDirective)blob).getExceptions()) {
                    if (yylexExceptionNames.contains(exceptionName)) {
                        this.problems.add(this.buildWarning(blob, "Duplicate declaration of init exception " + exceptionName + "."));
                        continue;
                    }
                    initExceptions.add(new StringSymbol(blob, exceptionName));
                    initExceptionNames.add(exceptionName);
                }
                continue;
            }
            if (blob instanceof AppendRegion) {
                if (appendRegion == null) {
                    appendRegion = new StringSymbol(blob, ((AppendRegion)blob).getText());
                    continue;
                }
                this.problems.add(this.buildWarning(blob, "Component already has an %append region."));
                continue;
            }
            throw new RuntimeException("Unexpected header blob type: " + blob.getClass().getName());
        }
        ComponentDirective compDir = headerSection.getComponentDirective();
        Symbol name = new Symbol(0, compDir.Namestart, compDir.Nameend, compDir.getName());
        List<MacroDecl> macros = new List<MacroDecl>();
        for (MacroDecl decl : headerSection.getMacroDeclList()) {
            String macroName = decl.getName();
            if (macroNames.contains(macroName)) {
                this.problems.add(this.buildWarning(decl, "Duplicate declaration of macro " + macroName + "."));
                continue;
            }
            macros.add(decl);
            macroNames.add(macroName);
        }
        Opt<StateRef> optStartState = startState == null ? new Opt<StateRef>() : new Opt<StateRef>(startState);
        return new Component(name, isHelper, optStartState, states, imports, externs, declRegions, yylexExceptions, initRegions, initExceptions, appendRegion, macros, localRuleSection, inheritSections);
    }

    public ComponentParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_c = this._symbols[offset + 1];
                Component c = (Component)_symbol_c.value;
                ComponentWrapper wrapper = new ComponentWrapper(c);
                wrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return wrapper;
            }
            case 1: {
                Symbol _symbol_header_section = this._symbols[offset + 1];
                HeaderSection header_section = (HeaderSection)_symbol_header_section.value;
                return this.buildComponent(header_section, new RuleSection(new List<RuleGroup>(), new List<RuleGroup>(), new List<RuleGroup>()), new List<InheritSection>());
            }
            case 2: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 3: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 6: {
                Symbol _symbol_header_section = this._symbols[offset + 1];
                HeaderSection header_section = (HeaderSection)_symbol_header_section.value;
                Symbol _symbol_rule_section = this._symbols[offset + 3];
                RuleSection rule_section = (RuleSection)_symbol_rule_section.value;
                Symbol _symbol_extensions = this._symbols[offset + 4];
                ArrayList _list_extensions = (ArrayList)_symbol_extensions.value;
                InheritSection[] extensions = _list_extensions == null ? new InheritSection[]{} : _list_extensions.toArray(new InheritSection[_list_extensions.size()]);
                return this.buildComponent(header_section, rule_section, ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_extensions)));
            }
            case 7: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 8: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 11: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 12: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 15: {
                Symbol _symbol_name = this._symbols[offset + 1];
                ComponentDirective name = (ComponentDirective)_symbol_name.value;
                Symbol _symbol_blobs = this._symbols[offset + 2];
                ArrayList _list_blobs = (ArrayList)_symbol_blobs.value;
                HeaderBlob[] blobs = _list_blobs == null ? new HeaderBlob[]{} : _list_blobs.toArray(new HeaderBlob[_list_blobs.size()]);
                Symbol _symbol_macros = this._symbols[offset + 3];
                ArrayList _list_macros = (ArrayList)_symbol_macros.value;
                MacroDecl[] macros = _list_macros == null ? new MacroDecl[]{} : _list_macros.toArray(new MacroDecl[_list_macros.size()]);
                return new HeaderSection(name, ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_blobs)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_macros)));
            }
            case 16: {
                Symbol _symbol_name = this._symbols[offset + 2];
                String name = (String)_symbol_name.value;
                return new ComponentDirective(_symbol_name);
            }
            case 17: {
                Symbol _symbol_name = this._symbols[offset + 1];
                String name = (String)_symbol_name.value;
                Symbol _symbol_regex = this._symbols[offset + 3];
                Regex regex = (Regex)_symbol_regex.value;
                return new MacroDecl(name, regex);
            }
            case 29: {
                Symbol _symbol_text = this._symbols[offset + 1];
                String text = (String)_symbol_text.value;
                return new DeclRegion(text);
            }
            case 30: {
                Symbol _symbol_text = this._symbols[offset + 1];
                String text = (String)_symbol_text.value;
                return new InitRegion(text);
            }
            case 31: {
                Symbol _symbol_text = this._symbols[offset + 1];
                String text = (String)_symbol_text.value;
                return new AppendRegion(text);
            }
            case 32: {
                return new HelperDirective();
            }
            case 33: {
                Symbol _symbol_s = this._symbols[offset + 2];
                StateRef s = (StateRef)_symbol_s.value;
                return new StartDirective(s);
            }
            case 34: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new ExternDecl(s);
            }
            case 35: {
                Symbol _symbol_t = this._symbols[offset + 2];
                ExternDecl t = (ExternDecl)_symbol_t.value;
                return new ExternDirective(t);
            }
            case 36: {
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                return new ImportDirective(s);
            }
            case 37: {
                Symbol _symbol_l = this._symbols[offset + 2];
                java.util.List l = (java.util.List)_symbol_l.value;
                return new InitThrowDirective(l);
            }
            case 38: {
                Symbol _symbol_l = this._symbols[offset + 2];
                java.util.List l = (java.util.List)_symbol_l.value;
                return new LexThrowDirective(l);
            }
            case 39: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new StateDirective(l);
            }
            case 40: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new XStateDirective(l);
            }
            case 41: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                ArrayList<String> strings = new ArrayList<String>();
                strings.add(s);
                return new Symbol(strings);
            }
            case 42: {
                Symbol _symbol_l = this._symbols[offset + 1];
                java.util.List l = (java.util.List)_symbol_l.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                l.add(s);
                return _symbol_l;
            }
            case 44: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new State(_symbol_s, false);
            }
            case 45: {
                Symbol _symbol_s = this._symbols[offset + 1];
                State s = (State)_symbol_s.value;
                return new List<State>().add(s);
            }
            case 46: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                State s = (State)_symbol_s.value;
                return l.add(s);
            }
            case 47: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new State(_symbol_s, true);
            }
            case 48: {
                Symbol _symbol_s = this._symbols[offset + 1];
                State s = (State)_symbol_s.value;
                return new List<State>().add(s);
            }
            case 49: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                State s = (State)_symbol_s.value;
                return l.add(s);
            }
            case 50: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new StateRef(_symbol_s);
            }
            case 51: {
                Symbol _symbol_s = this._symbols[offset + 1];
                StateRef s = (StateRef)_symbol_s.value;
                return new List<StateRef>().add(s);
            }
            case 52: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                StateRef s = (StateRef)_symbol_s.value;
                return l.add(s);
            }
            case 56: {
                Symbol _symbol_states = this._symbols[offset + 2];
                List states = (List)_symbol_states.value;
                Symbol _symbol_pattern = this._symbols[offset + 3];
                Pattern pattern = (Pattern)_symbol_pattern.value;
                return new Deletion(states, pattern);
            }
            case 57: {
                Symbol _symbol_pattern = this._symbols[offset + 4];
                Pattern pattern = (Pattern)_symbol_pattern.value;
                return new Deletion(new List<StateRef>(), pattern);
            }
            case 58: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Rule r = (Rule)_symbol_r.value;
                return new RuleGroup(new List<StateRef>(), new List<Rule>().add(r));
            }
            case 59: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 60: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 61: {
                Symbol _symbol_states = this._symbols[offset + 1];
                List states = (List)_symbol_states.value;
                Symbol _symbol_rules = this._symbols[offset + 3];
                ArrayList _list_rules = (ArrayList)_symbol_rules.value;
                Rule[] rules = _list_rules == null ? new Rule[]{} : _list_rules.toArray(new Rule[_list_rules.size()]);
                return new RuleGroup(states, ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_rules)));
            }
            case 64: {
                Symbol _symbol_pattern = this._symbols[offset + 1];
                Pattern pattern = (Pattern)_symbol_pattern.value;
                Symbol _symbol_action = this._symbols[offset + 2];
                String action = (String)_symbol_action.value;
                Symbol _symbol_meta = this._symbols[offset + 3];
                String meta = (String)_symbol_meta.value;
                return new Rule(pattern, _symbol_action, _symbol_meta);
            }
            case 68: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                return new EOLRegexPattern(false, r, false);
            }
            case 69: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                return new EOLRegexPattern(false, r, true);
            }
            case 70: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                Symbol _symbol_lookahead = this._symbols[offset + 3];
                Regex lookahead = (Regex)_symbol_lookahead.value;
                return new LookaheadRegexPattern(false, r, lookahead);
            }
            case 71: {
                Symbol _symbol_r = this._symbols[offset + 2];
                Regex r = (Regex)_symbol_r.value;
                return new EOLRegexPattern(true, r, false);
            }
            case 72: {
                Symbol _symbol_r = this._symbols[offset + 2];
                Regex r = (Regex)_symbol_r.value;
                return new EOLRegexPattern(true, r, true);
            }
            case 73: {
                Symbol _symbol_r = this._symbols[offset + 2];
                Regex r = (Regex)_symbol_r.value;
                Symbol _symbol_lookahead = this._symbols[offset + 4];
                Regex lookahead = (Regex)_symbol_lookahead.value;
                return new LookaheadRegexPattern(true, r, lookahead);
            }
            case 74: {
                return new AnyPattern();
            }
            case 75: {
                return new EOFPattern();
            }
            case 78: {
                Symbol _symbol_r1 = this._symbols[offset + 1];
                Regex r1 = (Regex)_symbol_r1.value;
                Symbol _symbol_r2 = this._symbols[offset + 3];
                Regex r2 = (Regex)_symbol_r2.value;
                return new AltRegex(r1, r2);
            }
            case 80: {
                Symbol _symbol_r1 = this._symbols[offset + 1];
                Regex r1 = (Regex)_symbol_r1.value;
                Symbol _symbol_r2 = this._symbols[offset + 2];
                Regex r2 = (Regex)_symbol_r2.value;
                return new SeqRegex(r1, r2);
            }
            case 82: {
                Symbol _symbol_r = this._symbols[offset + 2];
                Regex r = (Regex)_symbol_r.value;
                return new NotRegex(r);
            }
            case 83: {
                Symbol _symbol_r = this._symbols[offset + 2];
                Regex r = (Regex)_symbol_r.value;
                return new UptoRegex(r);
            }
            case 85: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                return new OptRegex(r);
            }
            case 86: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                return new PlusRegex(r);
            }
            case 87: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                return new StarRegex(r);
            }
            case 88: {
                ArrayList<Symbol> lst = new ArrayList<Symbol>();
                lst.add(this._symbols[offset + 1]);
                return new Symbol(lst);
            }
            case 89: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2]);
                return this._symbols[offset + 1];
            }
            case 92: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                Symbol _symbol_n = this._symbols[offset + 4];
                String n = (String)_symbol_n.value;
                return new RepeatRegex(r, n);
            }
            case 93: {
                Symbol _symbol_r = this._symbols[offset + 1];
                Regex r = (Regex)_symbol_r.value;
                Symbol _symbol_min = this._symbols[offset + 4];
                String min = (String)_symbol_min.value;
                Symbol _symbol_max = this._symbols[offset + 8];
                String max = (String)_symbol_max.value;
                return new RangeRepeatRegex(r, min, max);
            }
            case 97: {
                return new DotRegex();
            }
            case 98: {
                Symbol _symbol_str = this._symbols[offset + 1];
                String str = (String)_symbol_str.value;
                return new StringRegex(str);
            }
            case 99: {
                Symbol _symbol_escape = this._symbols[offset + 1];
                String escape = (String)_symbol_escape.value;
                return new EscapeRegex(escape);
            }
            case 100: {
                return new CharRegex("=");
            }
            case 101: {
                Symbol _symbol_ch = this._symbols[offset + 1];
                String ch = (String)_symbol_ch.value;
                return new CharRegex(ch);
            }
            case 102: {
                Symbol _symbol_name = this._symbols[offset + 3];
                String name = (String)_symbol_name.value;
                return new MacroInvocationRegex(name);
            }
            case 103: {
                Symbol _symbol_ch = this._symbols[offset + 2];
                String ch = (String)_symbol_ch.value;
                return new CharClassRegex(false, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(_symbol_ch)));
            }
            case 104: {
                Symbol _symbol_ch = this._symbols[offset + 3];
                String ch = (String)_symbol_ch.value;
                return new CharClassRegex(true, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(_symbol_ch)));
            }
            case 105: {
                Symbol _symbol_lower = this._symbols[offset + 2];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 4];
                String upper = (String)_symbol_upper.value;
                return new CharClassRegex(false, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper)));
            }
            case 106: {
                Symbol _symbol_lower = this._symbols[offset + 3];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 5];
                String upper = (String)_symbol_upper.value;
                return new CharClassRegex(true, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper)));
            }
            case 109: {
                Symbol _symbol_ch = this._symbols[offset + 1];
                String ch = (String)_symbol_ch.value;
                Symbol _symbol_tail = this._symbols[offset + 2];
                List tail = (List)_symbol_tail.value;
                return new CharClassRegex(false, tail.addFirst(ComponentParser.makeSingleCharRange(_symbol_ch)));
            }
            case 110: {
                Symbol _symbol_lower = this._symbols[offset + 1];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 3];
                String upper = (String)_symbol_upper.value;
                Symbol _symbol_tail = this._symbols[offset + 4];
                List tail = (List)_symbol_tail.value;
                return new CharClassRegex(false, tail.addFirst(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper)));
            }
            case 111: {
                Symbol _symbol_ch = this._symbols[offset + 1];
                String ch = (String)_symbol_ch.value;
                Symbol _symbol_tail = this._symbols[offset + 2];
                List tail = (List)_symbol_tail.value;
                return new CharClassRegex(true, tail.addFirst(ComponentParser.makeSingleCharRange(_symbol_ch)));
            }
            case 112: {
                Symbol _symbol_lower = this._symbols[offset + 1];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 3];
                String upper = (String)_symbol_upper.value;
                Symbol _symbol_tail = this._symbols[offset + 4];
                List tail = (List)_symbol_tail.value;
                return new CharClassRegex(true, tail.addFirst(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper)));
            }
            case 113: {
                Symbol _symbol_ch = this._symbols[offset + 1];
                String ch = (String)_symbol_ch.value;
                return new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(_symbol_ch));
            }
            case 114: {
                Symbol _symbol_lower = this._symbols[offset + 1];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 3];
                String upper = (String)_symbol_upper.value;
                return new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper));
            }
            case 115: {
                Symbol _symbol_ch = this._symbols[offset + 1];
                String ch = (String)_symbol_ch.value;
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return l.addFirst(ComponentParser.makeSingleCharRange(_symbol_ch));
            }
            case 116: {
                Symbol _symbol_lower = this._symbols[offset + 1];
                String lower = (String)_symbol_lower.value;
                Symbol _symbol_upper = this._symbols[offset + 3];
                String upper = (String)_symbol_upper.value;
                Symbol _symbol_l = this._symbols[offset + 4];
                List l = (List)_symbol_l.value;
                return l.addFirst(ComponentParser.makeMultiCharRange(_symbol_lower, _symbol_upper));
            }
            case 119: {
                return new Symbol("-");
            }
            case 122: {
                return new Symbol("^");
            }
            case 125: {
                return new Symbol("-");
            }
            case 126: {
                return new Symbol("^");
            }
            case 127: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 128: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 131: {
                Symbol _symbol_acyclic = this._symbols[offset + 1];
                ArrayList _list_acyclic = (ArrayList)_symbol_acyclic.value;
                RuleGroup[] acyclic = _list_acyclic == null ? new RuleGroup[]{} : _list_acyclic.toArray(new RuleGroup[_list_acyclic.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_acyclic)), new List<RuleGroup>(), new List<RuleGroup>());
            }
            case 132: {
                Symbol _symbol_acyclic = this._symbols[offset + 1];
                ArrayList _list_acyclic = (ArrayList)_symbol_acyclic.value;
                RuleGroup[] acyclic = _list_acyclic == null ? new RuleGroup[]{} : _list_acyclic.toArray(new RuleGroup[_list_acyclic.size()]);
                Symbol _symbol_cyclic = this._symbols[offset + 3];
                ArrayList _list_cyclic = (ArrayList)_symbol_cyclic.value;
                RuleGroup[] cyclic = _list_cyclic == null ? new RuleGroup[]{} : _list_cyclic.toArray(new RuleGroup[_list_cyclic.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_acyclic)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_cyclic)), new List<RuleGroup>());
            }
            case 133: {
                Symbol _symbol_acyclic = this._symbols[offset + 1];
                ArrayList _list_acyclic = (ArrayList)_symbol_acyclic.value;
                RuleGroup[] acyclic = _list_acyclic == null ? new RuleGroup[]{} : _list_acyclic.toArray(new RuleGroup[_list_acyclic.size()]);
                Symbol _symbol_cyclic = this._symbols[offset + 3];
                ArrayList _list_cyclic = (ArrayList)_symbol_cyclic.value;
                RuleGroup[] cyclic = _list_cyclic == null ? new RuleGroup[]{} : _list_cyclic.toArray(new RuleGroup[_list_cyclic.size()]);
                Symbol _symbol_cleanup = this._symbols[offset + 5];
                ArrayList _list_cleanup = (ArrayList)_symbol_cleanup.value;
                RuleGroup[] cleanup = _list_cleanup == null ? new RuleGroup[]{} : _list_cleanup.toArray(new RuleGroup[_list_cleanup.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_acyclic)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_cyclic)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_cleanup)));
            }
            case 134: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 135: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 138: {
                Symbol _symbol_name = this._symbols[offset + 2];
                String name = (String)_symbol_name.value;
                Symbol _symbol_deletions = this._symbols[offset + 3];
                ArrayList _list_deletions = (ArrayList)_symbol_deletions.value;
                Deletion[] deletions = _list_deletions == null ? new Deletion[]{} : _list_deletions.toArray(new Deletion[_list_deletions.size()]);
                Symbol _symbol_rules = this._symbols[offset + 4];
                RuleSection rules = (RuleSection)_symbol_rules.value;
                return new InheritSection(name, ComponentParser.nullToEmpty(ComponentParser.makeListNode(_list_deletions)), rules);
            }
            case 4: 
            case 9: 
            case 13: 
            case 62: 
            case 90: 
            case 129: 
            case 136: {
                return new Symbol(null);
            }
            case 5: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 43: 
            case 54: 
            case 55: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 130: 
            case 137: {
                return this._symbols[offset + 1];
            }
            case 53: 
            case 94: 
            case 107: {
                return this._symbols[offset + 2];
            }
            case 108: {
                return this._symbols[offset + 3];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        public void syntaxError(Symbol token) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(token, "unexpected token " + Terminals.NAMES[token.getId()]));
        }

        public void scannerError(Scanner.Exception e) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(e, "scanner error: " + e.getMessage()));
        }

        public void unexpectedTokenRemoved(Symbol token) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(token, "try deleting " + Terminals.NAMES[token.getId()]));
        }

        public void missingTokenInserted(Symbol token) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(token, "try inserting " + Terminals.NAMES[token.getId()]));
        }

        public void misspelledTokenReplaced(Symbol token) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(token, "try replacing with " + Terminals.NAMES[token.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short IDENTIFIER = 1;
        public static final short ESCAPE_SEQUENCE = 2;
        public static final short SECTION_SEPARATOR = 3;
        public static final short STRING = 4;
        public static final short ASSIGN = 5;
        public static final short LSQUARE = 6;
        public static final short OPEN_MACRO = 7;
        public static final short LPAREN = 8;
        public static final short NOT = 9;
        public static final short UPTO = 10;
        public static final short DOT = 11;
        public static final short NON_META = 12;
        public static final short DELETE_TERMINATOR = 13;
        public static final short ACTION = 14;
        public static final short IMPORT_DIRECTIVE = 15;
        public static final short DECL_REGION = 16;
        public static final short INIT_REGION = 17;
        public static final short APPEND_REGION = 18;
        public static final short HELPER_DIRECTIVE = 19;
        public static final short START_DIRECTIVE = 20;
        public static final short EXTERN_DIRECTIVE = 21;
        public static final short INITTHROW_DIRECTIVE = 22;
        public static final short LEXTHROW_DIRECTIVE = 23;
        public static final short STATE_DIRECTIVE = 24;
        public static final short XSTATE_DIRECTIVE = 25;
        public static final short END_OF_LINE = 26;
        public static final short SLASH = 27;
        public static final short RPAREN = 28;
        public static final short ALT = 29;
        public static final short INHERIT_SECTION_SEPARATOR = 30;
        public static final short BEGINNING_OF_LINE = 31;
        public static final short ANY_PATTERN = 32;
        public static final short EOF_PATTERN = 33;
        public static final short OPEN_REPETITION_SPEC = 34;
        public static final short OPT = 35;
        public static final short PLUS = 36;
        public static final short STAR = 37;
        public static final short COMMA = 38;
        public static final short LANGLE = 39;
        public static final short GROUP_SEPARATOR = 40;
        public static final short CHAR_CLASS_NEGATE = 41;
        public static final short DASH = 42;
        public static final short CHAR_CLASS_CHAR = 43;
        public static final short RSQUARE = 44;
        public static final short OTHER_WHITESPACE = 45;
        public static final short DELETE_DIRECTIVE = 46;
        public static final short NUMBER = 47;
        public static final short CLOSE_REPETITION_SPEC = 48;
        public static final short CLOSE_RULE_GROUP = 49;
        public static final short RANGLE = 50;
        public static final short CLOSE_MACRO = 51;
        public static final short OPEN_RULE_GROUP = 52;
        public static final short QUALIFIED_IDENTIFIER = 53;
        public static final short COMPONENT_DIRECTIVE = 54;
        public static final String[] NAMES = new String[]{"EOF", "IDENTIFIER", "ESCAPE_SEQUENCE", "SECTION_SEPARATOR", "STRING", "ASSIGN", "LSQUARE", "OPEN_MACRO", "LPAREN", "NOT", "UPTO", "DOT", "NON_META", "DELETE_TERMINATOR", "ACTION", "IMPORT_DIRECTIVE", "DECL_REGION", "INIT_REGION", "APPEND_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "EXTERN_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "STATE_DIRECTIVE", "XSTATE_DIRECTIVE", "END_OF_LINE", "SLASH", "RPAREN", "ALT", "INHERIT_SECTION_SEPARATOR", "BEGINNING_OF_LINE", "ANY_PATTERN", "EOF_PATTERN", "OPEN_REPETITION_SPEC", "OPT", "PLUS", "STAR", "COMMA", "LANGLE", "GROUP_SEPARATOR", "CHAR_CLASS_NEGATE", "DASH", "CHAR_CLASS_CHAR", "RSQUARE", "OTHER_WHITESPACE", "DELETE_DIRECTIVE", "NUMBER", "CLOSE_REPETITION_SPEC", "CLOSE_RULE_GROUP", "RANGLE", "CLOSE_MACRO", "OPEN_RULE_GROUP", "QUALIFIED_IDENTIFIER", "COMPONENT_DIRECTIVE"};
    }
}

