/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.Symbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.ComponentParser;
import metalexer.ComponentScanner;
import metalexer.LayoutParser;
import metalexer.LayoutScanner;
import metalexer.ast.Component;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.Layout;
import metalexer.ast.LayoutWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoaderHelper {
    private final String baseDir;
    private final Map<String, Component> components;
    private final Map<String, Layout> layouts;

    public FileLoaderHelper(String baseDir) {
        this.baseDir = baseDir;
        this.components = new HashMap<String, Component>();
        this.layouts = new HashMap<String, Layout>();
    }

    public Component loadComponent(String compName, SortedSet<CompilationProblem> errors) throws IOException {
        if (this.components.containsKey(compName)) {
            return this.components.get(compName);
        }
        String filename = String.valueOf(this.baseDir) + File.separator + FileLoaderHelper.expandQualifiedName(compName) + ".mlc";
        BufferedReader in = FileLoaderHelper.openFile(filename);
        ComponentScanner scanner = new ComponentScanner(in);
        ComponentParser parser = new ComponentParser();
        parser.setFilename(filename);
        Component root = null;
        try {
            root = ((ComponentWrapper)parser.parse(scanner)).getComponent();
        }
        catch (Parser.Exception exception) {
            // empty catch block
        }
        errors.addAll(parser.getProblems());
        this.components.put(compName, root);
        if (root != null && !root.getName().equals(compName)) {
            int pos = root.Namestart;
            int line = Symbol.getLine(pos);
            int col = Symbol.getColumn(pos);
            errors.add(new CompilationError(filename, line, col, "File name (" + compName + ".mlc" + ") does not match component name (" + root.getName() + ")."));
        }
        return root;
    }

    public Layout loadLayout(String layoutName, SortedSet<CompilationProblem> errors) throws IOException {
        if (this.layouts.containsKey(layoutName)) {
            return this.layouts.get(layoutName);
        }
        String filename = String.valueOf(this.baseDir) + File.separator + FileLoaderHelper.expandQualifiedName(layoutName) + ".mll";
        BufferedReader in = FileLoaderHelper.openFile(filename);
        LayoutScanner scanner = new LayoutScanner(in);
        LayoutParser parser = new LayoutParser();
        parser.setFilename(filename);
        Layout root = null;
        try {
            root = ((LayoutWrapper)parser.parse(scanner)).getLayout();
        }
        catch (Parser.Exception exception) {
            // empty catch block
        }
        errors.addAll(parser.getProblems());
        this.layouts.put(layoutName, root);
        if (root != null && !root.getName().equals(layoutName)) {
            int pos = root.Namestart;
            int line = Symbol.getLine(pos);
            int col = Symbol.getColumn(pos);
            errors.add(new CompilationError(filename, line, col, "File name (" + layoutName + ".mll" + ") does not match layout name (" + root.getName() + ")."));
        }
        return root;
    }

    private static BufferedReader openFile(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }

    private static String expandQualifiedName(String qualifiedName) {
        return qualifiedName.replaceAll("\\.", File.separator);
    }
}

