/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class InheritancePassTestGenerator
extends AbstractTestGenerator {
    private final String prefix;

    protected InheritancePassTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "InheritancePassTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + this.prefix + ";");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "InheritancePassTests extends " + this.prefix + "ParserPassTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        FileLoader loader = new FileLoader(\"test/frontend\");");
        testFileWriter.println("        SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();");
        testFileWriter.println("        " + this.prefix + " actual = loader.load" + this.prefix + "(\"" + testName + "\", problems);");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertTrue(ProblemUtil.extractErrors(problems).isEmpty());");
        testFileWriter.println("        actual = actual.processInheritance(loader, problems);");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        actual.tidyRuleGroups();");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertTrue(ProblemUtil.extractErrors(problems).isEmpty());");
        testFileWriter.println("        Structure expected = parseStructure(\"" + outFileName + "\");");
        testFileWriter.println("        assertEquiv(actual, expected);");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

