/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ScannerUtil;
import metalexer.ast.Layout;

public class LayoutWarningTestTool {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.LayoutWarningTestTool {basename}");
            System.exit(1);
        }
        String basename = args[0];
        try {
            FileLoader loader = new FileLoader("test/frontend");
            TreeSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
            Layout actual = loader.loadLayout(basename, problems);
            assert (actual.subtreeNodesHaveCorrectParents());
            actual = actual.processInheritance(loader, problems);
            assert (actual.subtreeNodesHaveCorrectParents());
            PrintWriter out = new PrintWriter(new FileWriter("test/frontend/" + basename + ".out"));
            for (CompilationWarning warning : ProblemUtil.extractWarnings(problems)) {
                out.println(ScannerUtil.stringifyValue(warning));
            }
            out.close();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

