/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Scanner;
import beaver.Symbol;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import metalexer.ast.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParserPassTestBase
extends TestCase {
    ParserPassTestBase() {
    }

    protected abstract Scanner getScanner(String var1) throws FileNotFoundException;

    static Structure parseStructure(String filename) throws IOException {
        StringBuffer structureBuf = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        StringTokenizer startTokenizer = new StringTokenizer(in.readLine());
        int startLine = Integer.parseInt(startTokenizer.nextToken());
        int startCol = Integer.parseInt(startTokenizer.nextToken());
        StringTokenizer endTokenizer = new StringTokenizer(in.readLine());
        int endLine = Integer.parseInt(endTokenizer.nextToken());
        int endCol = Integer.parseInt(endTokenizer.nextToken());
        while (in.ready()) {
            structureBuf.append(in.readLine());
            structureBuf.append('\n');
        }
        in.close();
        return new Structure(structureBuf.toString(), startLine, startCol, endLine, endCol);
    }

    public static void assertEquiv(ASTNode<?> actual, Structure expected) {
        try {
            BufferedReader expectedReader = new BufferedReader(new StringReader(expected.getStructureString()));
            BufferedReader actualReader = new BufferedReader(new StringReader(actual.getStructureString()));
            while (true) {
                String actualLine;
                String expectedLine;
                if (!ParserPassTestBase.equals(expectedLine = expectedReader.readLine(), actualLine = actualReader.readLine())) {
                    StringBuffer buf = new StringBuffer();
                    if (expectedLine == null) {
                        buf.append("Actual AST is larger than expected AST:\n");
                        buf.append(actualLine);
                        buf.append('\n');
                        ParserPassTestBase.appendRemainingToBuffer(actualReader, buf);
                        ParserPassTestBase.fail((String)buf.toString());
                        continue;
                    }
                    if (actualLine == null) {
                        buf.append("Expected AST is larger than actual AST:\n");
                        buf.append(expectedLine);
                        buf.append('\n');
                        ParserPassTestBase.appendRemainingToBuffer(expectedReader, buf);
                        ParserPassTestBase.fail((String)buf.toString());
                        continue;
                    }
                    buf.append("ASTs do not match:\n");
                    buf.append("Remaining expected:\n");
                    buf.append(expectedLine);
                    buf.append('\n');
                    ParserPassTestBase.appendRemainingToBuffer(expectedReader, buf);
                    buf.append('\n');
                    buf.append("Remaining actual:\n");
                    buf.append(actualLine);
                    buf.append('\n');
                    ParserPassTestBase.appendRemainingToBuffer(actualReader, buf);
                    ParserPassTestBase.fail((String)buf.toString());
                    continue;
                }
                if (actualLine == null) break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int actualStartPos = actual.getStart();
        int actualStartLine = Symbol.getLine(actualStartPos);
        int actualStartCol = Symbol.getColumn(actualStartPos);
        ParserPassTestBase.assertEquals((int)expected.getStartLine(), (int)actualStartLine);
        ParserPassTestBase.assertEquals((int)expected.getStartCol(), (int)actualStartCol);
        int actualEndPos = actual.getEnd();
        int actualEndLine = Symbol.getLine(actualEndPos);
        int actualEndCol = Symbol.getColumn(actualEndPos);
        ParserPassTestBase.assertEquals((int)expected.getEndLine(), (int)actualEndLine);
        ParserPassTestBase.assertEquals((int)expected.getEndCol(), (int)actualEndCol);
    }

    private static void appendRemainingToBuffer(BufferedReader reader, StringBuffer buf) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
    }

    private static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        if (str2 == null) {
            return str1 == null;
        }
        return str1.equals(str2);
    }

    static class Structure {
        private final String structureString;
        private final int startLine;
        private final int startCol;
        private final int endLine;
        private final int endCol;

        protected Structure(String structureString, int startLine, int startCol, int endLine, int endCol) {
            this.structureString = structureString;
            this.startLine = startLine;
            this.startCol = startCol;
            this.endLine = endLine;
            this.endCol = endCol;
        }

        public String getStructureString() {
            return this.structureString;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getStartCol() {
            return this.startCol;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getEndCol() {
            return this.endCol;
        }
    }
}

