/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import java.io.PrintWriter;
import metalexer.AbstractTestGenerator;

public abstract class ParserPassTestGenerator
extends AbstractTestGenerator {
    private final String prefix;

    protected ParserPassTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "ParserPassTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + this.prefix + ";");
        testFileWriter.println("import metalexer.ast." + this.prefix + "Wrapper;");
        testFileWriter.println();
        testFileWriter.println("import beaver.Scanner;");
        testFileWriter.println();
        testFileWriter.println("public class " + this.prefix + "ParserPassTests extends " + this.prefix + "ParserPassTestBase {");
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String inFileName = "test/frontend/" + testName + ".in";
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("\tpublic void " + methodName + "() throws Exception {");
        testFileWriter.println("\t\tScanner scanner = getScanner(\"" + inFileName + "\");");
        testFileWriter.println("\t\t" + this.prefix + "Parser parser = new " + this.prefix + "Parser();");
        testFileWriter.println("        parser.setFilename(\"" + inFileName + "\");");
        testFileWriter.println("\t\t" + this.prefix + " actual = ((" + this.prefix + "Wrapper) parser.parse(scanner)).get" + this.prefix + "();");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("\t\tStructure expected = parseStructure(\"" + outFileName + "\");");
        testFileWriter.println("\t\tassertEquiv(actual, expected);");
        testFileWriter.println("\t}");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}

