/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Scanner;
import beaver.Symbol;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import metalexer.ScannerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScannerTestBase
extends TestCase {
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("^\\s*([_A-Z]+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*(?:\\s(\\d+))?\\s*(?:\\s=(.*))?$");
    private final short eofTokenID;
    private final String[] terminalNames;

    protected ScannerTestBase(short eofTokenID, String[] terminalNames) {
        this.eofTokenID = eofTokenID;
        this.terminalNames = terminalNames;
    }

    public void checkScan(Scanner scanner, List<Symbol> symbols, Scanner.Exception exception) throws IOException, Scanner.Exception {
        int tokenNum = 0;
        for (Symbol expected : symbols) {
            try {
                Symbol actual = scanner.nextToken();
                this.assertEquals("Token #" + tokenNum, actual, expected);
                ++tokenNum;
            }
            catch (Scanner.Exception e) {
                ScannerTestBase.assertEquals(e.getMessage(), e, exception);
                return;
            }
        }
        try {
            short actualId = scanner.nextToken().getId();
            short expectedId = this.eofTokenID;
            if (actualId != expectedId) {
                ScannerTestBase.fail((String)("Token #" + tokenNum + ": incorrect token type - " + "expected: " + expectedId + " (" + this.terminalNames[expectedId] + ") " + "but was: " + actualId + " (" + this.terminalNames[actualId] + ")"));
            }
        }
        catch (Scanner.Exception e) {
            ScannerTestBase.assertEquals(e.getMessage(), e, exception);
        }
    }

    protected abstract Scanner getScanner(String var1) throws FileNotFoundException;

    public Scanner.Exception parseSymbols(String filename, List<Symbol> symbols) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while (in.ready()) {
            String line = in.readLine();
            if (ScannerTestBase.isExceptionLine(line)) {
                return ScannerTestBase.parseException(line);
            }
            symbols.add(this.parseSymbol(line));
        }
        in.close();
        return null;
    }

    private static boolean isExceptionLine(String line) {
        return line.charAt(0) == '~';
    }

    private static Scanner.Exception parseException(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line.substring(1));
        ScannerTestBase.assertEquals((String)("Number of tokens in exception line: " + line), (int)2, (int)tokenizer.countTokens());
        int lineNum = Integer.parseInt(tokenizer.nextToken());
        int colNum = Integer.parseInt(tokenizer.nextToken());
        return new Scanner.Exception(lineNum, colNum, null);
    }

    private Symbol parseSymbol(String line) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        Matcher matcher = SYMBOL_PATTERN.matcher(line);
        if (!matcher.matches()) {
            ScannerTestBase.fail((String)("Invalid line: " + line));
        }
        String idString = matcher.group(1);
        short id = this.getID(idString);
        int lineNum = Integer.parseInt(matcher.group(2));
        int colNum = Integer.parseInt(matcher.group(3));
        String value = matcher.group(6);
        if (matcher.group(5) == null) {
            int length = Integer.parseInt(matcher.group(4));
            return new Symbol(id, lineNum, colNum, length, value);
        }
        int endLine = Integer.parseInt(matcher.group(4));
        int endCol = Integer.parseInt(matcher.group(5));
        int startPos = Symbol.makePosition(lineNum, colNum);
        int endPos = Symbol.makePosition(endLine, endCol);
        return new Symbol(id, startPos, endPos, value);
    }

    protected abstract short getID(String var1) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException;

    protected void assertEquals(String msg, Symbol actual, Symbol expected) {
        short expectedId = expected.getId();
        short actualId = actual.getId();
        if (actualId != expectedId) {
            ScannerTestBase.fail((String)(String.valueOf(msg) + ": incorrect token type - " + "expected: " + expectedId + " (" + this.terminalNames[expectedId] + ") " + "but was: " + actualId + " (" + this.terminalNames[actualId] + ")"));
        }
        String expectedValue = (String)expected.value;
        String actualValue = ScannerUtil.stringifyValue(actual.value);
        if ((actualValue == null || expectedValue == null) && actualValue != expectedValue || actualValue != null && !actualValue.equals(expectedValue)) {
            ScannerTestBase.fail((String)(String.valueOf(msg) + " - " + this.terminalNames[actualId] + ": incorrect token value - " + "expected: " + expectedValue + " " + "but was: " + actualValue));
        }
        int expectedStart = expected.getStart();
        int actualStart = actual.getStart();
        if (actualStart != expectedStart) {
            ScannerTestBase.fail((String)(String.valueOf(msg) + " - " + this.getSymbolString(actual) + ": incorrect start position - " + "expected: line " + Symbol.getLine(expectedStart) + " col " + Symbol.getColumn(expectedStart) + " " + "but was: line " + Symbol.getLine(actualStart) + " col " + Symbol.getColumn(actualStart)));
        }
        int expectedEnd = expected.getEnd();
        int actualEnd = actual.getEnd();
        if (actualEnd != expectedEnd) {
            ScannerTestBase.fail((String)(String.valueOf(msg) + " - " + this.getSymbolString(actual) + ": incorrect end position - " + "expected: line " + Symbol.getLine(expectedEnd) + " col " + Symbol.getColumn(expectedEnd) + " " + "but was: line " + Symbol.getLine(actualEnd) + " col " + Symbol.getColumn(actualEnd)));
        }
    }

    public static void assertEquals(String msg, Scanner.Exception actual, Scanner.Exception expected) {
        if (actual == null) {
            if (expected == null) {
                return;
            }
            ScannerTestBase.fail((String)("Actual exception was unexpectedly null (expected: [" + actual.line + ", " + actual.column + "] " + expected + ")"));
        } else if (expected == null) {
            ScannerTestBase.fail((String)("Unexpected exception: [" + actual.line + ", " + actual.column + "] " + actual));
        }
        ScannerTestBase.assertEquals((String)(String.valueOf(msg) + " - exception line number"), (int)actual.line, (int)expected.line);
        ScannerTestBase.assertEquals((String)(String.valueOf(msg) + " - exception column number"), (int)actual.column, (int)expected.column);
    }

    protected String getSymbolString(Symbol symbol) {
        return String.valueOf(this.terminalNames[symbol.getId()]) + (symbol.value == null ? "" : "(" + symbol.value + ")");
    }
}

