/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Scanner;
import beaver.Symbol;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import metalexer.ScannerUtil;

public abstract class ScannerTestTool {
    private final short eofTokenID;
    private final String[] terminalNames;

    protected ScannerTestTool(short eofTokenID, String[] terminalNames) {
        this.eofTokenID = eofTokenID;
        this.terminalNames = terminalNames;
    }

    protected void processFile(String basename) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(String.valueOf(basename) + ".in"));
        Scanner scanner = this.makeScanner(in);
        PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(basename) + ".out"));
        while (true) {
            Symbol curr = null;
            try {
                curr = scanner.nextToken();
            }
            catch (Scanner.Exception e) {
                out.print('~');
                out.print(' ');
                out.print(e.line);
                out.print(' ');
                out.println(e.column);
                System.err.println("[" + e.line + ", " + e.column + "]  " + e.getMessage());
                break;
            }
            if (curr.getId() == this.eofTokenID) break;
            ScannerUtil.printSymbol(out, curr, this.terminalNames);
        }
        out.close();
        in.close();
    }

    protected abstract Scanner makeScanner(Reader var1) throws IOException;
}

