/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Layout;
import metalexer.ast.Opt;
import metalexer.ast.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompDecl
extends ASTNode<ASTNode>
implements Cloneable {
    private Stack<Replacement> replacements = new Stack();
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected Map makeCompilationError_String_visited;
    protected Map lookupExternDecls_String_visited;
    protected int getLayout_visited = -1;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.makeCompilationError_String_visited = new HashMap(4);
        this.lookupExternDecls_String_visited = new HashMap(4);
        this.getLayout_visited = -1;
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
    }

    @Override
    public CompDecl clone() throws CloneNotSupportedException {
        CompDecl node = (CompDecl)super.clone();
        node.makeCompilationError_String_visited = new HashMap(4);
        node.lookupExternDecls_String_visited = new HashMap(4);
        node.getLayout_visited = -1;
        node.getLexThrowsDecl_visited = -1;
        node.getTokenType_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CompDecl copy() {
        try {
            CompDecl node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CompDecl fullCopy() {
        CompDecl res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    Set<Replacement> replaceComponents(Map<String, Replacement> replacementMap) {
        if (replacementMap.containsKey(this.getName())) {
            Replacement replacement = replacementMap.get(this.getName());
            this.setName(replacement.getNew().getName());
            this.replacements.push(replacement);
            return Collections.singleton(replacement);
        }
        return Collections.emptySet();
    }

    public CompDecl() {
        this.setChild(new Opt(), 0);
    }

    public CompDecl(String p0, Opt<Component> p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    public CompDecl(Symbol p0, Opt<Component> p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setComponentOpt(Opt<Component> opt) {
        this.setChild(opt, 0);
    }

    public boolean hasComponent() {
        return this.getComponentOpt().getNumChild() != 0;
    }

    public Component getComponent() {
        return (Component)this.getComponentOpt().getChild(0);
    }

    public void setComponent(Component node) {
        this.getComponentOpt().setChild(node, 0);
    }

    public Opt<Component> getComponentOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<Component> getComponentOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    @Override
    public CompilationError makeCompilationError(String msg) {
        String _parameters = msg;
        if (this.makeCompilationError_String_visited == null) {
            this.makeCompilationError_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.makeCompilationError_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: makeCompilationError in class: ");
        }
        this.makeCompilationError_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        CompilationError makeCompilationError_String_value = this.makeCompilationError_compute(msg);
        this.makeCompilationError_String_visited.remove(_parameters);
        return makeCompilationError_String_value;
    }

    private CompilationError makeCompilationError_compute(String msg) {
        StringBuffer buf = new StringBuffer(msg);
        Collections.reverse(this.replacements);
        for (Replacement replacement : this.replacements) {
            int replacementPos = replacement.getStart();
            int replacementLine = Symbol.getLine(replacementPos);
            int replacementCol = Symbol.getColumn(replacementPos);
            buf.append("\n\tReplaced '" + replacement.getOld().getName() + "' with '" + replacement.getNew().getName() + "' at " + replacement.getFilename() + " [" + replacementLine + ", " + replacementCol + "]");
        }
        Collections.reverse(this.replacements);
        return super.makeCompilationError(buf.toString());
    }

    public Set<Declaration> lookupExternDecls(String text) {
        String _parameters = text;
        if (this.lookupExternDecls_String_visited == null) {
            this.lookupExternDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupExternDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupExternDecls in class: ");
        }
        this.lookupExternDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<Declaration> lookupExternDecls_String_value = this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, null, text);
        this.lookupExternDecls_String_visited.remove(_parameters);
        return lookupExternDecls_String_value;
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout getLayout_value = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return getLayout_value;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String getLexThrowsDecl_value = this.getParent().Define_String_getLexThrowsDecl(this, null);
        this.getLexThrowsDecl_visited = -1;
        return getLexThrowsDecl_value;
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String getTokenType_value = this.getParent().Define_String_getTokenType(this, null);
        this.getTokenType_visited = -1;
        return getTokenType_value;
    }

    @Override
    public Layout Define_Layout_getLayout(ASTNode caller, ASTNode child) {
        if (caller == this.getComponentOptNoTransform()) {
            return this.getLayout();
        }
        return this.getParent().Define_Layout_getLayout(this, caller);
    }

    @Override
    public Set<Declaration> Define_java_util_Set_Declaration__lookupExternDecls(ASTNode caller, ASTNode child, String text) {
        if (caller == this.getComponentOptNoTransform()) {
            return this.lookupExternDecls(text);
        }
        return this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, caller, text);
    }

    @Override
    public String Define_String_getLexThrowsDecl(ASTNode caller, ASTNode child) {
        if (caller == this.getComponentOptNoTransform()) {
            return this.getLexThrowsDecl();
        }
        return this.getParent().Define_String_getLexThrowsDecl(this, caller);
    }

    @Override
    public String Define_String_getTokenType(ASTNode caller, ASTNode child) {
        if (caller == this.getComponentOptNoTransform()) {
            return this.getTokenType();
        }
        return this.getParent().Define_String_getTokenType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getWarnings() {
        Layout ref;
        if (!this.getLayout().getHelper() && !this.hasComponent() && (ref = this.getLayout()) != null) {
            ref.Layout_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Layout_getWarnings();
    }

    @Override
    protected void contributeTo_Layout_Layout_getWarnings(SortedSet<CompilationWarning> collection) {
        super.contributeTo_Layout_Layout_getWarnings(collection);
        if (!this.getLayout().getHelper() && !this.hasComponent()) {
            collection.add(this.makeCompilationWarning("Component " + this.getName() + " import is unused."));
        }
    }
}

