/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.CompDecl;
import metalexer.ast.Layout;
import metalexer.ast.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompRef
extends ASTNode<ASTNode>
implements Cloneable {
    private Stack<Replacement> replacements = new Stack();
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getDecl_visited = -1;
    protected Map makeCompilationError_String_visited;
    protected Map lookupCompDecls_String_visited;
    protected int getLayout_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getDecl_visited = -1;
        this.makeCompilationError_String_visited = new HashMap(4);
        this.lookupCompDecls_String_visited = new HashMap(4);
        this.getLayout_visited = -1;
    }

    @Override
    public CompRef clone() throws CloneNotSupportedException {
        CompRef node = (CompRef)super.clone();
        node.getDecl_visited = -1;
        node.makeCompilationError_String_visited = new HashMap(4);
        node.lookupCompDecls_String_visited = new HashMap(4);
        node.getLayout_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CompRef copy() {
        try {
            CompRef node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CompRef fullCopy() {
        CompRef res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    @Override
    Set<Replacement> replaceComponents(Map<String, Replacement> replacementMap) {
        if (replacementMap.containsKey(this.getName())) {
            Replacement replacement = replacementMap.get(this.getName());
            this.setName(replacement.getNew().getName());
            this.replacements.push(replacement);
            return Collections.singleton(replacement);
        }
        return Collections.emptySet();
    }

    public CompRef() {
    }

    public CompRef(String p0) {
        this.setName(p0);
    }

    public CompRef(Symbol p0) {
        this.setName(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public CompDecl getDecl() {
        if (this.getDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDecl in class: ");
        }
        this.getDecl_visited = this.state().boundariesCrossed;
        CompDecl getDecl_value = this.getDecl_compute();
        this.getDecl_visited = -1;
        return getDecl_value;
    }

    private CompDecl getDecl_compute() {
        Set<CompDecl> decls = this.lookupCompDecls(this.getName());
        return decls.isEmpty() ? null : decls.iterator().next();
    }

    @Override
    public CompilationError makeCompilationError(String msg) {
        String _parameters = msg;
        if (this.makeCompilationError_String_visited == null) {
            this.makeCompilationError_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.makeCompilationError_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: makeCompilationError in class: ");
        }
        this.makeCompilationError_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        CompilationError makeCompilationError_String_value = this.makeCompilationError_compute(msg);
        this.makeCompilationError_String_visited.remove(_parameters);
        return makeCompilationError_String_value;
    }

    private CompilationError makeCompilationError_compute(String msg) {
        StringBuffer buf = new StringBuffer(msg);
        Collections.reverse(this.replacements);
        for (Replacement replacement : this.replacements) {
            int replacementPos = replacement.getStart();
            int replacementLine = Symbol.getLine(replacementPos);
            int replacementCol = Symbol.getColumn(replacementPos);
            buf.append("\n\tReplaced '" + replacement.getOld().getName() + "' with '" + replacement.getNew().getName() + "' at " + replacement.getFilename() + " [" + replacementLine + ", " + replacementCol + "]");
        }
        Collections.reverse(this.replacements);
        return super.makeCompilationError(buf.toString());
    }

    public Set<CompDecl> lookupCompDecls(String compName) {
        String _parameters = compName;
        if (this.lookupCompDecls_String_visited == null) {
            this.lookupCompDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupCompDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupCompDecls in class: ");
        }
        this.lookupCompDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<CompDecl> lookupCompDecls_String_value = this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, null, compName);
        this.lookupCompDecls_String_visited.remove(_parameters);
        return lookupCompDecls_String_value;
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout getLayout_value = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return getLayout_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout ref;
        if (!this.getLayout().getHelper() && this.getDecl() == null && (ref = this.getLayout()) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void collect_contributors_Layout_getReferencedComponents() {
        Layout ref;
        if (this.getDecl() != null && (ref = this.getLayout()) != null) {
            ref.Layout_getReferencedComponents_contributors().add(this);
        }
        super.collect_contributors_Layout_getReferencedComponents();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Layout_Layout_getErrors(collection);
        if (!this.getLayout().getHelper() && this.getDecl() == null) {
            collection.add(this.makeCompilationError("Component " + this.getName() + " has not been imported."));
        }
    }

    @Override
    protected void contributeTo_Layout_Layout_getReferencedComponents(List<CompDecl> collection) {
        super.contributeTo_Layout_Layout_getReferencedComponents(collection);
        if (this.getDecl() != null) {
            collection.add(this.getDecl());
        }
    }
}

