/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.BOFMetaPattern;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MetaPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedding
extends BodyElement
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getConflictingEmbeddings_visited = -1;
    protected int getStructureString_visited = -1;
    protected int hasPureBOFTransition_visited = -1;
    protected int getDirectPureBOFReachable_visited = -1;
    protected int getPureBOFReachable_visited;
    protected boolean getPureBOFReachable_computed = false;
    protected boolean getPureBOFReachable_initialized = false;
    protected Set<Embedding> getPureBOFReachable_value;
    protected int getMetaJFlexName_visited = -1;
    protected int getDFATransitionsName_visited = -1;
    protected int getDFAActionsName_visited = -1;
    protected int getDFAReverseStartMPatTransitionsName_visited = -1;
    protected int getDFAReverseStartMPatActionsName_visited = -1;
    protected int getNextByPureBOF_visited = -1;
    protected int getEmbeddingIndex_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingEmbeddings_visited = -1;
        this.getStructureString_visited = -1;
        this.hasPureBOFTransition_visited = -1;
        this.getDirectPureBOFReachable_visited = -1;
        this.getPureBOFReachable_visited = 0;
        this.getPureBOFReachable_computed = false;
        this.getPureBOFReachable_initialized = false;
        this.getPureBOFReachable_value = null;
        this.getMetaJFlexName_visited = -1;
        this.getDFATransitionsName_visited = -1;
        this.getDFAActionsName_visited = -1;
        this.getDFAReverseStartMPatTransitionsName_visited = -1;
        this.getDFAReverseStartMPatActionsName_visited = -1;
        this.getNextByPureBOF_visited = -1;
        this.getEmbeddingIndex_visited = -1;
    }

    @Override
    public Embedding clone() throws CloneNotSupportedException {
        Embedding node = (Embedding)super.clone();
        node.getConflictingEmbeddings_visited = -1;
        node.getStructureString_visited = -1;
        node.hasPureBOFTransition_visited = -1;
        node.getDirectPureBOFReachable_visited = -1;
        node.getPureBOFReachable_visited = 0;
        node.getPureBOFReachable_computed = false;
        node.getPureBOFReachable_initialized = false;
        node.getPureBOFReachable_value = null;
        node.getMetaJFlexName_visited = -1;
        node.getDFATransitionsName_visited = -1;
        node.getDFAActionsName_visited = -1;
        node.getDFAReverseStartMPatTransitionsName_visited = -1;
        node.getDFAReverseStartMPatActionsName_visited = -1;
        node.getNextByPureBOF_visited = -1;
        node.getEmbeddingIndex_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Embedding copy() {
        try {
            Embedding node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Embedding fullCopy() {
        Embedding res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public boolean isStartPatternSuppressed() {
        return this.getStartPattern().isBadJFlex() || this.hasPureBOFTransition();
    }

    public int addStartRule(int counter, java.util.List<MetaPattern> mpats, Map<MetaPattern, Integer> mpatNumbers, Map<MetaPattern, Integer> mpatActions) {
        MetaPattern startPattern = this.getStartPattern();
        if (this.isStartPatternSuppressed()) {
            return counter;
        }
        mpats.add(startPattern);
        mpatActions.put(startPattern, this.getEmbeddingIndex());
        if (mpatNumbers.containsKey(startPattern)) {
            return counter;
        }
        mpatNumbers.put(startPattern, counter);
        return counter + 1;
    }

    public boolean isEndPatternSuppressed() {
        return this.getEndPattern().isBadJFlex();
    }

    public int addEndRule(int counter, java.util.List<MetaPattern> mpats, Map<MetaPattern, Integer> mpatNumbers, Map<MetaPattern, Integer> mpatActions) {
        MetaPattern endPattern = this.getEndPattern();
        if (this.isEndPatternSuppressed()) {
            return counter;
        }
        mpats.add(endPattern);
        mpatActions.put(endPattern, -1);
        if (mpatNumbers.containsKey(endPattern)) {
            return counter;
        }
        mpatNumbers.put(endPattern, counter);
        return counter + 1;
    }

    public Embedding() {
        this.setChild(new List(), 0);
        this.setChild(new List(), 4);
    }

    public Embedding(String p0, List<CompRef> p1, CompRef p2, MetaPattern p3, MetaPattern p4, List<MTokPair> p5) {
        this.setName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    public Embedding(Symbol p0, List<CompRef> p1, CompRef p2, MetaPattern p3, MetaPattern p4, List<MTokPair> p5) {
        this.setName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHostList(List<CompRef> list) {
        this.setChild(list, 0);
    }

    public int getNumHost() {
        return this.getHostList().getNumChild();
    }

    public CompRef getHost(int i) {
        return (CompRef)this.getHostList().getChild(i);
    }

    public void addHost(CompRef node) {
        List<CompRef> list = this.getHostList();
        list.addChild(node);
    }

    public void setHost(CompRef node, int i) {
        List<CompRef> list = this.getHostList();
        list.setChild(node, i);
    }

    public List<CompRef> getHosts() {
        return this.getHostList();
    }

    public List<CompRef> getHostsNoTransform() {
        return this.getHostListNoTransform();
    }

    public List<CompRef> getHostList() {
        return (List)this.getChild(0);
    }

    public List<CompRef> getHostListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setGuest(CompRef node) {
        this.setChild(node, 1);
    }

    public CompRef getGuest() {
        return (CompRef)this.getChild(1);
    }

    public CompRef getGuestNoTransform() {
        return (CompRef)this.getChildNoTransform(1);
    }

    public void setStartPattern(MetaPattern node) {
        this.setChild(node, 2);
    }

    public MetaPattern getStartPattern() {
        return (MetaPattern)this.getChild(2);
    }

    public MetaPattern getStartPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(2);
    }

    public void setEndPattern(MetaPattern node) {
        this.setChild(node, 3);
    }

    public MetaPattern getEndPattern() {
        return (MetaPattern)this.getChild(3);
    }

    public MetaPattern getEndPatternNoTransform() {
        return (MetaPattern)this.getChildNoTransform(3);
    }

    public void setMTokPairList(List<MTokPair> list) {
        this.setChild(list, 4);
    }

    public int getNumMTokPair() {
        return this.getMTokPairList().getNumChild();
    }

    public MTokPair getMTokPair(int i) {
        return (MTokPair)this.getMTokPairList().getChild(i);
    }

    public void addMTokPair(MTokPair node) {
        List<MTokPair> list = this.getMTokPairList();
        list.addChild(node);
    }

    public void setMTokPair(MTokPair node, int i) {
        List<MTokPair> list = this.getMTokPairList();
        list.setChild(node, i);
    }

    public List<MTokPair> getMTokPairs() {
        return this.getMTokPairList();
    }

    public List<MTokPair> getMTokPairsNoTransform() {
        return this.getMTokPairListNoTransform();
    }

    public List<MTokPair> getMTokPairList() {
        return (List)this.getChild(4);
    }

    public List<MTokPair> getMTokPairListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    public Set<Embedding> getConflictingEmbeddings() {
        if (this.getConflictingEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingEmbeddings in class: ");
        }
        this.getConflictingEmbeddings_visited = this.state().boundariesCrossed;
        Set<Embedding> getConflictingEmbeddings_value = this.getConflictingEmbeddings_compute();
        this.getConflictingEmbeddings_visited = -1;
        return getConflictingEmbeddings_value;
    }

    private Set<Embedding> getConflictingEmbeddings_compute() {
        String name = this.getName();
        Set<Embedding> embeddings = this.lookupEmbeddings(name);
        HashSet<Embedding> conflictingEmbeddings = new HashSet<Embedding>();
        for (Embedding embedding : embeddings) {
            if (!name.equals(embedding.getName()) || embedding == this) continue;
            conflictingEmbeddings.add(embedding);
        }
        return conflictingEmbeddings;
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append("%%embed");
        buf.append('\n');
        buf.append("%name " + this.getName());
        buf.append('\n');
        for (CompRef comp : this.getHosts()) {
            buf.append("%host " + comp.getName());
            buf.append('\n');
        }
        buf.append("%guest " + this.getGuest().getName());
        buf.append('\n');
        buf.append("%start " + this.getStartPattern().getStructureString());
        buf.append('\n');
        buf.append("%end " + this.getEndPattern().getStructureString());
        buf.append('\n');
        for (MTokPair pair : this.getMTokPairs()) {
            buf.append("%pair " + pair.getL().getName() + ", " + pair.getR().getName());
            buf.append('\n');
        }
        return buf.toString();
    }

    public boolean hasPureBOFTransition() {
        if (this.hasPureBOFTransition_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: hasPureBOFTransition in class: ");
        }
        this.hasPureBOFTransition_visited = this.state().boundariesCrossed;
        boolean hasPureBOFTransition_value = this.hasPureBOFTransition_compute();
        this.hasPureBOFTransition_visited = -1;
        return hasPureBOFTransition_value;
    }

    private boolean hasPureBOFTransition_compute() {
        return this.getStartPattern() instanceof BOFMetaPattern;
    }

    public Set<Embedding> getDirectPureBOFReachable() {
        if (this.getDirectPureBOFReachable_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDirectPureBOFReachable in class: ");
        }
        this.getDirectPureBOFReachable_visited = this.state().boundariesCrossed;
        Set<Embedding> getDirectPureBOFReachable_value = this.getDirectPureBOFReachable_compute();
        this.getDirectPureBOFReachable_visited = -1;
        return getDirectPureBOFReachable_value;
    }

    private Set<Embedding> getDirectPureBOFReachable_compute() {
        HashSet<Embedding> reachable = new HashSet<Embedding>();
        for (Embedding potential : this.getEmbeddingsWithHost(this.getGuest())) {
            if (!potential.hasPureBOFTransition()) continue;
            reachable.add(potential);
        }
        return reachable;
    }

    public Set<Embedding> getPureBOFReachable() {
        if (this.getPureBOFReachable_computed) {
            return this.getPureBOFReachable_value;
        }
        if (!this.getPureBOFReachable_initialized) {
            this.getPureBOFReachable_initialized = true;
            this.getPureBOFReachable_value = this.getDirectPureBOFReachable();
        }
        if (!this.state().IN_CIRCLE) {
            this.state().IN_CIRCLE = true;
            int num = this.state().boundariesCrossed;
            boolean isFinal = this.is$Final();
            this.state().CIRCLE_INDEX = 1;
            do {
                this.getPureBOFReachable_visited = this.state().CIRCLE_INDEX;
                this.state().CHANGE = false;
                Set<Embedding> new_getPureBOFReachable_value = this.getPureBOFReachable_compute();
                if (new_getPureBOFReachable_value == null && this.getPureBOFReachable_value != null || new_getPureBOFReachable_value != null && !new_getPureBOFReachable_value.equals(this.getPureBOFReachable_value)) {
                    this.state().CHANGE = true;
                }
                this.getPureBOFReachable_value = new_getPureBOFReachable_value;
                ++this.state().CIRCLE_INDEX;
            } while (this.state().CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.getPureBOFReachable_computed = true;
                this.state().LAST_CYCLE = true;
                this.getPureBOFReachable_compute();
                this.state().LAST_CYCLE = false;
            } else {
                this.state().RESET_CYCLE = true;
                this.getPureBOFReachable_compute();
                this.state().RESET_CYCLE = false;
                this.getPureBOFReachable_computed = false;
                this.getPureBOFReachable_initialized = false;
            }
            this.state().IN_CIRCLE = false;
            return this.getPureBOFReachable_value;
        }
        if (this.getPureBOFReachable_visited != this.state().CIRCLE_INDEX) {
            this.getPureBOFReachable_visited = this.state().CIRCLE_INDEX;
            if (this.state().LAST_CYCLE) {
                this.getPureBOFReachable_computed = true;
                return this.getPureBOFReachable_compute();
            }
            if (this.state().RESET_CYCLE) {
                this.getPureBOFReachable_computed = false;
                this.getPureBOFReachable_initialized = false;
                return this.getPureBOFReachable_value;
            }
            Set<Embedding> new_getPureBOFReachable_value = this.getPureBOFReachable_compute();
            if (new_getPureBOFReachable_value == null && this.getPureBOFReachable_value != null || new_getPureBOFReachable_value != null && !new_getPureBOFReachable_value.equals(this.getPureBOFReachable_value)) {
                this.state().CHANGE = true;
            }
            this.getPureBOFReachable_value = new_getPureBOFReachable_value;
            return this.getPureBOFReachable_value;
        }
        return this.getPureBOFReachable_value;
    }

    private Set<Embedding> getPureBOFReachable_compute() {
        HashSet<Embedding> reachable = new HashSet<Embedding>();
        for (Embedding embedding : this.getPureBOFReachable()) {
            reachable.add(embedding);
            reachable.addAll(embedding.getPureBOFReachable());
        }
        return reachable;
    }

    public String getMetaJFlexName() {
        if (this.getMetaJFlexName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexName in class: ");
        }
        this.getMetaJFlexName_visited = this.state().boundariesCrossed;
        String getMetaJFlexName_value = this.getMetaJFlexName_compute();
        this.getMetaJFlexName_visited = -1;
        return getMetaJFlexName_value;
    }

    private String getMetaJFlexName_compute() {
        return "e_" + this.getName();
    }

    public String getDFATransitionsName() {
        if (this.getDFATransitionsName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDFATransitionsName in class: ");
        }
        this.getDFATransitionsName_visited = this.state().boundariesCrossed;
        String getDFATransitionsName_value = this.getDFATransitionsName_compute();
        this.getDFATransitionsName_visited = -1;
        return getDFATransitionsName_value;
    }

    private String getDFATransitionsName_compute() {
        return "trans_" + this.getName();
    }

    public String getDFAActionsName() {
        if (this.getDFAActionsName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDFAActionsName in class: ");
        }
        this.getDFAActionsName_visited = this.state().boundariesCrossed;
        String getDFAActionsName_value = this.getDFAActionsName_compute();
        this.getDFAActionsName_visited = -1;
        return getDFAActionsName_value;
    }

    private String getDFAActionsName_compute() {
        return "act_" + this.getName();
    }

    public String getDFAReverseStartMPatTransitionsName() {
        if (this.getDFAReverseStartMPatTransitionsName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDFAReverseStartMPatTransitionsName in class: ");
        }
        this.getDFAReverseStartMPatTransitionsName_visited = this.state().boundariesCrossed;
        String getDFAReverseStartMPatTransitionsName_value = this.getDFAReverseStartMPatTransitionsName_compute();
        this.getDFAReverseStartMPatTransitionsName_visited = -1;
        return getDFAReverseStartMPatTransitionsName_value;
    }

    private String getDFAReverseStartMPatTransitionsName_compute() {
        return "rev_trans_" + this.getName();
    }

    public String getDFAReverseStartMPatActionsName() {
        if (this.getDFAReverseStartMPatActionsName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDFAReverseStartMPatActionsName in class: ");
        }
        this.getDFAReverseStartMPatActionsName_visited = this.state().boundariesCrossed;
        String getDFAReverseStartMPatActionsName_value = this.getDFAReverseStartMPatActionsName_compute();
        this.getDFAReverseStartMPatActionsName_visited = -1;
        return getDFAReverseStartMPatActionsName_value;
    }

    private String getDFAReverseStartMPatActionsName_compute() {
        return "rev_act_" + this.getName();
    }

    public Embedding getNextByPureBOF() {
        if (this.getNextByPureBOF_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getNextByPureBOF in class: ");
        }
        this.getNextByPureBOF_visited = this.state().boundariesCrossed;
        Embedding getNextByPureBOF_value = this.getNextByPureBOF_compute();
        this.getNextByPureBOF_visited = -1;
        return getNextByPureBOF_value;
    }

    private Embedding getNextByPureBOF_compute() {
        for (Embedding possible : this.getEmbeddingsWithHost(this.getGuest())) {
            if (!possible.hasPureBOFTransition()) continue;
            return possible;
        }
        return null;
    }

    public int getEmbeddingIndex() {
        if (this.getEmbeddingIndex_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getEmbeddingIndex in class: ");
        }
        this.getEmbeddingIndex_visited = this.state().boundariesCrossed;
        int getEmbeddingIndex_value = this.getParent().Define_int_getEmbeddingIndex(this, null);
        this.getEmbeddingIndex_visited = -1;
        return getEmbeddingIndex_value;
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode caller, ASTNode child, String compName) {
        if (caller == this.getEndPatternNoTransform()) {
            return this.lookupCompDecls(compName);
        }
        if (caller == this.getStartPatternNoTransform()) {
            return this.lookupCompDecls(compName);
        }
        if (caller == this.getGuestNoTransform()) {
            return this.lookupCompDecls(compName);
        }
        if (caller == this.getHostListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.lookupCompDecls(compName);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, caller, compName);
    }

    @Override
    public java.util.List<Component> Define_java_util_List_Component__getComponents(ASTNode caller, ASTNode child) {
        if (caller == this.getEndPatternNoTransform()) {
            CompDecl decl = this.getGuest().getDecl();
            if (decl == null || !decl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(decl.getComponent());
        }
        if (caller == this.getStartPatternNoTransform()) {
            ArrayList<Component> comps = new ArrayList<Component>();
            for (CompRef ref : this.getHosts()) {
                CompDecl decl = ref.getDecl();
                if (decl == null || !decl.hasComponent()) continue;
                comps.add(decl.getComponent());
            }
            return comps;
        }
        if (caller == this.getMTokPairListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            CompDecl decl = this.getGuest().getDecl();
            if (decl == null || !decl.hasComponent()) {
                return new ArrayList<Component>();
            }
            return Collections.singletonList(decl.getComponent());
        }
        return this.getParent().Define_java_util_List_Component__getComponents(this, caller);
    }

    @Override
    public boolean Define_boolean_isInClass(ASTNode caller, ASTNode child) {
        if (caller == this.getEndPatternNoTransform()) {
            return false;
        }
        if (caller == this.getStartPatternNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isInClass(this, caller);
    }

    @Override
    public boolean Define_boolean_isInOpt(ASTNode caller, ASTNode child) {
        if (caller == this.getEndPatternNoTransform()) {
            return false;
        }
        if (caller == this.getStartPatternNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_isInOpt(this, caller);
    }

    @Override
    public boolean Define_boolean_isFirstOnly(ASTNode caller, ASTNode child) {
        if (caller == this.getEndPatternNoTransform()) {
            return true;
        }
        if (caller == this.getStartPatternNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isFirstOnly(this, caller);
    }

    @Override
    public boolean Define_boolean_isLastOnly(ASTNode caller, ASTNode child) {
        if (caller == this.getEndPatternNoTransform()) {
            return true;
        }
        if (caller == this.getStartPatternNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isLastOnly(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getWarnings() {
        Layout ref;
        if (!this.getConflictingEmbeddings().isEmpty() && (ref = this.getLayout()) != null) {
            ref.Layout_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Layout_getWarnings();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout ref;
        if (this.getEndPattern().containsBOF() && (ref = this.getLayout()) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        if (this.getPureBOFReachable().contains(this) && (ref = this.getLayout()) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getWarnings(SortedSet<CompilationWarning> collection) {
        super.contributeTo_Layout_Layout_getWarnings(collection);
        if (!this.getConflictingEmbeddings().isEmpty()) {
            collection.add(this.makeCompilationWarning("Embedding " + this.getName() + " is declared more than once."));
        }
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Layout_Layout_getErrors(collection);
        if (this.getEndPattern().containsBOF()) {
            collection.add(this.makeCompilationError("(JFlex) End meta-patterns may not contain <BOF>"));
        }
        if (this.getPureBOFReachable().contains(this)) {
            collection.add(this.makeCompilationError("(JFlex) Embedding " + this.getName() + " may be reached from itself without consuming any input (i.e. <BOF> only)"));
        }
    }
}

