/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import metalexer.ast.ASTNode;
import metalexer.ast.BodyElement;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.List;
import metalexer.ast.OptionRef;
import metalexer.ast.Replacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension
extends BodyElement
implements Cloneable {
    protected String tokenString_LayoutName;
    public int LayoutNamestart;
    public int LayoutNameend;
    protected int getStructureString_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getStructureString_visited = -1;
    }

    @Override
    public Extension clone() throws CloneNotSupportedException {
        Extension node = (Extension)super.clone();
        node.getStructureString_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Extension copy() {
        try {
            Extension node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Extension fullCopy() {
        Extension res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public Extension() {
        this.setChild(new List(), 0);
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
    }

    public Extension(String p0, List<OptionRef> p1, List<Replacement> p2, List<EmbeddingRef> p3) {
        this.setLayoutName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    public Extension(Symbol p0, List<OptionRef> p1, List<Replacement> p2, List<EmbeddingRef> p3) {
        this.setLayoutName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLayoutName(String value) {
        this.tokenString_LayoutName = value;
    }

    public void setLayoutName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLayoutName is only valid for String lexemes");
        }
        this.tokenString_LayoutName = (String)symbol.value;
        this.LayoutNamestart = symbol.getStart();
        this.LayoutNameend = symbol.getEnd();
    }

    public String getLayoutName() {
        return this.tokenString_LayoutName != null ? this.tokenString_LayoutName : "";
    }

    public void setDeletedOptionList(List<OptionRef> list) {
        this.setChild(list, 0);
    }

    public int getNumDeletedOption() {
        return this.getDeletedOptionList().getNumChild();
    }

    public OptionRef getDeletedOption(int i) {
        return (OptionRef)this.getDeletedOptionList().getChild(i);
    }

    public void addDeletedOption(OptionRef node) {
        List<OptionRef> list = this.getDeletedOptionList();
        list.addChild(node);
    }

    public void setDeletedOption(OptionRef node, int i) {
        List<OptionRef> list = this.getDeletedOptionList();
        list.setChild(node, i);
    }

    public List<OptionRef> getDeletedOptions() {
        return this.getDeletedOptionList();
    }

    public List<OptionRef> getDeletedOptionsNoTransform() {
        return this.getDeletedOptionListNoTransform();
    }

    public List<OptionRef> getDeletedOptionList() {
        return (List)this.getChild(0);
    }

    public List<OptionRef> getDeletedOptionListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setReplacementList(List<Replacement> list) {
        this.setChild(list, 1);
    }

    public int getNumReplacement() {
        return this.getReplacementList().getNumChild();
    }

    public Replacement getReplacement(int i) {
        return (Replacement)this.getReplacementList().getChild(i);
    }

    public void addReplacement(Replacement node) {
        List<Replacement> list = this.getReplacementList();
        list.addChild(node);
    }

    public void setReplacement(Replacement node, int i) {
        List<Replacement> list = this.getReplacementList();
        list.setChild(node, i);
    }

    public List<Replacement> getReplacements() {
        return this.getReplacementList();
    }

    public List<Replacement> getReplacementsNoTransform() {
        return this.getReplacementListNoTransform();
    }

    public List<Replacement> getReplacementList() {
        return (List)this.getChild(1);
    }

    public List<Replacement> getReplacementListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setDeletedEmbeddingList(List<EmbeddingRef> list) {
        this.setChild(list, 2);
    }

    public int getNumDeletedEmbedding() {
        return this.getDeletedEmbeddingList().getNumChild();
    }

    public EmbeddingRef getDeletedEmbedding(int i) {
        return (EmbeddingRef)this.getDeletedEmbeddingList().getChild(i);
    }

    public void addDeletedEmbedding(EmbeddingRef node) {
        List<EmbeddingRef> list = this.getDeletedEmbeddingList();
        list.addChild(node);
    }

    public void setDeletedEmbedding(EmbeddingRef node, int i) {
        List<EmbeddingRef> list = this.getDeletedEmbeddingList();
        list.setChild(node, i);
    }

    public List<EmbeddingRef> getDeletedEmbeddings() {
        return this.getDeletedEmbeddingList();
    }

    public List<EmbeddingRef> getDeletedEmbeddingsNoTransform() {
        return this.getDeletedEmbeddingListNoTransform();
    }

    public List<EmbeddingRef> getDeletedEmbeddingList() {
        return (List)this.getChild(2);
    }

    public List<EmbeddingRef> getDeletedEmbeddingListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append("%%inherit " + this.getLayoutName());
        buf.append('\n');
        for (OptionRef optionRef : this.getDeletedOptions()) {
            buf.append("%unoption " + optionRef.getName());
            buf.append('\n');
        }
        for (Replacement replacement : this.getReplacements()) {
            buf.append("%replace " + replacement.getOld().getName() + ", " + replacement.getNew().getName());
            buf.append('\n');
        }
        for (EmbeddingRef embeddingRef : this.getDeletedEmbeddings()) {
            buf.append("%delete " + embeddingRef.getName());
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

