/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Deletion;
import metalexer.ast.List;
import metalexer.ast.MacroDecl;
import metalexer.ast.RuleSection;
import metalexer.ast.State;
import metalexer.ast.StateRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritSection
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getStructureString_visited = -1;
    protected int getComponent_visited = -1;
    protected int lookupInclusiveStates_visited = -1;
    protected Map lookupMacroDecls_String_visited;
    protected Map lookupStateDecls_String_visited;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getStructureString_visited = -1;
        this.getComponent_visited = -1;
        this.lookupInclusiveStates_visited = -1;
        this.lookupMacroDecls_String_visited = new HashMap(4);
        this.lookupStateDecls_String_visited = new HashMap(4);
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
    }

    @Override
    public InheritSection clone() throws CloneNotSupportedException {
        InheritSection node = (InheritSection)super.clone();
        node.getStructureString_visited = -1;
        node.getComponent_visited = -1;
        node.lookupInclusiveStates_visited = -1;
        node.lookupMacroDecls_String_visited = new HashMap(4);
        node.lookupStateDecls_String_visited = new HashMap(4);
        node.getLexThrowsDecl_visited = -1;
        node.getTokenType_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public InheritSection copy() {
        try {
            InheritSection node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public InheritSection fullCopy() {
        InheritSection res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public InheritSection() {
        this.setChild(new List(), 0);
    }

    public InheritSection(String p0, List<Deletion> p1, RuleSection p2) {
        this.setName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    public InheritSection(Symbol p0, List<Deletion> p1, RuleSection p2) {
        this.setName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setDeletionList(List<Deletion> list) {
        this.setChild(list, 0);
    }

    public int getNumDeletion() {
        return this.getDeletionList().getNumChild();
    }

    public Deletion getDeletion(int i) {
        return (Deletion)this.getDeletionList().getChild(i);
    }

    public void addDeletion(Deletion node) {
        List<Deletion> list = this.getDeletionList();
        list.addChild(node);
    }

    public void setDeletion(Deletion node, int i) {
        List<Deletion> list = this.getDeletionList();
        list.setChild(node, i);
    }

    public List<Deletion> getDeletions() {
        return this.getDeletionList();
    }

    public List<Deletion> getDeletionsNoTransform() {
        return this.getDeletionListNoTransform();
    }

    public List<Deletion> getDeletionList() {
        return (List)this.getChild(0);
    }

    public List<Deletion> getDeletionListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setRuleSection(RuleSection node) {
        this.setChild(node, 1);
    }

    public RuleSection getRuleSection() {
        return (RuleSection)this.getChild(1);
    }

    public RuleSection getRuleSectionNoTransform() {
        return (RuleSection)this.getChildNoTransform(1);
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append("%%inherit " + this.getName());
        buf.append('\n');
        for (Deletion deletion : this.getDeletions()) {
            buf.append(deletion.getStructureString());
            buf.append('\n');
        }
        buf.append('\n');
        buf.append(this.getRuleSection().getStructureString());
        return buf.toString();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component getComponent_value = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return getComponent_value;
    }

    public List<StateRef> lookupInclusiveStates() {
        if (this.lookupInclusiveStates_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: lookupInclusiveStates in class: ");
        }
        this.lookupInclusiveStates_visited = this.state().boundariesCrossed;
        List<StateRef> lookupInclusiveStates_value = this.getParent().Define_List_StateRef__lookupInclusiveStates(this, null);
        this.lookupInclusiveStates_visited = -1;
        return lookupInclusiveStates_value;
    }

    public Set<MacroDecl> lookupMacroDecls(String macroName) {
        String _parameters = macroName;
        if (this.lookupMacroDecls_String_visited == null) {
            this.lookupMacroDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupMacroDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupMacroDecls in class: ");
        }
        this.lookupMacroDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<MacroDecl> lookupMacroDecls_String_value = this.getParent().Define_java_util_Set_MacroDecl__lookupMacroDecls(this, null, macroName);
        this.lookupMacroDecls_String_visited.remove(_parameters);
        return lookupMacroDecls_String_value;
    }

    public Set<State> lookupStateDecls(String stateName) {
        String _parameters = stateName;
        if (this.lookupStateDecls_String_visited == null) {
            this.lookupStateDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupStateDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupStateDecls in class: ");
        }
        this.lookupStateDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<State> lookupStateDecls_String_value = this.getParent().Define_java_util_Set_State__lookupStateDecls(this, null, stateName);
        this.lookupStateDecls_String_visited.remove(_parameters);
        return lookupStateDecls_String_value;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String getLexThrowsDecl_value = this.getParent().Define_String_getLexThrowsDecl(this, null);
        this.getLexThrowsDecl_visited = -1;
        return getLexThrowsDecl_value;
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String getTokenType_value = this.getParent().Define_String_getTokenType(this, null);
        this.getTokenType_visited = -1;
        return getTokenType_value;
    }

    @Override
    public String Define_String_getLexThrowsDecl(ASTNode caller, ASTNode child) {
        if (caller == this.getRuleSectionNoTransform()) {
            return this.getLexThrowsDecl();
        }
        return this.getParent().Define_String_getLexThrowsDecl(this, caller);
    }

    @Override
    public String Define_String_getTokenType(ASTNode caller, ASTNode child) {
        if (caller == this.getRuleSectionNoTransform()) {
            return this.getTokenType();
        }
        return this.getParent().Define_String_getTokenType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

