/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.FileLoader;
import metalexer.StringEval;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.ASTNode$State;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Embedding;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.Extension;
import metalexer.ast.LayoutWrapper;
import metalexer.ast.LexerOption;
import metalexer.ast.List;
import metalexer.ast.MTokPair;
import metalexer.ast.MTokRef;
import metalexer.ast.MetaPattern;
import metalexer.ast.Opt;
import metalexer.ast.OptionRef;
import metalexer.ast.RegionMetaPattern;
import metalexer.ast.Replacement;
import metalexer.jflex.PackageFind;
import metalexer.jflex.PrintHelper;
import metalexer.jflex.SymbolAssigner;
import metalexer.jflex.fsm.DFA;
import metalexer.jflex.fsm.ENFA;
import metalexer.jflex.fsm.SubmachinePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends ASTNode<ASTNode>
implements Cloneable {
    private static final Comparator<MTokRef> mtokRefComparator = new Comparator<MTokRef>(){

        @Override
        public int compare(MTokRef mt1, MTokRef mt2) {
            return mt1.getName().compareTo(mt2.getName());
        }
    };
    private static final Comparator<RegionMetaPattern> regionComparator = new Comparator<RegionMetaPattern>(){

        @Override
        public int compare(RegionMetaPattern r1, RegionMetaPattern r2) {
            return r1.getRegion().getName().compareTo(r2.getRegion().getName());
        }
    };
    int numSymbols;
    private boolean tracingCodeEmbedded = false;
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean tokenboolean_Helper;
    protected String tokenString_LocalHeader;
    public int LocalHeaderstart;
    public int LocalHeaderend;
    protected String tokenString_InheritedHeader;
    public int InheritedHeaderstart;
    public int InheritedHeaderend;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    private boolean collect_contributors_Layout_listMetaTokens = false;
    private boolean collect_contributors_Layout_listRegions = false;
    protected int getActiveComponents_visited = -1;
    protected Map lookupCompDecls_String_visited;
    protected Map lookupEmbeddings_String_visited;
    protected int getEmbeddings_visited = -1;
    protected Map lookupExternDecls_String_visited;
    protected int getStructureString_visited = -1;
    protected Map getEmbeddingsWithHost_CompRef_visited;
    protected int getGuestCompMap_visited = -1;
    protected int getHostCompMap_visited = -1;
    protected int getMetaJFlexPackage_visited = -1;
    protected int getJFlexStateClassName_visited = -1;
    protected int getJFlexStateObjectName_visited = -1;
    protected int getMetaLexerClassName_visited = -1;
    protected int getMetaLexerObjectName_visited = -1;
    protected Map getOptionValue_String_String_visited;
    protected int getInitialPureBOFSequence_visited = -1;
    protected int getSymbolsLegend_visited = -1;
    protected int getLexThrowsDecl_visited = -1;
    protected int getTokenType_visited = -1;
    protected int Layout_getErrors_visited = -1;
    protected boolean Layout_getErrors_computed = false;
    protected SortedSet<CompilationError> Layout_getErrors_value;
    Set Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_listMetaTokens_visited = -1;
    protected boolean Layout_listMetaTokens_computed = false;
    protected Set<MTokRef> Layout_listMetaTokens_value;
    Set Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getWarnings_visited = -1;
    protected boolean Layout_getWarnings_computed = false;
    protected SortedSet<CompilationWarning> Layout_getWarnings_value;
    Set Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getReferencedComponents_visited = -1;
    protected boolean Layout_getReferencedComponents_computed = false;
    protected java.util.List<CompDecl> Layout_getReferencedComponents_value;
    Set Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_listRegions_visited = -1;
    protected boolean Layout_listRegions_computed = false;
    protected Set<RegionMetaPattern> Layout_listRegions_value;
    Set Layout_listRegions_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getSymbolsMap_visited = -1;
    protected boolean Layout_getSymbolsMap_computed = false;
    protected Map<Integer, String> Layout_getSymbolsMap_value;
    Set Layout_getSymbolsMap_contributors = new ASTNode$State.IdentityHashSet(4);

    @Override
    public void flushCache() {
        super.flushCache();
        this.getActiveComponents_visited = -1;
        this.lookupCompDecls_String_visited = new HashMap(4);
        this.lookupEmbeddings_String_visited = new HashMap(4);
        this.getEmbeddings_visited = -1;
        this.lookupExternDecls_String_visited = new HashMap(4);
        this.getStructureString_visited = -1;
        this.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        this.getGuestCompMap_visited = -1;
        this.getHostCompMap_visited = -1;
        this.getMetaJFlexPackage_visited = -1;
        this.getJFlexStateClassName_visited = -1;
        this.getJFlexStateObjectName_visited = -1;
        this.getMetaLexerClassName_visited = -1;
        this.getMetaLexerObjectName_visited = -1;
        this.getOptionValue_String_String_visited = new HashMap(4);
        this.getInitialPureBOFSequence_visited = -1;
        this.getSymbolsLegend_visited = -1;
        this.getLexThrowsDecl_visited = -1;
        this.getTokenType_visited = -1;
        this.Layout_getErrors_visited = -1;
        this.Layout_getErrors_computed = false;
        this.Layout_getErrors_value = null;
        this.Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_listMetaTokens_visited = -1;
        this.Layout_listMetaTokens_computed = false;
        this.Layout_listMetaTokens_value = null;
        this.Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getWarnings_visited = -1;
        this.Layout_getWarnings_computed = false;
        this.Layout_getWarnings_value = null;
        this.Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getReferencedComponents_visited = -1;
        this.Layout_getReferencedComponents_computed = false;
        this.Layout_getReferencedComponents_value = null;
        this.Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_listRegions_visited = -1;
        this.Layout_listRegions_computed = false;
        this.Layout_listRegions_value = null;
        this.Layout_listRegions_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getSymbolsMap_visited = -1;
        this.Layout_getSymbolsMap_computed = false;
        this.Layout_getSymbolsMap_value = null;
        this.Layout_getSymbolsMap_contributors = new ASTNode$State.IdentityHashSet(4);
        this.collect_contributors_Layout_listMetaTokens = false;
        this.collect_contributors_Layout_listRegions = false;
    }

    @Override
    public Layout clone() throws CloneNotSupportedException {
        Layout node = (Layout)super.clone();
        node.getActiveComponents_visited = -1;
        node.lookupCompDecls_String_visited = new HashMap(4);
        node.lookupEmbeddings_String_visited = new HashMap(4);
        node.getEmbeddings_visited = -1;
        node.lookupExternDecls_String_visited = new HashMap(4);
        node.getStructureString_visited = -1;
        node.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        node.getGuestCompMap_visited = -1;
        node.getHostCompMap_visited = -1;
        node.getMetaJFlexPackage_visited = -1;
        node.getJFlexStateClassName_visited = -1;
        node.getJFlexStateObjectName_visited = -1;
        node.getMetaLexerClassName_visited = -1;
        node.getMetaLexerObjectName_visited = -1;
        node.getOptionValue_String_String_visited = new HashMap(4);
        node.getInitialPureBOFSequence_visited = -1;
        node.getSymbolsLegend_visited = -1;
        node.getLexThrowsDecl_visited = -1;
        node.getTokenType_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Layout copy() {
        try {
            Layout node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Layout fullCopy() {
        Layout res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public void deleteUnusedDeclarations() {
        List<CompDecl> comps = new List<CompDecl>();
        for (CompDecl decl : this.getComponents()) {
            if (!decl.hasComponent()) continue;
            comps.add(decl);
            decl.getComponent().deleteUnusedDeclarations();
        }
        this.setComponentList(comps);
    }

    public Layout processInheritance(FileLoader loader, SortedSet<CompilationProblem> problems) {
        return this.processInheritance(loader, new Stack<String>(), problems);
    }

    private Layout processInheritance(FileLoader loader, Stack<String> layoutStack, SortedSet<CompilationProblem> problems) {
        Layout clone = new LayoutWrapper(this.fullCopy()).getLayout();
        return Layout.processInheritance(clone, loader, layoutStack, problems);
    }

    private static Layout processInheritance(Layout clone, FileLoader loader, Stack<String> layoutStack, SortedSet<CompilationProblem> problems) {
        layoutStack.push(clone.getName());
        List<BodyElement> embeddings = new List<BodyElement>();
        for (BodyElement element : clone.getBodyElements()) {
            if (element instanceof Embedding) {
                embeddings.add(element);
                continue;
            }
            if (element instanceof Extension) {
                Extension extension = (Extension)element;
                Layout parentLayout = null;
                try {
                    parentLayout = loader.loadLayout(extension.getLayoutName(), problems);
                }
                catch (IOException e) {
                    problems.add(extension.makeCompilationError(e.getMessage()));
                }
                if (parentLayout == null) {
                    String errorMsg = "Cannot process layout " + clone.getName() + " until layout " + extension.getLayoutName() + " is available.";
                    problems.add(extension.makeCompilationError(errorMsg));
                    continue;
                }
                String parentLayoutName = parentLayout.getName();
                if (layoutStack.contains(parentLayoutName)) {
                    StringBuffer buf = new StringBuffer("Cyclic inheritance detected: ");
                    boolean first = true;
                    boolean include = false;
                    for (String layoutName : layoutStack) {
                        if (layoutName.equals(parentLayoutName)) {
                            include = true;
                            buf.append(layoutName);
                            first = false;
                            continue;
                        }
                        if (!include || first) continue;
                        buf.append(", ");
                        buf.append(layoutName);
                    }
                    problems.add(extension.makeCompilationError(buf.toString()));
                    continue;
                }
                parentLayout = parentLayout.processInheritance(loader, layoutStack, problems);
                parentLayout.processReplacements(extension.getReplacements(), problems);
                HashMap<String, EmbeddingRef> unembedMap = new HashMap<String, EmbeddingRef>();
                for (EmbeddingRef ref : extension.getDeletedEmbeddings()) {
                    unembedMap.put(ref.getName(), ref);
                }
                HashSet<EmbeddingRef> effectiveUnembeds = new HashSet<EmbeddingRef>();
                for (BodyElement extElement : parentLayout.getBodyElements()) {
                    if (extElement instanceof Embedding) {
                        Embedding extEmbedding = (Embedding)extElement;
                        String name = extEmbedding.getName();
                        if (unembedMap.containsKey(name)) {
                            effectiveUnembeds.add((EmbeddingRef)unembedMap.get(name));
                            continue;
                        }
                        embeddings.add(extEmbedding);
                        continue;
                    }
                    throw new RuntimeException("Parent still has non-Embedding BodyElements: " + extElement.getClass().getName());
                }
                for (EmbeddingRef ref : extension.getDeletedEmbeddings()) {
                    if (effectiveUnembeds.contains(ref)) continue;
                    problems.add(ref.makeCompilationWarning("Unembed has no effect."));
                }
                clone.setInheritedHeader(String.valueOf(clone.getInheritedHeader()) + parentLayout.getInheritedHeader());
                Layout.appendDistinctComponents(clone.getComponents(), parentLayout.getComponents(), problems);
                Layout.appendDistinctOptions(clone.getOptions(), parentLayout.getOptions(), extension.getDeletedOptions(), problems);
                Layout.appendDistinctDecls(clone.getDecls(), parentLayout.getDecls(), problems);
                Layout.appendDistinctStringSymbols(clone.getYylexExceptions(), parentLayout.getYylexExceptions(), problems);
                Layout.appendDistinctStringSymbols(clone.getInitExceptions(), parentLayout.getInitExceptions(), problems);
                clone.getDeclRegions().addAll(parentLayout.getDeclRegions());
                clone.getInitRegions().addAll(parentLayout.getInitRegions());
                continue;
            }
            throw new RuntimeException("Unexpected body element type: " + element.getClass().getName());
        }
        clone.setBodyElementList(embeddings);
        clone.fetchComponents(loader, problems);
        problems.addAll(clone.getErrors());
        problems.addAll(clone.getWarnings());
        layoutStack.pop();
        return clone;
    }

    private static void appendDistinctComponents(List<CompDecl> oldList, List<CompDecl> newList, SortedSet<CompilationProblem> problems) {
        HashSet<String> existing = new HashSet<String>();
        for (CompDecl ref : oldList) {
            existing.add(ref.getName());
        }
        for (CompDecl ref : newList) {
            if (existing.contains(ref.getName())) continue;
            oldList.add(ref);
        }
    }

    private static void appendDistinctOptions(List<LexerOption> oldList, List<LexerOption> newList, List<OptionRef> deletedOptions, SortedSet<CompilationProblem> problems) {
        HashMap<String, LexerOption> existing = new HashMap<String, LexerOption>();
        HashMap<String, OptionRef> deleted = new HashMap<String, OptionRef>();
        HashSet<OptionRef> effectiveDeletions = new HashSet<OptionRef>();
        for (LexerOption option : oldList) {
            existing.put(option.getName(), option);
        }
        for (OptionRef ref : deletedOptions) {
            deleted.put(ref.getName(), ref);
        }
        for (LexerOption option : newList) {
            String optionName = option.getName();
            if (existing.containsKey(optionName)) {
                if (((LexerOption)existing.get(optionName)).getFilename().equals(option.getFilename())) continue;
                problems.add(((LexerOption)existing.get(optionName)).makeCompilationWarning("Clobbering option from " + option.getFilename() + "."));
                continue;
            }
            if (deleted.containsKey(optionName)) {
                effectiveDeletions.add((OptionRef)deleted.get(optionName));
                continue;
            }
            oldList.add(option);
        }
        for (OptionRef ref : deletedOptions) {
            if (effectiveDeletions.contains(ref)) continue;
            problems.add(ref.makeCompilationWarning("Unoption has no effect."));
        }
    }

    private static void appendDistinctDecls(List<Declaration> oldList, List<Declaration> newList, SortedSet<CompilationProblem> problems) {
        block0: for (Declaration newDecl : newList) {
            for (Declaration oldDecl : oldList) {
                if (newDecl.getText().equals(oldDecl.getText())) continue block0;
            }
            oldList.add(newDecl);
        }
    }

    private static void appendDistinctStringSymbols(Set<StringSymbol> oldSet, Set<StringSymbol> newSet, SortedSet<CompilationProblem> problems) {
        block0: for (StringSymbol newSym : newSet) {
            for (StringSymbol oldSym : oldSet) {
                if (newSym.getText().equals(oldSym.getText())) continue block0;
            }
            oldSet.add(newSym);
        }
    }

    private void fetchComponents(FileLoader loader, SortedSet<CompilationProblem> problems) {
        HashSet<String> processed = new HashSet<String>();
        for (CompDecl decl : this.getReferencedComponents()) {
            String name = decl.getName();
            if (processed.contains(name)) continue;
            processed.add(name);
            Component comp = null;
            try {
                comp = loader.loadComponent(name, problems);
            }
            catch (IOException e) {
                problems.add(decl.makeCompilationError(e.getMessage()));
            }
            if (comp == null) {
                String errorMsg = "Cannot process layout " + this.getName() + " until component " + name + " is available.";
                problems.add(decl.makeCompilationError(errorMsg));
                return;
            }
            comp = comp.processInheritance(loader, problems);
            decl.setComponent(comp);
        }
    }

    private void processReplacements(List<Replacement> replacements, SortedSet<CompilationProblem> problems) {
        HashMap<String, Replacement> replacementMap = new HashMap<String, Replacement>();
        for (Replacement replacement : replacements) {
            replacementMap.put(replacement.getOld().getName(), replacement);
        }
        Set<Replacement> effectiveReplacements = this.replaceComponents(replacementMap);
        for (Replacement replacement : replacements) {
            if (effectiveReplacements.contains(replacement)) continue;
            problems.add(replacement.makeCompilationWarning("Replacement has no effect."));
        }
    }

    public void tidyRuleGroups() {
        for (Component comp : this.getActiveComponents()) {
            comp.tidyRuleGroups();
        }
    }

    private Map<String, java.util.List<Embedding>> buildHostCompMap() {
        HashMap<String, java.util.List<Embedding>> hostCompMap = new HashMap<String, java.util.List<Embedding>>();
        for (Embedding embedding : this.getEmbeddings()) {
            for (CompRef host : embedding.getHosts()) {
                String hostName = host.getName();
                ArrayList<Embedding> list = (ArrayList<Embedding>)hostCompMap.get(hostName);
                if (list == null) {
                    list = new ArrayList<Embedding>();
                    hostCompMap.put(hostName, list);
                }
                list.add(embedding);
            }
        }
        return hostCompMap;
    }

    private Map<String, java.util.List<Embedding>> buildGuestCompMap() {
        HashMap<String, java.util.List<Embedding>> guestCompMap = new HashMap<String, java.util.List<Embedding>>();
        for (Embedding embedding : this.getEmbeddings()) {
            String guestName = embedding.getGuest().getName();
            ArrayList<Embedding> list = (ArrayList<Embedding>)guestCompMap.get(guestName);
            if (list == null) {
                list = new ArrayList<Embedding>();
                guestCompMap.put(guestName, list);
            }
            list.add(embedding);
        }
        return guestCompMap;
    }

    public void printJFlexMetaLexerArrays(PrintHelper out, Map<MetaPattern, Integer> mpatNumbers, Map<MetaPattern, Integer> mpatActions) throws IOException {
        java.util.List<Embedding> embeddingsWithHost;
        Map<String, java.util.List<Embedding>> guestCompMap = this.getGuestCompMap();
        Map<String, java.util.List<Embedding>> hostCompMap = this.getHostCompMap();
        String startCompName = this.getStartComponent().getName();
        int counter = 0;
        ArrayList<MetaPattern> baseEmbeddingMPats = new ArrayList<MetaPattern>();
        HashMap otherEmbeddingMPats = new HashMap();
        for (Embedding embedding : this.getEmbeddings()) {
            otherEmbeddingMPats.put(embedding, new ArrayList());
        }
        if (!guestCompMap.containsKey(startCompName) && (embeddingsWithHost = hostCompMap.get(startCompName)) != null) {
            for (Embedding embedding : embeddingsWithHost) {
                counter = embedding.addStartRule(counter, baseEmbeddingMPats, mpatNumbers, mpatActions);
            }
        }
        for (Map.Entry<String, java.util.List<Embedding>> entry : guestCompMap.entrySet()) {
            String guestName = entry.getKey();
            java.util.List<Embedding> embeddingsWithGuest = entry.getValue();
            java.util.List<Embedding> embeddingsWithHost2 = hostCompMap.get(guestName);
            if (embeddingsWithHost2 == null) continue;
            if (startCompName.equals(guestName)) {
                for (Embedding embedding : embeddingsWithHost2) {
                    counter = embedding.addStartRule(counter, baseEmbeddingMPats, mpatNumbers, mpatActions);
                }
            }
            for (Embedding currEmbedding : embeddingsWithGuest) {
                for (Embedding nextEmbedding : embeddingsWithHost2) {
                    counter = nextEmbedding.addStartRule(counter, (java.util.List)otherEmbeddingMPats.get(currEmbedding), mpatNumbers, mpatActions);
                }
            }
        }
        for (Embedding embedding : this.getEmbeddings()) {
            counter = embedding.addEndRule(counter, (java.util.List)otherEmbeddingMPats.get(embedding), mpatNumbers, mpatActions);
        }
        int numSymbols = this.getNumSymbols();
        DFA dFA = Layout.buildDFA(baseEmbeddingMPats, mpatNumbers, numSymbols);
        Layout.printJFlexMetaLexerTransitionArrayInit(out, "trans_BASE", dFA);
        Layout.printJFlexMetaLexerActionArrayInit(out, "act_BASE", dFA);
        for (Map.Entry entry : otherEmbeddingMPats.entrySet()) {
            Embedding embedding = (Embedding)entry.getKey();
            java.util.List mpats = (java.util.List)entry.getValue();
            DFA dfa = Layout.buildDFA(mpats, mpatNumbers, numSymbols);
            out.println();
            Layout.printJFlexMetaLexerTransitionArrayInit(out, embedding.getDFATransitionsName(), dfa);
            Layout.printJFlexMetaLexerActionArrayInit(out, embedding.getDFAActionsName(), dfa);
        }
    }

    private static DFA buildDFA(java.util.List<MetaPattern> mpats, Map<MetaPattern, Integer> mpatNumbers, int numSymbols) {
        return Layout.buildENFA(mpats, mpatNumbers, numSymbols).convertToNFA().convertToDFA().minimize().moveAcceptingToEnd();
    }

    private static ENFA buildENFA(java.util.List<MetaPattern> mpats, Map<MetaPattern, Integer> mpatNumbers, int numSymbols) {
        ArrayList<Integer[]> transitions = new ArrayList<Integer[]>();
        ArrayList<Set<Integer>> epsilons = new ArrayList<Set<Integer>>();
        ArrayList<Integer> actions = new ArrayList<Integer>();
        int startStateNum = 0;
        Integer[] startStateTransitions = new Integer[numSymbols];
        transitions.add(startStateTransitions);
        int sym = 0;
        while (sym < numSymbols) {
            startStateTransitions[sym] = startStateNum;
            ++sym;
        }
        Object startStateAction = null;
        actions.add((Integer)startStateAction);
        HashSet<Integer> startStateEpsilons = new HashSet<Integer>();
        epsilons.add(startStateEpsilons);
        for (MetaPattern mpat : mpats) {
            Integer action = mpatNumbers.get(mpat);
            SubmachinePosition sub = mpat.buildSubmachine(transitions, epsilons, actions, numSymbols);
            startStateEpsilons.add(sub.getStartState());
            actions.set(sub.getEndState(), action);
        }
        return Layout.buildENFA(transitions, epsilons, actions, numSymbols);
    }

    private static DFA buildReverseDFA(MetaPattern mpat, int numSymbols) {
        return Layout.buildReverseENFA(mpat, numSymbols).convertToNFA().convertToDFA().minimize().moveAcceptingToEnd();
    }

    private static ENFA buildReverseENFA(MetaPattern mpat, int numSymbols) {
        ArrayList<Integer[]> transitions = new ArrayList<Integer[]>();
        ArrayList<Set<Integer>> epsilons = new ArrayList<Set<Integer>>();
        ArrayList<Integer> actions = new ArrayList<Integer>();
        boolean startStateNum = false;
        Integer[] startStateTransitions = new Integer[numSymbols];
        transitions.add(startStateTransitions);
        Object startStateAction = null;
        actions.add((Integer)startStateAction);
        HashSet<Integer> startStateEpsilons = new HashSet<Integer>();
        epsilons.add(startStateEpsilons);
        Integer action = 1;
        SubmachinePosition sub = mpat.buildReverseSubmachine(transitions, epsilons, actions, numSymbols);
        startStateEpsilons.add(sub.getStartState());
        actions.set(sub.getEndState(), action);
        int endStateNum = sub.getEndState();
        return Layout.buildENFA(transitions, epsilons, actions, numSymbols);
    }

    private static ENFA buildENFA(java.util.List<Integer[]> mTransitions, java.util.List<Set<Integer>> mEpsilons, java.util.List<Integer> mActions, int numSymbols) {
        int numStates = mTransitions.size();
        BitSet[][] transitions = new BitSet[numStates][numSymbols];
        BitSet[] epsilons = new BitSet[numStates];
        Integer[] actions = new Integer[numStates];
        int state = 0;
        while (state < numStates) {
            int sym = 0;
            while (sym < numSymbols) {
                transitions[state][sym] = new BitSet(numStates);
                Integer destination = mTransitions.get(state)[sym];
                if (destination != null) {
                    transitions[state][sym].set(destination);
                }
                ++sym;
            }
            epsilons[state] = new BitSet(numStates);
            for (Integer st : mEpsilons.get(state)) {
                epsilons[state].set(st);
            }
            actions[state] = mActions.get(state);
            ++state;
        }
        return new ENFA(transitions, epsilons, actions);
    }

    private static void printJFlexMetaLexerTransitionArrayInit(PrintHelper out, String arrayName, DFA dfa) {
        out.println("private static final Integer[][] " + arrayName + " = new Integer[][] {");
        out.indent();
        Integer[][] transitions = dfa.getTransitions();
        Integer[] actions = dfa.getActions();
        int state = 0;
        while (state < dfa.getNumStates() && actions[state] == null) {
            Integer[] row = transitions[state];
            out.print("{");
            Integer[] integerArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                Integer element = integerArray[n2];
                out.print(element);
                out.print(",");
                ++n2;
            }
            out.println("},");
            ++state;
        }
        out.dedent();
        out.println("};");
    }

    private static void printJFlexMetaLexerActionArrayInit(PrintHelper out, String arrayName, DFA dfa) {
        out.print("private static final Integer[] " + arrayName + " = new Integer[] {");
        Integer[] integerArray = dfa.getActions();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer element = integerArray[n2];
            out.print(element);
            out.print(",");
            ++n2;
        }
        out.println("};");
    }

    public void printJFlexMetaLexerCombinationArrays(PrintHelper out) throws IOException {
        Embedding embedding;
        java.util.List<Embedding> embeddings = this.getEmbeddings();
        Embedding[] orderedEmbeddings = new Embedding[embeddings.size()];
        Iterator<Embedding> iterator = embeddings.iterator();
        while (iterator.hasNext()) {
            orderedEmbeddings[embedding.getEmbeddingIndex()] = embedding = iterator.next();
        }
        out.println("private static final Integer[][][] transitionTables = new Integer[][][] {");
        out.indent();
        Embedding[] embeddingArray = orderedEmbeddings;
        int n = orderedEmbeddings.length;
        int n2 = 0;
        while (n2 < n) {
            embedding = embeddingArray[n2];
            out.println(String.valueOf(embedding.getDFATransitionsName()) + ",");
            ++n2;
        }
        out.dedent();
        out.println("};");
        out.println();
        out.println("private static final Integer[][] actionTables = new Integer[][] {");
        out.indent();
        embeddingArray = orderedEmbeddings;
        n = orderedEmbeddings.length;
        n2 = 0;
        while (n2 < n) {
            embedding = embeddingArray[n2];
            out.println(String.valueOf(embedding.getDFAActionsName()) + ",");
            ++n2;
        }
        out.dedent();
        out.println("};");
    }

    public void printJFlexMetaLexerReverseStartMPatArrays(PrintHelper out) throws IOException {
        int numSymbols = this.getNumSymbols();
        boolean first = true;
        for (Embedding embedding : this.getEmbeddings()) {
            if (embedding.isStartPatternSuppressed()) continue;
            if (!first) {
                out.println();
            }
            DFA dfa = Layout.buildReverseDFA(embedding.getStartPattern(), numSymbols);
            Layout.printJFlexMetaLexerTransitionArrayInit(out, embedding.getDFAReverseStartMPatTransitionsName(), dfa);
            Layout.printJFlexMetaLexerActionArrayInit(out, embedding.getDFAReverseStartMPatActionsName(), dfa);
            first = false;
        }
    }

    public void printJFlexMetaLexerActionArrays(PrintHelper out, Map<MetaPattern, Integer> mpatNumbers, Map<MetaPattern, Integer> mpatActions) throws IOException {
        String name;
        int numMPats = mpatNumbers.size();
        String[] reverseTransitionMap = new String[numMPats];
        String[] reverseActionMap = new String[numMPats];
        for (Embedding embedding : this.getEmbeddings()) {
            MetaPattern mpat = embedding.getStartPattern();
            if (embedding.isStartPatternSuppressed()) continue;
            int mpatNum = mpatNumbers.get(mpat);
            reverseTransitionMap[mpatNum] = embedding.getDFAReverseStartMPatTransitionsName();
            reverseActionMap[mpatNum] = embedding.getDFAReverseStartMPatActionsName();
        }
        out.println("private static final Integer[][][] reverseTransitionTables = new Integer[][][] {");
        out.indent();
        String[] mpatNum = reverseTransitionMap;
        int n = reverseTransitionMap.length;
        int n2 = 0;
        while (n2 < n) {
            name = mpatNum[n2];
            if (name == null) break;
            out.println(String.valueOf(name) + ",");
            ++n2;
        }
        out.dedent();
        out.println("};");
        out.println();
        out.println("private static final Integer[][] reverseActionTables = new Integer[][] {");
        out.indent();
        mpatNum = reverseActionMap;
        n = reverseActionMap.length;
        n2 = 0;
        while (n2 < n) {
            name = mpatNum[n2];
            if (name == null) break;
            out.println(String.valueOf(name) + ",");
            ++n2;
        }
        out.dedent();
        out.println("};");
        out.println();
        int[] actionMap = new int[numMPats];
        for (Map.Entry<MetaPattern, Integer> entry : mpatNumbers.entrySet()) {
            int action;
            MetaPattern mpat = entry.getKey();
            int mpatNum2 = entry.getValue();
            actionMap[mpatNum2] = action = mpatActions.get(mpat).intValue();
        }
        out.print("private static final int[] actionMap = new int[] {");
        int[] nArray = actionMap;
        int n3 = actionMap.length;
        int n4 = 0;
        while (n4 < n3) {
            int action = nArray[n4];
            out.print(String.valueOf(action) + ",");
            ++n4;
        }
        out.println("};");
    }

    public void printJFlexMetaLexerClass(PrintHelper out) throws IOException {
        IdentityHashMap<MetaPattern, Integer> mpatNumbers = new IdentityHashMap<MetaPattern, Integer>();
        IdentityHashMap<MetaPattern, Integer> mpatActions = new IdentityHashMap<MetaPattern, Integer>();
        this.printJFlexMetaLexerHeader(out);
        out.println();
        this.printJFlexMetaLexerSymbolsLegend(out);
        out.println();
        this.printJFlexMetaLexerArrays(out, mpatNumbers, mpatActions);
        out.println();
        this.printJFlexMetaLexerCombinationArrays(out);
        out.println();
        this.printJFlexMetaLexerReverseStartMPatArrays(out);
        out.println();
        this.printJFlexMetaLexerActionArrays(out, mpatNumbers, mpatActions);
        out.println();
        this.printJFlexMetaLexerFields(out);
        out.println();
        this.printJFlexMetaLexerConstructor(out);
        out.println();
        this.printJFlexMetaLexerMethods(out);
        out.println();
        this.printJFlexMetaLexerTransitionClass(out);
        out.println();
        this.printJFlexMetaLexerFooter(out);
    }

    public void printJFlexMetaLexerHeader(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        out.println("public static class " + this.getMetaLexerClassName() + " {");
        out.indent();
    }

    public void printJFlexMetaLexerSymbolsLegend(PrintHelper out) throws IOException {
        out.println("//// Symbols ////");
        String[] stringArray = this.getSymbolsLegend();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            out.println("// " + symbol);
            ++n2;
        }
    }

    public void printJFlexMetaLexerFields(PrintHelper out) throws IOException {
        out.println("private final java.util.Stack<Integer> stateStack = new java.util.Stack<Integer>();");
        out.println();
        out.println("private java.util.List<Integer> currentMatch = new java.util.ArrayList<Integer>();");
        out.println("private int currentState = 0;");
        out.println("private Integer[][] currentTransitionTable = trans_BASE;");
        out.println("private Integer[] currentActionTable = act_BASE;");
    }

    public void printJFlexMetaLexerConstructor(PrintHelper out) throws IOException {
        out.println("public " + this.getMetaLexerClassName() + "() {");
        out.indent();
        out.println("//Transition through states reachable by pure BOF patterns");
        for (Embedding pureBOF : this.getInitialPureBOFSequence()) {
            out.println("switchDFAs(/*" + pureBOF.getName() + "*/ " + pureBOF.getEmbeddingIndex() + "); ");
        }
        out.dedent();
        out.println("}");
    }

    public void printJFlexMetaLexerMethods(PrintHelper out) throws IOException {
        out.println("public Transition processSymbol(int sym) {");
        out.indent();
        out.println("System.err.println(\"Processing symbol \" + sym);");
        out.println("currentMatch.add(sym);");
        out.println("currentState = currentTransitionTable[currentState][sym];");
        out.println("Integer mpatNum = currentActionTable[currentState];");
        out.println("if(mpatNum == null) {");
        out.indent();
        out.println("return null;");
        out.dedent();
        out.println("}");
        out.println("int action = actionMap[mpatNum];");
        out.println("Transition transition = new Transition(action, cleanMatch(mpatNum, currentMatch));");
        out.println("switchDFAs(action);");
        out.println("return transition;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private void switchDFAs(int action) {");
        out.indent();
        out.println("currentState = 0;");
        out.println("currentMatch.clear();");
        out.println("");
        out.println("int nextEmbedding;");
        out.println("if(action < 0) {");
        out.indent();
        out.println("stateStack.pop();");
        out.println("nextEmbedding = stateStack.isEmpty() ? -1 : stateStack.peek();");
        out.dedent();
        out.println("} else {");
        out.indent();
        out.println("stateStack.push(action);");
        out.println("nextEmbedding = action;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("System.err.println(\"Switching to DFA \" + nextEmbedding);");
        out.println("if(nextEmbedding < 0) {");
        out.indent();
        out.println("currentTransitionTable = trans_BASE;");
        out.println("currentActionTable = act_BASE;");
        out.dedent();
        out.println("} else {");
        out.indent();
        out.println("currentTransitionTable = transitionTables[nextEmbedding];");
        out.println("currentActionTable = actionTables[nextEmbedding];");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private java.util.List<Integer> cleanMatch(int mpatNum, java.util.List<Integer> rawMatch) {");
        out.indent();
        out.println("if(mpatNum >= reverseTransitionTables.length) {");
        out.indent();
        out.println("//don't need to clean end pattern matches - they aren't looked at");
        out.println("return new java.util.ArrayList<Integer>(rawMatch);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("java.util.List<Integer> cleanMatch = new java.util.ArrayList<Integer>();");
        out.println("Integer[][] transitions = reverseTransitionTables[mpatNum];");
        out.println("Integer[] actions = reverseActionTables[mpatNum];");
        out.println("int dfaState = 0;");
        out.println("for(int i = rawMatch.size() - 1; (i >= 0) && (actions[dfaState] == null); i--) {");
        out.indent();
        out.println("int sym = rawMatch.get(i);");
        out.println("cleanMatch.add(sym);");
        out.println("dfaState = transitions[dfaState][sym];");
        out.dedent();
        out.println("}");
        out.println("java.util.Collections.reverse(cleanMatch);");
        out.println("return cleanMatch;");
        out.dedent();
        out.println("}");
    }

    public void printJFlexMetaLexerFooter(PrintHelper out) throws IOException {
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public void generateJFlex(String baseDir) throws IOException {
        new File(baseDir).mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(String.valueOf(baseDir) + "/" + this.getName() + ".flex"));
        PrintHelper out = new PrintHelper(writer, 4);
        this.generateJFlex(out);
        out.close();
    }

    public void generateJFlex(PrintHelper out) throws IOException {
        this.printJFlexHeader(out);
        out.println("%%");
        out.println("//// This file was generated by MetaLexer ////");
        out.println();
        this.printJFlexOptions(out);
        out.println();
        this.printJFlexStateClassInstance(out);
        out.println();
        this.printJFlexStateClass(out);
        out.println();
        this.printJFlexInnerClassBaseClass(out);
        out.println();
        this.printJFlexInnerClasses(out);
        out.println();
        this.printJFlexMetaLexerClass(out);
        out.println();
        this.printJFlexPairFilter(out);
        out.println();
        this.printJFlexEmbeddingRecord(out);
        out.println();
        this.printJFlexMaybeClass(out);
        out.println();
        this.printJFlexCodeRegions(out);
        out.println();
        this.printJFlexStates(out);
        out.println();
        this.printJFlexMacros(out);
        out.println();
        out.println("%%");
        out.println();
        this.printJFlexRules(out);
        out.println();
    }

    public void printJFlexHeader(PrintHelper out) throws IOException {
        out.print(this.getLocalHeader());
        out.print(this.getInheritedHeader());
        for (Component comp : this.getActiveComponents()) {
            comp.printJFlexImports(out);
        }
    }

    public void printJFlexOptions(PrintHelper out) throws IOException {
        for (LexerOption option : this.getOptions()) {
            option.printJFlexPosComment(out);
            out.println(StringEval.evalString(option.getValue()));
        }
        HashSet<StringSymbol> lexExceptions = new HashSet<StringSymbol>(this.getYylexExceptions());
        HashSet<StringSymbol> initExceptions = new HashSet<StringSymbol>(this.getInitExceptions());
        for (Component comp : this.getActiveComponents()) {
            lexExceptions.addAll(comp.getYylexExceptions());
            initExceptions.addAll(comp.getInitExceptions());
        }
        for (StringSymbol exception : lexExceptions) {
            exception.printJFlexPosComment(out);
            out.println("%yylexthrow " + StringEval.evalString(exception.getText()));
        }
        for (StringSymbol exception : initExceptions) {
            exception.printJFlexPosComment(out);
            out.println("%initthrow " + StringEval.evalString(exception.getText()));
        }
    }

    public void printJFlexCodeRegions(PrintHelper out) throws IOException {
        for (StringSymbol region : this.getDeclRegions()) {
            region.printJFlexPosComment(out);
            out.println(region.getText());
        }
        out.println();
        for (StringSymbol region : this.getInitRegions()) {
            region.printJFlexPosComment(out);
            out.println(region.getText());
        }
        if (this.isTracingCodeEmbedded()) {
            out.println("%{");
            out.indent();
            out.println("private boolean tracingEnabled = false;");
            out.println();
            out.println("public void setTracingEnabled(boolean tracingEnabled) {");
            out.indent();
            out.println("this.tracingEnabled = tracingEnabled;");
            out.dedent();
            out.println("}");
            out.println();
            out.println("public boolean isTracingEnabled() {");
            out.indent();
            out.println("return tracingEnabled;");
            out.dedent();
            out.println("}");
            out.dedent();
            out.println("%}");
            out.println();
            out.println("%{");
            out.indent();
            out.println("public String getCurrentEmbedding() {");
            out.indent();
            out.println("if(" + this.getJFlexStateObjectName() + ".embeddingStack == null || " + this.getJFlexStateObjectName() + ".embeddingStack.isEmpty()) { return null; }");
            out.println("return " + this.getJFlexStateObjectName() + ".embeddingStack.peek().getName();");
            out.dedent();
            out.println("}");
            out.println();
            out.println("public String getCurrentComponent() {");
            out.indent();
            out.println("if(" + this.getJFlexStateObjectName() + ".embeddingStack == null || " + this.getJFlexStateObjectName() + ".embeddingStack.isEmpty()) { return null; }");
            out.println("return " + this.getJFlexStateObjectName() + ".embeddingStack.peek().getComp().getName();");
            out.dedent();
            out.println("}");
            out.dedent();
            out.println("%}");
            out.println();
        }
    }

    public void printJFlexInnerClassBaseClass(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        out.println("private static abstract class ComponentInnerClass {");
        out.indent();
        out.println("public boolean isAppend() {");
        out.indent();
        out.println("return false;");
        out.dedent();
        out.println("}");
        out.println("public Maybe<? extends " + this.getTokenType() + "> " + "performAppendAction" + "(int startLine, int startCol, int endLine, int endCol, String text)" + this.getLexThrowsDecl() + " {");
        out.indent();
        out.println("throw new UnsupportedOperationException(getClass().getName() + \".performAppendAction has not been implemented.\");");
        out.dedent();
        out.println("}");
        out.println("public abstract int getStartState();");
        out.println("public abstract int getSymbolValue();");
        if (this.isTracingCodeEmbedded()) {
            out.println("public abstract String getName();");
        }
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public void printJFlexStateClassInstance(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        String className = this.getJFlexStateClassName();
        String instanceName = this.getJFlexStateObjectName();
        out.println("private final " + className + " " + instanceName + " = new " + className + "();");
        out.dedent();
        out.println("%}");
    }

    public void printJFlexStateClass(PrintHelper out) throws IOException {
        java.util.List<Embedding> embeddings = this.getEmbeddings();
        int numEmbeddings = embeddings.size();
        out.println("%{");
        out.indent();
        String className = "StateClass_" + this.getName();
        out.println("private class " + className + " {");
        out.indent();
        out.println("private " + className + "() {");
        out.indent();
        for (Embedding embedding : embeddings) {
            String instanceName = embedding.getGuest().getDecl().getComponent().getJFlexInnerClassInstanceName();
            String filter = "PairFilter.EMPTY";
            if (!embedding.getMTokPairs().isEmpty()) {
                Iterator<Component> filterBuf = new StringBuffer("new PairFilter.Builder()");
                for (MTokPair pair : embedding.getMTokPairs()) {
                    String lcomment = "/*" + pair.getL().getName() + "*/ ";
                    int lsym = pair.getL().getSymbolValue();
                    String rcomment = "/*" + pair.getR().getName() + "*/ ";
                    int rsym = pair.getR().getSymbolValue();
                    ((StringBuffer)((Object)filterBuf)).append(".add(" + lcomment + lsym + ", " + rcomment + rsym + ")");
                }
                ((StringBuffer)((Object)filterBuf)).append(".build()");
                filter = ((StringBuffer)((Object)filterBuf)).toString();
            }
            embedding.printJFlexPosComment(out);
            out.println("embeddingRecordArray[" + embedding.getEmbeddingIndex() + "] = " + "new EmbeddingRecord(\"" + embedding.getName() + "\", " + instanceName + ", " + filter + ");");
        }
        out.println();
        Component startComp = this.getStartComponent().getDecl().getComponent();
        String rawStartState = startComp.hasStartState() ? startComp.getStartState().getName() : "YYINITIAL";
        String startState = startComp.getJFlexStateName(rawStartState);
        this.getStartComponent().printJFlexPosComment(out);
        out.println("yybegin(" + startState + ");");
        out.println();
        if (this.isTracingCodeEmbedded()) {
            out.print("if(isTracingEnabled()) { ");
            out.print("System.err.println(\"INIT: component " + startComp.getName() + "\");");
            out.print("} ");
        }
        out.println("embeddingStack.add(new EmbeddingRecord(null, " + startComp.getJFlexInnerClassInstanceName() + ", PairFilter.EMPTY));");
        out.println();
        out.println("//Transition through states reachable by pure BOF patterns");
        out.println("//NB: append actions will not be performed");
        for (Embedding pureBOF : this.getInitialPureBOFSequence()) {
            out.println("startEmbedding(/*" + pureBOF.getName() + "*/ " + pureBOF.getEmbeddingIndex() + "); ");
        }
        out.println();
        out.println("restartAppendBuf();");
        out.println();
        out.println("//NB: Send <BOF> immediately.  Don't check for a return, because pure BOFs are handled above.");
        out.println("sendMTok(/*BOF*/ 0);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private final EmbeddingRecord[] embeddingRecordArray = new EmbeddingRecord[" + numEmbeddings + "];");
        for (Component comp : this.getActiveComponents()) {
            String compClassName = comp.getJFlexInnerClassName();
            String compInstanceName = comp.getJFlexInnerClassInstanceName();
            out.println("private final " + compClassName + " " + compInstanceName + " = new " + compClassName + "();");
        }
        out.println("private java.util.Stack<EmbeddingRecord> embeddingStack = new java.util.Stack<EmbeddingRecord>();");
        out.println();
        out.println("private void startEmbedding(int newEmbeddingNum) {");
        out.indent();
        out.println("EmbeddingRecord newEmbedding = embeddingRecordArray[newEmbeddingNum];");
        out.println("newEmbedding.getFilter().reset();");
        out.println("embeddingStack.push(newEmbedding);");
        out.println("yybegin(newEmbedding.getComp().getStartState());");
        out.dedent();
        out.println("}");
        out.println("private void endEmbedding() {");
        out.indent();
        out.println("embeddingStack.pop();");
        out.println("EmbeddingRecord newEmbedding = embeddingStack.peek();");
        out.println("yybegin(newEmbedding.getComp().getStartState());");
        out.dedent();
        out.println("}");
        out.println("private ComponentInnerClass getCurrComp() {");
        out.indent();
        out.println("return embeddingStack.peek().getComp();");
        out.dedent();
        out.println("}");
        out.println("private PairFilter getCurrFilter() {");
        out.indent();
        out.println("return embeddingStack.peek().getFilter();");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private int startLine = -1;");
        out.println("private int startCol = -1;");
        out.println("private StringBuffer appendBuf = null;");
        out.println();
        out.println("private void restartAppendBuf() {");
        out.indent();
        out.println("startLine = yyline + 1;");
        out.println("startCol = yycolumn + 1;");
        out.println("appendBuf = new StringBuffer();");
        out.dedent();
        out.println("}");
        out.println("private int getStartLine() {");
        out.indent();
        out.println("return startLine;");
        out.dedent();
        out.println("}");
        out.println("private int getStartColumn() {");
        out.indent();
        out.println("return startCol;");
        out.dedent();
        out.println("}");
        out.println("private String getAppendText() {");
        out.indent();
        out.println("return appendBuf.toString();");
        out.dedent();
        out.println("}");
        out.println("private <T> void append(T t) {");
        out.indent();
        out.println("appendBuf.append(t);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private " + this.getTokenType() + " extraReturn = null;");
        out.println("private int prevState = -1;");
        out.println();
        out.println("public " + this.getTokenType() + " getExtraReturn() {");
        out.indent();
        out.println("return extraReturn;");
        out.dedent();
        out.println("}");
        out.println("public int getPrevState() {");
        out.indent();
        out.println("return prevState;");
        out.dedent();
        out.println("}");
        out.println("private void returnExtraValue(" + this.getTokenType() + " value) {");
        out.indent();
        out.println("extraReturn = value;");
        out.println("prevState = yystate();");
        out.println("if(yylength() > 0) {");
        out.indent();
        out.println("yypushback(1); //to ensure that at least one char is available");
        out.dedent();
        out.println("}");
        out.println("yybegin(EXTRA_RETURN);");
        out.dedent();
        out.println("}");
        out.println();
        String mlClassName = this.getMetaLexerClassName();
        String mlInstanceName = this.getMetaLexerObjectName();
        out.println("private final " + mlClassName + " " + mlInstanceName + " = new " + mlClassName + "();");
        out.println("private " + mlClassName + ".Transition sendMTok(int mtok) {");
        out.indent();
        out.println("return " + mlInstanceName + ".processSymbol(mtok);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public void processMTok(int mtok) " + this.getLexThrowsDecl() + "{");
        out.indent();
        out.println("if(!getCurrFilter().test(mtok)) {");
        out.indent();
        if (this.isTracingCodeEmbedded()) {
            out.print("if(isTracingEnabled()) { ");
            out.print(" } ");
        }
        out.println("return; //don't send symbol if it gets filtered out");
        out.dedent();
        out.println("}");
        if (this.isTracingCodeEmbedded()) {
            out.print("if(isTracingEnabled()) { ");
            out.print("} ");
        }
        out.println("Maybe<? extends " + this.getTokenType() + "> maybeReturn = Maybe.Nothing();");
        out.println("ComponentInnerClass currComp = getCurrComp();");
        out.println("boolean appendActionPerformed = false;");
        out.println(String.valueOf(mlClassName) + ".Transition next = sendMTok(mtok);");
        out.println("while(next != null) {");
        out.indent();
        out.println("boolean endOfEmbedding = next.getEmbeddingNum() < 0;");
        out.println("if(endOfEmbedding) {");
        out.indent();
        out.println("endEmbedding();");
        out.dedent();
        out.println("} else {");
        out.indent();
        out.println("//NB: update filter in the OLD embedding and only in start case");
        out.println("getCurrFilter().clean(next.getMatch());");
        out.println("startEmbedding(next.getEmbeddingNum());");
        out.dedent();
        out.println("}");
        out.println("ComponentInnerClass nextComp = getCurrComp();");
        out.println("//NB: only one append action can meaningfully be performed since");
        out.println("//  no input can be consumed while in this loop");
        out.println("if(!appendActionPerformed && currComp.isAppend() && !nextComp.isAppend()) {");
        out.indent();
        out.println("int endLine = yyline + 1;");
        out.println("int endCol = yycolumn; //+1 handled by increment below");
        out.println();
        out.println("final String yytext = yytext();");
        out.println("final int yylength = yylength();");
        out.println("boolean prevWasNewline = false;");
        out.println("for(int i = 0; i < yylength; i++) {");
        out.indent();
        out.println("if(prevWasNewline) {");
        out.indent();
        out.println("endLine++;");
        out.println("endCol = 0;");
        out.dedent();
        out.println("}");
        out.println("switch(yytext.charAt(i)) {");
        out.println("case '\\r':");
        out.indent();
        out.println("if(i + 1 < yylength && yytext.charAt(i+1) == '\\n') {");
        out.indent();
        out.println("i++;");
        out.dedent();
        out.println("}");
        out.println("//NB: fall through");
        out.dedent();
        out.println("case '\\n':");
        out.indent();
        out.println("prevWasNewline = true;");
        out.println("break;");
        out.dedent();
        out.println("default:");
        out.indent();
        out.println("prevWasNewline = false;");
        out.println("break;");
        out.dedent();
        out.println("}");
        out.println("endCol++;");
        out.dedent();
        out.println("}");
        out.println("maybeReturn = currComp.performAppendAction(getStartLine(), getStartColumn(), endLine, endCol, getAppendText());");
        out.println("appendActionPerformed = true;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("if(currComp.isAppend() != nextComp.isAppend()) {");
        out.indent();
        out.println("restartAppendBuf();");
        out.dedent();
        out.println("}");
        out.println();
        out.println("next = null;");
        out.println("if(endOfEmbedding) {");
        out.indent();
        out.println("int regionSym = currComp.getSymbolValue();");
        out.println("if(getCurrFilter().test(regionSym)) {");
        out.indent();
        if (this.isTracingCodeEmbedded()) {
            out.print("if(isTracingEnabled()) { ");
            out.print("System.err.println(\"SEND: region %\" + currComp.getName() + \"%\");");
            out.print("} ");
        }
        out.println("next = sendMTok(regionSym);");
        out.dedent();
        out.println("} else {");
        out.indent();
        if (this.isTracingCodeEmbedded()) {
            out.print("if(isTracingEnabled()) { ");
            out.print("System.err.println(\"IGNORE: region %\" + currComp.getName() + \"% in pair filter for embedding \" + embeddingStack.peek().getName());");
            out.print("} ");
        }
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println("if(maybeReturn.isJust()) {");
        out.indent();
        out.println("returnExtraValue(maybeReturn.fromJust());");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public void printJFlexInnerClasses(PrintHelper out) throws IOException {
        for (Component comp : this.getActiveComponents()) {
            comp.printJFlexInnerClass(out);
        }
    }

    public void printJFlexStates(PrintHelper out) throws IOException {
        out.println("%xstate EXTRA_RETURN");
        out.println();
        for (Component comp : this.getActiveComponents()) {
            comp.printJFlexStates(out);
        }
    }

    public void printJFlexMacros(PrintHelper out) throws IOException {
        for (Component comp : this.getActiveComponents()) {
            comp.printJFlexMacros(out);
        }
    }

    public void printJFlexRules(PrintHelper out) throws IOException {
        String stateObjectName = this.getJFlexStateObjectName();
        out.println("<EXTRA_RETURN> {");
        out.indent();
        out.println("(. | \\n) {");
        out.indent();
        out.println("yybegin(" + stateObjectName + ".getPrevState());");
        out.println("return " + stateObjectName + ".getExtraReturn();");
        out.dedent();
        out.println("}");
        out.println();
        out.println("<<EOF>> {");
        out.indent();
        out.println("yybegin(" + stateObjectName + ".getPrevState());");
        out.println("return " + stateObjectName + ".getExtraReturn();");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println();
        for (Component comp : this.getActiveComponents()) {
            comp.printJFlexRules(out);
        }
    }

    public void printJFlexMetaLexerTransitionClass(PrintHelper out) throws IOException {
        out.println("public static class Transition {");
        out.indent();
        out.println("private final int embeddingNum;");
        out.println("private final java.util.List<Integer> match;");
        out.println();
        out.println("public Transition(int embeddingNum, java.util.List<Integer> match) {");
        out.indent();
        out.println("this.embeddingNum = embeddingNum;");
        out.println("this.match = new java.util.ArrayList<Integer>(match);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public int getEmbeddingNum() { return embeddingNum; }");
        out.println();
        out.println("public java.util.List<Integer> getMatch() { return match; }");
        out.dedent();
        out.println("}");
    }

    public void printJFlexPairFilter(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        out.println("private static class PairFilter {");
        out.indent();
        out.println("public static final PairFilter EMPTY = new PairFilter.Builder().build();");
        out.println();
        out.println("private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open");
        out.println("private final java.util.Set<Integer> allOpenSymbols;");
        out.println("private final java.util.List<Integer> unclosedOpenSymbols; //really a stack, but then the iterator would go backwards");
        out.println();
        out.println("private PairFilter(java.util.Map<Integer, java.util.Set<Integer>> pairMap, java.util.Set<Integer> allOpenSymbols) {");
        out.indent();
        out.println("this.pairMap = pairMap;");
        out.println("this.allOpenSymbols = allOpenSymbols;");
        out.println("this.unclosedOpenSymbols = new java.util.ArrayList<Integer>();");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public static class Builder {");
        out.indent();
        out.println("private final java.util.Map<Integer, java.util.Set<Integer>> pairMap; //close -> open");
        out.println("private final java.util.Set<Integer> allOpenSymbols;");
        out.println();
        out.println("public Builder() {");
        out.indent();
        out.println("this.pairMap = new java.util.HashMap<Integer, java.util.Set<Integer>>();");
        out.println("this.allOpenSymbols = new java.util.HashSet<Integer>();");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public Builder add(int open, int close) {");
        out.indent();
        out.println("allOpenSymbols.add(open);");
        out.println("java.util.Set<Integer> list = pairMap.get(close);");
        out.println("if(list == null) {");
        out.indent();
        out.println("list = new java.util.HashSet<Integer>();");
        out.println("pairMap.put(close, list);");
        out.dedent();
        out.println("}");
        out.println("list.add(open);");
        out.println("return this;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public PairFilter build() {");
        out.indent();
        out.println("return new PairFilter(pairMap, allOpenSymbols);");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public boolean test(int sym) {");
        out.indent();
        out.println("//NB: closing-ness takes precedence over opening-ness");
        out.println("java.util.Set<Integer> correspondingOpens = pairMap.get(sym);");
        out.println("if(correspondingOpens != null) { //implies closing");
        out.indent();
        out.println("for(java.util.Iterator<Integer> it = unclosedOpenSymbols.iterator(); it.hasNext(); ) {");
        out.indent();
        out.println("int open = it.next();");
        out.println("if(correspondingOpens.contains(open)) {");
        out.indent();
        out.println("//if closing and have seen corresponding open, then close open and reject");
        out.println("it.remove();");
        out.println("return false;");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println("//if closing and have not seen corresponding open, then accept");
        out.dedent();
        out.println("}");
        out.println("if(allOpenSymbols.contains(sym)) { //implies opening");
        out.indent();
        out.println("unclosedOpenSymbols.add(0, sym); //insert at beginning");
        out.dedent();
        out.println("}");
        out.println("return true;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public void clean(java.util.List<Integer> match) {");
        out.indent();
        out.println("java.util.Collections.reverse(match);");
        out.println("for(int sym : match) {");
        out.indent();
        out.println("if(unclosedOpenSymbols.isEmpty()) {");
        out.indent();
        out.println("return;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("if(unclosedOpenSymbols.get(0) == sym) {");
        out.indent();
        out.println("unclosedOpenSymbols.remove(0);");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public void reset() {");
        out.indent();
        out.println("unclosedOpenSymbols.clear();");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public void printJFlexEmbeddingRecord(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        out.println("public class EmbeddingRecord {");
        out.indent();
        out.println("private final String name;");
        out.println("private final ComponentInnerClass comp;");
        out.println("private final PairFilter filter;");
        out.println();
        out.println("public EmbeddingRecord(String name, ComponentInnerClass comp, PairFilter filter) {");
        out.indent();
        out.println("this.name = name;");
        out.println("this.comp = comp;");
        out.println("this.filter = filter;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public String getName() {");
        out.indent();
        out.println("return name;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public ComponentInnerClass getComp() {");
        out.indent();
        out.println("return comp;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public PairFilter getFilter() {");
        out.indent();
        out.println("return filter;");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public void printJFlexMaybeClass(PrintHelper out) throws IOException {
        out.println("%{");
        out.indent();
        out.println("private static abstract class Maybe<T> {");
        out.indent();
        out.println("@SuppressWarnings(\"unchecked\")");
        out.println("private final static Maybe NOTHING = new Nothing();");
        out.println();
        out.println("private Maybe() {}");
        out.println();
        out.println("public final boolean isNothing() {");
        out.indent();
        out.println("return !isJust();");
        out.dedent();
        out.println("}");
        out.println("public abstract boolean isJust();");
        out.println();
        out.println("public abstract T fromJust();");
        out.println();
        out.println("public static <S> Maybe<S> Just(S value) {");
        out.indent();
        out.println("return new Just<S>(value);");
        out.dedent();
        out.println("}");
        out.println();
        out.println("@SuppressWarnings(\"unchecked\")");
        out.println("public static <S> Maybe<S> Nothing() {");
        out.indent();
        out.println("return (Nothing<S>) NOTHING;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private static class Just<T> extends Maybe<T> {");
        out.indent();
        out.println("private T value;");
        out.println();
        out.println("private Just(T value) {");
        out.indent();
        out.println("this.value = value;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public boolean isJust() {");
        out.indent();
        out.println("return true;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public T fromJust() {");
        out.indent();
        out.println("return value;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public String toString() { ");
        out.indent();
        out.println("return \"Just \" + value;");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.println();
        out.println("private static class Nothing<T> extends Maybe<T> {");
        out.indent();
        out.println("private Nothing() {}");
        out.println();
        out.println("public boolean isJust() {");
        out.indent();
        out.println("return false;");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public T fromJust() {");
        out.indent();
        out.println("throw new UnsupportedOperationException(\"Cannot extract value from Nothing\");");
        out.dedent();
        out.println("}");
        out.println();
        out.println("public String toString() {");
        out.indent();
        out.println("return \"Nothing\";");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("}");
        out.dedent();
        out.println("%}");
    }

    public int getNumSymbols() {
        return this.numSymbols;
    }

    @Override
    public void assignSymbolsToMetaTokens(SymbolAssigner assigner) {
        for (Component comp : this.getActiveComponents()) {
            comp.regionSymbolValue = assigner.assignSymbol(comp.getMetaJFlexRegionName());
        }
        super.assignSymbolsToMetaTokens(assigner);
        this.numSymbols = assigner.getNumSymbols();
    }

    public void setTracingCodeEmbedded(boolean tracingCodeEmbedded) {
        this.tracingCodeEmbedded = tracingCodeEmbedded;
    }

    public boolean isTracingCodeEmbedded() {
        return this.tracingCodeEmbedded;
    }

    public void generateJFlexEmbeddingPropFile(String baseDir) throws IOException {
        new File(baseDir).mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(String.valueOf(baseDir) + "/" + this.getName() + ".embedding.properties"));
        PrintHelper out = new PrintHelper(writer, 4);
        this.generateJFlexEmbeddingPropFile(out);
        out.close();
    }

    public void generateJFlexEmbeddingPropFile(PrintHelper out) throws IOException {
        out.println("#Embeddings");
        for (Embedding embedding : this.getEmbeddings()) {
            out.println(String.valueOf(embedding.getName()) + " = " + embedding.getEmbeddingIndex());
        }
    }

    public void generateJFlexMacroPropFile(String baseDir) throws IOException {
        new File(baseDir).mkdirs();
        PrintWriter writer = new PrintWriter(new FileWriter(String.valueOf(baseDir) + "/" + this.getName() + ".macro.properties"));
        PrintHelper out = new PrintHelper(writer, 4);
        this.generateJFlexMacroPropFile(out);
        out.close();
    }

    public void generateJFlexMacroPropFile(PrintHelper out) throws IOException {
        out.println("#Meta-tokens");
        for (MTokRef mtok : this.listMetaTokens()) {
            out.println(String.valueOf(mtok.getMetaJFlexName()) + "=" + mtok.getSymbolValue());
        }
        out.println();
        out.println("#Regions");
        for (RegionMetaPattern region : this.listRegions()) {
            int symValue = region.getSymbolValue();
            out.println(String.valueOf(region.getMetaJFlexName()) + "=" + symValue);
        }
    }

    public Layout() {
        this.setChild(new Opt(), 0);
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
    }

    public Layout(String p0, boolean p1, String p2, String p3, Opt<CompRef> p4, List<CompDecl> p5, List<LexerOption> p6, List<Declaration> p7, Set<StringSymbol> p8, Set<StringSymbol> p9, Set<StringSymbol> p10, Set<StringSymbol> p11, List<BodyElement> p12) {
        this.setName(p0);
        this.setHelper(p1);
        this.setLocalHeader(p2);
        this.setInheritedHeader(p3);
        this.setChild(p4, 0);
        this.setChild(p5, 1);
        this.setChild(p6, 2);
        this.setChild(p7, 3);
        this.setDeclRegions(p8);
        this.setYylexExceptions(p9);
        this.setInitRegions(p10);
        this.setInitExceptions(p11);
        this.setChild(p12, 4);
    }

    public Layout(Symbol p0, boolean p1, Symbol p2, Symbol p3, Opt<CompRef> p4, List<CompDecl> p5, List<LexerOption> p6, List<Declaration> p7, Set<StringSymbol> p8, Set<StringSymbol> p9, Set<StringSymbol> p10, Set<StringSymbol> p11, List<BodyElement> p12) {
        this.setName(p0);
        this.setHelper(p1);
        this.setLocalHeader(p2);
        this.setInheritedHeader(p3);
        this.setChild(p4, 0);
        this.setChild(p5, 1);
        this.setChild(p6, 2);
        this.setChild(p7, 3);
        this.setDeclRegions(p8);
        this.setYylexExceptions(p9);
        this.setInitRegions(p10);
        this.setInitExceptions(p11);
        this.setChild(p12, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHelper(boolean value) {
        this.tokenboolean_Helper = value;
    }

    public boolean getHelper() {
        return this.tokenboolean_Helper;
    }

    public void setLocalHeader(String value) {
        this.tokenString_LocalHeader = value;
    }

    public void setLocalHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLocalHeader is only valid for String lexemes");
        }
        this.tokenString_LocalHeader = (String)symbol.value;
        this.LocalHeaderstart = symbol.getStart();
        this.LocalHeaderend = symbol.getEnd();
    }

    public String getLocalHeader() {
        return this.tokenString_LocalHeader != null ? this.tokenString_LocalHeader : "";
    }

    public void setInheritedHeader(String value) {
        this.tokenString_InheritedHeader = value;
    }

    public void setInheritedHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setInheritedHeader is only valid for String lexemes");
        }
        this.tokenString_InheritedHeader = (String)symbol.value;
        this.InheritedHeaderstart = symbol.getStart();
        this.InheritedHeaderend = symbol.getEnd();
    }

    public String getInheritedHeader() {
        return this.tokenString_InheritedHeader != null ? this.tokenString_InheritedHeader : "";
    }

    public void setStartComponentOpt(Opt<CompRef> opt) {
        this.setChild(opt, 0);
    }

    public boolean hasStartComponent() {
        return this.getStartComponentOpt().getNumChild() != 0;
    }

    public CompRef getStartComponent() {
        return (CompRef)this.getStartComponentOpt().getChild(0);
    }

    public void setStartComponent(CompRef node) {
        this.getStartComponentOpt().setChild(node, 0);
    }

    public Opt<CompRef> getStartComponentOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<CompRef> getStartComponentOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    public void setComponentList(List<CompDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    public CompDecl getComponent(int i) {
        return (CompDecl)this.getComponentList().getChild(i);
    }

    public void addComponent(CompDecl node) {
        List<CompDecl> list = this.getComponentList();
        list.addChild(node);
    }

    public void setComponent(CompDecl node, int i) {
        List<CompDecl> list = this.getComponentList();
        list.setChild(node, i);
    }

    public List<CompDecl> getComponents() {
        return this.getComponentList();
    }

    public List<CompDecl> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    public List<CompDecl> getComponentList() {
        return (List)this.getChild(1);
    }

    public List<CompDecl> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setOptionList(List<LexerOption> list) {
        this.setChild(list, 2);
    }

    public int getNumOption() {
        return this.getOptionList().getNumChild();
    }

    public LexerOption getOption(int i) {
        return (LexerOption)this.getOptionList().getChild(i);
    }

    public void addOption(LexerOption node) {
        List<LexerOption> list = this.getOptionList();
        list.addChild(node);
    }

    public void setOption(LexerOption node, int i) {
        List<LexerOption> list = this.getOptionList();
        list.setChild(node, i);
    }

    public List<LexerOption> getOptions() {
        return this.getOptionList();
    }

    public List<LexerOption> getOptionsNoTransform() {
        return this.getOptionListNoTransform();
    }

    public List<LexerOption> getOptionList() {
        return (List)this.getChild(2);
    }

    public List<LexerOption> getOptionListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setDeclList(List<Declaration> list) {
        this.setChild(list, 3);
    }

    public int getNumDecl() {
        return this.getDeclList().getNumChild();
    }

    public Declaration getDecl(int i) {
        return (Declaration)this.getDeclList().getChild(i);
    }

    public void addDecl(Declaration node) {
        List<Declaration> list = this.getDeclList();
        list.addChild(node);
    }

    public void setDecl(Declaration node, int i) {
        List<Declaration> list = this.getDeclList();
        list.setChild(node, i);
    }

    public List<Declaration> getDecls() {
        return this.getDeclList();
    }

    public List<Declaration> getDeclsNoTransform() {
        return this.getDeclListNoTransform();
    }

    public List<Declaration> getDeclList() {
        return (List)this.getChild(3);
    }

    public List<Declaration> getDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    public void setDeclRegions(Set<StringSymbol> value) {
        this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions = value;
    }

    public Set<StringSymbol> getDeclRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    }

    public void setYylexExceptions(Set<StringSymbol> value) {
        this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions = value;
    }

    public Set<StringSymbol> getYylexExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    }

    public void setInitRegions(Set<StringSymbol> value) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions = value;
    }

    public Set<StringSymbol> getInitRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    }

    public void setInitExceptions(Set<StringSymbol> value) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions = value;
    }

    public Set<StringSymbol> getInitExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    }

    public void setBodyElementList(List<BodyElement> list) {
        this.setChild(list, 4);
    }

    public int getNumBodyElement() {
        return this.getBodyElementList().getNumChild();
    }

    public BodyElement getBodyElement(int i) {
        return (BodyElement)this.getBodyElementList().getChild(i);
    }

    public void addBodyElement(BodyElement node) {
        List<BodyElement> list = this.getBodyElementList();
        list.addChild(node);
    }

    public void setBodyElement(BodyElement node, int i) {
        List<BodyElement> list = this.getBodyElementList();
        list.setChild(node, i);
    }

    public List<BodyElement> getBodyElements() {
        return this.getBodyElementList();
    }

    public List<BodyElement> getBodyElementsNoTransform() {
        return this.getBodyElementListNoTransform();
    }

    public List<BodyElement> getBodyElementList() {
        return (List)this.getChild(4);
    }

    public List<BodyElement> getBodyElementListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    @Override
    protected void collect_contributors_Layout_listMetaTokens() {
        if (this.collect_contributors_Layout_listMetaTokens) {
            return;
        }
        super.collect_contributors_Layout_listMetaTokens();
        this.collect_contributors_Layout_listMetaTokens = true;
    }

    @Override
    protected void collect_contributors_Layout_listRegions() {
        if (this.collect_contributors_Layout_listRegions) {
            return;
        }
        super.collect_contributors_Layout_listRegions();
        this.collect_contributors_Layout_listRegions = true;
    }

    public java.util.List<Component> getActiveComponents() {
        if (this.getActiveComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getActiveComponents in class: ");
        }
        this.getActiveComponents_visited = this.state().boundariesCrossed;
        java.util.List<Component> getActiveComponents_value = this.getActiveComponents_compute();
        this.getActiveComponents_visited = -1;
        return getActiveComponents_value;
    }

    private java.util.List<Component> getActiveComponents_compute() {
        ArrayList<Component> active = new ArrayList<Component>();
        for (CompDecl decl : this.getComponents()) {
            if (!decl.hasComponent()) continue;
            active.add(decl.getComponent());
        }
        return active;
    }

    public Set<CompDecl> lookupCompDecls(String compName) {
        String _parameters = compName;
        if (this.lookupCompDecls_String_visited == null) {
            this.lookupCompDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupCompDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupCompDecls in class: ");
        }
        this.lookupCompDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<CompDecl> lookupCompDecls_String_value = this.lookupCompDecls_compute(compName);
        this.lookupCompDecls_String_visited.remove(_parameters);
        return lookupCompDecls_String_value;
    }

    private Set<CompDecl> lookupCompDecls_compute(String compName) {
        HashSet<CompDecl> comps = new HashSet<CompDecl>();
        for (CompDecl decl : this.getComponents()) {
            if (!decl.getName().equals(compName)) continue;
            comps.add(decl);
        }
        return comps;
    }

    public Set<Embedding> lookupEmbeddings(String embeddingName) {
        String _parameters = embeddingName;
        if (this.lookupEmbeddings_String_visited == null) {
            this.lookupEmbeddings_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupEmbeddings_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupEmbeddings in class: ");
        }
        this.lookupEmbeddings_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<Embedding> lookupEmbeddings_String_value = this.lookupEmbeddings_compute(embeddingName);
        this.lookupEmbeddings_String_visited.remove(_parameters);
        return lookupEmbeddings_String_value;
    }

    private Set<Embedding> lookupEmbeddings_compute(String embeddingName) {
        HashSet<Embedding> embeddings = new HashSet<Embedding>();
        for (BodyElement element : this.getBodyElements()) {
            Embedding embedding;
            if (!(element instanceof Embedding) || !(embedding = (Embedding)element).getName().equals(embeddingName)) continue;
            embeddings.add(embedding);
        }
        return embeddings;
    }

    public java.util.List<Embedding> getEmbeddings() {
        if (this.getEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getEmbeddings in class: ");
        }
        this.getEmbeddings_visited = this.state().boundariesCrossed;
        java.util.List<Embedding> getEmbeddings_value = this.getEmbeddings_compute();
        this.getEmbeddings_visited = -1;
        return getEmbeddings_value;
    }

    private java.util.List<Embedding> getEmbeddings_compute() {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        for (BodyElement element : this.getBodyElements()) {
            if (!(element instanceof Embedding)) continue;
            embeddings.add((Embedding)element);
        }
        return embeddings;
    }

    public Set<Declaration> lookupExternDecls(String text) {
        String _parameters = text;
        if (this.lookupExternDecls_String_visited == null) {
            this.lookupExternDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupExternDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupExternDecls in class: ");
        }
        this.lookupExternDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<Declaration> lookupExternDecls_String_value = this.lookupExternDecls_compute(text);
        this.lookupExternDecls_String_visited.remove(_parameters);
        return lookupExternDecls_String_value;
    }

    private Set<Declaration> lookupExternDecls_compute(String text) {
        HashSet<Declaration> decls = new HashSet<Declaration>();
        for (Declaration decl : this.getDecls()) {
            if (!decl.getText().equals(text)) continue;
            decls.add(decl);
        }
        return decls;
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLocalHeader());
        buf.append("%%");
        buf.append('\n');
        buf.append(this.getInheritedHeader());
        buf.append("%%");
        buf.append('\n');
        buf.append('\n');
        buf.append("%layout " + this.getName());
        buf.append('\n');
        buf.append('\n');
        if (this.getHelper()) {
            buf.append("%helper");
            buf.append('\n');
            buf.append('\n');
        }
        if (this.hasStartComponent()) {
            buf.append("%start " + this.getStartComponent().getName());
            buf.append('\n');
            buf.append('\n');
        }
        if (!this.getComponents().isEmpty()) {
            for (CompDecl comp : this.getComponents()) {
                buf.append("%component " + comp.getName());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getOptions().isEmpty()) {
            for (LexerOption option : this.getOptions()) {
                buf.append("%option " + option.getName() + " " + option.getValue());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getDecls().isEmpty()) {
            for (Declaration decl : this.getDecls()) {
                buf.append("%declare " + decl.getText());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getYylexExceptions().isEmpty()) {
            for (StringSymbol e : this.getYylexExceptions()) {
                buf.append("%lexthrow " + e.getText());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getInitExceptions().isEmpty()) {
            for (StringSymbol e : this.getInitExceptions()) {
                buf.append("%initthrow " + e.getText());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getInitRegions().isEmpty()) {
            for (StringSymbol initRegion : this.getInitRegions()) {
                buf.append(initRegion.getText());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getDeclRegions().isEmpty()) {
            for (StringSymbol declRegion : this.getDeclRegions()) {
                buf.append(declRegion.getText());
                buf.append('\n');
            }
            buf.append('\n');
        }
        if (!this.getBodyElements().isEmpty()) {
            buf.append("%%");
            buf.append('\n');
            buf.append('\n');
            for (BodyElement element : this.getBodyElements()) {
                buf.append(element.getStructureString());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public java.util.List<Embedding> getEmbeddingsWithHost(CompRef host) {
        CompRef _parameters = host;
        if (this.getEmbeddingsWithHost_CompRef_visited == null) {
            this.getEmbeddingsWithHost_CompRef_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.getEmbeddingsWithHost_CompRef_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: getEmbeddingsWithHost in class: ");
        }
        this.getEmbeddingsWithHost_CompRef_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        java.util.List<Embedding> getEmbeddingsWithHost_CompRef_value = this.getEmbeddingsWithHost_compute(host);
        this.getEmbeddingsWithHost_CompRef_visited.remove(_parameters);
        return getEmbeddingsWithHost_CompRef_value;
    }

    private java.util.List<Embedding> getEmbeddingsWithHost_compute(CompRef host) {
        ArrayList embeddings = this.getHostCompMap().get(host.getName());
        return embeddings == null ? new ArrayList() : embeddings;
    }

    public Map<String, java.util.List<Embedding>> getGuestCompMap() {
        if (this.getGuestCompMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getGuestCompMap in class: ");
        }
        this.getGuestCompMap_visited = this.state().boundariesCrossed;
        Map<String, java.util.List<Embedding>> getGuestCompMap_value = this.getGuestCompMap_compute();
        this.getGuestCompMap_visited = -1;
        return getGuestCompMap_value;
    }

    private Map<String, java.util.List<Embedding>> getGuestCompMap_compute() {
        return this.buildGuestCompMap();
    }

    public Map<String, java.util.List<Embedding>> getHostCompMap() {
        if (this.getHostCompMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getHostCompMap in class: ");
        }
        this.getHostCompMap_visited = this.state().boundariesCrossed;
        Map<String, java.util.List<Embedding>> getHostCompMap_value = this.getHostCompMap_compute();
        this.getHostCompMap_visited = -1;
        return getHostCompMap_value;
    }

    private Map<String, java.util.List<Embedding>> getHostCompMap_compute() {
        return this.buildHostCompMap();
    }

    public String getMetaJFlexPackage() {
        if (this.getMetaJFlexPackage_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexPackage in class: ");
        }
        this.getMetaJFlexPackage_visited = this.state().boundariesCrossed;
        String getMetaJFlexPackage_value = this.getMetaJFlexPackage_compute();
        this.getMetaJFlexPackage_visited = -1;
        return getMetaJFlexPackage_value;
    }

    private String getMetaJFlexPackage_compute() {
        String pkg = PackageFind.findPackage(String.valueOf(this.getLocalHeader()) + this.getInheritedHeader());
        return pkg != null ? pkg : "meta." + this.getName();
    }

    public String getJFlexStateClassName() {
        if (this.getJFlexStateClassName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getJFlexStateClassName in class: ");
        }
        this.getJFlexStateClassName_visited = this.state().boundariesCrossed;
        String getJFlexStateClassName_value = this.getJFlexStateClassName_compute();
        this.getJFlexStateClassName_visited = -1;
        return getJFlexStateClassName_value;
    }

    private String getJFlexStateClassName_compute() {
        return "StateClass_" + this.getName();
    }

    public String getJFlexStateObjectName() {
        if (this.getJFlexStateObjectName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getJFlexStateObjectName in class: ");
        }
        this.getJFlexStateObjectName_visited = this.state().boundariesCrossed;
        String getJFlexStateObjectName_value = this.getJFlexStateObjectName_compute();
        this.getJFlexStateObjectName_visited = -1;
        return getJFlexStateObjectName_value;
    }

    private String getJFlexStateObjectName_compute() {
        return "state_" + this.getName();
    }

    public String getMetaLexerClassName() {
        if (this.getMetaLexerClassName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaLexerClassName in class: ");
        }
        this.getMetaLexerClassName_visited = this.state().boundariesCrossed;
        String getMetaLexerClassName_value = this.getMetaLexerClassName_compute();
        this.getMetaLexerClassName_visited = -1;
        return getMetaLexerClassName_value;
    }

    private String getMetaLexerClassName_compute() {
        return "MetaLexerClass_" + this.getName();
    }

    public String getMetaLexerObjectName() {
        if (this.getMetaLexerObjectName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaLexerObjectName in class: ");
        }
        this.getMetaLexerObjectName_visited = this.state().boundariesCrossed;
        String getMetaLexerObjectName_value = this.getMetaLexerObjectName_compute();
        this.getMetaLexerObjectName_visited = -1;
        return getMetaLexerObjectName_value;
    }

    private String getMetaLexerObjectName_compute() {
        return "metalexer_" + this.getName();
    }

    public String getOptionValue(String optionName, String defaultValue) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(optionName);
        _parameters.add(defaultValue);
        if (this.getOptionValue_String_String_visited == null) {
            this.getOptionValue_String_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.getOptionValue_String_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: getOptionValue in class: ");
        }
        this.getOptionValue_String_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        String getOptionValue_String_String_value = this.getOptionValue_compute(optionName, defaultValue);
        this.getOptionValue_String_String_visited.remove(_parameters);
        return getOptionValue_String_String_value;
    }

    private String getOptionValue_compute(String optionName, String defaultValue) {
        for (LexerOption option : this.getOptions()) {
            String raw = option.getValue();
            String unquoted = StringEval.evalString(raw);
            String trimmed = unquoted.trim();
            if (!trimmed.startsWith(optionName)) continue;
            return trimmed.substring(optionName.length()).trim();
        }
        return defaultValue;
    }

    public java.util.List<Embedding> getInitialPureBOFSequence() {
        if (this.getInitialPureBOFSequence_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getInitialPureBOFSequence in class: ");
        }
        this.getInitialPureBOFSequence_visited = this.state().boundariesCrossed;
        java.util.List<Embedding> getInitialPureBOFSequence_value = this.getInitialPureBOFSequence_compute();
        this.getInitialPureBOFSequence_visited = -1;
        return getInitialPureBOFSequence_value;
    }

    private java.util.List<Embedding> getInitialPureBOFSequence_compute() {
        ArrayList<Embedding> sequence = new ArrayList<Embedding>();
        Embedding firstEmbedding = null;
        for (Embedding possible : this.getEmbeddingsWithHost(this.getStartComponent())) {
            if (!possible.hasPureBOFTransition()) continue;
            firstEmbedding = possible;
            break;
        }
        Embedding curr = firstEmbedding;
        while (curr != null) {
            sequence.add(curr);
            curr = curr.getNextByPureBOF();
        }
        return sequence;
    }

    public String[] getSymbolsLegend() {
        if (this.getSymbolsLegend_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getSymbolsLegend in class: ");
        }
        this.getSymbolsLegend_visited = this.state().boundariesCrossed;
        String[] getSymbolsLegend_value = this.getSymbolsLegend_compute();
        this.getSymbolsLegend_visited = -1;
        return getSymbolsLegend_value;
    }

    private String[] getSymbolsLegend_compute() {
        Map<Integer, String> symbolsMap = this.getSymbolsMap();
        String[] legend = new String[symbolsMap.size() + 1];
        legend[0] = "<BOF>";
        for (Map.Entry<Integer, String> entry : symbolsMap.entrySet()) {
            legend[entry.getKey().intValue()] = entry.getValue();
        }
        return legend;
    }

    public String getLexThrowsDecl() {
        if (this.getLexThrowsDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLexThrowsDecl in class: ");
        }
        this.getLexThrowsDecl_visited = this.state().boundariesCrossed;
        String getLexThrowsDecl_value = this.getLexThrowsDecl_compute();
        this.getLexThrowsDecl_visited = -1;
        return getLexThrowsDecl_value;
    }

    private String getLexThrowsDecl_compute() {
        if (this.getYylexExceptions().isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(" throws");
        boolean first = true;
        for (StringSymbol exception : this.getYylexExceptions()) {
            if (!first) {
                buf.append(",");
            }
            buf.append(" " + StringEval.evalString(exception.getText()));
            first = false;
        }
        return buf.toString();
    }

    public String getTokenType() {
        if (this.getTokenType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getTokenType in class: ");
        }
        this.getTokenType_visited = this.state().boundariesCrossed;
        String getTokenType_value = this.getTokenType_compute();
        this.getTokenType_visited = -1;
        return getTokenType_value;
    }

    private String getTokenType_compute() {
        return this.getOptionValue("%type", "Yytoken");
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode caller, ASTNode child, String compName) {
        if (caller == this.getBodyElementListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.lookupCompDecls(compName);
        }
        if (caller == this.getStartComponentOptNoTransform()) {
            return this.lookupCompDecls(compName);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, caller, compName);
    }

    @Override
    public Set<Embedding> Define_java_util_Set_Embedding__lookupEmbeddings(ASTNode caller, ASTNode child, String embeddingName) {
        if (caller == this.getBodyElementListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.lookupEmbeddings(embeddingName);
        }
        return this.getParent().Define_java_util_Set_Embedding__lookupEmbeddings(this, caller, embeddingName);
    }

    @Override
    public Set<Declaration> Define_java_util_Set_Declaration__lookupExternDecls(ASTNode caller, ASTNode child, String text) {
        if (caller == this.getComponentListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.lookupExternDecls(text);
        }
        return this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, caller, text);
    }

    @Override
    public Layout Define_Layout_getLayout(ASTNode caller, ASTNode child) {
        if (caller == this.getBodyElementListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this;
        }
        if (caller == this.getComponentListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this;
        }
        if (caller == this.getStartComponentOptNoTransform()) {
            return this;
        }
        return this.getParent().Define_Layout_getLayout(this, caller);
    }

    @Override
    public java.util.List<Embedding> Define_java_util_List_Embedding__getEmbeddingsWithHost(ASTNode caller, ASTNode child, CompRef host) {
        if (caller == this.getBodyElementListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.getEmbeddingsWithHost(host);
        }
        return this.getParent().Define_java_util_List_Embedding__getEmbeddingsWithHost(this, caller, host);
    }

    @Override
    public int Define_int_getEmbeddingIndex(ASTNode caller, ASTNode child) {
        if (caller == this.getBodyElementListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return i;
        }
        return this.getParent().Define_int_getEmbeddingIndex(this, caller);
    }

    @Override
    public String Define_String_getLexThrowsDecl(ASTNode caller, ASTNode child) {
        if (caller == this.getComponentListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.getLexThrowsDecl();
        }
        return this.getParent().Define_String_getLexThrowsDecl(this, caller);
    }

    @Override
    public String Define_String_getTokenType(ASTNode caller, ASTNode child) {
        if (caller == this.getComponentListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return this.getTokenType();
        }
        return this.getParent().Define_String_getTokenType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public SortedSet<CompilationError> getErrors() {
        if (this.Layout_getErrors_computed) {
            return this.Layout_getErrors_value;
        }
        if (this.Layout_getErrors_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getErrors in class: ");
        }
        this.Layout_getErrors_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_getErrors_value = this.getErrors_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_getErrors_computed = true;
        }
        this.Layout_getErrors_visited = -1;
        return this.Layout_getErrors_value;
    }

    public Set Layout_getErrors_contributors() {
        return this.Layout_getErrors_contributors;
    }

    private SortedSet<CompilationError> getErrors_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof LayoutWrapper)) {
            node = node.getParent();
        }
        LayoutWrapper root = (LayoutWrapper)node;
        root.collect_contributors_Layout_getErrors();
        this.Layout_getErrors_value = new TreeSet<CompilationError>();
        for (ASTNode contributor : this.Layout_getErrors_contributors) {
            contributor.contributeTo_Layout_Layout_getErrors(this.Layout_getErrors_value);
        }
        return this.Layout_getErrors_value;
    }

    public Set<MTokRef> listMetaTokens() {
        if (this.Layout_listMetaTokens_computed) {
            return this.Layout_listMetaTokens_value;
        }
        if (this.Layout_listMetaTokens_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listMetaTokens in class: ");
        }
        this.Layout_listMetaTokens_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_listMetaTokens_value = this.listMetaTokens_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_listMetaTokens_computed = true;
        }
        this.Layout_listMetaTokens_visited = -1;
        return this.Layout_listMetaTokens_value;
    }

    public Set Layout_listMetaTokens_contributors() {
        return this.Layout_listMetaTokens_contributors;
    }

    private Set<MTokRef> listMetaTokens_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof Layout)) {
            node = node.getParent();
        }
        Layout root = node;
        root.collect_contributors_Layout_listMetaTokens();
        this.Layout_listMetaTokens_value = new TreeSet<MTokRef>(mtokRefComparator);
        for (ASTNode contributor : this.Layout_listMetaTokens_contributors) {
            contributor.contributeTo_Layout_Layout_listMetaTokens(this.Layout_listMetaTokens_value);
        }
        return this.Layout_listMetaTokens_value;
    }

    public SortedSet<CompilationWarning> getWarnings() {
        if (this.Layout_getWarnings_computed) {
            return this.Layout_getWarnings_value;
        }
        if (this.Layout_getWarnings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getWarnings in class: ");
        }
        this.Layout_getWarnings_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_getWarnings_value = this.getWarnings_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_getWarnings_computed = true;
        }
        this.Layout_getWarnings_visited = -1;
        return this.Layout_getWarnings_value;
    }

    public Set Layout_getWarnings_contributors() {
        return this.Layout_getWarnings_contributors;
    }

    private SortedSet<CompilationWarning> getWarnings_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof LayoutWrapper)) {
            node = node.getParent();
        }
        LayoutWrapper root = (LayoutWrapper)node;
        root.collect_contributors_Layout_getWarnings();
        this.Layout_getWarnings_value = new TreeSet<CompilationWarning>();
        for (ASTNode contributor : this.Layout_getWarnings_contributors) {
            contributor.contributeTo_Layout_Layout_getWarnings(this.Layout_getWarnings_value);
        }
        return this.Layout_getWarnings_value;
    }

    public java.util.List<CompDecl> getReferencedComponents() {
        if (this.Layout_getReferencedComponents_computed) {
            return this.Layout_getReferencedComponents_value;
        }
        if (this.Layout_getReferencedComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getReferencedComponents in class: ");
        }
        this.Layout_getReferencedComponents_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_getReferencedComponents_value = this.getReferencedComponents_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_getReferencedComponents_computed = true;
        }
        this.Layout_getReferencedComponents_visited = -1;
        return this.Layout_getReferencedComponents_value;
    }

    public Set Layout_getReferencedComponents_contributors() {
        return this.Layout_getReferencedComponents_contributors;
    }

    private java.util.List<CompDecl> getReferencedComponents_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof LayoutWrapper)) {
            node = node.getParent();
        }
        LayoutWrapper root = (LayoutWrapper)node;
        root.collect_contributors_Layout_getReferencedComponents();
        this.Layout_getReferencedComponents_value = new ArrayList<CompDecl>();
        for (ASTNode contributor : this.Layout_getReferencedComponents_contributors) {
            contributor.contributeTo_Layout_Layout_getReferencedComponents(this.Layout_getReferencedComponents_value);
        }
        return this.Layout_getReferencedComponents_value;
    }

    public Set<RegionMetaPattern> listRegions() {
        if (this.Layout_listRegions_computed) {
            return this.Layout_listRegions_value;
        }
        if (this.Layout_listRegions_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listRegions in class: ");
        }
        this.Layout_listRegions_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_listRegions_value = this.listRegions_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_listRegions_computed = true;
        }
        this.Layout_listRegions_visited = -1;
        return this.Layout_listRegions_value;
    }

    public Set Layout_listRegions_contributors() {
        return this.Layout_listRegions_contributors;
    }

    private Set<RegionMetaPattern> listRegions_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof Layout)) {
            node = node.getParent();
        }
        Layout root = node;
        root.collect_contributors_Layout_listRegions();
        this.Layout_listRegions_value = new TreeSet<RegionMetaPattern>(regionComparator);
        for (ASTNode contributor : this.Layout_listRegions_contributors) {
            contributor.contributeTo_Layout_Layout_listRegions(this.Layout_listRegions_value);
        }
        return this.Layout_listRegions_value;
    }

    public Map<Integer, String> getSymbolsMap() {
        if (this.Layout_getSymbolsMap_computed) {
            return this.Layout_getSymbolsMap_value;
        }
        if (this.Layout_getSymbolsMap_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getSymbolsMap in class: ");
        }
        this.Layout_getSymbolsMap_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.Layout_getSymbolsMap_value = this.getSymbolsMap_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.Layout_getSymbolsMap_computed = true;
        }
        this.Layout_getSymbolsMap_visited = -1;
        return this.Layout_getSymbolsMap_value;
    }

    public Set Layout_getSymbolsMap_contributors() {
        return this.Layout_getSymbolsMap_contributors;
    }

    private Map<Integer, String> getSymbolsMap_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof LayoutWrapper)) {
            node = node.getParent();
        }
        LayoutWrapper root = (LayoutWrapper)node;
        root.collect_contributors_Layout_getSymbolsMap();
        this.Layout_getSymbolsMap_value = new HashMap<Integer, String>();
        for (ASTNode contributor : this.Layout_getSymbolsMap_contributors) {
            contributor.contributeTo_Layout_Layout_getSymbolsMap(this.Layout_getSymbolsMap_value);
        }
        return this.Layout_getSymbolsMap_value;
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout ref;
        if (!this.getHelper() && !this.hasStartComponent() && (ref = this) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty() && (ref = this) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Layout_Layout_getErrors(collection);
        if (!this.getHelper() && !this.hasStartComponent()) {
            collection.add(this.makeCompilationError("Layout " + this.getName() + " has no start component."));
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty()) {
            collection.add(this.makeCompilationError("Layout " + this.getName() + " is not using any components."));
        }
    }
}

