/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Layout;
import metalexer.jflex.SymbolAssigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTokRef
extends ASTNode<ASTNode>
implements Cloneable {
    private int symbolValue;
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int listComponentsMissingDecl_visited = -1;
    protected int makeMissingDeclCompilationError_visited = -1;
    protected int getMetaJFlexName_visited = -1;
    protected int getLayout_visited = -1;
    protected int getComponents_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.listComponentsMissingDecl_visited = -1;
        this.makeMissingDeclCompilationError_visited = -1;
        this.getMetaJFlexName_visited = -1;
        this.getLayout_visited = -1;
        this.getComponents_visited = -1;
    }

    @Override
    public MTokRef clone() throws CloneNotSupportedException {
        MTokRef node = (MTokRef)super.clone();
        node.listComponentsMissingDecl_visited = -1;
        node.makeMissingDeclCompilationError_visited = -1;
        node.getMetaJFlexName_visited = -1;
        node.getLayout_visited = -1;
        node.getComponents_visited = -1;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MTokRef copy() {
        try {
            MTokRef node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MTokRef fullCopy() {
        MTokRef res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public int getSymbolValue() {
        return this.symbolValue;
    }

    @Override
    public void assignSymbolsToMetaTokens(SymbolAssigner assigner) {
        this.symbolValue = assigner.assignSymbol(this.getMetaJFlexName());
        super.assignSymbolsToMetaTokens(assigner);
    }

    public MTokRef() {
    }

    public MTokRef(String p0) {
        this.setName(p0);
    }

    public MTokRef(Symbol p0) {
        this.setName(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public List<Component> listComponentsMissingDecl() {
        if (this.listComponentsMissingDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listComponentsMissingDecl in class: ");
        }
        this.listComponentsMissingDecl_visited = this.state().boundariesCrossed;
        List<Component> listComponentsMissingDecl_value = this.listComponentsMissingDecl_compute();
        this.listComponentsMissingDecl_visited = -1;
        return listComponentsMissingDecl_value;
    }

    private List<Component> listComponentsMissingDecl_compute() {
        ArrayList<Component> comps = new ArrayList<Component>();
        for (Component comp : this.getComponents()) {
            if (comp == null || comp.listMetaTokens().contains(this.getName())) continue;
            comps.add(comp);
        }
        return comps;
    }

    public CompilationError makeMissingDeclCompilationError() {
        if (this.makeMissingDeclCompilationError_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: makeMissingDeclCompilationError in class: ");
        }
        this.makeMissingDeclCompilationError_visited = this.state().boundariesCrossed;
        CompilationError makeMissingDeclCompilationError_value = this.makeMissingDeclCompilationError_compute();
        this.makeMissingDeclCompilationError_visited = -1;
        return makeMissingDeclCompilationError_value;
    }

    private CompilationError makeMissingDeclCompilationError_compute() {
        StringBuffer buf = new StringBuffer("MetaToken " + this.getName() + " is not declared in components: ");
        boolean first = true;
        for (Component comp : this.listComponentsMissingDecl()) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append(comp.getName());
        }
        buf.append(".");
        return this.makeCompilationError(buf.toString());
    }

    public String getMetaJFlexName() {
        if (this.getMetaJFlexName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getMetaJFlexName in class: ");
        }
        this.getMetaJFlexName_visited = this.state().boundariesCrossed;
        String getMetaJFlexName_value = this.getMetaJFlexName_compute();
        this.getMetaJFlexName_visited = -1;
        return getMetaJFlexName_value;
    }

    private String getMetaJFlexName_compute() {
        return "t_" + this.getName();
    }

    public Layout getLayout() {
        if (this.getLayout_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getLayout in class: ");
        }
        this.getLayout_visited = this.state().boundariesCrossed;
        Layout getLayout_value = this.getParent().Define_Layout_getLayout(this, null);
        this.getLayout_visited = -1;
        return getLayout_value;
    }

    public List<Component> getComponents() {
        if (this.getComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponents in class: ");
        }
        this.getComponents_visited = this.state().boundariesCrossed;
        List<Component> getComponents_value = this.getParent().Define_java_util_List_Component__getComponents(this, null);
        this.getComponents_visited = -1;
        return getComponents_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout ref;
        if (!this.listComponentsMissingDecl().isEmpty() && (ref = this.getLayout()) != null) {
            ref.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void collect_contributors_Layout_listMetaTokens() {
        Layout ref = this.getLayout();
        if (ref != null) {
            ref.Layout_listMetaTokens_contributors().add(this);
        }
        super.collect_contributors_Layout_listMetaTokens();
    }

    @Override
    protected void collect_contributors_Layout_getSymbolsMap() {
        Layout ref = this.getLayout();
        if (ref != null) {
            ref.Layout_getSymbolsMap_contributors().add(this);
        }
        super.collect_contributors_Layout_getSymbolsMap();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Layout_Layout_getErrors(collection);
        if (!this.listComponentsMissingDecl().isEmpty()) {
            collection.add(this.makeMissingDeclCompilationError());
        }
    }

    @Override
    protected void contributeTo_Layout_Layout_listMetaTokens(Set<MTokRef> collection) {
        super.contributeTo_Layout_Layout_listMetaTokens(collection);
        collection.add(this);
    }

    @Override
    protected void contributeTo_Layout_Layout_getSymbolsMap(Map<Integer, String> collection) {
        super.contributeTo_Layout_Layout_getSymbolsMap(collection);
        collection.putAll((Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(MTokRef.this.symbolValue, MTokRef.this.getName());
            }
        });
    }
}

