/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.ASTNode$State;
import metalexer.ast.Component;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDecl
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected int getConflictingMacros_visited = -1;
    protected int getDependencies_visited;
    protected boolean getDependencies_computed = false;
    protected boolean getDependencies_initialized = false;
    protected Set<MacroDecl> getDependencies_value;
    protected int isRequired_visited = -1;
    protected int isUsed_visited = -1;
    protected int getStructureString_visited = -1;
    protected int getComponent_visited = -1;
    protected Map lookupMacroDecls_String_visited;
    protected int MacroDecl_getDirectDependencies_visited = -1;
    protected boolean MacroDecl_getDirectDependencies_computed = false;
    protected Set<MacroDecl> MacroDecl_getDirectDependencies_value;
    Set MacroDecl_getDirectDependencies_contributors = new ASTNode$State.IdentityHashSet(4);

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingMacros_visited = -1;
        this.getDependencies_visited = 0;
        this.getDependencies_computed = false;
        this.getDependencies_initialized = false;
        this.getDependencies_value = null;
        this.isRequired_visited = -1;
        this.isUsed_visited = -1;
        this.getStructureString_visited = -1;
        this.getComponent_visited = -1;
        this.lookupMacroDecls_String_visited = new HashMap(4);
        this.MacroDecl_getDirectDependencies_visited = -1;
        this.MacroDecl_getDirectDependencies_computed = false;
        this.MacroDecl_getDirectDependencies_value = null;
        this.MacroDecl_getDirectDependencies_contributors = new ASTNode$State.IdentityHashSet(4);
    }

    @Override
    public MacroDecl clone() throws CloneNotSupportedException {
        MacroDecl node = (MacroDecl)super.clone();
        node.getConflictingMacros_visited = -1;
        node.getDependencies_visited = 0;
        node.getDependencies_computed = false;
        node.getDependencies_initialized = false;
        node.getDependencies_value = null;
        node.isRequired_visited = -1;
        node.isUsed_visited = -1;
        node.getStructureString_visited = -1;
        node.getComponent_visited = -1;
        node.lookupMacroDecls_String_visited = new HashMap(4);
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MacroDecl copy() {
        try {
            MacroDecl node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MacroDecl fullCopy() {
        MacroDecl res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getRegex() == null ? 0 : this.getRegex().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacroDecl other = (MacroDecl)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getRegex() == null ? other.getRegex() != null : !this.getRegex().equals(other.getRegex()));
    }

    public MacroDecl() {
    }

    public MacroDecl(String p0, Regex p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    public MacroDecl(Symbol p0, Regex p1) {
        this.setName(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setRegex(Regex node) {
        this.setChild(node, 0);
    }

    public Regex getRegex() {
        return (Regex)this.getChild(0);
    }

    public Regex getRegexNoTransform() {
        return (Regex)this.getChildNoTransform(0);
    }

    public Set<MacroDecl> getConflictingMacros() {
        if (this.getConflictingMacros_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingMacros in class: ");
        }
        this.getConflictingMacros_visited = this.state().boundariesCrossed;
        Set<MacroDecl> getConflictingMacros_value = this.getConflictingMacros_compute();
        this.getConflictingMacros_visited = -1;
        return getConflictingMacros_value;
    }

    private Set<MacroDecl> getConflictingMacros_compute() {
        String name = this.getName();
        Regex regex = this.getRegex();
        Set<MacroDecl> macros = this.lookupMacroDecls(name);
        HashSet<MacroDecl> conflictingMacros = new HashSet<MacroDecl>();
        for (MacroDecl macro : macros) {
            if (!name.equals(macro.getName()) || regex.equals(macro.getRegex())) continue;
            conflictingMacros.add(macro);
        }
        return conflictingMacros;
    }

    public Set<MacroDecl> getDependencies() {
        if (this.getDependencies_computed) {
            return this.getDependencies_value;
        }
        if (!this.getDependencies_initialized) {
            this.getDependencies_initialized = true;
            this.getDependencies_value = this.getDirectDependencies();
        }
        if (!this.state().IN_CIRCLE) {
            this.state().IN_CIRCLE = true;
            int num = this.state().boundariesCrossed;
            boolean isFinal = this.is$Final();
            this.state().CIRCLE_INDEX = 1;
            do {
                this.getDependencies_visited = this.state().CIRCLE_INDEX;
                this.state().CHANGE = false;
                Set<MacroDecl> new_getDependencies_value = this.getDependencies_compute();
                if (new_getDependencies_value == null && this.getDependencies_value != null || new_getDependencies_value != null && !new_getDependencies_value.equals(this.getDependencies_value)) {
                    this.state().CHANGE = true;
                }
                this.getDependencies_value = new_getDependencies_value;
                ++this.state().CIRCLE_INDEX;
            } while (this.state().CHANGE);
            if (isFinal && num == this.state().boundariesCrossed) {
                this.getDependencies_computed = true;
                this.state().LAST_CYCLE = true;
                this.getDependencies_compute();
                this.state().LAST_CYCLE = false;
            } else {
                this.state().RESET_CYCLE = true;
                this.getDependencies_compute();
                this.state().RESET_CYCLE = false;
                this.getDependencies_computed = false;
                this.getDependencies_initialized = false;
            }
            this.state().IN_CIRCLE = false;
            return this.getDependencies_value;
        }
        if (this.getDependencies_visited != this.state().CIRCLE_INDEX) {
            this.getDependencies_visited = this.state().CIRCLE_INDEX;
            if (this.state().LAST_CYCLE) {
                this.getDependencies_computed = true;
                return this.getDependencies_compute();
            }
            if (this.state().RESET_CYCLE) {
                this.getDependencies_computed = false;
                this.getDependencies_initialized = false;
                return this.getDependencies_value;
            }
            Set<MacroDecl> new_getDependencies_value = this.getDependencies_compute();
            if (new_getDependencies_value == null && this.getDependencies_value != null || new_getDependencies_value != null && !new_getDependencies_value.equals(this.getDependencies_value)) {
                this.state().CHANGE = true;
            }
            this.getDependencies_value = new_getDependencies_value;
            return this.getDependencies_value;
        }
        return this.getDependencies_value;
    }

    private Set<MacroDecl> getDependencies_compute() {
        HashSet<MacroDecl> dependencies = new HashSet<MacroDecl>(this.getDependencies());
        for (MacroDecl dep : this.getDependencies()) {
            dependencies.addAll(dep.getDependencies());
        }
        return dependencies;
    }

    public boolean isRequired() {
        if (this.isRequired_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isRequired in class: ");
        }
        this.isRequired_visited = this.state().boundariesCrossed;
        boolean isRequired_value = this.isRequired_compute();
        this.isRequired_visited = -1;
        return isRequired_value;
    }

    private boolean isRequired_compute() {
        return this.getComponent().getRequiredMacros().contains(this);
    }

    public boolean isUsed() {
        if (this.isUsed_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isUsed in class: ");
        }
        this.isUsed_visited = this.state().boundariesCrossed;
        boolean isUsed_value = this.isUsed_compute();
        this.isUsed_visited = -1;
        return isUsed_value;
    }

    private boolean isUsed_compute() {
        String name = this.getName();
        Set<MacroInvocationRegex> macroRefs = this.getComponent().getMacroRefs();
        for (MacroInvocationRegex ref : macroRefs) {
            if (!name.equals(ref.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStructureString() {
        if (this.getStructureString_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getStructureString in class: ");
        }
        this.getStructureString_visited = this.state().boundariesCrossed;
        String getStructureString_value = this.getStructureString_compute();
        this.getStructureString_visited = -1;
        return getStructureString_value;
    }

    private String getStructureString_compute() {
        return String.valueOf(this.getName()) + " = " + this.getRegex().getStructureString();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component getComponent_value = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return getComponent_value;
    }

    public Set<MacroDecl> lookupMacroDecls(String macroName) {
        String _parameters = macroName;
        if (this.lookupMacroDecls_String_visited == null) {
            this.lookupMacroDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupMacroDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupMacroDecls in class: ");
        }
        this.lookupMacroDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<MacroDecl> lookupMacroDecls_String_value = this.getParent().Define_java_util_Set_MacroDecl__lookupMacroDecls(this, null, macroName);
        this.lookupMacroDecls_String_visited.remove(_parameters);
        return lookupMacroDecls_String_value;
    }

    @Override
    public MacroDecl Define_MacroDecl_getContainingMacro(ASTNode caller, ASTNode child) {
        if (caller == this.getRegexNoTransform()) {
            return this;
        }
        return this.getParent().Define_MacroDecl_getContainingMacro(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public Set<MacroDecl> getDirectDependencies() {
        if (this.MacroDecl_getDirectDependencies_computed) {
            return this.MacroDecl_getDirectDependencies_value;
        }
        if (this.MacroDecl_getDirectDependencies_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getDirectDependencies in class: ");
        }
        this.MacroDecl_getDirectDependencies_visited = this.state().boundariesCrossed;
        int num = this.state().boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.MacroDecl_getDirectDependencies_value = this.getDirectDependencies_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.MacroDecl_getDirectDependencies_computed = true;
        }
        this.MacroDecl_getDirectDependencies_visited = -1;
        return this.MacroDecl_getDirectDependencies_value;
    }

    public Set MacroDecl_getDirectDependencies_contributors() {
        return this.MacroDecl_getDirectDependencies_contributors;
    }

    private Set<MacroDecl> getDirectDependencies_compute() {
        ASTNode node = this;
        while (node.getParent() != null && !(node instanceof Component)) {
            node = node.getParent();
        }
        Component root = (Component)node;
        root.collect_contributors_MacroDecl_getDirectDependencies();
        this.MacroDecl_getDirectDependencies_value = new HashSet<MacroDecl>();
        for (ASTNode contributor : this.MacroDecl_getDirectDependencies_contributors) {
            contributor.contributeTo_MacroDecl_MacroDecl_getDirectDependencies(this.MacroDecl_getDirectDependencies_value);
        }
        return this.MacroDecl_getDirectDependencies_value;
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (this.getDependencies().contains(this) && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_getWarnings() {
        Component ref;
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed() && (ref = this.getComponent()) != null) {
            ref.Component_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Component_getWarnings();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (this.getDependencies().contains(this)) {
            collection.add(this.makeCompilationError("Macro " + this.getName() + " depends (possibly indirectly) on itself."));
        }
    }

    @Override
    protected void contributeTo_Component_Component_getWarnings(SortedSet<CompilationWarning> collection) {
        super.contributeTo_Component_Component_getWarnings(collection);
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed()) {
            collection.add(this.makeCompilationWarning("Macro " + this.getName() + " is unused."));
        }
    }
}

