/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.CompilationWarning;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.StateRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean tokenboolean_Exclusive;
    protected int getConflictingStates_visited = -1;
    protected int isUsed_visited = -1;
    protected int getComponent_visited = -1;
    protected Map lookupStateDecls_String_visited;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getConflictingStates_visited = -1;
        this.isUsed_visited = -1;
        this.getComponent_visited = -1;
        this.lookupStateDecls_String_visited = new HashMap(4);
    }

    @Override
    public State clone() throws CloneNotSupportedException {
        State node = (State)super.clone();
        node.getConflictingStates_visited = -1;
        node.isUsed_visited = -1;
        node.getComponent_visited = -1;
        node.lookupStateDecls_String_visited = new HashMap(4);
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public State copy() {
        try {
            State node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public State fullCopy() {
        State res = this.copy();
        int i = 0;
        while (i < this.getNumChildNoTransform()) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public State() {
    }

    public State(String p0, boolean p1) {
        this.setName(p0);
        this.setExclusive(p1);
    }

    public State(Symbol p0, boolean p1) {
        this.setName(p0);
        this.setExclusive(p1);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String value) {
        this.tokenString_Name = value;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setExclusive(boolean value) {
        this.tokenboolean_Exclusive = value;
    }

    public boolean getExclusive() {
        return this.tokenboolean_Exclusive;
    }

    public Set<State> getConflictingStates() {
        if (this.getConflictingStates_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getConflictingStates in class: ");
        }
        this.getConflictingStates_visited = this.state().boundariesCrossed;
        Set<State> getConflictingStates_value = this.getConflictingStates_compute();
        this.getConflictingStates_visited = -1;
        return getConflictingStates_value;
    }

    private Set<State> getConflictingStates_compute() {
        String name = this.getName();
        boolean exclusive = this.getExclusive();
        Set<State> states = this.lookupStateDecls(name);
        HashSet<State> conflictingStates = new HashSet<State>();
        for (State state : states) {
            if (!name.equals(state.getName()) || exclusive == state.getExclusive()) continue;
            conflictingStates.add(state);
        }
        return conflictingStates;
    }

    public boolean isUsed() {
        if (this.isUsed_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isUsed in class: ");
        }
        this.isUsed_visited = this.state().boundariesCrossed;
        boolean isUsed_value = this.isUsed_compute();
        this.isUsed_visited = -1;
        return isUsed_value;
    }

    private boolean isUsed_compute() {
        String name = this.getName();
        if (name.equals("YYINITIAL")) {
            return true;
        }
        Set<StateRef> stateRefs = this.getComponent().getStateRefs();
        for (StateRef ref : stateRefs) {
            if (!name.equals(ref.getName())) continue;
            return true;
        }
        return false;
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component getComponent_value = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return getComponent_value;
    }

    public Set<State> lookupStateDecls(String stateName) {
        String _parameters = stateName;
        if (this.lookupStateDecls_String_visited == null) {
            this.lookupStateDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupStateDecls_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attr: lookupStateDecls in class: ");
        }
        this.lookupStateDecls_String_visited.put(_parameters, new Integer(this.state().boundariesCrossed));
        Set<State> lookupStateDecls_String_value = this.getParent().Define_java_util_Set_State__lookupStateDecls(this, null, stateName);
        this.lookupStateDecls_String_visited.remove(_parameters);
        return lookupStateDecls_String_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component ref;
        if (!this.getConflictingStates().isEmpty() && (ref = this.getComponent()) != null) {
            ref.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_getWarnings() {
        Component ref;
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed() && (ref = this.getComponent()) != null) {
            ref.Component_getWarnings_contributors().add(this);
        }
        super.collect_contributors_Component_getWarnings();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> collection) {
        super.contributeTo_Component_Component_getErrors(collection);
        if (!this.getConflictingStates().isEmpty()) {
            collection.add(this.makeCompilationError("State " + this.getName() + " is declared as both inclusive and exclusive."));
        }
    }

    @Override
    protected void contributeTo_Component_Component_getWarnings(SortedSet<CompilationWarning> collection) {
        super.contributeTo_Component_Component_getWarnings(collection);
        if (!this.getComponent().getHelper() && this.getComponent().getFilename().equals(this.getFilename()) && !this.isUsed()) {
            collection.add(this.makeCompilationWarning("State " + this.getName() + " is unused."));
        }
    }
}

