/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import metalexer.jflex.MetaScannerPropHelper;
import metalexer.jflex.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMetaScannerTestTool {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: java metalexer.jflex.ComponentScannerTestTool {groupName} {layoutName} {basename}");
            System.exit(1);
        }
        String groupName = args[0];
        String layoutName = args[1];
        String baseName = args[2];
        MetaScannerPropHelper propHelper = new MetaScannerPropHelper(groupName, layoutName);
        String inFileName = String.valueOf(baseName) + ".in";
        String outFileName = String.valueOf(baseName) + ".out";
        ArrayList<Integer> input = new ArrayList<Integer>();
        BufferedReader inReader = new BufferedReader(new FileReader(inFileName));
        while (inReader.ready()) {
            String line = inReader.readLine();
            input.add(propHelper.getMacroValue(line));
        }
        inReader.close();
        List<List<Integer>> actualOutput = ComponentMetaScannerTestTool.getActualOutput(input);
        PrintWriter outWriter = new PrintWriter(new FileWriter(outFileName));
        for (List<Integer> line : actualOutput) {
            boolean first = true;
            for (Integer val : line) {
                if (!first) {
                    outWriter.print(" ");
                }
                outWriter.print(propHelper.getEmbeddingName(val));
                first = false;
            }
            outWriter.println();
        }
        outWriter.close();
    }

    public static List<List<Integer>> getActualOutput(List<Integer> input) {
        ReflectionHelper.MetaLexerWrapper metalexer = new ReflectionHelper.MetaLexerWrapper("test.jflex.metalexer.ComponentScanner$MetaLexerClass_component");
        ArrayList<List<Integer>> actualOutput = new ArrayList<List<Integer>>();
        for (int sym : input) {
            Integer transition = metalexer.processSymbol(sym);
            ArrayList<Integer> line = new ArrayList<Integer>();
            if (transition != null) {
                line.add(transition);
            }
            actualOutput.add(line);
        }
        return actualOutput;
    }
}

