/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class JFlexHelper {
    private static final String PROP_FILE = "common.properties";
    private static final String LIB_DIR_PROP_NAME = "lib.dir";
    private static final String JAR_PROP_NAME = "jflex.jar.path.prop";
    private final Class<?> silentExitClass;
    private final Method genMethod;
    private final boolean jflexAvailable;

    public JFlexHelper() {
        Class<?> silentExitClass = null;
        Method genMethod = null;
        boolean jflexAvailable = false;
        try {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(PROP_FILE));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load properties file common.properties", e);
            }
            String libDir = properties.getProperty(LIB_DIR_PROP_NAME);
            if (libDir == null) {
                throw new RuntimeException("Failed to load property lib.dir");
            }
            String jarFile = properties.getProperty(JAR_PROP_NAME);
            if (jarFile == null) {
                throw new RuntimeException("Failed to load property jflex.jar.path.prop");
            }
            jarFile = String.valueOf(libDir) + "/" + jarFile;
            URL jarURL = null;
            try {
                jarURL = new URL("file:" + jarFile);
                URLClassLoader loader = new URLClassLoader(new URL[]{jarURL});
                silentExitClass = Class.forName("JFlex.SilentExit", true, loader);
                Class<?> mainClass = Class.forName("JFlex.Main", true, loader);
                genMethod = mainClass.getMethod("generate", String[].class);
                jflexAvailable = true;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Jar path is incorrect: " + jarURL, e);
            }
            catch (Exception exception) {
            }
        }
        finally {
            this.silentExitClass = silentExitClass;
            this.genMethod = genMethod;
            this.jflexAvailable = jflexAvailable;
        }
    }

    public boolean isJFlexAvailable() {
        return this.jflexAvailable;
    }

    public void generate(String file, String destDir) {
        if (!this.jflexAvailable) {
            throw new IllegalStateException("Can't generate when jflex is not available");
        }
        try {
            this.genMethod.invoke(null, new Object[]{new String[]{"-d", destDir, "--nobak", "-v", file}});
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (!this.silentExitClass.isInstance(targetException)) {
                throw new RuntimeException(targetException);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

