/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.FileLoader;
import metalexer.ProblemUtil;
import metalexer.ScannerUtil;
import metalexer.ast.Layout;

public class LayoutErrorTestTool {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.LayoutErrorTestTool {basename}");
            System.exit(1);
        }
        String basename = args[0];
        try {
            FileLoader loader = new FileLoader("test/backend-jflex");
            TreeSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();
            Layout actual = loader.loadLayout(basename, problems);
            assert (actual.subtreeNodesHaveCorrectParents());
            actual = actual.processInheritance(loader, problems);
            assert (actual.subtreeNodesHaveCorrectParents());
            PrintWriter out = new PrintWriter(new FileWriter("test/backend-jflex/" + basename + ".out"));
            for (CompilationError error : ProblemUtil.extractErrors(problems)) {
                out.println(ScannerUtil.stringifyValue(error));
            }
            out.close();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

