/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import junit.framework.TestCase;
import metalexer.jflex.PackageFind;

public class PackageFindTests
extends TestCase {
    public void testSingleLineComments() {
        PackageFindTests.checkPackage("//package x;", null);
        PackageFindTests.checkPackage("package x;\n//package y;", "x");
        PackageFindTests.checkPackage("//package x;\npackage y;", "y");
        PackageFindTests.checkPackage("package x;\n//package y;\npackage z;", "z");
    }

    public void testMultiLineComments() {
        PackageFindTests.checkPackage("/*package x;*/", null);
        PackageFindTests.checkPackage("package x;\n/*package y;*/", "x");
        PackageFindTests.checkPackage("/*package x;*/\npackage y;", "y");
        PackageFindTests.checkPackage("package x;\n/*package y;*/\npackage z;", "z");
    }

    public void testNestedComments() {
        PackageFindTests.checkPackage("/*package x; /*package y;*/*/", null);
        PackageFindTests.checkPackage("/*/*package x;*/ package y;*/", null);
        PackageFindTests.checkPackage("/*/*package x;*/*/ package y;", "y");
    }

    public void testStrings() {
        PackageFindTests.checkPackage("\"package x;\"", null);
        PackageFindTests.checkPackage("package x;\n\"package y;\"", "x");
        PackageFindTests.checkPackage("\"package x;\"\npackage y;", "y");
        PackageFindTests.checkPackage("package x;\n\"package y;\"\npackage z;", "z");
    }

    public void testStringsWithEscapes() {
        PackageFindTests.checkPackage("\"package \\\"x\\\";\"", null);
    }

    public void testEmptyPackage() {
        PackageFindTests.checkPackage("package;", null);
    }

    public void testMalformed() {
        PackageFindTests.checkPackage("package x", "x");
        PackageFindTests.checkPackage("package", null);
        PackageFindTests.checkPackage("package ", null);
        PackageFindTests.checkPackage("/*package", null);
        PackageFindTests.checkPackage("/*/*package*/", null);
        PackageFindTests.checkPackage("/*/*package", null);
        PackageFindTests.checkPackage("//package x", null);
        PackageFindTests.checkPackage("/package x", "x");
        PackageFindTests.checkPackage("asdjf;ilai package x; ahdfkd; fas", "x");
        PackageFindTests.checkPackage("\"package x\\\";\"", null);
        PackageFindTests.checkPackage("\"package x", null);
    }

    public void testIdentifier() {
        PackageFindTests.checkPackage("package1 x;", null);
    }

    public void testCommentInPackage() {
        PackageFindTests.checkPackage("package x//\n;", "x");
        PackageFindTests.checkPackage("package /* */ x\n;", "x");
        PackageFindTests.checkPackage("package x//;\n;", "x");
        PackageFindTests.checkPackage("package x/*;*/\n;", "x");
        PackageFindTests.checkPackage("package//\n x\n;", "x");
        PackageFindTests.checkPackage("package/* */ x\n;", "x");
    }

    private static void checkPackage(String original, String expected) {
        PackageFindTests.assertEquals((String)"Package: ", (String)expected, (String)PackageFind.findPackage(original));
    }
}

