/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex;

import java.util.List;
import junit.framework.TestCase;
import metalexer.jflex.StaticFind;

public class StaticFindTests
extends TestCase {
    public void testSingleLineComments() {
        StaticFindTests.checkStatic("//static x;", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("static x;\n//static y;", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("//static x;\nstatic y;", 1, 1, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("static x;\n//static y;\nstatic z;", 1, 1, new int[][]{{1, 1}, {3, 1}});
    }

    public void testMultiLineComments() {
        StaticFindTests.checkStatic("/*static x;*/", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("static x;\n/*static y;*/", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("/*static x;*/\nstatic y;", 1, 1, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("static x;\n/*static y;*/\nstatic z;", 1, 1, new int[][]{{1, 1}, {3, 1}});
    }

    public void testNestedComments() {
        StaticFindTests.checkStatic("/*static x; /*static y;*/*/", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("/*/*static x;*/ static y;*/", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("/*/*static x;*/*/ static y;", 1, 1, new int[][]{{1, 19}});
    }

    public void testStrings() {
        StaticFindTests.checkStatic("\"static x;\"", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("static x;\n\"static y;\"", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("\"static x;\"\nstatic y;", 1, 1, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("static x;\n\"static y;\"\nstatic z;", 1, 1, new int[][]{{1, 1}, {3, 1}});
    }

    public void testStringsWithEscapes() {
        StaticFindTests.checkStatic("\"static \\\"x\\\";\"", 1, 1, new int[0][]);
    }

    public void testMalformed() {
        StaticFindTests.checkStatic("static x", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("static", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("static ", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("/*static", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("/*/*static*/", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("/*/*static", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("//static x", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("/static x", 1, 1, new int[][]{{1, 2}});
        StaticFindTests.checkStatic("asdjf;ilai static x; ahdfkd; fas", 1, 1, new int[][]{{1, 12}});
        StaticFindTests.checkStatic("\"static x\\\";\"", 1, 1, new int[0][]);
        StaticFindTests.checkStatic("\"static x", 1, 1, new int[0][]);
    }

    public void testIdentifier() {
        StaticFindTests.checkStatic("static1 x;", 1, 1, new int[0][]);
    }

    public void testBasePos() {
        StaticFindTests.checkStatic("static", 1, 1, new int[][]{{1, 1}});
        StaticFindTests.checkStatic("+static", 1, 1, new int[][]{{1, 2}});
        StaticFindTests.checkStatic("+\nstatic", 1, 1, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("+\n+static", 1, 1, new int[][]{{2, 2}});
        StaticFindTests.checkStatic("static", 1, 2, new int[][]{{1, 2}});
        StaticFindTests.checkStatic("+static", 1, 2, new int[][]{{1, 3}});
        StaticFindTests.checkStatic("+\nstatic", 1, 2, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("+\n+static", 1, 2, new int[][]{{2, 2}});
        StaticFindTests.checkStatic("static", 2, 1, new int[][]{{2, 1}});
        StaticFindTests.checkStatic("+static", 2, 1, new int[][]{{2, 2}});
        StaticFindTests.checkStatic("+\nstatic", 2, 1, new int[][]{{3, 1}});
        StaticFindTests.checkStatic("+\n+static", 2, 1, new int[][]{{3, 2}});
    }

    private static void checkStatic(String original, int baseLine, int baseCol, int[][] expected) {
        List<StaticFind.Position> actualList = StaticFind.findStaticKeywords(baseLine, baseCol, original);
        StaticFindTests.assertEquals((String)"Number of keywords", (int)expected.length, (int)actualList.size());
        int i = 0;
        while (i < actualList.size()) {
            StaticFind.Position pos = actualList.get(i);
            StaticFindTests.assertEquals((String)("Static keyword #" + (i + 1) + " (line)"), (int)expected[i][0], (int)pos.getLine());
            StaticFindTests.assertEquals((String)("Static keyword #" + (i + 1) + " (column)"), (int)expected[i][1], (int)pos.getColumn());
            ++i;
        }
    }
}

