/*
 * Decompiled with CFR 0.152.
 */
package metalexer.jflex.fsm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class DFA {
    private final int numStates;
    private final int numSymbols;
    private final Integer[][] transitions;
    private final Integer[] actions;

    public DFA(Integer[][] transitions, Integer[] actions) {
        this.numStates = transitions.length;
        this.numSymbols = transitions[0].length;
        this.transitions = transitions;
        this.actions = actions;
    }

    public DFA minimize() {
        boolean[][] areDistinct = this.findDistinct();
        int[] stateMap = this.buildStateMap(areDistinct);
        HashMap<Integer, Integer[]> transitionMap = new HashMap<Integer, Integer[]>();
        HashMap<Integer, Integer> actionMap = new HashMap<Integer, Integer>();
        Integer minimalStartState = stateMap[0];
        LinkedList<Integer> workList = new LinkedList<Integer>();
        workList.add(minimalStartState);
        ArrayList<Integer> minimalStateList = new ArrayList<Integer>();
        while (!workList.isEmpty()) {
            Integer state = (Integer)workList.poll();
            if (transitionMap.containsKey(state)) continue;
            Integer[] row = new Integer[this.numSymbols];
            int sym = 0;
            while (sym < this.numSymbols) {
                Integer dest;
                row[sym] = dest = Integer.valueOf(stateMap[this.transitions[state][sym]]);
                workList.add(dest);
                ++sym;
            }
            transitionMap.put(state, row);
            actionMap.put(state, this.actions[stateMap[state]]);
            minimalStateList.add(state);
        }
        int minimalNumStates = minimalStateList.size();
        Integer[][] minimalTransitions = new Integer[minimalNumStates][this.numSymbols];
        Integer[] minimalActions = new Integer[minimalNumStates];
        HashMap<Integer, Integer> minimalStateNumMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < minimalNumStates) {
            minimalStateNumMap.put((Integer)minimalStateList.get(i), i);
            ++i;
        }
        i = 0;
        while (i < minimalNumStates) {
            Integer minimalState = (Integer)minimalStateList.get(i);
            Integer[] row = (Integer[])transitionMap.get(minimalState);
            Integer[] destinations = new Integer[this.numSymbols];
            int j = 0;
            while (j < this.numSymbols) {
                destinations[j] = (Integer)minimalStateNumMap.get(row[j]);
                ++j;
            }
            minimalTransitions[i] = destinations;
            minimalActions[i] = (Integer)actionMap.get(minimalState);
            ++i;
        }
        return new DFA(minimalTransitions, minimalActions);
    }

    private boolean[][] findDistinct() {
        boolean changed;
        boolean[][] areDistinct = new boolean[this.numStates][];
        int i = 0;
        while (i < this.numStates) {
            areDistinct[i] = new boolean[i];
            int j = 0;
            while (j < i) {
                areDistinct[i][j] = !DFA.equals(this.actions[i], this.actions[j]);
                ++j;
            }
            ++i;
        }
        do {
            changed = false;
            int i2 = 0;
            while (i2 < this.numStates) {
                int j = 0;
                while (j < i2) {
                    if (!areDistinct[i2][j]) {
                        int sym = 0;
                        while (sym < this.numSymbols) {
                            int dest2;
                            int dest1 = this.transitions[i2][sym];
                            if (dest1 != (dest2 = this.transitions[j][sym].intValue())) {
                                if (dest1 < dest2) {
                                    int tmp = dest1;
                                    dest1 = dest2;
                                    dest2 = tmp;
                                }
                                if (areDistinct[dest1][dest2]) {
                                    areDistinct[i2][j] = true;
                                    changed = true;
                                }
                            }
                            ++sym;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        } while (changed);
        return areDistinct;
    }

    private int[] buildStateMap(boolean[][] areDistinct) {
        int[] stateMap = new int[this.numStates];
        int i = 0;
        while (i < this.numStates) {
            stateMap[i] = i;
            int j = 0;
            while (j < i) {
                if (!areDistinct[i][j]) {
                    stateMap[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return stateMap;
    }

    public DFA moveAcceptingToEnd() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IndexActionPair
        implements Comparable<IndexActionPair> {
            int index;
            Integer action;

            IndexActionPair() {
            }

            @Override
            public int compareTo(IndexActionPair o) {
                if (this.index == 0) {
                    return -1;
                }
                if (o.index == 0) {
                    return 1;
                }
                if (this.action == null) {
                    return o.action == null ? 0 : -1;
                }
                return o.action == null ? 1 : 0;
            }
        }
        Object[] array = new IndexActionPair[this.numStates];
        int i = 0;
        while (i < this.numStates) {
            array[i] = new IndexActionPair();
            ((IndexActionPair)array[i]).index = i;
            ((IndexActionPair)array[i]).action = this.actions[i];
            ++i;
        }
        Arrays.sort(array);
        Integer[][] newTransitions = new Integer[this.numStates][this.numSymbols];
        Integer[] newActions = new Integer[this.numStates];
        int state = 0;
        while (state < this.numStates) {
            newActions[state] = ((IndexActionPair)array[state]).action;
            int sym = 0;
            while (sym < this.numSymbols) {
                newTransitions[state][sym] = ((IndexActionPair)array[this.transitions[state][sym].intValue()]).index;
                ++sym;
            }
            ++state;
        }
        return new DFA(newTransitions, newActions);
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getNumSymbols() {
        return this.numSymbols;
    }

    public Integer[][] getTransitions() {
        return this.transitions;
    }

    public Integer[] getActions() {
        return this.actions;
    }

    private static boolean equals(Integer i1, Integer i2) {
        if (i1 == null || i2 == null) {
            return i1 == i2;
        }
        return i1.equals(i2);
    }

    public void dump() {
        System.out.println("DFA");
        System.out.println("Transitions:");
        int state = 0;
        while (state < this.numStates) {
            int symbol = 0;
            while (symbol < this.numSymbols) {
                System.out.print(this.transitions[state][symbol] + "\t");
                ++symbol;
            }
            System.out.println();
            ++state;
        }
        System.out.println();
        System.out.println("Actions:");
        state = 0;
        while (state < this.numStates) {
            System.out.println(this.actions[state]);
            ++state;
        }
    }
}

