/*
 * Decompiled with CFR 0.152.
 */
package metalexer.metalexer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import junit.framework.TestCase;
import metalexer.metalexer.ML2ML;

public class PrettyPrinterIdentityTests
extends TestCase {
    private static final String TEST_DIR = "test/backend-metalexer/";
    private static final String IN_DIR = "test/backend-metalexer/in/";
    private static final String OUT1_DIR = "test/backend-metalexer/out1/";
    private static final String OUT2_DIR = "test/backend-metalexer/out2/";
    private static final FilenameFilter METALEXER_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".mll") || name.endsWith(".mlc");
        }
    };

    public void test_metalexer_component() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("metalexer", "component");
    }

    public void test_metalexer_layout() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("metalexer", "layout");
    }

    public void test_natlab_natlab() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("natlab", "natlab");
    }

    public void test_natlab_annotations() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("natlab", "annotations");
    }

    public void test_natlab_annotated_natlab() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("natlab", "annotated_natlab");
    }

    public void test_natlab_attributed_natlab() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("natlab", "attributed_natlab");
    }

    public void test_natlab_naive_natlab() throws Exception {
        PrettyPrinterIdentityTests.checkLayout("natlab-naive", "natlab");
    }

    private static void checkLayout(String dirName, String layoutName) throws IOException {
        ML2ML.main(new String[]{layoutName, IN_DIR + dirName, OUT1_DIR + dirName + "/" + layoutName});
        ML2ML.main(new String[]{layoutName, OUT1_DIR + dirName + "/" + layoutName, OUT2_DIR + dirName + "/" + layoutName});
        PrettyPrinterIdentityTests.assertBitwiseEquals(OUT1_DIR + dirName + "/" + layoutName, OUT2_DIR + dirName + "/" + layoutName);
    }

    private static void assertBitwiseEquals(String out1DirName, String out2DirName) throws IOException {
        File[] out1Files = new File(out1DirName).listFiles(METALEXER_FILE_FILTER);
        PrettyPrinterIdentityTests.assertNotNull((String)"Files in out1", (Object)out1Files);
        File[] out2Files = new File(out2DirName).listFiles(METALEXER_FILE_FILTER);
        PrettyPrinterIdentityTests.assertNotNull((String)"Files in out2", (Object)out2Files);
        PrettyPrinterIdentityTests.assertEquals((String)"Number of files", (int)out1Files.length, (int)out2Files.length);
        int i = 0;
        while (i < out1Files.length) {
            PrettyPrinterIdentityTests.assertEquals((String)"File names", (String)out1Files[i].getName(), (String)out2Files[i].getName());
            PrettyPrinterIdentityTests.assertBitwiseEquals(out1Files[i], out2Files[i]);
            ++i;
        }
    }

    private static void assertBitwiseEquals(File file1, File file2) throws IOException {
        int ch1;
        BufferedReader in1 = new BufferedReader(new FileReader(file1));
        BufferedReader in2 = new BufferedReader(new FileReader(file2));
        do {
            ch1 = in1.read();
            int ch2 = in2.read();
            PrettyPrinterIdentityTests.assertEquals((String)file1.getName(), (int)ch1, (int)ch2);
        } while (ch1 >= 0);
    }
}

