/*
 * Decompiled with CFR 0.152.
 */
package pi;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import pi.JFlexBadPiScanner;
import pi.JFlexGoodPiScanner;
import pi.MLBadPiScanner;
import pi.MLBadPiScanner_Tweaked;
import pi.MLGoodPiScanner;
import pi.MLNBadPiScanner;
import pi.MLNGoodPiScanner;
import pi.PiScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String PI_FILE = "/Users/amcasey/Misc/Pi/pi1M.txt";

    public static void main(String[] args) {
        System.out.println("JFlex - Good:  " + Main.getFreqs(JFlexGoodPiScanner.class, PI_FILE));
        System.out.println("JFlex - Bad :  " + Main.getFreqs(JFlexBadPiScanner.class, PI_FILE));
        System.out.println("ML - Good   :  " + Main.getFreqs(MLGoodPiScanner.class, PI_FILE));
        System.out.println("ML - Bad    :  " + Main.getFreqs(MLBadPiScanner.class, PI_FILE));
        System.out.println("ML - Bad Tw :  " + Main.getFreqs(MLBadPiScanner_Tweaked.class, PI_FILE));
        System.out.println("MLN - Good  :  " + Main.getFreqs(MLNGoodPiScanner.class, PI_FILE));
        System.out.println("MLN - Bad   :  " + Main.getFreqs(MLNBadPiScanner.class, PI_FILE));
    }

    private static Result getFreqs(Class<? extends PiScanner> clazz, String fileName) {
        try {
            return Main.getFreqs(clazz, new BufferedReader(new FileReader(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Result getFreqs(Class<? extends PiScanner> clazz, Reader reader) {
        try {
            Constructor<? extends PiScanner> ctor = clazz.getConstructor(Reader.class);
            PiScanner scanner = ctor.newInstance(reader);
            long startTime = System.currentTimeMillis();
            int[] freqs = scanner.getFreqs();
            scanner.stop();
            long endTime = System.currentTimeMillis();
            Result result = new Result(freqs, startTime, endTime);
            reader.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void print(int[] array) {
        Main.print(array, new PrintWriter(System.out));
    }

    private static void print(int[] array, PrintWriter writer) {
        writer.print("[");
        boolean first = true;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!first) {
                writer.print(", ");
            }
            writer.print(n3);
            first = false;
            ++n2;
        }
        writer.print("]");
        writer.flush();
    }

    private static class Result {
        final int[] freqs;
        long time;

        public Result(int[] freqs, long startTime, long endTime) {
            this.freqs = freqs;
            this.time = endTime - startTime;
        }

        public String toString() {
            StringWriter strWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(strWriter);
            writer.print(String.valueOf(this.time) + ":\t");
            Main.print(this.freqs, writer);
            return strWriter.toString();
        }
    }
}

