/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import metalexer.CompilationError;
import metalexer.PatternType;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.Pattern;
import metalexer.metalexer.EscapeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends ASTNode<ASTNode>
implements Cloneable {
    protected String tokenString_Action;
    public int Actionstart;
    public int Actionend;
    protected String tokenString_MetaToken;
    public int MetaTokenstart;
    public int MetaTokenend;
    protected int isMisclassified_visited = -1;
    protected int getComponent_visited = -1;
    protected int getGroupPatternType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.isMisclassified_visited = -1;
        this.getComponent_visited = -1;
        this.getGroupPatternType_visited = -1;
    }

    @Override
    public Rule clone() throws CloneNotSupportedException {
        Rule rule = (Rule)super.clone();
        rule.isMisclassified_visited = -1;
        rule.getComponent_visited = -1;
        rule.getGroupPatternType_visited = -1;
        rule.in$Circle(false);
        rule.is$Final(false);
        return rule;
    }

    public Rule copy() {
        try {
            Rule rule = this.clone();
            if (this.children != null) {
                rule.children = (ASTNode[])this.children.clone();
            }
            return rule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Rule fullCopy() {
        Rule rule = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            rule.setChild(object, i);
        }
        return rule;
    }

    void generateMetaLexer(PrintWriter printWriter) throws IOException {
        this.getPattern().generateMetaLexer(printWriter);
        printWriter.println(" " + EscapeHelper.escapeAction(this.getAction()) + " " + this.getMetaToken());
    }

    public Rule() {
    }

    public Rule(Pattern pattern, String string, String string2) {
        this.setChild(pattern, 0);
        this.setAction(string);
        this.setMetaToken(string2);
    }

    public Rule(Pattern pattern, Symbol symbol, Symbol symbol2) {
        this.setChild(pattern, 0);
        this.setAction(symbol);
        this.setMetaToken(symbol2);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPattern(Pattern pattern) {
        this.setChild(pattern, 0);
    }

    public Pattern getPattern() {
        return (Pattern)this.getChild(0);
    }

    public Pattern getPatternNoTransform() {
        return (Pattern)this.getChildNoTransform(0);
    }

    public void setAction(String string) {
        this.tokenString_Action = string;
    }

    public void setAction(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setAction is only valid for String lexemes");
        }
        this.tokenString_Action = (String)symbol.value;
        this.Actionstart = symbol.getStart();
        this.Actionend = symbol.getEnd();
    }

    public String getAction() {
        return this.tokenString_Action != null ? this.tokenString_Action : "";
    }

    public void setMetaToken(String string) {
        this.tokenString_MetaToken = string;
    }

    public void setMetaToken(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setMetaToken is only valid for String lexemes");
        }
        this.tokenString_MetaToken = (String)symbol.value;
        this.MetaTokenstart = symbol.getStart();
        this.MetaTokenend = symbol.getEnd();
    }

    public String getMetaToken() {
        return this.tokenString_MetaToken != null ? this.tokenString_MetaToken : "";
    }

    public boolean isMisclassified() {
        if (this.isMisclassified_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: isMisclassified in class: ");
        }
        this.isMisclassified_visited = this.state().boundariesCrossed;
        boolean bl = this.isMisclassified_compute();
        this.isMisclassified_visited = -1;
        return bl;
    }

    private boolean isMisclassified_compute() {
        return this.getPattern().getType() != this.getGroupPatternType();
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component component = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return component;
    }

    public PatternType getGroupPatternType() {
        if (this.getGroupPatternType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getGroupPatternType in class: ");
        }
        this.getGroupPatternType_visited = this.state().boundariesCrossed;
        PatternType patternType = this.getParent().Define_metalexer_PatternType_getGroupPatternType(this, null);
        this.getGroupPatternType_visited = -1;
        return patternType;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_Component_getErrors() {
        Component component;
        if (this.isMisclassified() && (component = this.getComponent()) != null) {
            component.Component_getErrors_contributors().add(this);
        }
        super.collect_contributors_Component_getErrors();
    }

    @Override
    protected void collect_contributors_Component_listMetaTokens() {
        Component component;
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0 && (component = this.getComponent()) != null) {
            component.Component_listMetaTokens_contributors().add(this);
        }
        super.collect_contributors_Component_listMetaTokens();
    }

    @Override
    protected void collect_contributors_Component_listRules() {
        Component component = this.getComponent();
        if (component != null) {
            component.Component_listRules_contributors().add(this);
        }
        super.collect_contributors_Component_listRules();
    }

    @Override
    protected void contributeTo_Component_Component_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Component_Component_getErrors(sortedSet);
        if (this.isMisclassified()) {
            sortedSet.add(this.makeCompilationError("Rule misclassified: " + (Object)((Object)this.getPattern().getType()) + " rule in " + (Object)((Object)this.getGroupPatternType()) + " section."));
        }
    }

    @Override
    protected void contributeTo_Component_Component_listMetaTokens(Set<String> set) {
        super.contributeTo_Component_Component_listMetaTokens(set);
        if (this.getMetaToken() != null && this.getMetaToken().length() > 0) {
            set.add(this.getMetaToken());
        }
    }

    @Override
    protected void contributeTo_Component_Component_listRules(List<Rule> list) {
        super.contributeTo_Component_Component_listRules(list);
        list.add(this);
    }
}

