/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import beaver.Symbol;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.FileLoader;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.ASTNode$State;
import metalexer.ast.BodyElement;
import metalexer.ast.CompDecl;
import metalexer.ast.CompRef;
import metalexer.ast.Component;
import metalexer.ast.Declaration;
import metalexer.ast.Embedding;
import metalexer.ast.EmbeddingRef;
import metalexer.ast.Extension;
import metalexer.ast.LayoutWrapper;
import metalexer.ast.LexerOption;
import metalexer.ast.List;
import metalexer.ast.MTokRef;
import metalexer.ast.Opt;
import metalexer.ast.OptionRef;
import metalexer.ast.Replacement;
import metalexer.metalexer.EscapeHelper;

public class Layout
extends ASTNode<ASTNode>
implements Cloneable {
    private Layout processed = null;
    private static final Comparator<MTokRef> mtokRefComparator = new Comparator<MTokRef>(){

        @Override
        public int compare(MTokRef mTokRef, MTokRef mTokRef2) {
            return mTokRef.getName().compareTo(mTokRef2.getName());
        }
    };
    protected String tokenString_Name;
    public int Namestart;
    public int Nameend;
    protected boolean tokenboolean_Helper;
    protected String tokenString_LocalHeader;
    public int LocalHeaderstart;
    public int LocalHeaderend;
    protected String tokenString_InheritedHeader;
    public int InheritedHeaderstart;
    public int InheritedHeaderend;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    protected Set<StringSymbol> tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    private boolean collect_contributors_Layout_listMetaTokens = false;
    protected int getActiveComponents_visited = -1;
    protected Map lookupCompDecls_String_visited;
    protected Map lookupEmbeddings_String_visited;
    protected int getEmbeddings_visited = -1;
    protected Map lookupExternDecls_String_visited;
    protected int Layout_getErrors_visited = -1;
    protected boolean Layout_getErrors_computed = false;
    protected SortedSet<CompilationError> Layout_getErrors_value;
    Set Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_listMetaTokens_visited = -1;
    protected boolean Layout_listMetaTokens_computed = false;
    protected Set<MTokRef> Layout_listMetaTokens_value;
    Set Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getWarnings_visited = -1;
    protected boolean Layout_getWarnings_computed = false;
    protected SortedSet<CompilationWarning> Layout_getWarnings_value;
    Set Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
    protected int Layout_getReferencedComponents_visited = -1;
    protected boolean Layout_getReferencedComponents_computed = false;
    protected java.util.List<CompDecl> Layout_getReferencedComponents_value;
    Set Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);

    @Override
    public void flushCache() {
        super.flushCache();
        this.getActiveComponents_visited = -1;
        this.lookupCompDecls_String_visited = new HashMap(4);
        this.lookupEmbeddings_String_visited = new HashMap(4);
        this.getEmbeddings_visited = -1;
        this.lookupExternDecls_String_visited = new HashMap(4);
        this.Layout_getErrors_visited = -1;
        this.Layout_getErrors_computed = false;
        this.Layout_getErrors_value = null;
        this.Layout_getErrors_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_listMetaTokens_visited = -1;
        this.Layout_listMetaTokens_computed = false;
        this.Layout_listMetaTokens_value = null;
        this.Layout_listMetaTokens_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getWarnings_visited = -1;
        this.Layout_getWarnings_computed = false;
        this.Layout_getWarnings_value = null;
        this.Layout_getWarnings_contributors = new ASTNode$State.IdentityHashSet(4);
        this.Layout_getReferencedComponents_visited = -1;
        this.Layout_getReferencedComponents_computed = false;
        this.Layout_getReferencedComponents_value = null;
        this.Layout_getReferencedComponents_contributors = new ASTNode$State.IdentityHashSet(4);
        this.collect_contributors_Layout_listMetaTokens = false;
    }

    @Override
    public Layout clone() throws CloneNotSupportedException {
        Layout layout = (Layout)super.clone();
        layout.getActiveComponents_visited = -1;
        layout.lookupCompDecls_String_visited = new HashMap(4);
        layout.lookupEmbeddings_String_visited = new HashMap(4);
        layout.getEmbeddings_visited = -1;
        layout.lookupExternDecls_String_visited = new HashMap(4);
        layout.in$Circle(false);
        layout.is$Final(false);
        return layout;
    }

    public Layout copy() {
        try {
            Layout layout = this.clone();
            if (this.children != null) {
                layout.children = (ASTNode[])this.children.clone();
            }
            return layout;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public Layout fullCopy() {
        Layout layout = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            layout.setChild(object, i);
        }
        return layout;
    }

    public void deleteUnusedDeclarations() {
        List<CompDecl> list = new List<CompDecl>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.hasComponent()) continue;
            list.add(compDecl);
            compDecl.getComponent().deleteUnusedDeclarations();
        }
        this.setComponentList(list);
    }

    public Layout processInheritance(FileLoader fileLoader, SortedSet<CompilationProblem> sortedSet) {
        return this.processInheritance(fileLoader, new Stack<String>(), sortedSet);
    }

    private Layout processInheritance(FileLoader fileLoader, Stack<String> stack, SortedSet<CompilationProblem> sortedSet) {
        if (this.processed == null) {
            Layout layout = new LayoutWrapper(this.fullCopy()).getLayout();
            this.processed = Layout.processInheritance(layout, fileLoader, stack, sortedSet);
            return this.processed;
        }
        return new LayoutWrapper(this.processed.fullCopy()).getLayout();
    }

    private static Layout processInheritance(Layout layout, FileLoader fileLoader, Stack<String> stack, SortedSet<CompilationProblem> sortedSet) {
        stack.push(layout.getName());
        List<BodyElement> list = new List<BodyElement>();
        for (BodyElement bodyElement : layout.getBodyElements()) {
            if (bodyElement instanceof Embedding) {
                list.add(bodyElement);
                continue;
            }
            if (bodyElement instanceof Extension) {
                Serializable serializable;
                String string;
                Extension extension = (Extension)bodyElement;
                Layout layout2 = null;
                try {
                    layout2 = fileLoader.loadLayout(extension.getLayoutName(), sortedSet);
                }
                catch (IOException iOException) {
                    sortedSet.add(extension.makeCompilationError(iOException.getMessage()));
                }
                if (layout2 == null) {
                    string = "Cannot process layout " + layout.getName() + " until layout " + extension.getLayoutName() + " is available.";
                    sortedSet.add(extension.makeCompilationError(string));
                    continue;
                }
                string = layout2.getName();
                if (stack.contains(string)) {
                    serializable = new StringBuffer("Cyclic inheritance detected: ");
                    boolean bl = true;
                    boolean bl2 = false;
                    for (String string2 : stack) {
                        if (string2.equals(string)) {
                            bl2 = true;
                            ((StringBuffer)serializable).append(string2);
                            bl = false;
                            continue;
                        }
                        if (!bl2 || bl) continue;
                        ((StringBuffer)serializable).append(", ");
                        ((StringBuffer)serializable).append(string2);
                    }
                    sortedSet.add(extension.makeCompilationError(((StringBuffer)serializable).toString()));
                    continue;
                }
                layout2 = layout2.processInheritance(fileLoader, stack, sortedSet);
                layout2.processReplacements(extension.getReplacements(), sortedSet);
                serializable = new HashMap();
                for (EmbeddingRef embeddingRef : extension.getDeletedEmbeddings()) {
                    serializable.put(embeddingRef.getName(), embeddingRef);
                }
                HashSet hashSet = new HashSet();
                for (BodyElement bodyElement2 : layout2.getBodyElements()) {
                    if (bodyElement2 instanceof Embedding) {
                        Embedding embedding = (Embedding)bodyElement2;
                        String string3 = embedding.getName();
                        if (serializable.containsKey(string3)) {
                            hashSet.add(serializable.get(string3));
                            continue;
                        }
                        list.add(embedding);
                        continue;
                    }
                    throw new RuntimeException("Parent still has non-Embedding BodyElements: " + bodyElement2.getClass().getName());
                }
                for (EmbeddingRef embeddingRef : extension.getDeletedEmbeddings()) {
                    if (hashSet.contains(embeddingRef)) continue;
                    sortedSet.add(embeddingRef.makeCompilationWarning("Unembed has no effect."));
                }
                layout.setInheritedHeader(layout.getInheritedHeader() + layout2.getInheritedHeader());
                Layout.appendDistinctComponents(layout.getComponents(), layout2.getComponents(), sortedSet);
                Layout.appendDistinctOptions(layout.getOptions(), layout2.getOptions(), extension.getDeletedOptions(), sortedSet);
                Layout.appendDistinctDecls(layout.getDecls(), layout2.getDecls(), sortedSet);
                Layout.appendDistinctStringSymbols(layout.getYylexExceptions(), layout2.getYylexExceptions(), sortedSet);
                Layout.appendDistinctStringSymbols(layout.getInitExceptions(), layout2.getInitExceptions(), sortedSet);
                layout.getDeclRegions().addAll(layout2.getDeclRegions());
                layout.getInitRegions().addAll(layout2.getInitRegions());
                continue;
            }
            throw new RuntimeException("Unexpected body element type: " + bodyElement.getClass().getName());
        }
        layout.setBodyElementList(list);
        layout.fetchComponents(fileLoader, sortedSet);
        sortedSet.addAll(layout.getErrors());
        sortedSet.addAll(layout.getWarnings());
        stack.pop();
        return layout;
    }

    private static void appendDistinctComponents(List<CompDecl> list, List<CompDecl> list2, SortedSet<CompilationProblem> sortedSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CompDecl compDecl : list) {
            hashSet.add(compDecl.getName());
        }
        for (CompDecl compDecl : list2) {
            if (hashSet.contains(compDecl.getName())) continue;
            list.add(compDecl);
        }
    }

    private static void appendDistinctOptions(List<LexerOption> list, List<LexerOption> list2, List<OptionRef> list3, SortedSet<CompilationProblem> sortedSet) {
        HashMap<String, LexerOption> hashMap = new HashMap<String, LexerOption>();
        HashMap<String, OptionRef> hashMap2 = new HashMap<String, OptionRef>();
        HashSet hashSet = new HashSet();
        for (LexerOption aSTNode : list) {
            hashMap.put(aSTNode.getName(), aSTNode);
        }
        for (OptionRef optionRef : list3) {
            hashMap2.put(optionRef.getName(), optionRef);
        }
        for (LexerOption lexerOption : list2) {
            String string = lexerOption.getName();
            if (hashMap.containsKey(string)) {
                if (((LexerOption)hashMap.get(string)).getFilename().equals(lexerOption.getFilename())) continue;
                sortedSet.add(((LexerOption)hashMap.get(string)).makeCompilationWarning("Clobbering option from " + lexerOption.getFilename() + "."));
                continue;
            }
            if (hashMap2.containsKey(string)) {
                hashSet.add(hashMap2.get(string));
                continue;
            }
            list.add(lexerOption);
        }
        for (OptionRef optionRef : list3) {
            if (hashSet.contains(optionRef)) continue;
            sortedSet.add(optionRef.makeCompilationWarning("Unoption has no effect."));
        }
    }

    private static void appendDistinctDecls(List<Declaration> list, List<Declaration> list2, SortedSet<CompilationProblem> sortedSet) {
        block0: for (Declaration declaration : list2) {
            for (Declaration declaration2 : list) {
                if (!declaration.getText().equals(declaration2.getText())) continue;
                continue block0;
            }
            list.add(declaration);
        }
    }

    private static void appendDistinctStringSymbols(Set<StringSymbol> set, Set<StringSymbol> set2, SortedSet<CompilationProblem> sortedSet) {
        block0: for (StringSymbol stringSymbol : set2) {
            for (StringSymbol stringSymbol2 : set) {
                if (!stringSymbol.getText().equals(stringSymbol2.getText())) continue;
                continue block0;
            }
            set.add(stringSymbol);
        }
    }

    private void fetchComponents(FileLoader fileLoader, SortedSet<CompilationProblem> sortedSet) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CompDecl compDecl : this.getReferencedComponents()) {
            String string = compDecl.getName();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            Component component = null;
            try {
                component = fileLoader.loadComponent(string, sortedSet);
            }
            catch (IOException iOException) {
                sortedSet.add(compDecl.makeCompilationError(iOException.getMessage()));
            }
            if (component == null) {
                String string2 = "Cannot process layout " + this.getName() + " until component " + string + " is available.";
                sortedSet.add(compDecl.makeCompilationError(string2));
                return;
            }
            component = component.processInheritance(fileLoader, sortedSet);
            compDecl.setComponent(component);
        }
    }

    private void processReplacements(List<Replacement> list, SortedSet<CompilationProblem> sortedSet) {
        HashMap<String, Replacement> hashMap = new HashMap<String, Replacement>();
        for (Replacement object : list) {
            hashMap.put(object.getOld().getName(), object);
        }
        Set<Replacement> set = this.replaceComponents(hashMap);
        for (Replacement replacement : list) {
            if (set.contains(replacement)) continue;
            sortedSet.add(replacement.makeCompilationWarning("Replacement has no effect."));
        }
    }

    public void tidyRuleGroups() {
        for (Component component : this.getActiveComponents()) {
            component.tidyRuleGroups();
        }
    }

    public void generateMetaLexer(String string) throws IOException {
        new File(string).mkdirs();
        PrintWriter printWriter = new PrintWriter(new FileWriter(string + "/" + this.getName() + ".mll"));
        this.generateMetaLexer(printWriter);
        for (Component component : this.getActiveComponents()) {
            component.generateMetaLexer(string);
        }
        printWriter.close();
    }

    void generateMetaLexer(PrintWriter printWriter) throws IOException {
        printWriter.print(this.getLocalHeader());
        printWriter.println("%%");
        printWriter.print(this.getInheritedHeader());
        printWriter.println("%%");
        printWriter.println("//// This file was generated by MetaLexer ////");
        printWriter.println();
        printWriter.println("%layout " + this.getName());
        printWriter.println();
        if (this.getHelper()) {
            printWriter.println("%helper");
            printWriter.println();
        }
        if (this.hasStartComponent()) {
            printWriter.println("%start " + this.getStartComponent().getName());
            printWriter.println();
        }
        if (!this.getComponents().isEmpty()) {
            for (CompDecl aSTNode : this.getComponents()) {
                printWriter.println("%component " + aSTNode.getName());
            }
            printWriter.println();
        }
        if (!this.getOptions().isEmpty()) {
            for (LexerOption lexerOption : this.getOptions()) {
                printWriter.println("%option " + lexerOption.getName() + " " + EscapeHelper.escapeString(lexerOption.getValue()));
            }
            printWriter.println();
        }
        if (!this.getDecls().isEmpty()) {
            for (Declaration declaration : this.getDecls()) {
                printWriter.println("%declare " + EscapeHelper.escapeString(declaration.getText()));
            }
            printWriter.println();
        }
        if (!this.getYylexExceptions().isEmpty()) {
            for (StringSymbol stringSymbol : this.getYylexExceptions()) {
                printWriter.println("%lexthrow " + EscapeHelper.escapeString(stringSymbol.getText()));
            }
            printWriter.println();
        }
        if (!this.getInitExceptions().isEmpty()) {
            for (StringSymbol stringSymbol : this.getInitExceptions()) {
                printWriter.println("%initthrow " + EscapeHelper.escapeString(stringSymbol.getText()));
            }
            printWriter.println();
        }
        if (!this.getInitRegions().isEmpty()) {
            for (StringSymbol stringSymbol : this.getInitRegions()) {
                printWriter.println(EscapeHelper.escapeInitRegion(stringSymbol.getText()));
            }
            printWriter.println();
        }
        if (!this.getDeclRegions().isEmpty()) {
            for (StringSymbol stringSymbol : this.getDeclRegions()) {
                printWriter.println(EscapeHelper.escapeDeclRegion(stringSymbol.getText()));
            }
            printWriter.println();
        }
        if (!this.getBodyElements().isEmpty()) {
            printWriter.println("%%");
            printWriter.println();
            for (BodyElement bodyElement : this.getBodyElements()) {
                if (bodyElement instanceof Embedding) {
                    ((Embedding)bodyElement).generateMetaLexer(printWriter);
                    continue;
                }
                throw new RuntimeException("There shouldn't be any non-embedding BodyElements remaining: " + bodyElement.getClass().getName());
            }
        }
    }

    public Layout() {
        this.setChild(new Opt(), 0);
        this.setChild(new List(), 1);
        this.setChild(new List(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
    }

    public Layout(String string, boolean bl, String string2, String string3, Opt<CompRef> opt, List<CompDecl> list, List<LexerOption> list2, List<Declaration> list3, Set<StringSymbol> set, Set<StringSymbol> set2, Set<StringSymbol> set3, Set<StringSymbol> set4, List<BodyElement> list4) {
        this.setName(string);
        this.setHelper(bl);
        this.setLocalHeader(string2);
        this.setInheritedHeader(string3);
        this.setChild(opt, 0);
        this.setChild(list, 1);
        this.setChild(list2, 2);
        this.setChild(list3, 3);
        this.setDeclRegions(set);
        this.setYylexExceptions(set2);
        this.setInitRegions(set3);
        this.setInitExceptions(set4);
        this.setChild(list4, 4);
    }

    public Layout(Symbol symbol, boolean bl, Symbol symbol2, Symbol symbol3, Opt<CompRef> opt, List<CompDecl> list, List<LexerOption> list2, List<Declaration> list3, Set<StringSymbol> set, Set<StringSymbol> set2, Set<StringSymbol> set3, Set<StringSymbol> set4, List<BodyElement> list4) {
        this.setName(symbol);
        this.setHelper(bl);
        this.setLocalHeader(symbol2);
        this.setInheritedHeader(symbol3);
        this.setChild(opt, 0);
        this.setChild(list, 1);
        this.setChild(list2, 2);
        this.setChild(list3, 3);
        this.setDeclRegions(set);
        this.setYylexExceptions(set2);
        this.setInitRegions(set3);
        this.setInitExceptions(set4);
        this.setChild(list4, 4);
    }

    @Override
    protected int numChildren() {
        return 5;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setName(String string) {
        this.tokenString_Name = string;
    }

    public void setName(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setName is only valid for String lexemes");
        }
        this.tokenString_Name = (String)symbol.value;
        this.Namestart = symbol.getStart();
        this.Nameend = symbol.getEnd();
    }

    public String getName() {
        return this.tokenString_Name != null ? this.tokenString_Name : "";
    }

    public void setHelper(boolean bl) {
        this.tokenboolean_Helper = bl;
    }

    public boolean getHelper() {
        return this.tokenboolean_Helper;
    }

    public void setLocalHeader(String string) {
        this.tokenString_LocalHeader = string;
    }

    public void setLocalHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLocalHeader is only valid for String lexemes");
        }
        this.tokenString_LocalHeader = (String)symbol.value;
        this.LocalHeaderstart = symbol.getStart();
        this.LocalHeaderend = symbol.getEnd();
    }

    public String getLocalHeader() {
        return this.tokenString_LocalHeader != null ? this.tokenString_LocalHeader : "";
    }

    public void setInheritedHeader(String string) {
        this.tokenString_InheritedHeader = string;
    }

    public void setInheritedHeader(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setInheritedHeader is only valid for String lexemes");
        }
        this.tokenString_InheritedHeader = (String)symbol.value;
        this.InheritedHeaderstart = symbol.getStart();
        this.InheritedHeaderend = symbol.getEnd();
    }

    public String getInheritedHeader() {
        return this.tokenString_InheritedHeader != null ? this.tokenString_InheritedHeader : "";
    }

    public void setStartComponentOpt(Opt<CompRef> opt) {
        this.setChild(opt, 0);
    }

    public boolean hasStartComponent() {
        return this.getStartComponentOpt().getNumChild() != 0;
    }

    public CompRef getStartComponent() {
        return (CompRef)this.getStartComponentOpt().getChild(0);
    }

    public void setStartComponent(CompRef compRef) {
        this.getStartComponentOpt().setChild(compRef, 0);
    }

    public Opt<CompRef> getStartComponentOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<CompRef> getStartComponentOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    public void setComponentList(List<CompDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    public CompDecl getComponent(int n) {
        return (CompDecl)this.getComponentList().getChild(n);
    }

    public void addComponent(CompDecl compDecl) {
        List<CompDecl> list = this.getComponentList();
        list.addChild(compDecl);
    }

    public void setComponent(CompDecl compDecl, int n) {
        List<CompDecl> list = this.getComponentList();
        list.setChild(compDecl, n);
    }

    public List<CompDecl> getComponents() {
        return this.getComponentList();
    }

    public List<CompDecl> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    public List<CompDecl> getComponentList() {
        return (List)this.getChild(1);
    }

    public List<CompDecl> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void setOptionList(List<LexerOption> list) {
        this.setChild(list, 2);
    }

    public int getNumOption() {
        return this.getOptionList().getNumChild();
    }

    public LexerOption getOption(int n) {
        return (LexerOption)this.getOptionList().getChild(n);
    }

    public void addOption(LexerOption lexerOption) {
        List<LexerOption> list = this.getOptionList();
        list.addChild(lexerOption);
    }

    public void setOption(LexerOption lexerOption, int n) {
        List<LexerOption> list = this.getOptionList();
        list.setChild(lexerOption, n);
    }

    public List<LexerOption> getOptions() {
        return this.getOptionList();
    }

    public List<LexerOption> getOptionsNoTransform() {
        return this.getOptionListNoTransform();
    }

    public List<LexerOption> getOptionList() {
        return (List)this.getChild(2);
    }

    public List<LexerOption> getOptionListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setDeclList(List<Declaration> list) {
        this.setChild(list, 3);
    }

    public int getNumDecl() {
        return this.getDeclList().getNumChild();
    }

    public Declaration getDecl(int n) {
        return (Declaration)this.getDeclList().getChild(n);
    }

    public void addDecl(Declaration declaration) {
        List<Declaration> list = this.getDeclList();
        list.addChild(declaration);
    }

    public void setDecl(Declaration declaration, int n) {
        List<Declaration> list = this.getDeclList();
        list.setChild(declaration, n);
    }

    public List<Declaration> getDecls() {
        return this.getDeclList();
    }

    public List<Declaration> getDeclsNoTransform() {
        return this.getDeclListNoTransform();
    }

    public List<Declaration> getDeclList() {
        return (List)this.getChild(3);
    }

    public List<Declaration> getDeclListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    public void setDeclRegions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions = set;
    }

    public Set<StringSymbol> getDeclRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__DeclRegions;
    }

    public void setYylexExceptions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions = set;
    }

    public Set<StringSymbol> getYylexExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__YylexExceptions;
    }

    public void setInitRegions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions = set;
    }

    public Set<StringSymbol> getInitRegions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitRegions;
    }

    public void setInitExceptions(Set<StringSymbol> set) {
        this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions = set;
    }

    public Set<StringSymbol> getInitExceptions() {
        return this.tokenjava_util_Set_metalexer_StringSymbol__InitExceptions;
    }

    public void setBodyElementList(List<BodyElement> list) {
        this.setChild(list, 4);
    }

    public int getNumBodyElement() {
        return this.getBodyElementList().getNumChild();
    }

    public BodyElement getBodyElement(int n) {
        return (BodyElement)this.getBodyElementList().getChild(n);
    }

    public void addBodyElement(BodyElement bodyElement) {
        List<BodyElement> list = this.getBodyElementList();
        list.addChild(bodyElement);
    }

    public void setBodyElement(BodyElement bodyElement, int n) {
        List<BodyElement> list = this.getBodyElementList();
        list.setChild(bodyElement, n);
    }

    public List<BodyElement> getBodyElements() {
        return this.getBodyElementList();
    }

    public List<BodyElement> getBodyElementsNoTransform() {
        return this.getBodyElementListNoTransform();
    }

    public List<BodyElement> getBodyElementList() {
        return (List)this.getChild(4);
    }

    public List<BodyElement> getBodyElementListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    @Override
    protected void collect_contributors_Layout_listMetaTokens() {
        if (this.collect_contributors_Layout_listMetaTokens) {
            return;
        }
        super.collect_contributors_Layout_listMetaTokens();
        this.collect_contributors_Layout_listMetaTokens = true;
    }

    public java.util.List<Component> getActiveComponents() {
        if (this.getActiveComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getActiveComponents in class: ");
        }
        this.getActiveComponents_visited = this.state().boundariesCrossed;
        java.util.List<Component> list = this.getActiveComponents_compute();
        this.getActiveComponents_visited = -1;
        return list;
    }

    private java.util.List<Component> getActiveComponents_compute() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.hasComponent()) continue;
            arrayList.add(compDecl.getComponent());
        }
        return arrayList;
    }

    public Set<CompDecl> lookupCompDecls(String string) {
        String string2 = string;
        if (this.lookupCompDecls_String_visited == null) {
            this.lookupCompDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupCompDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupCompDecls in class: ");
        }
        this.lookupCompDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<CompDecl> set = this.lookupCompDecls_compute(string);
        this.lookupCompDecls_String_visited.remove(string2);
        return set;
    }

    private Set<CompDecl> lookupCompDecls_compute(String string) {
        HashSet<CompDecl> hashSet = new HashSet<CompDecl>();
        for (CompDecl compDecl : this.getComponents()) {
            if (!compDecl.getName().equals(string)) continue;
            hashSet.add(compDecl);
        }
        return hashSet;
    }

    public Set<Embedding> lookupEmbeddings(String string) {
        String string2 = string;
        if (this.lookupEmbeddings_String_visited == null) {
            this.lookupEmbeddings_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupEmbeddings_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupEmbeddings in class: ");
        }
        this.lookupEmbeddings_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<Embedding> set = this.lookupEmbeddings_compute(string);
        this.lookupEmbeddings_String_visited.remove(string2);
        return set;
    }

    private Set<Embedding> lookupEmbeddings_compute(String string) {
        HashSet<Embedding> hashSet = new HashSet<Embedding>();
        for (BodyElement bodyElement : this.getBodyElements()) {
            Embedding embedding;
            if (!(bodyElement instanceof Embedding) || !(embedding = (Embedding)bodyElement).getName().equals(string)) continue;
            hashSet.add(embedding);
        }
        return hashSet;
    }

    public java.util.List<Embedding> getEmbeddings() {
        if (this.getEmbeddings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getEmbeddings in class: ");
        }
        this.getEmbeddings_visited = this.state().boundariesCrossed;
        java.util.List<Embedding> list = this.getEmbeddings_compute();
        this.getEmbeddings_visited = -1;
        return list;
    }

    private java.util.List<Embedding> getEmbeddings_compute() {
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        for (BodyElement bodyElement : this.getBodyElements()) {
            if (!(bodyElement instanceof Embedding)) continue;
            arrayList.add((Embedding)bodyElement);
        }
        return arrayList;
    }

    public Set<Declaration> lookupExternDecls(String string) {
        String string2 = string;
        if (this.lookupExternDecls_String_visited == null) {
            this.lookupExternDecls_String_visited = new HashMap(4);
        }
        if (new Integer(this.state().boundariesCrossed).equals(this.lookupExternDecls_String_visited.get(string2))) {
            throw new RuntimeException("Circular definition of attr: lookupExternDecls in class: ");
        }
        this.lookupExternDecls_String_visited.put(string2, new Integer(this.state().boundariesCrossed));
        Set<Declaration> set = this.lookupExternDecls_compute(string);
        this.lookupExternDecls_String_visited.remove(string2);
        return set;
    }

    private Set<Declaration> lookupExternDecls_compute(String string) {
        HashSet<Declaration> hashSet = new HashSet<Declaration>();
        for (Declaration declaration : this.getDecls()) {
            if (!declaration.getText().equals(string)) continue;
            hashSet.add(declaration);
        }
        return hashSet;
    }

    @Override
    public Set<CompDecl> Define_java_util_Set_CompDecl__lookupCompDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupCompDecls(string);
        }
        if (aSTNode == this.getStartComponentOptNoTransform()) {
            return this.lookupCompDecls(string);
        }
        return this.getParent().Define_java_util_Set_CompDecl__lookupCompDecls(this, aSTNode, string);
    }

    @Override
    public Set<Embedding> Define_java_util_Set_Embedding__lookupEmbeddings(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupEmbeddings(string);
        }
        return this.getParent().Define_java_util_Set_Embedding__lookupEmbeddings(this, aSTNode, string);
    }

    @Override
    public Set<Declaration> Define_java_util_Set_Declaration__lookupExternDecls(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.lookupExternDecls(string);
        }
        return this.getParent().Define_java_util_Set_Declaration__lookupExternDecls(this, aSTNode, string);
    }

    @Override
    public Layout Define_Layout_getLayout(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getBodyElementListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this;
        }
        if (aSTNode == this.getComponentListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this;
        }
        if (aSTNode == this.getStartComponentOptNoTransform()) {
            return this;
        }
        return this.getParent().Define_Layout_getLayout(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    public SortedSet<CompilationError> getErrors() {
        if (this.Layout_getErrors_computed) {
            return this.Layout_getErrors_value;
        }
        if (this.Layout_getErrors_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getErrors in class: ");
        }
        this.Layout_getErrors_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getErrors_value = this.getErrors_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getErrors_computed = true;
        }
        this.Layout_getErrors_visited = -1;
        return this.Layout_getErrors_value;
    }

    public Set Layout_getErrors_contributors() {
        return this.Layout_getErrors_contributors;
    }

    private SortedSet<CompilationError> getErrors_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getErrors();
        this.Layout_getErrors_value = new TreeSet<CompilationError>();
        for (ASTNode aSTNode2 : this.Layout_getErrors_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getErrors(this.Layout_getErrors_value);
        }
        return this.Layout_getErrors_value;
    }

    public Set<MTokRef> listMetaTokens() {
        if (this.Layout_listMetaTokens_computed) {
            return this.Layout_listMetaTokens_value;
        }
        if (this.Layout_listMetaTokens_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: listMetaTokens in class: ");
        }
        this.Layout_listMetaTokens_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_listMetaTokens_value = this.listMetaTokens_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_listMetaTokens_computed = true;
        }
        this.Layout_listMetaTokens_visited = -1;
        return this.Layout_listMetaTokens_value;
    }

    public Set Layout_listMetaTokens_contributors() {
        return this.Layout_listMetaTokens_contributors;
    }

    private Set<MTokRef> listMetaTokens_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof Layout)) {
            aSTNode = aSTNode.getParent();
        }
        Layout layout = aSTNode;
        layout.collect_contributors_Layout_listMetaTokens();
        this.Layout_listMetaTokens_value = new TreeSet<MTokRef>(mtokRefComparator);
        for (ASTNode aSTNode2 : this.Layout_listMetaTokens_contributors) {
            aSTNode2.contributeTo_Layout_Layout_listMetaTokens(this.Layout_listMetaTokens_value);
        }
        return this.Layout_listMetaTokens_value;
    }

    public SortedSet<CompilationWarning> getWarnings() {
        if (this.Layout_getWarnings_computed) {
            return this.Layout_getWarnings_value;
        }
        if (this.Layout_getWarnings_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getWarnings in class: ");
        }
        this.Layout_getWarnings_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getWarnings_value = this.getWarnings_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getWarnings_computed = true;
        }
        this.Layout_getWarnings_visited = -1;
        return this.Layout_getWarnings_value;
    }

    public Set Layout_getWarnings_contributors() {
        return this.Layout_getWarnings_contributors;
    }

    private SortedSet<CompilationWarning> getWarnings_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getWarnings();
        this.Layout_getWarnings_value = new TreeSet<CompilationWarning>();
        for (ASTNode aSTNode2 : this.Layout_getWarnings_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getWarnings(this.Layout_getWarnings_value);
        }
        return this.Layout_getWarnings_value;
    }

    public java.util.List<CompDecl> getReferencedComponents() {
        if (this.Layout_getReferencedComponents_computed) {
            return this.Layout_getReferencedComponents_value;
        }
        if (this.Layout_getReferencedComponents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getReferencedComponents in class: ");
        }
        this.Layout_getReferencedComponents_visited = this.state().boundariesCrossed;
        int n = this.state().boundariesCrossed;
        boolean bl = this.is$Final();
        this.Layout_getReferencedComponents_value = this.getReferencedComponents_compute();
        if (bl && n == this.state().boundariesCrossed) {
            this.Layout_getReferencedComponents_computed = true;
        }
        this.Layout_getReferencedComponents_visited = -1;
        return this.Layout_getReferencedComponents_value;
    }

    public Set Layout_getReferencedComponents_contributors() {
        return this.Layout_getReferencedComponents_contributors;
    }

    private java.util.List<CompDecl> getReferencedComponents_compute() {
        ASTNode aSTNode = this;
        while (aSTNode.getParent() != null && !(aSTNode instanceof LayoutWrapper)) {
            aSTNode = aSTNode.getParent();
        }
        LayoutWrapper layoutWrapper = (LayoutWrapper)aSTNode;
        layoutWrapper.collect_contributors_Layout_getReferencedComponents();
        this.Layout_getReferencedComponents_value = new ArrayList<CompDecl>();
        for (ASTNode aSTNode2 : this.Layout_getReferencedComponents_contributors) {
            aSTNode2.contributeTo_Layout_Layout_getReferencedComponents(this.Layout_getReferencedComponents_value);
        }
        return this.Layout_getReferencedComponents_value;
    }

    @Override
    protected void collect_contributors_Layout_getErrors() {
        Layout layout;
        if (!this.getHelper() && !this.hasStartComponent() && (layout = this) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty() && (layout = this) != null) {
            layout.Layout_getErrors_contributors().add(this);
        }
        super.collect_contributors_Layout_getErrors();
    }

    @Override
    protected void contributeTo_Layout_Layout_getErrors(SortedSet<CompilationError> sortedSet) {
        super.contributeTo_Layout_Layout_getErrors(sortedSet);
        if (!this.getHelper() && !this.hasStartComponent()) {
            sortedSet.add(this.makeCompilationError("Layout " + this.getName() + " has no start component."));
        }
        if (!this.getHelper() && this.getReferencedComponents().isEmpty()) {
            sortedSet.add(this.makeCompilationError("Layout " + this.getName() + " is not using any components."));
        }
    }
}

