/*
 * Decompiled with CFR 0.152.
 */
package metalexer;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import metalexer.CompilationError;
import metalexer.CompilationProblem;
import metalexer.CompilationWarning;
import metalexer.StringSymbol;
import metalexer.ast.ASTNode;
import metalexer.ast.AltRegex;
import metalexer.ast.AnyPattern;
import metalexer.ast.AppendRegion;
import metalexer.ast.CharClassRegex;
import metalexer.ast.CharRegex;
import metalexer.ast.Component;
import metalexer.ast.ComponentDirective;
import metalexer.ast.ComponentWrapper;
import metalexer.ast.DeclRegion;
import metalexer.ast.Deletion;
import metalexer.ast.DotRegex;
import metalexer.ast.EOFPattern;
import metalexer.ast.EOLRegexPattern;
import metalexer.ast.EscapeRegex;
import metalexer.ast.ExternDecl;
import metalexer.ast.ExternDirective;
import metalexer.ast.HeaderBlob;
import metalexer.ast.HeaderSection;
import metalexer.ast.HelperDirective;
import metalexer.ast.ImportDirective;
import metalexer.ast.InheritSection;
import metalexer.ast.InitRegion;
import metalexer.ast.InitThrowDirective;
import metalexer.ast.LexThrowDirective;
import metalexer.ast.List;
import metalexer.ast.LookaheadRegexPattern;
import metalexer.ast.MacroDecl;
import metalexer.ast.MacroInvocationRegex;
import metalexer.ast.MultiCharRange;
import metalexer.ast.NotRegex;
import metalexer.ast.Opt;
import metalexer.ast.OptRegex;
import metalexer.ast.Pattern;
import metalexer.ast.PlusRegex;
import metalexer.ast.RangeRepeatRegex;
import metalexer.ast.Regex;
import metalexer.ast.RepeatRegex;
import metalexer.ast.Rule;
import metalexer.ast.RuleGroup;
import metalexer.ast.RuleSection;
import metalexer.ast.SeqRegex;
import metalexer.ast.SingleCharRange;
import metalexer.ast.StarRegex;
import metalexer.ast.StartDirective;
import metalexer.ast.State;
import metalexer.ast.StateDirective;
import metalexer.ast.StateRef;
import metalexer.ast.StringRegex;
import metalexer.ast.UptoRegex;
import metalexer.ast.XStateDirective;

public class ComponentParser
extends Parser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMWUO54KQVJCzczSiXbFaCAs98A0Y8A8U0eiWEQq28b45bBoAWe0Wc1KLSo286J0BY2S28aiKHNBES2WdGK#lxbLrc9wUgjxPzRwx#qxcVM$$glh$$rNidfwT0N8tYAzCG14Q6dqznGGqGmklNbi8T10Jn7XLguZpS3wkmLzOcsV4p#8V9f$I7ezChzuKLo2RwkDLVRpOZ#UG9VQp$4OOK0#NuLhKHpxkm9Mu01UXBXhWKi$VMymWVa4LL49bN2nU3WFLJjAePNd#0dJ4xUZbPRmK1ggTfb6hvlaBS2DkG3iluyKmKEroZLfDpo$LMbBDpNWX35IxIgDslUU$rHcRc$5y6AZMNAFMslCNu3QgtU9bF1S6gitMg7Nn$5yuOtCpdWq3rVfgr4Pu4NU9EyMlefzNVoOCFFa3x9EFgt4spl6otOZfOZgEnh5U$Uam9AZLmJdogb1NXkjlZzfeowlEpNWo30bgWtnghhyxrRfHpSruD0m9QdTnfZ$oYkmlVlGY$auKacxzeJ0agBr0jRyHXQGRyPFuYNloarT$C0m#jJoMBtJAexs8VufFn2U8UVKnOQ121KSXVb$xc73zLT4OJL3BotWW33phmyMdubFQ9t0wxiKb68cop7RzP#8i3CLzNiPZOL1NTIEqmtNEcRyNhT26U#ZwEwCh7iPOB#EfK8nqLSHzgCxJK8FZca0wVlHXsmFnkXWRYdl5I8NXOeIuJs4OXlETml6Z7xM7KSsDVpWCAA2U0aiZ58QA3matuWVn0V63Ltya5CCvqvkvRfqu9dVExnEE7y#AzuZVlFZ7Gp6KSxGnMWopmLt#pVNZUJo4QNZCYtyY5FTJpyOewYbW13vm$NWV7s46Fl7YnuK1ZrDF0JTHJu4dRxhddu7Fg9xZPNoECyZxnUT1C6g4c2Ace1wPTCTKdk6#s1xYQvxiiQe#nGOMycH3VCsMTy80yAuCJHzknDjXm40Cnjr8UdaHRuN1sBSRyMOOZ7sx4Q#7mTYt6p4v38Q#d$GYNWi3qdqv6OvzaIDt8ruD0yPvkSyapDkDU2KCoUlbPBiHKyLKdhgfcfMH7bFsL0VlXc8#8#S7mPFk#WU81M80PjC6iS29$WnVahH1iCsDdO#lsSz716jgU9$Z4No5CLvi8Uvan4HIrkpNNDPcIR9jLX9cqgCOXCgrgFMK6#ieJoHaVIAYNdHVkmzRnxTw$INPrZy8BsAWoo1KPaAitUBRd37nsBYUNHDordDPcnk45pd7PH0gCo7MRaceUR5nFRic1acoDYW8Br9UNzfhL6KcnDej2RMxawxH8MppF$kKvtEPVFq9vV1dsXDLhGmv2aVnx$582nb3cD8ztWnAF0OnAJ26N6SC9skkoC7c5LBzJ$AFGTKcyI$7eCg3DQCRB3XscqduagsAGVZMtObDR54sELRM$qgh68HsbHwqLqaKYIBrrusDQyfwaHxGlCGtH97uHkihKbuDDB539EaR4eJTI#YUd#AFTVLOI$Mi7iCzFjvm3bxs3V8Ll8hnc829c8JNC1clumsygJ#bnPpHbM8bof2ZS1pa6KrSYvK6B1VBwLsUj7YVggpb1dmhlgNtswGLLphIgyNtudjwlq$AKZhIgyKAiOBU5OOHhZ1WYLX2xvAaB7KkfLUBPM8PlSkIHgXqf5UBfM8flKkJifIEz6hndVYEtk#IifIEz6gnK2oaTs7IlEQfh8K6B1QBwLsSr9VIaLuj5eb5z2vAob8wqgl5GN6GteD9MRREXtWBR#CTl8ifc8hty35cOXRcY0FY06CE9CqBeLc7n25c7T8dIQyMUyLUUlSQilOQi4VieNUF8MkF0Rl5Rdft6x9s6x1BxA9tbo5hbm4xnKvwTngoTXgmG#oWTuSXQuS1syLsUhSRihORi4rietUR8MkR0Ll5Ldgt6hAs6h15RA5tYo5hYm6RnMPwDnkoDXkmIMoYTvCXQvC16yL6UZSQiZOQi45ie7U38Mk30Ul5UdhN6xBM6x1EhADtdI5hdG5hnLfwrngorXgmMgocTxKXQxK1QyGQUjSOijOOi4giedUL8MkL0OV5ONeF6x8E6x1FxADtdo5hdnufFMVKmmcQvyylgFf544aTQpyh#sF5R9mgPWSXOx30bw9zVd5ZyRGNzr9mHih$g9oHc2QcKNUQPdMcwLhZFdhFPJ62A2p4aCRFy1d8H1QoaODSN8OUE0R7yddeUAxKYLona$Z4VWfEvKeEG1xgu2grekLn9aS7hkJ5r9B$uQoEor43DL4BbKBqvSkaBxNpqDJJhyyUciXlM9H#DQLQZgfX#aVXQ7hoD9wBSHfEHrcSGR#C0iwI$sqFNGrRxHADfvnFxG9So7EKgjhH6a$bKgjLBcQc9LChg$5KABLQXN#hMjrGjHObL8jeF15FpNsbfXO$#LUWDkygvHouQZBcVA9qQlAga7JLv5LHd$l#lw0cewinEhvk4TBw7Mhb0cgHKgd5owrzQZAgv6hnacntrUgfLSmlmUbrpzqTl3lLGoFqPxQh9cqhL4rPpJxh5Jmhnn8$lR9s7YujiLgKuwf8vlCEak#RQKL#$avzfd4rjrIN2d6rQfpxxr7pxqB9zhGujUObV5$GpJH#rQSngX5PUZLvZtBL#h4SmyqfghNsdGoTcbIAu9Q0MX$jFJ5IJ5zrlVVh29#GyZZdIzNxjTjN4xGIWcUxIhWEOw9aiiz$Dp2FGer09BrIo$v$wvlFKAbbT$7btEhOvgcE7Dszt9wbcRV#zP$8Dgou$$q$p$34KTKvw#0JXpuYVZrSWfRiH$R7wq6DhXVpM$BvrOrWVsoDa4u4Ixr9o5F1AqRp$6mwBogtCyVTrLLdlI8PVtxkw$KxYErLL8RNhweP#qsCqFSVxzUBJbIlP8vmUgxqH#av#EoZsgzMln8Hk5RL6f0DSHt$DiRrvZ4KhsGQPNYcEfMQCU3safvAjkVvnv1uAesZCy#ucDxCCmvPYzAjBzGgMGPDm#TSeNcf#rKUBAslQkfApXvfFlywIk5x$ZlFAcVHsB2ApNoQRT0MxL206t0ZsgC3Ek8cT3BiJFXuvQeruFexPpIm5gR$CpYxbhHsUKUoZcJzzxESt2DPHxAEP1t9#kDafV2SmMURXfgdYsAU1fr#zP#LVQscppviBVRvnNkwxUR5tPRq7yugxepCAvJYfzj5G#NtEKBz5k9i87eda2w$EQfDNa4EOmUFitq6aFOeVIjPVu9aEUCqsiU0p8lehyZwUMGpiWFpEW6n1a1k0TcLRQFPDeLjcTHvXLn2ocyf#rBZ3UQ$JVPYlIVjmyoHlnKPo$YJoPfaEzQdqnRIRgALl$diIFiHoR773b17$Xfp7ESYVyd0ljDEP9lynSi7r9JVldx6jggqvzBEvPYEep#BTVdzu2YsSUoGl$#LludvbRwpo7po3bBsTpTrFcHv5gty1SnEbkNtwHDOFuhbT5hvxT82MiujSYmjvu$zj5n7AqQoF#j2iZBRNYUv3f5JMMVVqKEqhLc$Z9Px4wb3MvUyZUIQMvoxTG$vCid#hOdaFBA8kN8it4ehcvRzMHiv7pbkzfF6VgocB5FRQaCE8eTmZSUmZOnoRj4MN4EEFuDpoPZF7FQJTWlBUxdd$AIKNfOnR8zndQn9hClrPMvi3kkJMUV#f8zqlkrWdnRtC8ljFDsmEZDNdYsU4ulx7A5sj27Pd36poNNapq0szokx4iarp#v2SZxPpv5Sy#obv1uW9uCya#JPpE5SSdX#SjYNjOnMpfFhcVCboVssU2voVg5TmJFACLXStqpEE$DPbhc$cJmNiGWjSsBiEtCtny4ro2hFUXdQMhGNq7BTilgG3t7Ds6vnhBcLXwgffjqlhLrEvncFlUHSJx$PRRm7m7g6lWNnk8prjiqiQzlS4roVeyCpc34diItQo5yFaclQsnSh$oEptrUlxjYs#jneEySM#jhcE7QUeR#dVB7jmyR6iKmarpgndU9vo0bgqZ$PLnyNFcUB#nUPwUY#wykR5PONcFjYnnuCZ6Mchxn5azVFiVk3Fb$C6MuVtC$syNPvRUOEDkVbrkCvckx4LlVfvSJB6TjJdMFu$ArkZksYyHLgsbwqRLfZsqRA9FhJEZYsXoPtcstLwq4CucVklkIjYb7mYYTbMuplU14oYcviwyPoJyKekhFUdUNE$ApUbVNcjCrOJvLjoBPaEuS5v0tKwKTx8srxiWFPaRo9x4JARpXkPZzrQLkGlHGjjAJjhMYX4MqhHKlz7w49ovAjEPVMl0SqPFbsHVkvWtTcCe9h6TkVzcg7roX6ISjdOtoVZoZM9gzKjFZk726ZV3A8a5756YpNKDPcFklvwliu#RjewKidi$ayOP4H8sjnp3KPKvDzrrJbT3AgsWRG3c3xGDg1jFLfw$ji3#QxlCh7EW4sLeog$$PSn$BrYXQPXZuizw6Fxq1a14sfM$WlTMz0CW==");
    private String filename = null;
    private final SortedSet<CompilationProblem> problems = new TreeSet<CompilationProblem>();

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public SortedSet<CompilationProblem> getProblems() {
        return Collections.unmodifiableSortedSet(this.problems);
    }

    public boolean hasProblem() {
        return !this.problems.isEmpty();
    }

    private CompilationError buildError(Symbol symbol, String string) {
        return new CompilationError(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationError buildError(Scanner.Exception exception, String string) {
        return new CompilationError(this.filename, exception.line, exception.column, string);
    }

    private CompilationWarning buildWarning(Symbol symbol, String string) {
        return new CompilationWarning(this.filename, Symbol.getLine(symbol.getStart()), Symbol.getColumn(symbol.getStart()), string);
    }

    private CompilationWarning buildWarning(Scanner.Exception exception, String string) {
        return new CompilationWarning(this.filename, exception.line, exception.column, string);
    }

    private static <T extends ASTNode<?>> List<T> makeListNode(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new List<T>().addAll(list);
    }

    private static <T extends ASTNode<?>> List<T> nullToEmpty(List<T> list) {
        return list == null ? new List() : list;
    }

    private static SingleCharRange makeSingleCharRange(Symbol symbol) {
        SingleCharRange singleCharRange = new SingleCharRange(symbol);
        singleCharRange.acquirePositionFromChildren();
        return singleCharRange;
    }

    private static MultiCharRange makeMultiCharRange(Symbol symbol, Symbol symbol2) {
        MultiCharRange multiCharRange = new MultiCharRange(symbol, symbol2);
        multiCharRange.acquirePositionFromChildren();
        return multiCharRange;
    }

    private Symbol buildComponent(HeaderSection headerSection, RuleSection ruleSection, List<InheritSection> list) {
        Object object;
        StateRef stateRef = null;
        boolean bl = false;
        List<State> list2 = new List<State>();
        LinkedHashSet<StringSymbol> linkedHashSet = new LinkedHashSet<StringSymbol>();
        List<ExternDecl> list3 = new List<ExternDecl>();
        LinkedHashSet<StringSymbol> linkedHashSet2 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet3 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet4 = new LinkedHashSet<StringSymbol>();
        LinkedHashSet<StringSymbol> linkedHashSet5 = new LinkedHashSet<StringSymbol>();
        boolean bl2 = false;
        StringSymbol stringSymbol = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<Iterator<String>> hashSet3 = new HashSet<Iterator<String>>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        HashSet<String> hashSet6 = new HashSet<String>();
        HashSet<String> hashSet7 = new HashSet<String>();
        for (HeaderBlob symbol2 : headerSection.getHeaderBlobs()) {
            if (symbol2 instanceof StartDirective) {
                if (stateRef == null) {
                    stateRef = ((StartDirective)symbol2).getState();
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Start state has already been declared."));
                continue;
            }
            if (symbol2 instanceof HelperDirective) {
                if (bl) {
                    this.problems.add(this.buildWarning(symbol2, "Component has already been flagged as a helper component."));
                }
                bl = true;
                continue;
            }
            if (symbol2 instanceof StateDirective) {
                for (State state : ((StateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of state " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet.add(string);
                }
                continue;
            }
            if (symbol2 instanceof XStateDirective) {
                for (State state : ((XStateDirective)symbol2).getStates()) {
                    String string = state.getName();
                    if (hashSet2.contains(string)) {
                        this.problems.add(this.buildWarning(state, "Duplicate declaration of xstate " + string + "."));
                        continue;
                    }
                    list2.add(state);
                    hashSet2.add(string);
                }
                continue;
            }
            if (symbol2 instanceof ImportDirective) {
                object = ((ImportDirective)symbol2).getText();
                if (hashSet3.contains(object)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate import."));
                    continue;
                }
                linkedHashSet.add(new StringSymbol(symbol2, (String)object));
                hashSet3.add((Iterator<String>)object);
                continue;
            }
            if (symbol2 instanceof ExternDirective) {
                object = ((ExternDirective)symbol2).getExternDecl();
                String string = ((ExternDecl)object).getText();
                if (hashSet4.contains(string)) {
                    this.problems.add(this.buildWarning(symbol2, "Duplicate extern."));
                    continue;
                }
                list3.add((ExternDecl)object);
                hashSet4.add(string);
                continue;
            }
            if (symbol2 instanceof DeclRegion) {
                linkedHashSet2.add(new StringSymbol(symbol2, ((DeclRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof LexThrowDirective) {
                for (String string : ((LexThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of lex exception " + string + "."));
                        continue;
                    }
                    linkedHashSet3.add(new StringSymbol(symbol2, string));
                    hashSet5.add(string);
                }
                continue;
            }
            if (symbol2 instanceof InitRegion) {
                linkedHashSet4.add(new StringSymbol(symbol2, ((InitRegion)symbol2).getText()));
                continue;
            }
            if (symbol2 instanceof InitThrowDirective) {
                for (String string : ((InitThrowDirective)symbol2).getExceptions()) {
                    if (hashSet5.contains(string)) {
                        this.problems.add(this.buildWarning(symbol2, "Duplicate declaration of init exception " + string + "."));
                        continue;
                    }
                    linkedHashSet5.add(new StringSymbol(symbol2, string));
                    hashSet6.add(string);
                }
                continue;
            }
            if (symbol2 instanceof AppendRegion) {
                if (stringSymbol == null) {
                    object = (AppendRegion)symbol2;
                    bl2 = ((AppendRegion)object).getIncludeStartDelimiter();
                    stringSymbol = new StringSymbol((Symbol)object, ((AppendRegion)object).getText());
                    continue;
                }
                this.problems.add(this.buildWarning(symbol2, "Component already has an %append region."));
                continue;
            }
            throw new RuntimeException("Unexpected header blob type: " + symbol2.getClass().getName());
        }
        ComponentDirective componentDirective = headerSection.getComponentDirective();
        Symbol symbol = new Symbol(0, componentDirective.Namestart, componentDirective.Nameend, componentDirective.getName());
        object = new List();
        for (MacroDecl macroDecl : headerSection.getMacroDeclList()) {
            String string = macroDecl.getName();
            if (hashSet7.contains(string)) {
                this.problems.add(this.buildWarning(macroDecl, "Duplicate declaration of macro " + string + "."));
                continue;
            }
            ((List)object).add((MacroDecl)macroDecl);
            hashSet7.add(string);
        }
        Opt<StateRef> opt = stateRef == null ? new Opt<StateRef>() : new Opt<StateRef>(stateRef);
        return new Component(symbol, bl, opt, list2, linkedHashSet, list3, linkedHashSet2, linkedHashSet3, linkedHashSet4, linkedHashSet5, bl2, stringSymbol, (List<MacroDecl>)object, ruleSection, list);
    }

    public ComponentParser() {
        super(PARSING_TABLES);
        this.report = new Events();
    }

    @Override
    protected Symbol invokeReduceAction(int n, int n2) {
        switch (n) {
            case 0: {
                Symbol symbol = this._symbols[n2 + 1];
                Component component = (Component)symbol.value;
                ComponentWrapper componentWrapper = new ComponentWrapper(component);
                componentWrapper.setFilenameOnSubtreeNoTransform(this.filename);
                return componentWrapper;
            }
            case 1: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                return this.buildComponent(headerSection, new RuleSection(new List<RuleGroup>(), new List<RuleGroup>(), new List<RuleGroup>()), new List<InheritSection>());
            }
            case 2: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 3: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 6: {
                Symbol symbol = this._symbols[n2 + 1];
                HeaderSection headerSection = (HeaderSection)symbol.value;
                Symbol symbol2 = this._symbols[n2 + 3];
                RuleSection ruleSection = (RuleSection)symbol2.value;
                Symbol symbol3 = this._symbols[n2 + 4];
                ArrayList arrayList = (ArrayList)symbol3.value;
                InheritSection[] inheritSectionArray = arrayList == null ? new InheritSection[]{} : arrayList.toArray(new InheritSection[arrayList.size()]);
                return this.buildComponent(headerSection, ruleSection, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 7: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 8: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 11: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 12: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 15: {
                Symbol symbol = this._symbols[n2 + 1];
                ComponentDirective componentDirective = (ComponentDirective)symbol.value;
                Symbol symbol4 = this._symbols[n2 + 2];
                ArrayList arrayList = (ArrayList)symbol4.value;
                HeaderBlob[] headerBlobArray = arrayList == null ? new HeaderBlob[]{} : arrayList.toArray(new HeaderBlob[arrayList.size()]);
                Symbol symbol5 = this._symbols[n2 + 3];
                ArrayList arrayList2 = (ArrayList)symbol5.value;
                MacroDecl[] macroDeclArray = arrayList2 == null ? new MacroDecl[]{} : arrayList2.toArray(new MacroDecl[arrayList2.size()]);
                return new HeaderSection(componentDirective, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList2)));
            }
            case 16: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ComponentDirective(symbol);
            }
            case 17: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol6 = this._symbols[n2 + 3];
                Regex regex = (Regex)symbol6.value;
                return new MacroDecl(string, regex);
            }
            case 29: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new DeclRegion(string);
            }
            case 30: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new InitRegion(string);
            }
            case 31: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new AppendRegion(false, string);
            }
            case 32: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new AppendRegion(true, string);
            }
            case 33: {
                return new HelperDirective();
            }
            case 34: {
                Symbol symbol = this._symbols[n2 + 2];
                StateRef stateRef = (StateRef)symbol.value;
                return new StartDirective(stateRef);
            }
            case 35: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new ExternDecl(string);
            }
            case 36: {
                Symbol symbol = this._symbols[n2 + 2];
                ExternDecl externDecl = (ExternDecl)symbol.value;
                return new ExternDirective(externDecl);
            }
            case 37: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new ImportDirective(string);
            }
            case 38: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new InitThrowDirective(list);
            }
            case 39: {
                Symbol symbol = this._symbols[n2 + 2];
                java.util.List list = (java.util.List)symbol.value;
                return new LexThrowDirective(list);
            }
            case 40: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new StateDirective(list);
            }
            case 41: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                return new XStateDirective(list);
            }
            case 42: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                return new Symbol(arrayList);
            }
            case 43: {
                Symbol symbol = this._symbols[n2 + 1];
                java.util.List list = (java.util.List)symbol.value;
                Symbol symbol7 = this._symbols[n2 + 3];
                String string = (String)symbol7.value;
                list.add(string);
                return symbol;
            }
            case 45: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, false);
            }
            case 46: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 47: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol8 = this._symbols[n2 + 3];
                State state = (State)symbol8.value;
                return list.add(state);
            }
            case 48: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new State(symbol, true);
            }
            case 49: {
                Symbol symbol = this._symbols[n2 + 1];
                State state = (State)symbol.value;
                return new List<State>().add(state);
            }
            case 50: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol9 = this._symbols[n2 + 3];
                State state = (State)symbol9.value;
                return list.add(state);
            }
            case 51: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StateRef(symbol);
            }
            case 52: {
                Symbol symbol = this._symbols[n2 + 1];
                StateRef stateRef = (StateRef)symbol.value;
                return new List<StateRef>().add(stateRef);
            }
            case 53: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol10 = this._symbols[n2 + 3];
                StateRef stateRef = (StateRef)symbol10.value;
                return list.add(stateRef);
            }
            case 57: {
                Symbol symbol = this._symbols[n2 + 2];
                List list = (List)symbol.value;
                Symbol symbol11 = this._symbols[n2 + 3];
                Pattern pattern = (Pattern)symbol11.value;
                return new Deletion(list, pattern);
            }
            case 58: {
                Symbol symbol = this._symbols[n2 + 4];
                Pattern pattern = (Pattern)symbol.value;
                return new Deletion(new List<StateRef>(), pattern);
            }
            case 59: {
                Symbol symbol = this._symbols[n2 + 1];
                Rule rule = (Rule)symbol.value;
                return new RuleGroup(new List<StateRef>(), new List<Rule>().add(rule));
            }
            case 60: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 61: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 62: {
                Symbol symbol = this._symbols[n2 + 1];
                List list = (List)symbol.value;
                Symbol symbol12 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol12.value;
                Rule[] ruleArray = arrayList == null ? new Rule[]{} : arrayList.toArray(new Rule[arrayList.size()]);
                return new RuleGroup(list, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)));
            }
            case 65: {
                Symbol symbol = this._symbols[n2 + 1];
                Pattern pattern = (Pattern)symbol.value;
                Symbol symbol13 = this._symbols[n2 + 2];
                String string = (String)symbol13.value;
                Symbol symbol14 = this._symbols[n2 + 3];
                String string2 = (String)symbol14.value;
                return new Rule(pattern, symbol13, symbol14);
            }
            case 69: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, false);
            }
            case 70: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(false, regex, true);
            }
            case 71: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol15 = this._symbols[n2 + 3];
                Regex regex2 = (Regex)symbol15.value;
                return new LookaheadRegexPattern(false, regex, regex2);
            }
            case 72: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, false);
            }
            case 73: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new EOLRegexPattern(true, regex, true);
            }
            case 74: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                Symbol symbol16 = this._symbols[n2 + 4];
                Regex regex3 = (Regex)symbol16.value;
                return new LookaheadRegexPattern(true, regex, regex3);
            }
            case 75: {
                return new AnyPattern();
            }
            case 76: {
                return new EOFPattern();
            }
            case 79: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol17 = this._symbols[n2 + 3];
                Regex regex4 = (Regex)symbol17.value;
                return new AltRegex(regex, regex4);
            }
            case 81: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol18 = this._symbols[n2 + 2];
                Regex regex5 = (Regex)symbol18.value;
                return new SeqRegex(regex, regex5);
            }
            case 83: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new NotRegex(regex);
            }
            case 84: {
                Symbol symbol = this._symbols[n2 + 2];
                Regex regex = (Regex)symbol.value;
                return new UptoRegex(regex);
            }
            case 86: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new OptRegex(regex);
            }
            case 87: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new PlusRegex(regex);
            }
            case 88: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                return new StarRegex(regex);
            }
            case 89: {
                ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                arrayList.add(this._symbols[n2 + 1]);
                return new Symbol(arrayList);
            }
            case 90: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2]);
                return this._symbols[n2 + 1];
            }
            case 93: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol19 = this._symbols[n2 + 4];
                String string = (String)symbol19.value;
                return new RepeatRegex(regex, string);
            }
            case 94: {
                Symbol symbol = this._symbols[n2 + 1];
                Regex regex = (Regex)symbol.value;
                Symbol symbol20 = this._symbols[n2 + 4];
                String string = (String)symbol20.value;
                Symbol symbol21 = this._symbols[n2 + 8];
                String string3 = (String)symbol21.value;
                return new RangeRepeatRegex(regex, string, string3);
            }
            case 98: {
                return new DotRegex();
            }
            case 99: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new StringRegex(string);
            }
            case 100: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new EscapeRegex(string);
            }
            case 101: {
                return new CharRegex("=");
            }
            case 102: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new CharRegex(string);
            }
            case 103: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new MacroInvocationRegex(string);
            }
            case 104: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                return new CharClassRegex(false, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 105: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                return new CharClassRegex(true, new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 106: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol22 = this._symbols[n2 + 4];
                String string4 = (String)symbol22.value;
                return new CharClassRegex(false, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol22)));
            }
            case 107: {
                Symbol symbol = this._symbols[n2 + 3];
                String string = (String)symbol.value;
                Symbol symbol23 = this._symbols[n2 + 5];
                String string5 = (String)symbol23.value;
                return new CharClassRegex(true, new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol23)));
            }
            case 110: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol24 = this._symbols[n2 + 2];
                List list = (List)symbol24.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 111: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol25 = this._symbols[n2 + 3];
                String string6 = (String)symbol25.value;
                Symbol symbol26 = this._symbols[n2 + 4];
                List list = (List)symbol26.value;
                return new CharClassRegex(false, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol25)));
            }
            case 112: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol27 = this._symbols[n2 + 2];
                List list = (List)symbol27.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeSingleCharRange(symbol)));
            }
            case 113: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol28 = this._symbols[n2 + 3];
                String string7 = (String)symbol28.value;
                Symbol symbol29 = this._symbols[n2 + 4];
                List list = (List)symbol29.value;
                return new CharClassRegex(true, list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol28)));
            }
            case 114: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                return new List<SingleCharRange>().add(ComponentParser.makeSingleCharRange(symbol));
            }
            case 115: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol30 = this._symbols[n2 + 3];
                String string8 = (String)symbol30.value;
                return new List<MultiCharRange>().add(ComponentParser.makeMultiCharRange(symbol, symbol30));
            }
            case 116: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol31 = this._symbols[n2 + 2];
                List list = (List)symbol31.value;
                return list.addFirst(ComponentParser.makeSingleCharRange(symbol));
            }
            case 117: {
                Symbol symbol = this._symbols[n2 + 1];
                String string = (String)symbol.value;
                Symbol symbol32 = this._symbols[n2 + 3];
                String string9 = (String)symbol32.value;
                Symbol symbol33 = this._symbols[n2 + 4];
                List list = (List)symbol33.value;
                return list.addFirst(ComponentParser.makeMultiCharRange(symbol, symbol32));
            }
            case 120: {
                return new Symbol("-");
            }
            case 123: {
                return new Symbol("^");
            }
            case 126: {
                return new Symbol("-");
            }
            case 127: {
                return new Symbol("^");
            }
            case 128: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 129: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 132: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), new List<RuleGroup>(), new List<RuleGroup>());
            }
            case 133: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol34 = this._symbols[n2 + 3];
                ArrayList arrayList3 = (ArrayList)symbol34.value;
                RuleGroup[] ruleGroupArray2 = arrayList3 == null ? new RuleGroup[]{} : arrayList3.toArray(new RuleGroup[arrayList3.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList3)), new List<RuleGroup>());
            }
            case 134: {
                Symbol symbol = this._symbols[n2 + 1];
                ArrayList arrayList = (ArrayList)symbol.value;
                RuleGroup[] ruleGroupArray = arrayList == null ? new RuleGroup[]{} : arrayList.toArray(new RuleGroup[arrayList.size()]);
                Symbol symbol35 = this._symbols[n2 + 3];
                ArrayList arrayList4 = (ArrayList)symbol35.value;
                RuleGroup[] ruleGroupArray3 = arrayList4 == null ? new RuleGroup[]{} : arrayList4.toArray(new RuleGroup[arrayList4.size()]);
                Symbol symbol36 = this._symbols[n2 + 5];
                ArrayList arrayList5 = (ArrayList)symbol36.value;
                RuleGroup[] ruleGroupArray4 = arrayList5 == null ? new RuleGroup[]{} : arrayList5.toArray(new RuleGroup[arrayList5.size()]);
                return new RuleSection(ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList4)), ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList5)));
            }
            case 135: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this._symbols[n2 + 1].value);
                return new Symbol(arrayList);
            }
            case 136: {
                ((ArrayList)this._symbols[n2 + 1].value).add(this._symbols[n2 + 2].value);
                return this._symbols[n2 + 1];
            }
            case 139: {
                Symbol symbol = this._symbols[n2 + 2];
                String string = (String)symbol.value;
                Symbol symbol37 = this._symbols[n2 + 3];
                ArrayList arrayList = (ArrayList)symbol37.value;
                Deletion[] deletionArray = arrayList == null ? new Deletion[]{} : arrayList.toArray(new Deletion[arrayList.size()]);
                Symbol symbol38 = this._symbols[n2 + 4];
                RuleSection ruleSection = (RuleSection)symbol38.value;
                return new InheritSection(string, ComponentParser.nullToEmpty(ComponentParser.makeListNode(arrayList)), ruleSection);
            }
            case 4: 
            case 9: 
            case 13: 
            case 63: 
            case 91: 
            case 130: 
            case 137: {
                return new Symbol(null);
            }
            case 5: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 44: 
            case 55: 
            case 56: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 77: 
            case 78: 
            case 80: 
            case 82: 
            case 85: 
            case 92: 
            case 96: 
            case 97: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 131: 
            case 138: {
                return this._symbols[n2 + 1];
            }
            case 54: 
            case 95: 
            case 108: {
                return this._symbols[n2 + 2];
            }
            case 109: {
                return this._symbols[n2 + 3];
            }
        }
        throw new IllegalArgumentException("unknown production #" + n);
    }

    class Events
    extends Parser.Events {
        Events() {
        }

        @Override
        public void syntaxError(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "unexpected token " + Terminals.NAMES[symbol.getId()]));
        }

        @Override
        public void scannerError(Scanner.Exception exception) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(exception, "scanner error: " + exception.getMessage()));
        }

        @Override
        public void unexpectedTokenRemoved(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try deleting " + Terminals.NAMES[symbol.getId()]));
        }

        @Override
        public void missingTokenInserted(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try inserting " + Terminals.NAMES[symbol.getId()]));
        }

        @Override
        public void misspelledTokenReplaced(Symbol symbol) {
            ComponentParser.this.problems.add(ComponentParser.this.buildError(symbol, "try replacing with " + Terminals.NAMES[symbol.getId()]));
        }
    }

    public static class Terminals {
        public static final short EOF = 0;
        public static final short IDENTIFIER = 1;
        public static final short ESCAPE_SEQUENCE = 2;
        public static final short SECTION_SEPARATOR = 3;
        public static final short STRING = 4;
        public static final short ASSIGN = 5;
        public static final short LSQUARE = 6;
        public static final short OPEN_MACRO = 7;
        public static final short LPAREN = 8;
        public static final short NOT = 9;
        public static final short UPTO = 10;
        public static final short DOT = 11;
        public static final short NON_META = 12;
        public static final short DELETE_TERMINATOR = 13;
        public static final short ACTION = 14;
        public static final short IMPORT_DIRECTIVE = 15;
        public static final short DECL_REGION = 16;
        public static final short INIT_REGION = 17;
        public static final short APPEND_REGION = 18;
        public static final short APPEND_WITH_START_DELIM_REGION = 19;
        public static final short HELPER_DIRECTIVE = 20;
        public static final short START_DIRECTIVE = 21;
        public static final short EXTERN_DIRECTIVE = 22;
        public static final short INITTHROW_DIRECTIVE = 23;
        public static final short LEXTHROW_DIRECTIVE = 24;
        public static final short STATE_DIRECTIVE = 25;
        public static final short XSTATE_DIRECTIVE = 26;
        public static final short END_OF_LINE = 27;
        public static final short SLASH = 28;
        public static final short RPAREN = 29;
        public static final short ALT = 30;
        public static final short INHERIT_SECTION_SEPARATOR = 31;
        public static final short BEGINNING_OF_LINE = 32;
        public static final short ANY_PATTERN = 33;
        public static final short EOF_PATTERN = 34;
        public static final short OPEN_REPETITION_SPEC = 35;
        public static final short OPT = 36;
        public static final short PLUS = 37;
        public static final short STAR = 38;
        public static final short COMMA = 39;
        public static final short LANGLE = 40;
        public static final short GROUP_SEPARATOR = 41;
        public static final short CHAR_CLASS_NEGATE = 42;
        public static final short DASH = 43;
        public static final short CHAR_CLASS_CHAR = 44;
        public static final short RSQUARE = 45;
        public static final short OTHER_WHITESPACE = 46;
        public static final short DELETE_DIRECTIVE = 47;
        public static final short NUMBER = 48;
        public static final short CLOSE_REPETITION_SPEC = 49;
        public static final short CLOSE_RULE_GROUP = 50;
        public static final short RANGLE = 51;
        public static final short CLOSE_MACRO = 52;
        public static final short OPEN_RULE_GROUP = 53;
        public static final short QUALIFIED_IDENTIFIER = 54;
        public static final short COMPONENT_DIRECTIVE = 55;
        public static final String[] NAMES = new String[]{"EOF", "IDENTIFIER", "ESCAPE_SEQUENCE", "SECTION_SEPARATOR", "STRING", "ASSIGN", "LSQUARE", "OPEN_MACRO", "LPAREN", "NOT", "UPTO", "DOT", "NON_META", "DELETE_TERMINATOR", "ACTION", "IMPORT_DIRECTIVE", "DECL_REGION", "INIT_REGION", "APPEND_REGION", "APPEND_WITH_START_DELIM_REGION", "HELPER_DIRECTIVE", "START_DIRECTIVE", "EXTERN_DIRECTIVE", "INITTHROW_DIRECTIVE", "LEXTHROW_DIRECTIVE", "STATE_DIRECTIVE", "XSTATE_DIRECTIVE", "END_OF_LINE", "SLASH", "RPAREN", "ALT", "INHERIT_SECTION_SEPARATOR", "BEGINNING_OF_LINE", "ANY_PATTERN", "EOF_PATTERN", "OPEN_REPETITION_SPEC", "OPT", "PLUS", "STAR", "COMMA", "LANGLE", "GROUP_SEPARATOR", "CHAR_CLASS_NEGATE", "DASH", "CHAR_CLASS_CHAR", "RSQUARE", "OTHER_WHITESPACE", "DELETE_DIRECTIVE", "NUMBER", "CLOSE_REPETITION_SPEC", "CLOSE_RULE_GROUP", "RANGLE", "CLOSE_MACRO", "OPEN_RULE_GROUP", "QUALIFIED_IDENTIFIER", "COMPONENT_DIRECTIVE"};
    }
}

