/*
 * Decompiled with CFR 0.152.
 */
package metalexer.ast;

import java.io.IOException;
import java.io.PrintWriter;
import metalexer.PatternType;
import metalexer.ast.ASTNode;
import metalexer.ast.Component;
import metalexer.ast.List;
import metalexer.ast.Rule;
import metalexer.ast.StateRef;

public class RuleGroup
extends ASTNode<ASTNode>
implements Cloneable {
    protected int getComponent_visited = -1;
    protected int lookupInclusiveStates_visited = -1;
    protected int getPatternType_visited = -1;

    @Override
    public void flushCache() {
        super.flushCache();
        this.getComponent_visited = -1;
        this.lookupInclusiveStates_visited = -1;
        this.getPatternType_visited = -1;
    }

    @Override
    public RuleGroup clone() throws CloneNotSupportedException {
        RuleGroup ruleGroup = (RuleGroup)super.clone();
        ruleGroup.getComponent_visited = -1;
        ruleGroup.lookupInclusiveStates_visited = -1;
        ruleGroup.getPatternType_visited = -1;
        ruleGroup.in$Circle(false);
        ruleGroup.is$Final(false);
        return ruleGroup;
    }

    public RuleGroup copy() {
        try {
            RuleGroup ruleGroup = this.clone();
            if (this.children != null) {
                ruleGroup.children = (ASTNode[])this.children.clone();
            }
            return ruleGroup;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public RuleGroup fullCopy() {
        RuleGroup ruleGroup = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object object = this.getChildNoTransform(i);
            if (object != null) {
                object = ((ASTNode)object).fullCopy();
            }
            ruleGroup.setChild(object, i);
        }
        return ruleGroup;
    }

    void generateMetaLexer(PrintWriter printWriter) throws IOException {
        if (this.getStates().isEmpty()) {
            for (Rule rule : this.getRules()) {
                rule.generateMetaLexer(printWriter);
            }
        } else {
            printWriter.print("<");
            boolean bl = true;
            for (StateRef aSTNode : this.getStates()) {
                if (!bl) {
                    printWriter.print(", ");
                }
                printWriter.print(aSTNode.getName());
                bl = false;
            }
            printWriter.println("> {");
            for (Rule rule : this.getRules()) {
                rule.generateMetaLexer(printWriter);
            }
            printWriter.println("}");
            printWriter.println();
        }
    }

    public RuleGroup() {
        this.setChild(new List(), 0);
        this.setChild(new List(), 1);
    }

    public RuleGroup(List<StateRef> list, List<Rule> list2) {
        this.setChild(list, 0);
        this.setChild(list2, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setStateList(List<StateRef> list) {
        this.setChild(list, 0);
    }

    public int getNumState() {
        return this.getStateList().getNumChild();
    }

    public StateRef getState(int n) {
        return (StateRef)this.getStateList().getChild(n);
    }

    public void addState(StateRef stateRef) {
        List<StateRef> list = this.getStateList();
        list.addChild(stateRef);
    }

    public void setState(StateRef stateRef, int n) {
        List<StateRef> list = this.getStateList();
        list.setChild(stateRef, n);
    }

    public List<StateRef> getStates() {
        return this.getStateList();
    }

    public List<StateRef> getStatesNoTransform() {
        return this.getStateListNoTransform();
    }

    public List<StateRef> getStateList() {
        return (List)this.getChild(0);
    }

    public List<StateRef> getStateListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setRuleList(List<Rule> list) {
        this.setChild(list, 1);
    }

    public int getNumRule() {
        return this.getRuleList().getNumChild();
    }

    public Rule getRule(int n) {
        return (Rule)this.getRuleList().getChild(n);
    }

    public void addRule(Rule rule) {
        List<Rule> list = this.getRuleList();
        list.addChild(rule);
    }

    public void setRule(Rule rule, int n) {
        List<Rule> list = this.getRuleList();
        list.setChild(rule, n);
    }

    public List<Rule> getRules() {
        return this.getRuleList();
    }

    public List<Rule> getRulesNoTransform() {
        return this.getRuleListNoTransform();
    }

    public List<Rule> getRuleList() {
        return (List)this.getChild(1);
    }

    public List<Rule> getRuleListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public Component getComponent() {
        if (this.getComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getComponent in class: ");
        }
        this.getComponent_visited = this.state().boundariesCrossed;
        Component component = this.getParent().Define_Component_getComponent(this, null);
        this.getComponent_visited = -1;
        return component;
    }

    public List<StateRef> lookupInclusiveStates() {
        if (this.lookupInclusiveStates_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: lookupInclusiveStates in class: ");
        }
        this.lookupInclusiveStates_visited = this.state().boundariesCrossed;
        List<StateRef> list = this.getParent().Define_List_StateRef__lookupInclusiveStates(this, null);
        this.lookupInclusiveStates_visited = -1;
        return list;
    }

    public PatternType getPatternType() {
        if (this.getPatternType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attr: getPatternType in class: ");
        }
        this.getPatternType_visited = this.state().boundariesCrossed;
        PatternType patternType = this.getParent().Define_metalexer_PatternType_getPatternType(this, null);
        this.getPatternType_visited = -1;
        return patternType;
    }

    @Override
    public PatternType Define_metalexer_PatternType_getGroupPatternType(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == this.getRuleListNoTransform()) {
            int n = aSTNode.getIndexOfChild(aSTNode2);
            return this.getPatternType();
        }
        return this.getParent().Define_metalexer_PatternType_getGroupPatternType(this, aSTNode);
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.getStates().isEmpty()) {
            ++this.state().duringImpliedStates;
            RuleGroup ruleGroup = this.rewriteRule0();
            --this.state().duringImpliedStates;
            return ruleGroup;
        }
        return super.rewriteTo();
    }

    private RuleGroup rewriteRule0() {
        this.setStateList(this.lookupInclusiveStates());
        return this;
    }
}

