/*
 * Decompiled with CFR 0.152.
 */
package ast.AST;

import ast.AST.ASTDecl;
import ast.AST.ASTNode;
import ast.AST.Ast;
import ast.AST.AstVisitor;
import ast.AST.Components;
import ast.AST.Node;
import ast.AST.TokenId;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TokenComponent
extends Components
implements Cloneable {
    private boolean called = false;
    protected boolean constrParmType_visited = false;
    protected boolean name_visited = false;
    protected boolean type_visited = false;

    public void flushCache() {
        super.flushCache();
        this.constrParmType_visited = false;
        this.name_visited = false;
        this.type_visited = false;
    }

    public Object clone() throws CloneNotSupportedException {
        TokenComponent node = (TokenComponent)super.clone();
        node.constrParmType_visited = false;
        node.name_visited = false;
        node.type_visited = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode copy() {
        try {
            TokenComponent node = (TokenComponent)this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode fullCopy() {
        TokenComponent res = (TokenComponent)this.copy();
        int i = 0;
        while (i < this.getNumChild()) {
            ASTNode node = this.getChildNoTransform(i);
            if (node != null) {
                node = node.fullCopy();
            }
            res.setChild(node, i);
            ++i;
        }
        return res;
    }

    public boolean declared() {
        return true;
    }

    public void jaddGen(PrintWriter stream, int index, boolean publicModifier, ASTDecl decl) {
        String name = decl.name();
        StringBuffer buf = new StringBuffer();
        buf.append("    // Declared in " + this.hostClass().getFileName() + " line " + this.hostClass().getStartLine() + "\n");
        if (decl.redefinesTokenComponent(this)) {
            buf.append("    protected #TYPE# #HOST#.token#TYPEINSIGNATURE#_#ID#;\n");
        }
        buf.append("    public void #HOST#.set#ID#(#TYPE# value) {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + "        token#TYPEINSIGNATURE#_#ID# = value;\n" + (ASTNode.block ? ASTNode.blockEnd : "") + "    }\n");
        if (!this.isNTA()) {
            boolean isStringToken;
            boolean bl = isStringToken = this.getTokenId().getTYPE().equals("String") || this.getTokenId().getTYPE().equals("java.lang.String");
            if (isStringToken && ASTNode.beaver) {
                if (decl.redefinesTokenComponent(this)) {
                    buf.append("    public int #HOST#.#ID#start;\n    public int #HOST#.#ID#end;\n");
                }
                buf.append("    public void #HOST#.set#ID#(beaver.Symbol symbol) {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + "        if(symbol.value != null && !(symbol.value instanceof String))\n" + "          throw new UnsupportedOperationException(\"set#ID# is only valid for String lexemes\");\n" + "        token#TYPEINSIGNATURE#_#ID# = (String)symbol.value;\n" + "        #ID#start = symbol.getStart();\n" + "        #ID#end = symbol.getEnd();\n" + (ASTNode.block ? ASTNode.blockEnd : "") + "    }\n");
            }
            if (isStringToken) {
                buf.append("    public #TYPE# #HOST#.get#ID#() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + "        return token#TYPEINSIGNATURE#_#ID# != null ? token#TYPEINSIGNATURE#_#ID# : \"\";\n" + (ASTNode.block ? ASTNode.blockEnd : "") + "    }\n\n");
            } else {
                buf.append("    public #TYPE# #HOST#.get#ID#() {\n" + (ASTNode.block ? ASTNode.blockBegin : "") + "        return token#TYPEINSIGNATURE#_#ID#;\n" + (ASTNode.block ? ASTNode.blockEnd : "") + "    }\n\n");
            }
        }
        String s = buf.toString();
        s = s.replaceAll("#ID#", this.getTokenId().getID());
        s = s.replaceAll("#TYPE#", this.getTokenId().getTYPE());
        s = s.replaceAll("#TYPEINSIGNATURE#", ASTNode.convTypeNameToSignature(this.getTokenId().getTYPE()));
        s = s.replaceAll("#HOST#", name);
        if (!publicModifier) {
            s = s.replaceAll("    public ", "    private ");
        }
        this.parse(s);
    }

    public TokenComponent(int i) {
        super(i);
    }

    public TokenComponent(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public TokenComponent() {
        this(0);
        this.setChild(null, 0);
    }

    public TokenComponent(TokenId p0) {
        this.setChild(p0, 0);
    }

    public void dumpTree(String indent, PrintStream pStream) {
        pStream.println(String.valueOf(indent) + "TokenComponent");
        String childIndent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.getNumChild()) {
            this.getChild(i).dumpTree(childIndent, pStream);
            ++i;
        }
    }

    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
        if (i == 0 && !(n instanceof TokenId)) {
            throw new Error("Child number 0 of TokenComponent has the type " + n.getClass().getName() + " which is not an instance of TokenId");
        }
    }

    public int getNumChild() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTokenId(TokenId node) {
        this.setChild(node, 0);
    }

    public TokenId getTokenId() {
        return (TokenId)this.getChild(0);
    }

    public TokenId getTokenIdNoTransform() {
        return (TokenId)this.getChildNoTransform(0);
    }

    public String constrParmType() {
        boolean interruptedCircle = false;
        if (this.constrParmType_visited) {
            throw new RuntimeException("Circular definition of attr: constrParmType in class: ");
        }
        this.constrParmType_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String constrParmType_value = this.constrParmType_compute();
        this.constrParmType_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return constrParmType_value;
    }

    private String constrParmType_compute() {
        return this.getTokenId().getTYPE();
    }

    public String name() {
        boolean interruptedCircle = false;
        if (this.name_visited) {
            throw new RuntimeException("Circular definition of attr: name in class: ");
        }
        this.name_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String name_value = this.name_compute();
        this.name_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return name_value;
    }

    private String name_compute() {
        return this.getTokenId().name();
    }

    public String type() {
        boolean interruptedCircle = false;
        if (this.type_visited) {
            throw new RuntimeException("Circular definition of attr: type in class: ");
        }
        this.type_visited = true;
        if (ASTNode.IN_CIRCLE) {
            interruptedCircle = true;
            ASTNode.IN_CIRCLE = false;
            this.pushEvalStack();
        }
        String type_value = this.type_compute();
        this.type_visited = false;
        if (interruptedCircle) {
            ASTNode.IN_CIRCLE = true;
            this.popEvalStack();
        }
        return type_value;
    }

    private String type_compute() {
        return this.getTokenId().type();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

