/*
 * Decompiled with CFR 0.152.
 */
package beaver;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public final class ParsingTables {
    private final short[] actions;
    final short[] lookaheads;
    final int[] actn_offsets;
    private final int[] goto_offsets;
    private final short[] default_actions;
    final int[] rule_infos;
    final short error_symbol_id;
    final boolean compressed;
    final int n_term;
    static final int UNUSED_OFFSET = Integer.MIN_VALUE;

    public ParsingTables(Class impl_class) {
        this(ParsingTables.getSpecAsResourceStream(impl_class));
    }

    public ParsingTables(String spec) {
        this(new ByteArrayInputStream(ParsingTables.decode(spec)));
    }

    private ParsingTables(InputStream in) {
        try {
            DataInputStream data = new DataInputStream(new InflaterInputStream(in));
            try {
                int len = data.readInt();
                this.actions = new short[len];
                int i = 0;
                while (i < len) {
                    this.actions[i] = data.readShort();
                    ++i;
                }
                this.lookaheads = new short[len];
                i = 0;
                while (i < len) {
                    this.lookaheads[i] = data.readShort();
                    ++i;
                }
                len = data.readInt();
                this.actn_offsets = new int[len];
                i = 0;
                while (i < len) {
                    this.actn_offsets[i] = data.readInt();
                    ++i;
                }
                this.goto_offsets = new int[len];
                i = 0;
                while (i < len) {
                    this.goto_offsets[i] = data.readInt();
                    ++i;
                }
                len = data.readInt();
                boolean bl = this.compressed = len != 0;
                if (this.compressed) {
                    this.default_actions = new short[len];
                    i = 0;
                    while (i < len) {
                        this.default_actions[i] = data.readShort();
                        ++i;
                    }
                } else {
                    this.default_actions = null;
                }
                int min_nt_id = Integer.MAX_VALUE;
                len = data.readInt();
                this.rule_infos = new int[len];
                int i2 = 0;
                while (i2 < len) {
                    this.rule_infos[i2] = data.readInt();
                    min_nt_id = Math.min(min_nt_id, this.rule_infos[i2] >>> 16);
                    ++i2;
                }
                this.n_term = min_nt_id;
                this.error_symbol_id = data.readShort();
            }
            finally {
                data.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot initialize parser tables: " + e.getMessage());
        }
    }

    final short findFirstTerminal(int state) {
        int offset = this.actn_offsets[state];
        short term_id = offset < 0 ? (short)(-offset) : (short)0;
        while (term_id < this.n_term) {
            int index = offset + term_id;
            if (index >= this.lookaheads.length) break;
            if (this.lookaheads[index] == term_id) {
                return term_id;
            }
            term_id = (short)(term_id + 1);
        }
        return -1;
    }

    final short findParserAction(int state, short lookahead) {
        int index = this.actn_offsets[state];
        if (index != Integer.MIN_VALUE && (index += lookahead) >= 0 && index < this.actions.length && this.lookaheads[index] == lookahead) {
            return this.actions[index];
        }
        return this.compressed ? this.default_actions[state] : (short)0;
    }

    final short findNextState(int state, short lookahead) {
        int index = this.goto_offsets[state];
        if (index != Integer.MIN_VALUE && (index += lookahead) >= 0 && index < this.actions.length && this.lookaheads[index] == lookahead) {
            return this.actions[index];
        }
        return this.compressed ? this.default_actions[state] : (short)0;
    }

    static byte[] decode(String spec) {
        int acc;
        char[] chars = spec.toCharArray();
        if (chars.length % 4 != 0) {
            throw new IllegalArgumentException("corrupted encoding");
        }
        int len = chars.length / 4 * 3;
        byte[] bytes = new byte[chars[chars.length - 1] == '=' ? (chars[chars.length - 2] == '=' ? len - 2 : len - 1) : len];
        len -= 3;
        int ci = 0;
        int bi = 0;
        while (bi < len) {
            acc = ParsingTables.decode(chars[ci++]) << 18 | ParsingTables.decode(chars[ci++]) << 12 | ParsingTables.decode(chars[ci++]) << 6 | ParsingTables.decode(chars[ci++]);
            bytes[bi++] = (byte)(acc >> 16);
            bytes[bi++] = (byte)(acc >> 8 & 0xFF);
            bytes[bi++] = (byte)(acc & 0xFF);
        }
        acc = ParsingTables.decode(chars[ci++]) << 18 | ParsingTables.decode(chars[ci++]) << 12 | ParsingTables.decode(chars[ci++]) << 6 | ParsingTables.decode(chars[ci++]);
        bytes[bi++] = (byte)(acc >> 16);
        if (bi < bytes.length) {
            bytes[bi++] = (byte)(acc >> 8 & 0xFF);
            if (bi < bytes.length) {
                bytes[bi++] = (byte)(acc & 0xFF);
            }
        }
        return bytes;
    }

    static int decode(char c) {
        if (c <= '9') {
            if (c >= '0') {
                return c - 48;
            }
            if (c == '#') {
                return 62;
            }
            if (c == '$') {
                return 63;
            }
        } else if (c <= 'Z') {
            if (c >= 'A') {
                return c - 65 + 10;
            }
            if (c == '=') {
                return 0;
            }
        } else if ('a' <= c && c <= 'z') {
            return c - 97 + 36;
        }
        throw new IllegalStateException("illegal encoding character '" + c + "'");
    }

    static InputStream getSpecAsResourceStream(Class impl_class) {
        String name = impl_class.getName();
        InputStream spec_stream = impl_class.getResourceAsStream(name = String.valueOf(name.substring(name.lastIndexOf(46) + 1)) + ".spec");
        if (spec_stream == null) {
            throw new IllegalStateException("parser specification not found");
        }
        return spec_stream;
    }
}

