import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

import metalexer.CompilationError;
import metalexer.FileLoader;
import metalexer.ast.Layout;

public class SyntaxChecker {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java SyntaxChecker {basedir} {basename}");
            System.exit(1);
        }
        String basedir = args[0];
        String basename = args[1];
        System.out.println("Checking " + basename + " in " + basedir);
        SortedSet<CompilationError> errors = new TreeSet<CompilationError>();
        try {
            FileLoader loader = new FileLoader(basedir);
            Layout actual = loader.loadLayout(basename, errors);
            if(actual != null) {
                actual = actual.processInheritance(loader, errors);
                if(actual.getHelper()) {
                    errors.add(actual.makeCompilationError(actual.getName() + " is a helper layout."));
                }
            }
        } catch(IOException e) {
            errors.add(new CompilationError(null, e.getMessage()));
        }
        if(errors.isEmpty()) {
            System.out.println("VALID");
        } else {
            for(CompilationError error : errors) {
                System.out.println(error);
            }
        }
    }
}
