//TODO-AC: combine with ReturnWrap?

package metalexer.jflex;

import java.io.IOException;
import java.io.StringReader;

import java.util.ArrayList;
import java.util.List;

%%

//general header info
%public
%final
%class StaticFind

%line
%column

%unicode
%function findStaticKeywords
%type void

%{
    public class Position {
        private int line;
        private int col;
        
        private Position() {
            line = yyline + baseLine;
            col = yycolumn + ((yyline == 0) ? baseCol : 1);
        }
        
        public int getLine() {
            return line;
        }
        
        public int getColumn() {
            return col;
        }
    }
%}

%{
    private int baseLine = 0; //1-indexed
    private int baseCol = 0;  //1-indexed
    
    private final List<Position> positions = new ArrayList<Position>();
%}

%{
    public static List<Position> findStaticKeywords(int baseLine, int baseCol, String code) {
        StringReader reader = new StringReader(code);
        StaticFind scanner = new StaticFind(reader);
        scanner.baseLine = baseLine;
        scanner.baseCol = baseCol;
        try {
            scanner.findStaticKeywords();
            reader.close();
        } catch(IOException e) {
            //can't happen since StringReader
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return scanner.positions;
    }
%}

%{
    private int depth = 0;
%}

Any = . | \n

StartSLC = "//"
EndSLC = \r | \n | \r\n

StartMLC = "/*"
EndMLC = "*/"

StartString = \"
EndString = \"

%xstate SINGLE_LINE_COMMENT
%xstate MULTI_LINE_COMMENT
%xstate STRING

%%

{StartSLC} { yybegin(SINGLE_LINE_COMMENT); }

//NB: don't check for return stmts in comments
<SINGLE_LINE_COMMENT> {
    {EndSLC} { yybegin(YYINITIAL); }
    {Any} { }
    <<EOF>> { return; }
}

{StartMLC} { yybegin(MULTI_LINE_COMMENT); depth++; }

//NB: don't check for return stmts in comments
<MULTI_LINE_COMMENT> {
    {StartMLC} { depth++; }
    {EndMLC} { depth--; if(depth == 0) { yybegin(YYINITIAL); } }
    {Any} { }
    <<EOF>> { return; }
}

{StartString} { yybegin(STRING); }

//NB: don't check for return stmts in strings
<STRING> {
    \\\" { }
    {EndString} { yybegin(YYINITIAL); }
    {Any} { }
    <<EOF>> { return; }
}

static [:jletterdigit:] { /* skip */ }
static { positions.add(new Position()); }

{Any} { /* skip */ }

<<EOF>> { return; }
