package metalexer;

import java.io.*;

%%

//general header info
%public
%final
%class StringEval

%unicode
%function process
%type String

%{
    private StringBuffer buf = new StringBuffer();
%}

%{
    //string leading and trailing quotation marks
    public static String stripQuotes(String original) {
        return original.substring(1, original.length() - 1);
    }
    
    //replace escape sequences with the corresponding characters
    public static String evalString(String original) {
        original = stripQuotes(original);
        StringReader reader = new StringReader(original);
        StringEval scanner = new StringEval(reader);
        String result = null;
        try {
            result = scanner.process();
            reader.close();
        } catch(IOException e) {
            //can't happen since StringReader
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }
%}

HexDigit = [0-9A-Fa-f]

%%

(\\u{HexDigit}{1, 4}) | (\\x{HexDigit}{2}) {
    String hexString = yytext().substring(2);
    int hexNum = Integer.parseInt(hexString, 16);
    char ch = (char) hexNum;
    buf.append(ch);
}

\\[0-3]?[0-7]?[0-7] {
    String octalString = yytext().substring(1);
    int octalNum = Integer.parseInt(octalString, 8);
    char ch = (char) octalNum;
    buf.append(ch);
}

\\ (n|\n) { buf.append("\n"); }
\\ (r|\r) { buf.append("\r"); }
\\t { buf.append("\t"); }
\\f { buf.append("\f"); }
\\b { buf.append("\b"); }

\\ (. | \n) { buf.append(yytext().substring(1)); }
(. | \n) { buf.append(yytext()); }

<<EOF>> { return buf.toString(); }