/* The following code was generated by JFlex 1.4.1 on 1/19/09 1:48 PM */

//TODO-AC: many of the catchall errors are recoverable - either return a bad token which will be discarded or just discard and make a note.
//based on http://jflex.de/manual.html

package metalexer;

import static metalexer.ComponentParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 1/19/09 1:48 PM from the specification file
 * <tt>/Users/amcasey/Research/metalexer/src/frontend/component.flex</tt>
 */
public final class ComponentScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int INSIDE_APPEND_REGION = 14;
  public static final int INSIDE_DELETE_ANGLE_BRACKETS = 30;
  public static final int INSIDE_ANGLE_BRACKETS = 22;
  public static final int INSIDE_BRACKET_COMMENT = 6;
  public static final int INSIDE_INIT_REGION = 12;
  public static final int INSIDE_DECL_REGION = 10;
  public static final int INSIDE_ACTION = 20;
  public static final int INSIDE_RULE_SECTION = 4;
  public static final int INSIDE_OPEN_RULE_GROUP = 34;
  public static final int INSIDE_MACRO = 16;
  public static final int INSIDE_STRING = 8;
  public static final int INSIDE_STRING_DIRECTIVE = 26;
  public static final int INSIDE_HEADER_SECTION = 2;
  public static final int INSIDE_META_TOKEN = 32;
  public static final int INSIDE_CHARACTER_CLASS = 36;
  public static final int INSIDE_REPETITION_SPEC = 18;
  public static final int YYINITIAL = 0;
  public static final int INSIDE_IDENTIFIER_DIRECTIVE = 24;
  public static final int INSIDE_DELETE_DIRECTIVE = 28;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  2,  3,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,  9, 
    10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 
    18, 18, 19, 19, 20, 20
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\2\1\0\1\3\1\1\22\0\1\3\1\57\1\12"+
    "\1\0\1\56\1\10\2\0\1\51\1\52\1\25\1\61\1\41\1\63"+
    "\1\23\1\24\1\7\3\21\4\22\2\5\1\11\1\0\1\37\1\65"+
    "\1\40\1\62\1\0\1\66\3\13\1\71\1\73\7\4\1\67\1\72"+
    "\11\4\1\70\1\4\1\53\1\14\1\54\1\55\1\6\1\0\1\33"+
    "\1\16\1\44\1\36\1\35\1\16\1\4\1\42\1\30\2\4\1\43"+
    "\1\46\1\31\1\45\1\34\1\4\1\15\1\47\1\32\1\20\1\4"+
    "\1\50\1\17\2\4\1\26\1\64\1\27\1\60\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\25\0\1\1\1\2\2\3\1\2\1\4\1\5\1\6"+
    "\1\7\1\10\3\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\3\1\27\1\30\1\2\1\11\1\31\1\32\1\3"+
    "\1\2\3\33\1\34\2\35\1\36\1\37\3\34\1\40"+
    "\2\41\1\42\1\43\2\44\1\45\1\46\2\34\2\47"+
    "\1\50\1\51\2\52\1\51\2\53\2\54\1\55\1\56"+
    "\2\57\2\60\1\61\1\62\1\5\1\63\1\64\1\65"+
    "\2\0\1\66\2\67\2\66\1\67\1\70\1\71\6\0"+
    "\1\30\1\72\10\0\1\73\1\74\3\0\1\75\1\76"+
    "\1\77\1\34\2\77\1\34\1\0\1\100\4\0\1\101"+
    "\3\102\3\0\1\67\1\0\1\103\1\104\17\0\1\34"+
    "\6\0\1\67\17\0\1\34\6\0\1\67\16\0\1\34"+
    "\4\0\1\105\13\0\1\106\1\107\2\0\1\110\3\0"+
    "\1\111\1\112\1\113\1\0\1\114\1\115\1\116\2\0"+
    "\1\106\1\0\1\107\5\0\1\117\1\113\2\0\1\114"+
    "\1\0\1\115\1\0\1\116\5\0\1\120\1\0\1\121"+
    "\1\0\1\122\1\123\1\124\1\121\1\0\1\125\1\124"+
    "\1\0\1\125\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[286];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u0168\0\u01a4"+
    "\0\u01e0\0\u021c\0\u0258\0\u0294\0\u02d0\0\u030c\0\u0348\0\u0384"+
    "\0\u03c0\0\u03fc\0\u0438\0\u0474\0\u04b0\0\u04ec\0\u04ec\0\u0528"+
    "\0\u04ec\0\u0564\0\u04ec\0\u05a0\0\u04ec\0\u05dc\0\u04ec\0\u0618"+
    "\0\u04ec\0\u0654\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u04ec\0\u0690"+
    "\0\u06cc\0\u0708\0\u0744\0\u0780\0\u04ec\0\u0654\0\u07bc\0\u07f8"+
    "\0\u04ec\0\u0834\0\u0870\0\u04ec\0\u08ac\0\u04ec\0\u04ec\0\u08e8"+
    "\0\u0924\0\u0960\0\u099c\0\u04ec\0\u09d8\0\u04ec\0\u04ec\0\u04ec"+
    "\0\u0a14\0\u04ec\0\u04ec\0\u04ec\0\u0a50\0\u0a8c\0\u04ec\0\u05dc"+
    "\0\u04ec\0\u04ec\0\u0ac8\0\u04ec\0\u05dc\0\u04ec\0\u05dc\0\u0b04"+
    "\0\u04ec\0\u0654\0\u04ec\0\u04ec\0\u05dc\0\u04ec\0\u05dc\0\u04ec"+
    "\0\u04ec\0\u0b40\0\u04ec\0\u04ec\0\u04ec\0\u0b7c\0\u0bb8\0\u04ec"+
    "\0\u0bf4\0\u04ec\0\u0c30\0\u0c6c\0\u0ca8\0\u0ce4\0\u04ec\0\u0618"+
    "\0\u0d20\0\u0d5c\0\u0d98\0\u0dd4\0\u0690\0\u0e10\0\u04ec\0\u0e4c"+
    "\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c\0\u0f78\0\u0fb4\0\u0ff0\0\u04ec"+
    "\0\u04ec\0\u07bc\0\u102c\0\u1068\0\u04ec\0\u04ec\0\u04ec\0\u10a4"+
    "\0\u10e0\0\u111c\0\u1158\0\u1194\0\u04ec\0\u11d0\0\u120c\0\u1248"+
    "\0\u1284\0\u04ec\0\u04ec\0\u0c30\0\u0c6c\0\u12c0\0\u12fc\0\u1338"+
    "\0\u1374\0\u13b0\0\u04ec\0\u04ec\0\u13ec\0\u1428\0\u1464\0\u14a0"+
    "\0\u14dc\0\u1518\0\u1554\0\u1590\0\u15cc\0\u1608\0\u1644\0\u1680"+
    "\0\u16bc\0\u16f8\0\u1734\0\u1770\0\u17ac\0\u17e8\0\u1824\0\u1860"+
    "\0\u189c\0\u18d8\0\u1914\0\u1950\0\u198c\0\u19c8\0\u1a04\0\u1a40"+
    "\0\u1a7c\0\u1ab8\0\u1af4\0\u1b30\0\u1b6c\0\u1ba8\0\u1be4\0\u1c20"+
    "\0\u1c5c\0\u1c98\0\u1cd4\0\u1d10\0\u1d4c\0\u1d88\0\u1dc4\0\u1e00"+
    "\0\u1e3c\0\u1338\0\u1e78\0\u1eb4\0\u1ef0\0\u1f2c\0\u1f68\0\u1fa4"+
    "\0\u1fe0\0\u201c\0\u2058\0\u2094\0\u20d0\0\u210c\0\u2148\0\u2184"+
    "\0\u1734\0\u21c0\0\u21fc\0\u2238\0\u2274\0\u04ec\0\u22b0\0\u22ec"+
    "\0\u2328\0\u2364\0\u23a0\0\u23dc\0\u2418\0\u2454\0\u2490\0\u24cc"+
    "\0\u2508\0\u2544\0\u2580\0\u25bc\0\u25f8\0\u04ec\0\u2634\0\u2670"+
    "\0\u26ac\0\u04ec\0\u04ec\0\u26e8\0\u2724\0\u2760\0\u279c\0\u27d8"+
    "\0\u2814\0\u2850\0\u288c\0\u288c\0\u28c8\0\u28c8\0\u2904\0\u2940"+
    "\0\u297c\0\u29b8\0\u04ec\0\u29f4\0\u29f4\0\u2a30\0\u2a6c\0\u2a6c"+
    "\0\u2aa8\0\u2aa8\0\u2ae4\0\u2ae4\0\u2b20\0\u2b5c\0\u2b98\0\u2bd4"+
    "\0\u04ec\0\u2c10\0\u2c4c\0\u2c88\0\u04ec\0\u04ec\0\u2cc4\0\u2d00"+
    "\0\u2d00\0\u2d3c\0\u2d78\0\u2d78\0\u2db4\0\u2db4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[286];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\74\26\1\27\1\30\2\31\4\27\1\32\1\27\1\33"+
    "\1\27\1\34\6\27\1\35\1\36\1\37\1\40\1\41"+
    "\7\27\1\42\1\41\10\27\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\7\27\1\30\1\31\1\60\1\61\3\27\1\62"+
    "\1\27\1\33\1\61\1\34\4\61\2\27\1\35\1\36"+
    "\1\37\1\40\1\41\7\61\1\42\1\41\1\27\7\61"+
    "\1\43\1\44\1\45\1\46\1\47\1\50\1\51\1\52"+
    "\1\53\1\54\1\55\1\56\1\57\6\61\1\27\1\30"+
    "\2\31\4\27\1\63\1\27\1\33\1\27\1\34\6\27"+
    "\1\35\1\36\1\37\1\64\1\65\7\27\1\66\1\41"+
    "\10\27\1\43\1\44\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\7\27\1\30"+
    "\1\31\1\67\4\27\1\70\1\27\1\33\1\27\1\34"+
    "\6\27\1\35\1\36\1\37\1\64\1\65\7\27\1\66"+
    "\1\41\10\27\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\57\6\27"+
    "\24\71\1\72\1\73\46\71\1\74\1\75\1\76\7\74"+
    "\1\77\1\74\1\100\67\74\1\101\73\74\1\102\73\74"+
    "\1\103\63\74\1\104\1\105\2\106\1\61\6\104\1\61"+
    "\1\104\4\61\6\104\1\107\7\61\3\104\7\61\15\104"+
    "\6\61\1\110\1\105\2\106\1\110\1\111\1\110\1\112"+
    "\11\110\2\111\4\110\1\113\11\110\1\114\32\110\10\74"+
    "\1\115\1\116\62\74\1\117\1\30\2\31\1\61\6\117"+
    "\1\61\1\117\4\61\3\117\1\120\3\117\7\61\1\117"+
    "\1\121\1\114\7\61\15\117\6\61\1\122\1\123\1\124"+
    "\1\31\1\61\6\122\1\61\1\122\4\61\3\122\1\125"+
    "\3\122\7\61\2\122\1\114\7\61\15\122\6\61\1\126"+
    "\1\123\1\124\1\31\6\126\1\33\11\126\1\127\14\126"+
    "\1\114\32\126\1\27\1\130\1\131\1\31\6\27\1\33"+
    "\1\27\1\34\6\27\1\35\1\36\1\37\1\40\1\41"+
    "\7\27\1\132\1\41\10\27\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\6\27\1\117\1\30\2\31\1\61\6\117\1\61"+
    "\1\117\4\61\3\117\1\120\3\117\7\61\1\117\1\133"+
    "\1\114\7\61\15\117\6\61\1\134\1\123\1\124\1\31"+
    "\1\61\6\134\1\61\1\134\4\61\3\134\1\135\3\134"+
    "\7\61\3\134\7\61\15\134\6\61\1\136\1\30\2\31"+
    "\20\136\1\137\1\136\1\140\45\136\14\141\1\142\37\141"+
    "\1\143\1\144\5\141\1\55\10\141\76\0\1\31\117\0"+
    "\1\145\1\0\1\146\2\0\1\147\40\0\7\150\1\151"+
    "\2\150\1\152\1\150\3\152\1\153\1\154\1\151\1\155"+
    "\5\152\1\150\2\152\4\150\2\152\10\150\14\152\7\150"+
    "\24\0\1\156\1\157\51\0\1\160\1\161\1\162\1\0"+
    "\1\163\3\0\1\161\1\0\4\161\2\162\5\0\7\161"+
    "\3\0\7\161\15\0\6\161\37\0\1\164\37\0\1\165"+
    "\1\61\3\0\1\166\2\0\1\61\1\0\4\61\7\0"+
    "\7\61\3\0\7\61\15\0\6\61\4\0\4\61\3\0"+
    "\1\61\1\0\6\61\5\0\7\61\3\0\7\61\15\0"+
    "\6\61\10\0\1\167\6\0\1\170\6\0\1\145\1\0"+
    "\1\171\2\0\1\147\1\0\1\172\4\0\1\173\1\174"+
    "\1\175\2\0\1\176\34\0\1\177\1\200\65\0\1\160"+
    "\1\161\1\162\1\0\1\163\1\0\1\201\1\0\1\161"+
    "\1\0\4\161\2\162\5\0\7\161\3\0\7\161\15\0"+
    "\6\161\3\0\1\202\4\0\1\203\73\0\1\177\1\200"+
    "\24\0\1\204\62\0\1\205\72\0\1\206\51\0\1\76"+
    "\71\0\7\207\1\210\2\207\1\74\1\207\3\74\1\211"+
    "\1\212\1\210\1\213\5\74\1\207\2\74\4\207\2\74"+
    "\10\207\14\74\7\207\10\0\1\214\16\0\1\215\54\0"+
    "\1\216\17\0\1\217\53\0\1\220\22\0\1\221\42\0"+
    "\1\106\76\0\1\111\1\0\1\111\11\0\2\111\62\0"+
    "\1\214\111\0\1\222\46\0\1\124\73\0\1\131\71\0"+
    "\7\223\1\151\2\223\1\152\1\223\3\152\1\224\1\225"+
    "\1\151\1\155\5\152\1\223\2\152\4\223\2\152\10\223"+
    "\14\152\7\223\31\0\1\226\76\0\1\227\46\0\1\155"+
    "\11\0\2\155\56\0\1\230\1\0\1\230\3\0\1\230"+
    "\2\0\1\230\2\0\2\230\10\0\1\230\1\0\2\230"+
    "\5\0\1\230\21\0\1\230\2\0\1\230\1\0\1\230"+
    "\5\0\1\231\1\0\1\231\3\0\1\231\2\0\1\231"+
    "\2\0\2\231\10\0\1\231\1\0\2\231\5\0\1\231"+
    "\21\0\1\231\2\0\1\231\1\0\1\231\7\0\1\152"+
    "\11\0\2\152\51\0\1\156\2\0\71\156\3\0\1\232"+
    "\4\161\3\0\1\161\1\0\6\161\4\0\1\233\7\161"+
    "\3\0\7\161\15\0\6\161\3\0\1\163\1\0\1\162"+
    "\1\0\1\162\11\0\2\162\4\0\1\234\11\0\1\235"+
    "\35\0\1\163\23\0\1\234\11\0\1\235\120\0\1\236"+
    "\2\0\1\237\12\0\1\167\6\0\1\170\10\0\1\240"+
    "\4\0\1\172\4\0\1\173\1\174\1\175\2\0\1\176"+
    "\73\0\1\241\55\0\1\242\14\0\1\243\44\0\1\244"+
    "\111\0\1\245\73\0\1\246\103\0\1\247\60\0\1\250"+
    "\71\0\1\251\101\0\1\204\72\0\1\252\45\0\1\213"+
    "\11\0\2\213\56\0\1\253\1\0\1\253\3\0\1\253"+
    "\2\0\1\253\2\0\2\253\10\0\1\253\1\0\2\253"+
    "\5\0\1\253\21\0\1\253\2\0\1\253\1\0\1\253"+
    "\5\0\1\254\1\0\1\254\3\0\1\254\2\0\1\254"+
    "\2\0\2\254\10\0\1\254\1\0\2\254\5\0\1\254"+
    "\21\0\1\254\2\0\1\254\1\0\1\254\7\0\1\74"+
    "\11\0\2\74\100\0\1\207\74\0\1\255\74\0\1\256"+
    "\75\0\1\257\74\0\1\260\67\0\1\261\77\0\1\262"+
    "\44\0\1\152\1\0\1\152\3\0\1\152\2\0\1\152"+
    "\2\0\2\152\10\0\1\152\1\0\2\152\5\0\1\152"+
    "\21\0\1\152\2\0\1\152\1\0\1\152\5\0\1\263"+
    "\1\0\1\263\3\0\1\263\2\0\1\263\2\0\2\263"+
    "\10\0\1\263\1\0\2\263\5\0\1\263\21\0\1\263"+
    "\2\0\1\263\1\0\1\263\3\0\1\232\23\0\1\233"+
    "\47\0\1\235\1\0\1\264\1\0\1\265\11\0\2\264"+
    "\140\0\1\266\76\0\1\267\32\0\1\270\14\0\1\243"+
    "\57\0\1\271\71\0\1\272\77\0\1\273\71\0\1\274"+
    "\104\0\1\275\47\0\1\276\122\0\1\277\60\0\1\300"+
    "\71\0\1\301\105\0\1\302\35\0\1\74\1\0\1\74"+
    "\3\0\1\74\2\0\1\74\2\0\2\74\10\0\1\74"+
    "\1\0\2\74\5\0\1\74\21\0\1\74\2\0\1\74"+
    "\1\0\1\74\5\0\1\303\1\0\1\303\3\0\1\303"+
    "\2\0\1\303\2\0\2\303\10\0\1\303\1\0\2\303"+
    "\5\0\1\303\21\0\1\303\2\0\1\303\1\0\1\303"+
    "\31\0\1\304\72\0\1\305\77\0\1\306\73\0\1\307"+
    "\71\0\1\310\76\0\1\311\43\0\1\312\1\0\1\312"+
    "\3\0\1\312\2\0\1\312\2\0\2\312\10\0\1\312"+
    "\1\0\2\312\5\0\1\312\21\0\1\312\2\0\1\312"+
    "\1\0\1\312\3\0\1\265\1\0\1\264\1\0\1\264"+
    "\11\0\2\264\4\0\1\234\47\0\1\265\23\0\1\234"+
    "\134\0\1\313\76\0\1\314\30\0\1\315\76\0\1\316"+
    "\72\0\1\317\106\0\1\320\63\0\1\321\72\0\1\322"+
    "\71\0\1\323\75\0\1\324\54\0\1\325\14\0\1\326"+
    "\103\0\1\327\66\0\1\330\43\0\1\331\1\0\1\331"+
    "\3\0\1\331\2\0\1\331\2\0\2\331\10\0\1\331"+
    "\1\0\2\331\5\0\1\331\21\0\1\331\2\0\1\331"+
    "\1\0\1\331\30\0\1\332\75\0\1\333\75\0\1\334"+
    "\74\0\1\335\64\0\1\336\76\0\1\337\102\0\1\340"+
    "\73\0\1\341\65\0\1\342\73\0\1\343\67\0\1\336"+
    "\3\0\1\344\56\0\1\345\73\0\1\346\113\0\1\347"+
    "\100\0\1\350\76\0\1\351\60\0\1\352\76\0\1\353"+
    "\73\0\1\354\70\0\1\355\73\0\1\214\70\0\1\356"+
    "\101\0\1\357\67\0\1\360\100\0\1\361\75\0\1\362"+
    "\73\0\1\363\65\0\1\344\76\0\1\364\100\0\1\365"+
    "\63\0\1\366\72\0\1\367\57\0\1\370\73\0\1\371"+
    "\107\0\1\372\42\0\4\373\4\374\3\373\1\374\1\373"+
    "\6\374\5\373\7\374\3\373\7\374\15\373\6\374\4\375"+
    "\4\376\3\375\1\376\1\375\6\376\5\375\7\376\3\375"+
    "\7\376\15\375\6\376\15\0\1\377\113\0\1\u0100\67\0"+
    "\1\u0101\100\0\1\u0102\63\0\1\u0103\45\0\4\u0104\4\u0105"+
    "\3\u0104\1\u0105\1\u0104\6\u0105\5\u0104\7\u0105\3\u0104\7\u0105"+
    "\15\u0104\6\u0105\15\0\1\u0106\56\0\4\u0107\4\u0108\3\u0107"+
    "\1\u0108\1\u0107\6\u0108\5\u0107\7\u0108\3\u0107\7\u0108\15\u0107"+
    "\6\u0108\4\u0109\4\u010a\3\u0109\1\u010a\1\u0109\6\u010a\5\u0109"+
    "\7\u010a\3\u0109\7\u010a\15\u0109\6\u010a\4\u010b\4\u010c\3\u010b"+
    "\1\u010c\1\u010b\6\u010c\5\u010b\7\u010c\3\u010b\7\u010c\15\u010b"+
    "\6\u010c\45\0\1\u010d\63\0\1\u010e\36\0\74\373\74\375"+
    "\30\0\1\u010f\44\0\3\u0110\126\0\1\214\64\0\1\u0111"+
    "\44\0\74\u0104\45\0\1\u0112\26\0\74\u0107\74\u0109\74\u010b"+
    "\50\0\1\u0113\54\0\1\u0114\74\0\1\u0115\42\0\3\u0110"+
    "\33\0\1\u0116\104\0\1\u0117\23\0\4\u0118\4\u0119\3\u0118"+
    "\1\u0119\1\u0118\6\u0119\5\u0118\7\u0119\3\u0118\7\u0119\15\u0118"+
    "\6\u0119\32\0\1\u011a\41\0\4\u011b\4\u011c\3\u011b\1\u011c"+
    "\1\u011b\6\u011c\5\u011b\7\u011c\3\u011b\7\u011c\15\u011b\6\u011c"+
    "\74\u0118\4\u011d\4\u011e\3\u011d\1\u011e\1\u011d\6\u011e\5\u011d"+
    "\7\u011e\3\u011d\7\u011e\15\u011d\6\u011e\74\u011b\74\u011d";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11760];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\25\0\2\11\1\1\1\11\1\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\3\1\11\1\1\15\11\4\1\1\3"+
    "\1\11\3\1\1\11\2\1\1\11\1\1\2\11\4\1"+
    "\1\11\1\1\3\11\1\1\3\11\2\1\1\11\1\1"+
    "\2\11\1\1\1\11\1\1\1\11\2\1\1\11\1\1"+
    "\2\11\1\1\1\11\1\1\2\11\1\1\3\11\2\0"+
    "\1\11\1\1\1\11\4\1\1\11\6\0\1\1\1\11"+
    "\10\0\2\11\3\0\3\11\4\1\1\0\1\11\4\0"+
    "\2\11\2\1\3\0\1\1\1\0\2\15\17\0\1\1"+
    "\6\0\1\1\17\0\1\1\6\0\1\1\16\0\1\1"+
    "\4\0\1\11\13\0\2\7\2\0\1\11\3\0\2\11"+
    "\1\7\1\0\3\7\2\0\1\5\1\0\1\5\2\0"+
    "\1\2\2\0\1\11\1\5\2\0\1\5\1\0\1\5"+
    "\1\0\1\5\5\0\1\11\1\0\1\7\1\0\1\11"+
    "\1\15\1\7\1\5\1\0\1\7\1\5\1\0\1\5"+
    "\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[286];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  //// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
  
  //// Position ////////////////////////////////////////////////////////////////
  
  //records the position of a symbol
  private static class PositionRecord {
      int startLine = -1;
      int startCol = -1;
      int endLine = -1;
      int endCol = -1;
  }
  
  //the position of the current symbol
  private PositionRecord pos = new PositionRecord();
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markStartPosition() {
    //correct to one-indexed
    pos.startLine = yyline + 1;
    pos.startCol = yycolumn + 1;
  }
  
  //populate the start line and column fields of the Position record with
  //values from JFlex
  private void markEndPosition() {
    //correct to one-indexed
    pos.endLine = yyline + 1;
    pos.endCol = (yycolumn + 1) + yylength() - 1;
  }
  
  //like symbol(type), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type) {
    return symbolFromMarkedPositions(type, null);
  }
  
  //like symbol(type, value), but uses the position stored in pos rather than
  //the position computed by JFlex
  private Symbol symbolFromMarkedPositions(short type, Object value) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.endLine, pos.endCol);
  }
  
  //like symbol(type), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, int length) {
    return symbolFromMarkedStart(type, null, length);
  }
  
  //like symbol(type, value), but uses the start position stored in pos rather than
  //the start position computed by JFlex and an explicit length param rather
  //than yylength
  private Symbol symbolFromMarkedStart(short type, Object value, int length) {
    return symbol(type, value, pos.startLine, pos.startCol, pos.startLine, pos.startCol + length - 1);
  }
  
  //// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
  
  //// State transitions ///////////////////////////////////////////////////////
  
  //stack entry: stack identifier + symbol position
  private static class StateRecord {
    int stateNum;
    PositionRecord pos;
    
    StateRecord(int stateNum, PositionRecord pos) {
        this.stateNum = stateNum;
        this.pos = pos;
    }
  }
  
  //most of our states are used for bracketing
  //this gives us a way to nest bracketing states
  private java.util.Stack<StateRecord> stateStack = new java.util.Stack<StateRecord>();
  
  void saveStateAndTransition(int newState) {
    stateStack.push(new StateRecord(yystate(), pos));
    pos = new PositionRecord();
    yybegin(newState);
  }
  
  void restoreState() {
    StateRecord rec = stateStack.pop();
    yybegin(rec.stateNum);
    pos = rec.pos;
  }
  
  //// Comment nesting /////////////////////////////////////////////////////////
  
  //number of '*/'s
  private int nestingDepth = 0;
  
  //// Blob accumulation ///////////////////////////////////////////////////////
  
  //for accumulating the contents of a string literal, comment, action, etc
  private StringBuffer blobBuf = new StringBuffer();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ComponentScanner(java.io.Reader in) {
    saveStateAndTransition(INSIDE_HEADER_SECTION);
  blobBuf = new StringBuffer();
  markStartPosition();
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ComponentScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 156) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol nextToken() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;
    int zzPushbackPosL = zzPushbackPos = -1;
    boolean zzWasPushback;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      zzWasPushback = false;

      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            zzPushbackPos = zzPushbackPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            zzPushbackPosL = zzPushbackPos;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 2) == 2 )
            zzPushbackPosL = zzCurrentPosL;

          if ( (zzAttributes & 1) == 1 ) {
            zzWasPushback = (zzAttributes & 4) == 4;
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;
      if (zzWasPushback)
        zzMarkedPos = zzPushbackPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 43: 
          { error("Unexpected character in string list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 86: break;
        case 66: 
          { return symbol(CHAR_CLASS_CHAR, yytext().substring(1));
          }
        case 87: break;
        case 9: 
          { error("Unexpected character: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 88: break;
        case 34: 
          { restoreState();
        return symbol(CLOSE_MACRO);
          }
        case 89: break;
        case 35: 
          { error("Unexpected character in repetition specification: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 90: break;
        case 14: 
          { return symbol(BEGINNING_OF_LINE);
          }
        case 91: break;
        case 50: 
          { return symbol(CHAR_CLASS_CHAR, yytext());
          }
        case 92: break;
        case 82: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(INHERIT_SECTION_SEPARATOR);
          }
        case 93: break;
        case 33: 
          { /*ignore*/
          }
        case 94: break;
        case 13: 
          { return symbol(RSQUARE);
          }
        case 95: break;
        case 21: 
          { return symbol(ALT);
          }
        case 96: break;
        case 59: 
          { return symbol(GROUP_SEPARATOR);
          }
        case 97: break;
        case 56: 
          { /* ignore */
        //return symbol(COMMENT, yytext());
          }
        case 98: break;
        case 30: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(STRING, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 99: break;
        case 60: 
          { saveStateAndTransition(INSIDE_ACTION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 100: break;
        case 32: 
          { error("Unexpected character in macro invocation: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 101: break;
        case 64: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(DECL_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 102: break;
        case 61: 
          { //blobBuf.append(yytext());
        nestingDepth++;
          }
        case 103: break;
        case 57: 
          { saveStateAndTransition(INSIDE_BRACKET_COMMENT);
        //blobBuf = new StringBuffer(yytext());
        //markStartPosition();
        nestingDepth++;
          }
        case 104: break;
        case 18: 
          { return symbol(PLUS);
          }
        case 105: break;
        case 44: 
          { restoreState(); return symbol(DELETE_TERMINATOR);
          }
        case 106: break;
        case 45: 
          { saveStateAndTransition(INSIDE_DELETE_ANGLE_BRACKETS);
        return symbol(LANGLE);
          }
        case 107: break;
        case 73: 
          { return symbol(ANY_PATTERN);
          }
        case 108: break;
        case 48: 
          { error("Expecting '{', found: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 109: break;
        case 11: 
          { return symbol(RPAREN);
          }
        case 110: break;
        case 76: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(IMPORT_DIRECTIVE);
          }
        case 111: break;
        case 51: 
          { restoreState(); return symbol(RSQUARE);
          }
        case 112: break;
        case 22: 
          { return symbol(ASSIGN);
          }
        case 113: break;
        case 78: 
          { return symbol(HELPER_DIRECTIVE);
          }
        case 114: break;
        case 70: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(START_DIRECTIVE);
          }
        case 115: break;
        case 17: 
          { return symbol(UPTO);
          }
        case 116: break;
        case 65: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(ACTION, blobBuf.toString());
        restoreState(); //NB: restore before transitioning
        saveStateAndTransition(INSIDE_META_TOKEN);
        return sym;
          }
        case 117: break;
        case 28: 
          { blobBuf.append(yytext());
          }
        case 118: break;
        case 29: 
          { yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
          }
        case 119: break;
        case 80: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(APPEND_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 120: break;
        case 63: 
          { blobBuf.append(yytext().substring(1));
          }
        case 121: break;
        case 23: 
          { return symbol(IDENTIFIER, yytext());
          }
        case 122: break;
        case 55: 
          { return symbol(ESCAPE_SEQUENCE, yytext());
          }
        case 123: break;
        case 10: 
          { return symbol(LPAREN);
          }
        case 124: break;
        case 58: 
          { restoreState();
        saveStateAndTransition(INSIDE_RULE_SECTION);
        return symbol(SECTION_SEPARATOR);
          }
        case 125: break;
        case 25: 
          { return symbol(CLOSE_RULE_GROUP);
          }
        case 126: break;
        case 52: 
          { return symbol(CHAR_CLASS_NEGATE);
          }
        case 127: break;
        case 12: 
          { saveStateAndTransition(INSIDE_CHARACTER_CLASS); return symbol(LSQUARE);
          }
        case 128: break;
        case 19: 
          { return symbol(OPT);
          }
        case 129: break;
        case 39: 
          { error("Unexpected character between angle brackets: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 130: break;
        case 81: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(LEXTHROW_DIRECTIVE);
          }
        case 131: break;
        case 26: 
          { saveStateAndTransition(INSIDE_ANGLE_BRACKETS);
        return symbol(LANGLE);
          }
        case 132: break;
        case 77: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(EXTERN_DIRECTIVE);
          }
        case 133: break;
        case 27: 
          { //blobBuf.append(yytext());
          }
        case 134: break;
        case 40: 
          { restoreState();
        saveStateAndTransition(INSIDE_OPEN_RULE_GROUP);
        return symbol(RANGLE);
          }
        case 135: break;
        case 6: 
          { return symbol(DOT);
          }
        case 136: break;
        case 36: 
          { return symbol(NUMBER, yytext());
          }
        case 137: break;
        case 69: 
          { saveStateAndTransition(INSIDE_INIT_REGION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 138: break;
        case 85: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(COMPONENT_DIRECTIVE);
          }
        case 139: break;
        case 74: 
          { return symbol(EOF_PATTERN);
          }
        case 140: break;
        case 8: 
          { return symbol(STAR);
          }
        case 141: break;
        case 71: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(STATE_DIRECTIVE);
          }
        case 142: break;
        case 53: 
          { saveStateAndTransition(INSIDE_DECL_REGION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 143: break;
        case 20: 
          { return symbol(DASH);
          }
        case 144: break;
        case 5: 
          { error("Incomplete escape sequence");
          }
        case 145: break;
        case 1: 
          { error("Unexpected character: " + yytext());
          }
        case 146: break;
        case 68: 
          { saveStateAndTransition(INSIDE_REPETITION_SPEC);
        return symbol(OPEN_REPETITION_SPEC);
          }
        case 147: break;
        case 15: 
          { return symbol(END_OF_LINE);
          }
        case 148: break;
        case 79: 
          { saveStateAndTransition(INSIDE_APPEND_REGION);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 149: break;
        case 83: 
          { saveStateAndTransition(INSIDE_DELETE_DIRECTIVE);
        return symbol(DELETE_DIRECTIVE);
          }
        case 150: break;
        case 16: 
          { return symbol(NOT);
          }
        case 151: break;
        case 24: 
          { error("Invalid directive");
          }
        case 152: break;
        case 37: 
          { restoreState();
        return symbol(CLOSE_REPETITION_SPEC);
          }
        case 153: break;
        case 47: 
          { error("Unexpected character in meta token specification: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 154: break;
        case 3: 
          { /* ignore */
          }
        case 155: break;
        case 67: 
          { saveStateAndTransition(INSIDE_MACRO);
        return symbol(OPEN_MACRO);
          }
        case 156: break;
        case 84: 
          { saveStateAndTransition(INSIDE_STRING_DIRECTIVE);
        return symbol(INITTHROW_DIRECTIVE);
          }
        case 157: break;
        case 41: 
          { error("Unexpected character in identifier list: " + yytext());
        yybegin(YYINITIAL); //central handling of EOF
          }
        case 158: break;
        case 7: 
          { return symbol(SLASH);
          }
        case 159: break;
        case 49: 
          { restoreState();
        return symbol(OPEN_RULE_GROUP);
          }
        case 160: break;
        case 42: 
          { restoreState(); /* ignore */
          }
        case 161: break;
        case 54: 
          { return symbol(NON_META, yytext().substring(1));
          }
        case 162: break;
        case 2: 
          { return symbol(NON_META, yytext());
          }
        case 163: break;
        case 62: 
          { //blobBuf.append(yytext());
        nestingDepth--;
        if(nestingDepth == 0) {
            //markEndPosition();
            //Symbol sym = symbolFromMarkedPositions(BRACKET_COMMENT, blobBuf.toString());
            restoreState();
            //return sym;
        }
          }
        case 164: break;
        case 4: 
          { saveStateAndTransition(INSIDE_STRING);
        blobBuf = new StringBuffer(yytext());
        markStartPosition();
          }
        case 165: break;
        case 38: 
          { return symbol(COMMA);
          }
        case 166: break;
        case 31: 
          { yybegin(YYINITIAL);
        error("Incomplete escape sequence");
          }
        case 167: break;
        case 75: 
          { saveStateAndTransition(INSIDE_IDENTIFIER_DIRECTIVE);
        return symbol(XSTATE_DIRECTIVE);
          }
        case 168: break;
        case 72: 
          { blobBuf.append(yytext());
        markEndPosition();
        Symbol sym = symbolFromMarkedPositions(INIT_REGION, blobBuf.toString());
        restoreState();
        return sym;
          }
        case 169: break;
        case 46: 
          { restoreState();
        return symbol(RANGLE);
          }
        case 170: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case INSIDE_APPEND_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated append region: '" + blobBuf + "'");
            }
            case 287: break;
            case INSIDE_DELETE_ANGLE_BRACKETS: {
              error("Unterminated angle brackets"); //TODO-AC: could attach position
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 288: break;
            case INSIDE_ANGLE_BRACKETS: {
              error("Unterminated angle brackets"); //TODO-AC: could attach position
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 289: break;
            case INSIDE_BRACKET_COMMENT: {
              yybegin(YYINITIAL);
        //don't finish scanning if there's an unclosed comment
        if(nestingDepth != 0) {
            error(nestingDepth + " levels of comments not closed");
        }
            }
            case 290: break;
            case INSIDE_INIT_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated init region: '" + blobBuf + "'");
            }
            case 291: break;
            case INSIDE_DECL_REGION: {
              yybegin(YYINITIAL); 
        error("Unterminated declaration region: '" + blobBuf + "'");
            }
            case 292: break;
            case INSIDE_ACTION: {
              yybegin(YYINITIAL);
            }
            case 293: break;
            case INSIDE_RULE_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 294: break;
            case INSIDE_OPEN_RULE_GROUP: {
              error("No group associated with state list");
        yybegin(YYINITIAL); //central handling of EOF
            }
            case 295: break;
            case INSIDE_STRING: {
              yybegin(YYINITIAL); 
        error("Unterminated string literal: '" + blobBuf + "'");
            }
            case 296: break;
            case INSIDE_STRING_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 297: break;
            case INSIDE_HEADER_SECTION: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 298: break;
            case INSIDE_META_TOKEN: {
              yybegin(YYINITIAL);
            }
            case 299: break;
            case YYINITIAL: {
              return symbol(EOF);
            }
            case 300: break;
            case INSIDE_IDENTIFIER_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
            }
            case 301: break;
            case INSIDE_DELETE_DIRECTIVE: {
              yybegin(YYINITIAL); //central handling of EOF
        return symbol(DELETE_TERMINATOR);
            }
            case 302: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
