//based on http://jflex.de/manual.html

package test.jflex.metalexer;
%%
import static test.jflex.metalexer.ComponentParser.Terminals.*;

import beaver.Symbol;
import beaver.Scanner;
%%
%layout component

//general header info
%option visibility "%public"
%option final "%final"
%option class "%class ComponentScanner"

//required for beaver compatibility
%option extends "%extends Scanner"
%option encoding "%unicode"
%option function "%function nextToken"
%option type "%type Symbol"

//for debugging - track line and column
%option line "%line"
%option col "%column"

%lexthrow "Scanner.Exception"

%declare "Symbol symbol(short)"
%declare "Symbol symbol(short, Object)"
%declare "Symbol symbol(short, Object, int, int, int, int)"
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}

%declare "void error(String) throws Scanner.Exception"
%declare "void error(String, int) throws Scanner.Exception"
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}

%component action
%component append_region
%component base
%component bracket_comment
%component bracketed_state_list
%component char_class
%component component_option_section
%component component_rule_section
%component decl_region
%component delete_directive
%component identifier_directive
%component init_region
%component macro_invoc
%component metatoken_decl
%component open_rule_group
%component repetition_spec
%component string_directive
%component string

%start base

%%

//// Option Section ////////////////////////////////////////////////////////////

%%embed
%name option_section
%host base
%guest component_option_section
%start <BOF>
%end END_OPTION_SECTION

%%embed
%name option_append
%host component_option_section
%guest append_region
%start START_APPEND_REGION
%end END_APPEND_REGION

%%embed
%name option_decl
%host component_option_section
%guest decl_region
%start START_DECL_REGION
%end END_DECL_REGION

%%embed
%name option_init
%host component_option_section
%guest init_region
%start START_INIT_REGION
%end END_INIT_REGION

%%embed
%name option_string_directive
%host component_option_section
%guest string_directive
%start START_STRING_DIRECTIVE
%end END_STRING_DIRECTIVE

//// Rule Section //////////////////////////////////////////////////////////////

%%embed
%name rule_section
%host base
%guest component_rule_section
%start %component_option_section%
%end END_RULE_SECTION

%%embed
%name rule_delete_directive
%host component_rule_section
%guest delete_directive
%start START_DELETE_DIRECTIVE
%end END_DELETE_DIRECTIVE

%%embed
%name rule_action
%host component_rule_section
%guest action
%start START_ACTION
%end END_ACTION

%%embed
%name rule_metatoken
%host component_rule_section
%guest metatoken_decl
%start %action%
%end END_METATOKEN_DECL

%%embed
%name open_rule_group
%host component_rule_section
%guest open_rule_group
%start %bracketed_state_list%
%end END_OPEN_RULE_GROUP


//// Shared Embeddings /////////////////////////////////////////////////////////

%%embed
%name comments
%host component_option_section, component_rule_section, delete_directive
%host metatoken_decl, bracketed_state_list, identifier_directive, string_directive
%host bracket_comment //NB: host and guest => nestable
%guest bracket_comment
%start START_BRACKET_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name string
%host component_option_section, component_rule_section, string_directive, delete_directive
%guest string
%start START_STRING
%end END_STRING

%%embed
%name identifier_directive
%host component_option_section, component_rule_section
%guest identifier_directive
%start START_IDENTIFIER_DIRECTIVE
%end END_IDENTIFIER_DIRECTIVE

%%embed
%name macro_invoc
%host component_option_section, component_rule_section, delete_directive
%guest macro_invoc
%start START_MACRO_INVOC
%end END_MACRO_INVOC

%%embed
%name repetition_spec
%host component_option_section, component_rule_section, delete_directive
%guest repetition_spec
%start START_REPETITION_SPEC
%end END_REPETITION_SPEC

%%embed
%name bracketed_state_list
%host component_rule_section, delete_directive
%guest bracketed_state_list
%start START_BRACKETED_STATE_LIST
%end END_BRACKETED_STATE_LIST

%%embed
%name char_class
%host component_option_section, component_rule_section, delete_directive
%guest char_class
%start START_CHAR_CLASS
%end END_CHAR_CLASS