package metalexer;

import java.io.PrintWriter;

/** Generates metalexer.*ParserPassTests from the provided list file. */
public abstract class InheritancePassTestGenerator extends AbstractTestGenerator {
    private final String prefix;

    protected InheritancePassTestGenerator(String prefix) {
        super("/metalexer/" + prefix + "InheritancePassTests.java");
        this.prefix = prefix;
    }

    protected void printHeader(PrintWriter testFileWriter) {
        testFileWriter.println("package metalexer;");
        testFileWriter.println();
        testFileWriter.println("import java.util.SortedSet;");
        testFileWriter.println("import java.util.TreeSet;");
        testFileWriter.println();
        testFileWriter.println("import metalexer.ast." + prefix + ";");
        testFileWriter.println();
        testFileWriter.println("public class " + prefix + "InheritancePassTests extends " + prefix + "ParserPassTestBase {");
        //NB: not a typo - do extend ParserPassTestBase
    }

    protected void printMethod(PrintWriter testFileWriter, String testName) {
        String methodName = "test_" + testName;
        String outFileName = "test/frontend/" + testName + ".out";
        testFileWriter.println();
        testFileWriter.println("    public void " + methodName + "() throws Exception {");
        testFileWriter.println("        FileLoader loader = new FileLoader(\"test/frontend\");");
        testFileWriter.println("        SortedSet<CompilationError> errors = new TreeSet<CompilationError>();");
        testFileWriter.println("        " + prefix + " actual = loader.load" + prefix + "(\"" + testName + "\", errors);");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertTrue(errors.isEmpty());");
        testFileWriter.println("        actual = actual.processInheritance(loader, errors);");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        actual.tidyRuleGroups();");
        testFileWriter.println("        assertTrue(actual.subtreeNodesHaveCorrectParents());");
        testFileWriter.println("        assertTrue(errors.isEmpty());");
        testFileWriter.println("        Structure expected = parseStructure(\"" + outFileName + "\");");
        testFileWriter.println("        assertEquiv(actual, expected);");
        testFileWriter.println("    }");
    }

    protected void printFooter(PrintWriter testFileWriter) {
        testFileWriter.println("}");
        testFileWriter.println();
    }
}
