#!/usr/bin/env ruby

require "cgi"

metalexer_dir = "../metalexer/"

cgi = CGI.new("html3")
cgi.out() do
    cgi.html() do
        cgi.head{ cgi.title{"MetaLexer"} } +
        cgi.body() do
            
            dev_manual = []
            user_manual = []
            m2m = []
            m2j = []
            src = []
            
            cgi_files = []
            Dir.open(metalexer_dir) do |dir|
                dir.entries.each do |file|
                    case file
                    when /^Dev Manual/
                        dev_manual << file;
                    when /^User Manual/
                        user_manual << file;
                    when /^metalexer\-metalexer/
                        m2m << file;
                    when /^metalexer\-jflex/
                        m2j << file;
                    when /^metalexer\-src/
                        src << file;
                    end
                end
            end
            
            dev_manual.sort.reverse
            user_manual.sort.reverse
            m2m.sort.reverse
            m2j.sort.reverse
            src.sort.reverse
            
            cgi.h1{"MetaLexer"} +
            "MetaLexer is covered by a (modified) BSD " + cgi.a(metalexer_dir + "LICENSE") {"license"} + "." + cgi.br +
            
            cgi.h2{"Current Files"} +
            cgi.h3{"For Developers"} +
            cgi.ul do
                cgi.li { cgi.a(metalexer_dir + dev_manual.shift){"Manual"} } +
                cgi.li { cgi.a(metalexer_dir + src.shift){"Source"} } 
            end +
            cgi.h3{"For Users"} +
            cgi.ul do
                cgi.li { cgi.a(metalexer_dir + user_manual.shift){"Manual"} } +
                cgi.li { cgi.a(metalexer_dir + m2m.shift){"MetaLexer-to-MetaLexer"} } +
                cgi.li { cgi.a(metalexer_dir + m2j.shift){"MetaLexer-to-JFlex"} }
            end +
            
            cgi.h2{"JFlex"} +
            "For full functionality, you should download " + cgi.a("http://jflex.de/") {"JFlex"} + "." + cgi.br +
            
            cgi.h2{"Old Files"} +
            cgi.h3{"Developer Manual"} +
            cgi.ul do
                dev_manual.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"User Manual"} +
            cgi.ul do
                user_manual.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"MetaLexer-to-MetaLexer"} +
            cgi.ul do
                m2m.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"MetaLexer-to-JFlex"} +
            cgi.ul do
                m2j.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            cgi.h3{"Source"} +
            cgi.ul do
                src.collect do |old|
                    cgi.li { cgi.a(metalexer_dir + old){old} }
                end.join("")
            end +
            
            cgi.h2{"Feedback"} +
            "Direct your questions or comments to " + cgi.img("email.gif") + "." + cgi.br
        end
    end
end

