package metalexer.jflex;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedSet;
import java.util.TreeSet;

import metalexer.CompilationError;
import metalexer.FileLoader;
import metalexer.ScannerUtil;
import metalexer.ast.Component;

/**
 * A utility for producing the output file corresponding to a given input file.
 * Note that the output should be checked manually before using it as a test.
 */
public class ComponentErrorTestTool {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java metalexer.ComponentErrorTestTool {basename}");
            System.exit(1);
        }
        String basename = args[0];
        try {
            FileLoader loader = new FileLoader("test/backend-jflex");
            SortedSet<CompilationError> errors = new TreeSet<CompilationError>();
            Component actual = loader.loadComponent(basename, errors);
            assert(actual.subtreeNodesHaveCorrectParents());
            actual = actual.processInheritance(loader, errors);
            assert(actual.subtreeNodesHaveCorrectParents());

            PrintWriter out = new PrintWriter(new FileWriter("test/backend-jflex/" + basename + ".out"));
            for(CompilationError error : errors) {
                out.println(ScannerUtil.stringifyValue(error));
            }
            out.close();

            System.exit(0);
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}
