package metalexer.jflex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

import metalexer.ScannerTestBase;
import test.jflex.metalexer.ComponentParser;
import beaver.Scanner;

public class ComponentScannerTestBase extends ScannerTestBase {

    protected ComponentScannerTestBase() {
        super(ComponentParser.Terminals.EOF, ComponentParser.Terminals.NAMES);
    }

    /* Construct a scanner that will read from the specified file. */
    protected Scanner getScanner(String filename) throws FileNotFoundException {
        return ReflectionHelper.instantiateScanner("test.jflex.metalexer.ComponentScanner", new BufferedReader(new FileReader(filename)));
    }

    protected short getID(String idString) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return ComponentParser.Terminals.class.getField(idString).getShort(null);
    }
}
