package natlab.attributed;
%%
import static natlab.NatlabParser.Terminals.*;
import beaver.Symbol;
import beaver.Scanner;
import beaver.Symbol;
import beaver.Scanner;
%%
//// This file was generated by MetaLexer ////

%layout attributed_natlab

%start base

%component attributes
%component leading_ws
%component base
%component attributed_class
%component class_bracketed
%component field_name
%component comma_terminator
%component semicolon_terminator
%component string
%component transpose
%component comment_start
%component bracket_comment
%component bracket_help_comment

%option class "%class AttributedNatlabScanner"
%option function "%function nextToken"
%option visibility "%public"
%option final "%final"
%option extends "%extends Scanner"
%option encoding "%unicode"
%option line "%line"
%option col "%column"
%option type "%type Symbol"

%declare "CommentBuffer commentBuffer"
%declare "int storedLine"
%declare "int storedCol"
%declare "Symbol symbol(short)"
%declare "Symbol symbol(short, Object)"
%declare "Symbol symbol(short, Object, int, int, int, int)"
%declare "void error(String) throws Scanner.Exception"
%declare "void error(String, int) throws Scanner.Exception"

%lexthrow "Scanner.Exception"

%{//// Comment queue ///////////////////////////////////////////////////////////
  
  //put comments in the buffer rather than returning them
  //NB: must be non-null before scanning starts
  private CommentBuffer commentBuffer = null;
  
  public void setCommentBuffer(CommentBuffer commentBuffer) {
      this.commentBuffer = commentBuffer;
  }
  
  public CommentBuffer getCommentBuffer() {
      return commentBuffer;
  }
%}
%{//// Position info for commas and semicolons /////////////////////////////////
  
  private int storedLine = -1;
  private int storedCol = -1;
%}
%{//// Returning symbols ///////////////////////////////////////////////////////

  //Create a symbol using the current line and column number, as computed by JFlex
  //No attached value
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(SEMICOLON)
  private Symbol symbol(short type) {
    return symbol(type, null);
  }
  
  //Create a symbol using the current line and column number, as computed by JFlex
  //Attached value gives content information
  //Symbol is assumed to start and end on the same line
  //e.g. symbol(IDENTIFIER, "x")
  private Symbol symbol(short type, Object value) {
    //NB: JFlex is zero-indexed, but we want one-indexed
    int startLine = yyline + 1;
    int startCol = yycolumn + 1;
    int endLine = startLine;
    int endCol = startCol + yylength() - 1;
    return symbol(type, value, startLine, startCol, endLine, endCol);
  }
  
  //Create a symbol using explicit position information (one-indexed)
  private Symbol symbol(short type, Object value, int startLine, int startCol, int endLine, int endCol) {
    int startPos = Symbol.makePosition(startLine, startCol);
    int endPos = Symbol.makePosition(endLine, endCol);
    return new Symbol(type, startPos, endPos, value);
  }
%}
%{//// Errors //////////////////////////////////////////////////////////////////
  
  //throw an exceptions with position information from JFlex
  private void error(String msg) throws Scanner.Exception {
    //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1, msg);
  }
  
  //throw an exceptions with position information from JFlex
  //columnOffset is added to the column
  private void error(String msg, int columnOffset) throws Scanner.Exception {
  //correct to one-indexed
    throw new Scanner.Exception(yyline + 1, yycolumn + 1 + columnOffset, msg);
  }
%}

%%

%%embed
%name leading_ws
%host base
%guest leading_ws
%start <BOF>
%end END_LEADING_WS

%%embed
%name class_brackets
%host attributed_class
%guest class_bracketed
%start START_BRACKETED
%end END_BRACKETED
%pair START_BRACKETED, END_BRACKETED

%%embed
%name field_name
%host base
%host attributed_class
%guest field_name
%start START_FIELD_NAME
%end (END_FIELD_NAME | %transpose%)

%%embed
%name transpose
%host base
%host attributed_class
%host field_name
%guest transpose
%start [ START_TRANSPOSE END_BRACKETED ]
%end END_TRANSPOSE

%%embed
%name string
%host base
%host attributed_class
%guest string
%start START_STRING
%end END_STRING

%%embed
%name comma_terminator
%host base
%host attributed_class
%guest comma_terminator
%start START_COMMA_TERMINATOR
%end END_COMMA_TERMINATOR

%%embed
%name semicolon_terminator
%host base
%host attributed_class
%guest semicolon_terminator
%start START_SEMICOLON_TERMINATOR
%end END_SEMICOLON_TERMINATOR

%%embed
%name bracket_comment
%host base
%host attributed_class
%host field_name
%host bracket_comment
%host bracket_help_comment
%guest bracket_comment
%start START_BRACKET_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name bracket_help_comment
%host base
%host attributed_class
%host field_name
%guest bracket_help_comment
%start START_BRACKET_HELP_COMMENT
%end END_BRACKET_COMMENT

%%embed
%name class
%host base
%guest attributed_class
%start START_CLASS
%end END
%pair OPEN_END, END
%pair PROPERTIES, END
%pair METHODS, END
%pair EVENTS, END

%%embed
%name class_attributes
%host attributed_class
%guest attributes
%start PROPERTIES ([^ START_BRACKETED ])* START_BRACKETED
%end END_BRACKETED

